%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : extractCSP.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: extract a CSP from the given files
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
extractCSP(Trees,ClassDeclsHashtable,DVars,Object):-
    [_|_]<=Trees :
    extractClassConstrFromTrees(Trees,ClassDecls,ConstrDecls,MainClass),
    extractCSP1(ClassDecls,ConstrDecls,MainClass,ClassDeclsHashtable,DVars,Object).
extractCSP(Tree,ClassDeclsHashtable,DVars,Object):-
    true :
    extractClassConstr(Tree,ClassDecls,ConstrDecls,MainClass),
    extractCSP1(ClassDecls,ConstrDecls,MainClass,ClassDeclsHashtable,DVars,Object).

extractCSP1(ClassDecls,ConstrDecls,MainClass,ClassDeclsHashtable,DVars,Object):-
    extractClassComponentAttribute(ClassDecls),
    length(ClassDecls,NoClasses),
    length(ConstrDecls,NoConstrs),
    hashtableCreate(NoClasses,ClassDeclsHashtable),
    hashtableCreate(NoConstrs,ConstrDeclsHashtable),
    listToHashtable(ClassDecls,ClassDeclsHashtable),
    listToHashtable(ConstrDecls,ConstrDeclsHashtable),
    createClassInstance0(MainClass,ClassDeclsHashtable,ConstrDeclsHashtable,DVars,Object),
    collectAttributeNames(ClassDecls,ClassDeclsHashtable).

extractClassConstrFromTrees([],ClassDecls,ConstrDecls,MainClass):-true : true.
extractClassConstrFromTrees([Tree|Trees],ClassDecls,ConstrDecls,MainClass):-
    true :
    extractClassConstr(Tree,ClassDecls,ConstrDecls,MainClass),
    extractClassConstrFromTrees(Trees,ClassDecls,ConstrDecls,MainClass).
    
extractClassConstr(
    'Goal'(CompilationUnit),
    ClassDecls,ConstrDecls,MainClass):-true :
    extractClassConstr(CompilationUnit,ClassDecls,ConstrDecls,MainClass).
extractClassConstr(
    'CompilationUnit'(PackageDeclaration,ImportDeclarations,TypeOrConstraintDeclarations),
    ClassDecls,ConstrDecls,MainClass):-true :
    extractClassConstr(TypeOrConstraintDeclarations,ClassDecls,ConstrDecls,MainClass).
extractClassConstr(
    'TypeOrConstraintDeclarations'(TypeOrConstraintDeclaration,TypeOrConstraintDeclarations),
    ClassDecls,ConstrDecls,MainClass):-true :
    extractClassConstr(TypeOrConstraintDeclaration,ClassDecls,ConstrDecls,MainClass),
    extractClassConstr(TypeOrConstraintDeclarations,ClassDecls,ConstrDecls,MainClass).
extractClassConstr(
    'TypeOrConstraintDeclaration'(SomeDeclaration), %class, interface, or constr
    ClassDecls,ConstrDecls,MainClass):-true :
    extractClassConstr(SomeDeclaration,ClassDecls,ConstrDecls,MainClass).
extractClassConstr(
    'ClassDeclaration'(Modifiers,class,Identifier,Super,Interfaces,ClassBody),
    ClassDecls,ConstrDecls,MainClass):-true :
    dj2proIdentifier(Identifier,PIdentifier),
    Class=class(PIdentifier,Constants,SuperClass,CompAttributes,Constrs,ClassBody,Args,TAPairs),
    attach(Class,ClassDecls),
    (isMainClass(Modifiers)->
     (var(MainClass) -> MainClass=Class
       ;
      cmpError(['multiple main classes declared']))
      ;
     true),
    extractSuperClass(Super,SuperClass).
extractClassConstr(ConstraintDeclaration,ClassDecls,ConstrDecls,MainClass):-
    'ConstraintDeclaration'(constraint,Identifier,'(',FormalParameterList,')',ConstraintBody)<=ConstraintDeclaration :
    dj2proFormalParameterList(FormalParameterList,PFormalParameterList),
%    write(dj2proFormalParameterList(PFormalParameterList)),nl,
    dj2proConstraintBody(ConstraintBody,PConstraintBody),
    dj2proIdentifier(Identifier,PIdentifier),
    attach(constraintDecl(PIdentifier,PFormalParameterList,PConstraintBody),ConstrDecls).
extractClassConstr(Something,ClassDecls,ConstrDecls,MainClass):-true : true. %nil,;,interface

extractClassComponentAttribute(Classes):-var(Classes) : true.
extractClassComponentAttribute([]):-true : true.
extractClassComponentAttribute([Class|Classes]):-
    class(PIdentifier,Constants,SuperClass,CompAttributes,Constrs,ClassBody,Args,TAPairs)<=Class :
    extractComponentAttribute(ClassBody,Constants,CompAttributes,Constrs),
    extractClassComponentAttribute(Classes).

extractComponentAttribute(
    'ClassBody'('{',ClassBodyDeclarations,'}'),
    Constants,CompAttributes,Constrs):-true:
    extractComponentAttribute(ClassBodyDeclarations,Constants,CompAttributes,Constrs).
extractComponentAttribute(
    'ClassBodyDeclarations'(ClassBodyDeclaration,ClassBodyDeclarations),
    Constants,CompAttributes,Constrs):-true :
    extractComponentAttribute(ClassBodyDeclaration,Constants,CompAttributes,Constrs),
    extractComponentAttribute(ClassBodyDeclarations,Constants,CompAttributes,Constrs).
extractComponentAttribute(
    'ClassBodyDeclaration'(Something),
    Constants,CompAttributes,Constrs):-true :
    extractComponentAttribute(Something,Constants,CompAttributes,Constrs).
extractComponentAttribute(
    'ClassMemberDeclaration'(Something),
    Constants,CompAttributes,Constrs):-true :
    extractComponentAttribute(Something,Constants,CompAttributes,Constrs).
extractComponentAttribute(
    'ComponentDeclaration'(component,Type,ComponentAttributeDeclarators,';'),
    Constants,CompAttributes,Constrs):-true :
    dj2proType(Type,PType),
    extractComponentAttributeDeclarators(ComponentAttributeDeclarators,PType,CompAttributes,Constrs,Constants).
extractComponentAttribute(
    'AttributeDeclaration'(attribute,Type,ComponentAttributeDeclarators,';'),
    Constants,CompAttributes,Constrs):-true :
    dj2proType(Type,PType),
    checkAttributeType(PType),
    extractComponentAttributeDeclarators(ComponentAttributeDeclarators,PType,CompAttributes,Constrs,Constants).
extractComponentAttribute(
    'ClassMemberDeclaration'(Constraint,';'),
    Constants,CompAttributes,Constrs):-true :
    dj2proConstraint(Constraint,PConstraint),
    attach(constraint(PConstraint),Constrs).
extractComponentAttribute(Something,Constants,CompAttributes,Constrs):-
    'FieldDeclaration'(Modifiers,Type,VariableDeclarators,';')<=Something :
    extractConstant(Something,Constants).
extractComponentAttribute(Something,Constants,CompAttributes,Constrs):-
    true : true.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
extractConstant(
    'FieldDeclaration'(Modifiers,Type,VariableDeclarators,';'), 
    Constants):-
    dj2proType(Type,PType),
    isStaticFinal(Modifiers,PublicOrPrivate),
    extractConstant1(PublicOrPrivate,PType,VariableDeclarators,Constants),!.
extractConstant(Something,Constants):-true : true.

isStaticFinal(Modifiers,PublicOrPrivate):-
    dj2proModifiers(Modifiers,PModifiers),
    membchk(static,PModifiers),
    membchk(final,PModifiers),
    (membchk(public,PModifiers)->
     PublicOrPrivate=public;
     PublicOrPrivate=private).

extractConstant1(Public,PType,'VariableDeclarators'(VariableDeclarator,VariableDeclaratorsRest),Consts):-true :
    extractConstant1(Public,PType,VariableDeclarator,Consts),
    extractConstant1(Public,PType,VariableDeclaratorsRest,Consts).
extractConstant1(Public,PType,'VariableDeclaratorsRest'(',',VariableDeclarators),Consts):-true :
    extractConstant1(Public,PType,VariableDeclarators,Consts).
extractConstant1(Public,PType,'VariableDeclarator'(VariableDeclaratorId,VariableDeclaratorRest),Consts):-
    dj2proVariableDeclaratorId(VariableDeclaratorId,_,_,PId),
    extractConstant2(Public,PType,PId,VariableDeclaratorRest,Consts).
extractConstant1(Public,PType,Something,Consts):-true : true.

extractConstant2(Public,PType,PId,'VariableDeclaratorRest'('=',VariableInitializer),Consts):-true :
    extractConstant2(Public,PType,PId,VariableInitializer,Consts).
extractConstant2(Public,PType,PId,'VariableInitializer'(Expression),Consts):-
    'Expression'(_)<=Expression :
    dj2proExpression(Expression,PExpression),
    evalConstantExpression(PType,PExpression,Value,Consts),
    attach(constant(Public,PType,PId,Value),Consts).
extractConstant2(Public,PType,PId,'VariableInitializer'(Expression),Consts):-
    true :
    cmpError(['Constant array is not supported']).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
extractComponentAttributeDeclarators('ComponentAttributeDeclarators'(ComponentAttributeDeclarator,ComponentAttributeDeclaratorsRest),
			   PType,ComponentAttributes,Constrs,Constants):-
    true :
    extractComponentAttributeDeclarators(ComponentAttributeDeclarator,PType,ComponentAttributes,Constrs,Constants),
    extractComponentAttributeDeclarators(ComponentAttributeDeclaratorsRest,PType,ComponentAttributes,Constrs,Constants).
extractComponentAttributeDeclarators('ComponentAttributeDeclaratorsRest'(',',ComponentAttributeDeclarators),
			   PType,ComponentAttributes,Constrs,Constants):-
    true :
    extractComponentAttributeDeclarators(ComponentAttributeDeclarators,PType,ComponentAttributes,Constrs,Constants).
extractComponentAttributeDeclarators('ComponentAttributeDeclarator'(Something,nil),
			   PType,ComponentAttributes,Constrs,Constants):-
    true :
    extractComponentAttributeDeclarators(Something,PType,ComponentAttributes,Constrs,Constants).
extractComponentAttributeDeclarators('ComponentAttributeDeclarator'(Something,
								    'ComponentAttributeDeclaratorRest'('{',ConstraintsOrConstraintBlocks,'}')),
				     PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proConstraintsOrConstraintBlocks(ConstraintsOrConstraintBlocks,PConstraints),
    extractComponentAttributesWithConstrs(Something,PConstraints,PType,ComponentAttributes,Constrs,Constants).
extractComponentAttributeDeclarators('ComponentAttributeDeclarator'(Something,
								    'ComponentAttributeDeclaratorRest'(in,Range)),
				     PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proRange(Range,PRange),
    extractComponentAttributesWithSingleConstr(Something,in,PRange,PType,ComponentAttributes,Constrs,Constants).
extractComponentAttributeDeclarators('ComponentAttributeDeclarator'(Something,
								    'ComponentAttributeDeclaratorRest'(ArithmeticConstraintRest)),
				     PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proArithmeticConstraintRest(ArithmeticConstraintRest,PR,PExp),
    extractComponentAttributesWithSingleConstr(Something,PR,PExp,PType,ComponentAttributes,Constrs,Constants).
extractComponentAttributeDeclarators('IdentifierOrArray'(Identifier),
			   PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proIdentifier(Identifier,PIdentifier),
    attach(component(PIdentifier,PType),ComponentAttributes).
extractComponentAttributeDeclarators('IdentifierOrArray'(Identifier,DimExprs),
			   PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proIdentifier(Identifier,PIdentifier),
    dj2proDimExprs(DimExprs,PDimExprs),
    (evalConstantExpressions(int,PDimExprs,ConstantDims,Constants)->true;
     cmpError(['Wrong constant expression'],displayDimExprs(DimExprs))),
    extractComponentAttributeArray(PIdentifier,ConstantDims,PType,ComponentAttributes).
extractComponentAttributeDeclarators(nil, PType,ComponentAttributes,Constrs,Constants):-true : true.

%%%%%%%%%%%%
extractComponentAttributeArray(Identifier,[Dim|PDims],PType,ComponentAttributes):-
    true :
    (PDims==[]->ElmType=PType;ElmType=array(PDims,PType)),
    attach(component(Identifier,array(Dim,ElmType,ComponentAttributeArray)),ComponentAttributes),
    extractComponentAttributeArray(0,Dim,PDims,PType,ComponentAttributeArray).

extractComponentAttributeArray(N0,N,PDims,PType,ComponentAttributes):-
    N0>=N : true.
extractComponentAttributeArray(N0,N,[],PType,ComponentAttributes):-
    true :
    attach(component(N0,PType),ComponentAttributes),
    N1 is N0+1,
    extractComponentAttributeArray(N1,N,[],PType,ComponentAttributes).
extractComponentAttributeArray(N0,N,PDims,PType,ComponentAttributes):-
    [Dim|PDims1]<=PDims :
    (PDims1==[]->ElmType=PType;ElmType=array(PDims1,PType)),
    attach(component(N0,array(Dim,ElmType,ComponentAttributeArray)),ComponentAttributes),
    extractComponentAttributeArray(0,Dim,PDims1,PType,ComponentAttributeArray),
    N1 is N0+1,
    extractComponentAttributeArray(N1,N,PDims,PType,ComponentAttributes).

%%%%%%%%%%%%
extractComponentAttributesWithConstrs('IdentifierOrArray'(Identifier),
				      PConstraints,PType,ComponentAttributes,Constrs,Constants):-true :
    dj2proIdentifier(Identifier,PIdentifier),
    attach(component(PIdentifier,PType),ComponentAttributes),
    attach(constraint(PConstraints,PType,PIdentifier),Constrs).
extractComponentAttributesWithConstrs('IdentifierOrArray'(Identifier,DimExprs),
				      PConstraints,PType,ComponentAttributes,Constrs,Constants):-
    isConstraintBlocks(PConstraints),!,
    dj2proIdentifier(Identifier,PIdentifier),
    dj2proDimExprs(DimExprs,PDimExprs),
    (evalConstantExpressions(int,PDimExprs,ConstantDims,Constants)->true;
     cmpError(['Wrong constant expression'],displayDimExprs(DimExprs))),
    extractComponentAttributeArray(PIdentifier,ConstantDims,PType,ComponentAttributes),
    extractComponentAttributeArrayWithConstrBlocks(PIdentifier,ConstantDims,PType,PConstraints,Constrs).
extractComponentAttributesWithConstrs('IdentifierOrArray'(Identifier,DimExprs),
				      PConstraints,PType,ComponentAttributes,Constrs,Constants):-true :
    dj2proIdentifier(Identifier,PIdentifier),
    dj2proDimExprs(DimExprs,PDimExprs),
    (evalConstantExpressions(int,PDimExprs,ConstantDims,Constants)->true;
     cmpError(['Wrong constant expression'],displayDimExprs(DimExprs))),
    extractComponentAttributeArray(PIdentifier,ConstantDims,PType,ComponentAttributes),
    extractComponentAttributeArrayWithConstrs(PIdentifier,ConstantDims,PType,PConstraints,Constrs).

%%%%%%%%%%%%
extractComponentAttributeArrayWithConstrs(Primary,[],PType,PConstraints,Constrs):-true :
    attach(constraint(PConstraints,PType,Primary),Constrs).
extractComponentAttributeArrayWithConstrs(Primary,[N|PDims],PType,PConstraints,Constrs):-
    integer(N) :
    extractComponentAttributeArrayWithConstrs(Primary,0,N,PDims,PType,PConstraints,Constrs).

extractComponentAttributeArrayWithConstrs(Primary,N0,N,PDims,PType,PConstraints,Constrs):-
    N0>=N : true.
extractComponentAttributeArrayWithConstrs(Primary,N0,N,PDims,PType,PConstraints,Constrs):-
    true :
    NewPrimary=array(Primary,N0),
    extractComponentAttributeArrayWithConstrs(NewPrimary,PDims,PType,PConstraints,Constrs),
    N1 is N0+1,
    extractComponentAttributeArrayWithConstrs(Primary,N1,N,PDims,PType,PConstraints,Constrs).
    
%%%%%%%%%%%%
extractComponentAttributeArrayWithConstrBlocks(Primary,[],PType,PBlocks,Constrs):-true :
    attach(constraint(PBlocks,PType,Primary),Constrs).
extractComponentAttributeArrayWithConstrBlocks(Primary,[N|PDims],PType,PBlocks,Constrs):-
    integer(N) :
    extractComponentAttributeArrayWithConstrBlocks(Primary,0,N,PDims,PType,PBlocks,Constrs).

extractComponentAttributeArrayWithConstrBlocks(Primary,N0,N,PDims,PType,[],Constrs):-
    N0>=N : true.
extractComponentAttributeArrayWithConstrBlocks(Primary,N0,N,PDims,PType,[PBlock|PBlocks],Constrs):-
    true :
    NewPrimary=array(Primary,N0),
    (isConstraintBlocks(PBlock)->
     extractComponentAttributeArrayWithConstrBlocks(NewPrimary,PDims,PType,PBlock,Constrs);
     extractComponentAttributeArrayWithConstrs(NewPrimary,PDims,PType,PBlock,Constrs)),
    N1 is N0+1,
    extractComponentAttributeArrayWithConstrBlocks(Primary,N1,N,PDims,PType,PBlocks,Constrs).
extractComponentAttributeArrayWithConstrBlocks(Primary,N0,N,PDims,PType,PBlocks,Constrs):-
    true :
    cmpError(['Array dimension does not match the number of constraint blocks']).

%%%%%%%%%%%%
extractComponentAttributesWithSingleConstr('IdentifierOrArray'(Identifier),
					   PR,PExp,PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proIdentifier(Identifier,PIdentifier),
    attach(component(PIdentifier,PType),ComponentAttributes),
    PConstraint=..[PR,PIdentifier,PExp],
    attach(constraint(PConstraint),Constrs).
extractComponentAttributesWithSingleConstr('IdentifierOrArray'(Identifier,DimExprs),
					   PR,PExp,PType,ComponentAttributes,Constrs,Constants):-
    true :
    dj2proIdentifier(Identifier,PIdentifier),
    dj2proDimExprs(DimExprs,PDimExprs),
    evalConstantExpressions(int,PDimExprs,ConstantDims,Constants),
    extractComponentAttributeArray(PIdentifier,ConstantDims,PType,ComponentAttributes),
    extractComponentAttributeArrayWithSingleConstr(PIdentifier,ConstantDims,PR,PExp,PType,Constrs).


%%%%%%%%%%%%
extractComponentAttributeArrayWithSingleConstr(Primary,[],PR,PExp,PType,Constrs):-
    true : 
    PConstraint=..[PR,Primary,PExp],
    attach(constraint(PConstraint),Constrs).
extractComponentAttributeArrayWithSingleConstr(Primary,[N|PDims],PR,PExp,PType,Constrs):-
    integer(N) :
    extractComponentAttributeArrayWithSingleConstr(Primary,0,N,PDims,PR,PExp,PType,Constrs).

extractComponentAttributeArrayWithSingleConstr(Primary,N0,N,PDims,PR,PExp,PType,Constrs):-
    N0>=N : true.
extractComponentAttributeArrayWithSingleConstr(Primary,N0,N,PDims,PR,PExp,PType,Constrs):-
    true :
    NewPrimary=array(Primary,N0),
    extractComponentAttributeArrayWithSingleConstr(NewPrimary,PDims,PR,PExp,PType,Constrs),
    N1 is N0+1,
    extractComponentAttributeArrayWithSingleConstr(Primary,N1,N,PDims,PR,PExp,PType,Constrs).

extractSuperClass('Super'(extends,ClassType),SuperClass):-
    true :
    dj2proClassType(ClassType,SuperClass).
extractSuperClass(_,SuperClass):-
    true :
    SuperClass=nil.

isConstraintBlocks([]):-true : true.
isConstraintBlocks([{}|Blocks]):-true : isConstraintBlocks(Blocks).
isConstraintBlocks([{_}|Blocks]):-true : isConstraintBlocks(Blocks).

isMainClass(Modifiers):-
    dj2proModifiers(Modifiers,PModifiers),
    membchk(main,PModifiers).


checkAttributeType(Type):-
    attributeType(Type),!.
checkAttributeType(Type):-
    cmpError(['Invalide attribute type: ',Type]).

attributeType(int):-true : true.
attributeType('String'):-true : true.
attributeType('Color'):-true : true.


evalConstantExpressions(Type,[],Values,Constants):-
    true : Values=[].
evalConstantExpressions(Type,[Exp|Exps],Values,Constants):-
    true :
    Values=[Value|Values1],
    evalConstantExpression(Type,Exp,Value,Constants),
    evalConstantExpressions(Type,Exps,Values1,Constants).
    
evalConstantExpression(Type,X,Value,Constants):-
    integer(X) : Value=X,Type=int.
evalConstantExpression(Type,X,Value,Constants):-
    atom(X) :
    (lookupConstant(private,Type,X,Value,Constants)->true;
     cmpError([X,' is not a constant'])).
evalConstantExpression(Type,X+Y,Value,Constants):-
    true :
    evalConstantExpression(Type,X,ValueX,Constants),
    evalConstantExpression(Type,Y,ValueY,Constants),
    Value is ValueX+ValueY.
evalConstantExpression(Type,X-Y,Value,Constants):-
    true :
    evalConstantExpression(Type,X,ValueX,Constants),
    evalConstantExpression(Type,Y,ValueY,Constants),
    Value is ValueX-ValueY.
evalConstantExpression(Type,X*Y,Value,Constants):-
    true :
    evalConstantExpression(Type,X,ValueX,Constants),
    evalConstantExpression(Type,Y,ValueY,Constants),
    Value is ValueX*ValueY.
evalConstantExpression(Type,X/Y,Value,Constants):-
    true :
    evalConstantExpression(Type,X,ValueX,Constants),
    evalConstantExpression(Type,Y,ValueY,Constants),
    (Type==int->Value is ValueX//ValueY;
     Value is ValueX/ValueY).
    
