%% file  : expressions.pl
%% author: Sosuke Kaneko & Neng-Fa Zhou
%% date  : Dec.1997 - Apr.1998
%   COPYRIGHT (C) 1998 Sosuke Kaneko & Neng-Fa Zhou

%--------  19.12  Expressions  --------%

%Primary:
%	sum ( Template , EnumeratorConditionList )   % for dj
%	minimum ( Template , EnumeratorConditionList )   % for dj
%	maximum ( Template , EnumeratorConditionList )   % for dj
%	times ( Template , EnumeratorConditionList ) % for dj
%       PrimaryNoNewArray
%       ArrayCreationExpression
'Primary'(T,[tok(sum,TN)|S0],S):-!,
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='Primary'(sum,'(',Template,',',EnumeratorConditionList,')'),
	'Template'(Template,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==',' -> true ; error1(', expected',TN1)),
	'EnumeratorConditionList'(EnumeratorConditionList,S3,S4),
	S4=[tok(Tok2,TN2)|S],
	(Tok2==')' -> true ; error1(') expected',TN2)).
'Primary'(T,[tok(minimum,TN)|S0],S):-!,
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='Primary'(minimum,'(',Template,',',EnumeratorConditionList,')'),
	'Template'(Template,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==',' -> true ; error1(', expected',TN1)),
	'EnumeratorConditionList'(EnumeratorConditionList,S3,S4),
	S4=[tok(Tok2,TN2)|S],
	(Tok2==')' -> true ; error1(') expected',TN2)).
'Primary'(T,[tok(maximum,TN)|S0],S):-!,
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='Primary'(maximum,'(',Template,',',EnumeratorConditionList,')'),
	'Template'(Template,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==',' -> true ; error1(', expected',TN1)),
	'EnumeratorConditionList'(EnumeratorConditionList,S3,S4),
	S4=[tok(Tok2,TN2)|S],
	(Tok2==')' -> true ; error1(') expected',TN2)).
'Primary'(T,[tok(times,TN)|S0],S):-!,
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='Primary'(times,'(',Template,',',EnumeratorConditionList,')'),
	'Template'(Template,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==',' -> true ; error1(', expected',TN1)),
	'EnumeratorConditionList'(EnumeratorConditionList,S3,S4),
	S4=[tok(Tok2,TN2)|S],
	(Tok2==')' -> true ; erorReport1(') expected',TN2)).
'Primary'(T,S0,S):-
	T='Primary'(T1),
	'PrimaryNoNewArray'(PrimaryNoNewArray,S0,S1),!,
	'PrimaryRestsopt'(PrimaryNoNewArray,T1,S1,S).
'Primary'(T,S0,S):-
	T='Primary'(T1),
	'ArrayCreationExpression'(ArrayCreationExpression,S0,S1),
	'PrimaryRestsNotArrayAccessopt'(ArrayCreationExpression,T1,S1,S).

%%PrimaryRests :
%%	PrimaryRest PrimaryRestsopt
'PrimaryRests'(T0,T) -->
	'PrimaryRest'(T0,T1),
	'PrimaryRestsopt'(T1,T).

'PrimaryRestsopt'(T0,T) -->
	'PrimaryRests'(T0,T). %,{!}.
'PrimaryRestsopt'(T,T) --> [].
	
%%PrimaryRest :
%%	. Identifier ( ArgumentListopt )	<- MethodInvocation
%%	. Identifier				<- FieldAccess
%%	[ Expression ]				<- ArrayAccess 
'PrimaryRest'(T0,T,[tok('.',_)|S0],S):-
	'Identifier'(Identifier,S0,S1),
	S1=[tok('(',_)|S2],!,
	'ArgumentListopt'(ArgumentListopt,S2,S3),
	S3=[tok(')',_)|S],
	functor(T1,'MethodInvocation',6),
	arg(1,T1,'Primary'(T0)),
	arg(2,T1,'.'),
	arg(3,T1,Identifier),
	arg(4,T1,'('),
	arg(5,T1,ArgumentListopt),
	arg(6,T1,')'),
	T='PrimaryNoNewArray'(T1).
'PrimaryRest'(T0,T,[tok('.',_)|S0],S):-!,
	'Identifier'(Identifier,S0,S),
	functor(T1,'FieldAccess',3),
	arg(1,T1,'Primary'(T0)),
	arg(2,T1,'.'),
	arg(3,T1,Identifier),
	T='PrimaryNoNewArray'(T1).
'PrimaryRest'(T0,T,[tok('[',_)|S0],S):-
	'Expression'(Expression,S0,S1),
	S1=[tok(']',_)|S],
	functor(T1,'ArrayAccess',4),
	arg(1,T1,T0),
	arg(2,T1,'['),
	arg(3,T1,Expression),
	arg(4,T1,']'),
	T='PrimaryNoNewArray'(T1).
	
%%PrimaryRestsNotArrayAccess :
%%	PrimaryRestNotArrayAccess PrimaryRestsopt
'PrimaryRestsNotArrayAccess'(T0,T) -->
	'PrimaryRestNotArrayAccess'(T0,T1),
	'PrimaryRestsopt'(T1,T).

'PrimaryRestsNotArrayAccessopt'(T0,T) -->
	'PrimaryRestsNotArrayAccess'(T0,T). %,{!}.
'PrimaryRestsNotArrayAccessopt'(T,T) --> [].

%%PrimaryRestNotArrayAccess :
%%	. Identifier ( ArgumentListopt )    	<- MethodInvocation
%%	. Identifier				<- FieldAccess
'PrimaryRestNotArrayAccess'(T0,T,[tok('.',_)|S0],S):-
	'Identifier'(Identifier,S0,S1),
	S1=[tok('(',_)|S2],!,
	'ArgumentListopt'(ArgumentListopt,S2,S3),
	S3=[tok(')',_)|S],
	functor(T1,'MethodInvocation',6),
	arg(1,T1,'Primary'(T0)),
	arg(2,T1,'.'),
	arg(3,T1,Identifier),
	arg(4,T1,'('),
	arg(5,T1,ArgumentListopt),
	arg(6,T1,')'),
	T='PrimaryNoNewArray'(T1).
'PrimaryRestNotArrayAccess'(T0,T,[tok('.',_)|S0],S):-
	'Identifier'(Identifier,S0,S),
	functor(T1,'FieldAccess',3),
	arg(1,T1,'Primary'(T0)),
	arg(2,T1,'.'),
	arg(3,T1,Identifier),
	T='PrimaryNoNewArray'(T1).

%PrimaryNoNewArray:
%       this
%       Literal
%       ( Expression )
%       ClassInstanceCreationExpression
%       FieldAccess
%       MethodInvocation
%       ArrayAccess
'PrimaryNoNewArray'(T,[tok(this,_)|S0],S):-!,
	S=S0,
	T='PrimaryNoNewArray'(this).
'PrimaryNoNewArray'(T,S0,S):-
	'Literal'(Literal,S0,S),!,
	T='PrimaryNoNewArray'(Literal).
'PrimaryNoNewArray'(T,[tok('(',_)|S0],S):-!,
	T='PrimaryNoNewArray'('(',Expression,')'),
	'Expression'(Expression,S0,S1),
%	S1=[tok(')',_)|S].
	S1=[tok(Tok,TN)|S],
	(Tok==')' -> true ; error1(') expected',TN)).
'PrimaryNoNewArray'(T,S0,S):-
	T='PrimaryNoNewArray'(ClassInstanceCreationExpression),
	'ClassInstanceCreationExpression'(ClassInstanceCreationExpression,S0,S),!.
'PrimaryNoNewArray'(T,S0,S):-
	'FieldAccess'(FieldAccess,S0,S),!,
	T='PrimaryNoNewArray'(FieldAccess).
'PrimaryNoNewArray'(T,S0,S):-
	'MethodInvocation'(MethodInvocation,S0,S),!,
	T='PrimaryNoNewArray'(MethodInvocation).
'PrimaryNoNewArray'(T,S0,S):-
	'ArrayAccess'(ArrayAccess,S0,S),!,
	T='PrimaryNoNewArray'(ArrayAccess).

%ClassInstanceCreationExpression:
%       new ClassType ( ArgumentListopt )
'ClassInstanceCreationExpression'(T,[tok(new,TN)|S0],S):-
	T='ClassInstanceCreationExpression'(new,ClassType,'(',ArgumentListopt,')'),
        'ClassType'(ClassType,S0,S1),
        S1=[tok('(',_)|S2],
%	(Tok1=='(' -> true ; error1('( expected',TN1)),
        'ArgumentListopt'(ArgumentListopt,S2,S3),
        S3=[tok(Tok2,TN2)|S],
	(Tok2==')' -> true ; error1(') expected',TN2)).
%	S\=[tok('.',_)|_],S\=[tok('[',_)|_]. % for longest matching

%ArgumentList:
%       Expression ArgumentListRestopt
'ArgumentList'('ArgumentList'(
                   Expression,
                   ArgumentListRestopt)) -->
        'Expression'(Expression),
        'ArgumentListRestopt'(ArgumentListRestopt).

'ArgumentListopt'(ArgumentList) -->
	'ArgumentList'(ArgumentList),{!}.
'ArgumentListopt'(nil) --> [].

%ArgumentListRest:
%	, ArgumentList
'ArgumentListRest'(T,[tok(',',_)|S0],S):-
	T='ArgumentListRest'(',',ArgumentList),
	'ArgumentList'(ArgumentList,S0,S).

'ArgumentListRestopt'(ArgumentListRest) -->
	'ArgumentListRest'(ArgumentListRest),{!}.
'ArgumentListRestopt'(nil) --> [].

%ArrayCreationExpression:
%       new PrimitiveType DimExprs Dimsopt
%       new ClassOrInterfaceType DimExprs Dimsopt                 
'ArrayCreationExpression'(T,[tok(new,_)|S0],S):-
	T='ArrayCreationExpression'(new,PrimitiveType,DimExprs,Dimsopt),
        'PrimitiveType'(PrimitiveType,S0,S1),!,
        'DimExprs'(DimExprs,S1,S2),
        'Dimsopt'(Dimsopt,S2,S).
'ArrayCreationExpression'(T,[tok(new,TN)|S0],S):-
	T='ArrayCreationExpression'(new,ClassOrInterfaceType,DimExprs,Dimsopt),
	'ClassOrInterfaceType'(ClassOrInterfaceType,S0,S1),
	'DimExprs'(DimExprs,S1,S2),
        'Dimsopt'(Dimsopt,S2,S).


%DimExprs:
%       DimExpr DimExprsopt
'DimExprs'('DimExprs'(
               DimExpr,
               DimExprsopt)) -->
        'DimExpr'(DimExpr),
        'DimExprsopt'(DimExprsopt).

'DimExprsopt'(DimExprs) -->
	'DimExprs'(DimExprs).
'DimExprsopt'(nil) --> [].

%DimExpr:
%       [ Expression ]
'DimExpr'(T,[tok('[',_)|S0],S):-
	T='DimExpr'('[',Expression,']'),
        'Expression'(Expression,S0,S1),
        S1=[tok(Tok,TN)|S],
	(Tok==']' -> true ; error1('] expected',TN)).

%Dims:
%       [ ] Dimsopt
'Dims'(T,[tok('[',_),tok(']',_)|S0],S):-
%	(S0=[tok(']',_)|S1] -> true ; error('] expected',TN)),
	T='Dims'('[]',Dimsopt),
        'Dimsopt'(Dimsopt,S0,S).

'Dimsopt'(Dims) -->
	'Dims'(Dims).
'Dimsopt'(nil) --> [].


%MethodInvocation:
%        super . Identifier ( ArgumentListopt )
%        Name ( ArgumentListopt )
%%        Primary . Identifier ( ArgumentListopt )
'MethodInvocation'(T,[tok(super,_),tok('.',_)|S0],S):- !,
	T='MethodInvocation'(super,'.',Identifier,'(',ArgumentListopt,')'),
	'Identifier'(Identifier,S0,S1),
	S1=[tok('(',_)|S2],
	'ArgumentListopt'(ArgumentListopt,S2,S3),
	S3=[tok(')',_)|S].
%	S3=[tok(Tok,TN)|S],
%	(Tok==')' -> true ; error1(') expected',TN)),!.
'MethodInvocation'(T,S0,S):-
	'Name'(Name,S0,S1),
	T='MethodInvocation'(Name,'(',ArgumentListopt,')'),
	S1=[tok('(',_)|S2],
	'ArgumentListopt'(ArgumentListopt,S2,S3),
	S3=[tok(')',_)|S].
%	S3=[tok(Tok,TN)|S],
%	(Tok==')' -> true ; error1(') expected',TN)).

%FieldAccess:
%        super . Identifier
%%        Primary . Identifier
'FieldAccess'(T,[tok(super,_),tok('.',_)|S0],S):- 
	T='FieldAccess'(super,'.',Identifier),
	'Identifier'(Identifier,S0,S).
%	S\=[tok('(',_)|_],S\=[tok('[',_)|_].	% for longest matching

%ArrayAccess:
%	Name [ Expression ]
%%	 PrimaryNoNewArray [ Expression ]
'ArrayAccess'(T,S0,S):-
	T='ArrayAccess'(Name,'[',Expression,']'),
	'Name'(Name,S0,S1),% !, bug
	S1=[tok('[',_)|S2],
	'Expression'(Expression,S2,S3),
%	S3=[tok(']',_)|S].
	S3=[tok(Tok,TN)|S],
	(Tok==']' -> true ; error1('] expected',TN)).
%	S\=[tok('[',_)|_].	% for longest matching

%PrimaryOrName :
%	Primary
%	Name
'PrimaryOrName'('PrimaryOrName'(
			Primary)) -->
	'Primary'(Primary).
'PrimaryOrName'('PrimaryOrName'(
			Name)) -->
	'Name'(Name).

%PostIncrementOrDecrementExpression :
%        PrimaryOrName PlusPlusMinusMinus
'PostIncrementOrDecrementExpression'('PostIncrementOrDecrementExpression'(
					PrimaryOrName,
					PlusPlusMinusMinus)) -->
	'PrimaryOrName'(PrimaryOrName),
	'PlusPlusMinusMinus'(PlusPlusMinusMinus).

%PostfixExpression :
%        PrimaryOrName PlusPlusMinusMinusopt
'PostfixExpression'(T) -->
	{T='PostfixExpression'(PrimaryOrName,PlusPlusMinusMinusopt)},
	'PrimaryOrName'(PrimaryOrName),
	'PlusPlusMinusMinusopt'(PlusPlusMinusMinusopt).

%PlusPlusMinusMinus :
%	++ PlusPlusMinusMinusopt
%	-- PlusPlusMinusMinusopt
'PlusPlusMinusMinus'(T,[tok('+',_),tok('+',_)|S0],S):-!,
	T='PlusPlusMinusMinus'('++',PlusPlusMinusMinusopt),
	'PlusPlusMinusMinusopt'(PlusPlusMinusMinusopt,S0,S).
'PlusPlusMinusMinus'(T,[tok('-',_),tok('-',_)|S0],S):-
	T='PlusPlusMinusMinus'('--',PlusPlusMinusMinusopt),
	'PlusPlusMinusMinusopt'(PlusPlusMinusMinusopt,S0,S).

'PlusPlusMinusMinusopt'(PlusPlusMinusMinus) -->
	'PlusPlusMinusMinus'(PlusPlusMinusMinus).
	{!}.
'PlusPlusMinusMinusopt'(nil) --> [].

%UnaryExpression:
%       PreIncrementExpression
%       PreDecrementExpression
%       + UnaryExpression
%       - UnaryExpression
%       UnaryExpressionNotPlusMinus
'UnaryExpression'('UnaryExpression'(
                      PreIncrementExpression)) -->
        'PreIncrementExpression'(PreIncrementExpression),{!}.
'UnaryExpression'('UnaryExpression'(
                      PreDecrementExpression)) -->
        'PreDecrementExpression'(PreDecrementExpression),{!}.
'UnaryExpression'(T,[tok('+',_)|S0],S):-
	T='UnaryExpression'('+',UnaryExpression),
        'UnaryExpression'(UnaryExpression,S0,S),!.
'UnaryExpression'(T,[tok('-',_)|S0],S):-
	T='UnaryExpression'('-',UnaryExpression),
        'UnaryExpression'(UnaryExpression,S0,S),!.
'UnaryExpression'('UnaryExpression'(
                      UnaryExpressionNotPlusMinus)) -->
        'UnaryExpressionNotPlusMinus'(UnaryExpressionNotPlusMinus).

%PreIncrementExpression:
%       ++ UnaryExpression
'PreIncrementExpression'(T,[tok('+',_),tok('+',_)|S0],S):-
	T='PreIncrementExpression'('++',UnaryExpression),
        'UnaryExpression'(UnaryExpression,S0,S).

%PreDecrementExpression:
%       -- UnaryExpression
'PreDecrementExpression'(T,[tok('-',_),tok('-',_)|S0],S):-
	T='PreDecrementExpression'('--',UnaryExpression),
        'UnaryExpression'(UnaryExpression,S0,S).

%UnaryExpressionNotPlusMinus:
%        ~ UnaryExpression
%        ! UnaryExpression
%        CastExpression
%        PostfixExpression
'UnaryExpressionNotPlusMinus'(T,[tok('~',_)|S0],S):-
	T='UnaryExpressionNotPlusMinus'('~',UnaryExpression),
        'UnaryExpression'(UnaryExpression,S0,S),!.
'UnaryExpressionNotPlusMinus'(T,[tok('!',_)|S0],S):-
	T='UnaryExpressionNotPlusMinus'('!',UnaryExpression),
        'UnaryExpression'(UnaryExpression,S0,S),!.
'UnaryExpressionNotPlusMinus'('UnaryExpressionNotPlusMinus'(
                                  CastExpression)) -->
        'CastExpression'(CastExpression),{!}.
'UnaryExpressionNotPlusMinus'('UnaryExpressionNotPlusMinus'(
                                  PostfixExpression)) -->
        'PostfixExpression'(PostfixExpression).

%CastExpression:
%        ( PrimitiveType Dimsopt ) UnaryExpression
%        ( Expression ) UnaryExpressionNotPlusMinus
%        ( Name Dims ) UnaryExpressionNotPlusMinus
'CastExpression'(T,[tok('(',_)|S0],S):-
	T='CastExpression'('(',PrimitiveType,Dimsopt,')',UnaryExpression),
	'PrimitiveType'(PrimitiveType,S0,S1),
	'Dimsopt'(Dimsopt,S1,S2),
	S2=[tok(Tok,TN)|S3],
	(Tok==')' -> true ; error1(') expected',TN)),
	'UnaryExpression'(UnaryExpression,S3,S),!.
'CastExpression'(T,[tok('(',_)|S0],S):-
	T='CastExpression'('(',Expression,')',UnaryExpressionNotPlusMinus),
	'Expression'(Expression,S0,S1),
%	S1=[tok(')',_)|S2],
	S1=[tok(Tok,TN)|S2],
	(Tok==')' -> true ; error1(') expected',TN)),
	'UnaryExpressionNotPlusMinus'(UnaryExpressionNotPlusMinus,S2,S),!.
'CastExpression'(T,[tok('(',_)|S0],S):-
	T='CastExpression'('(',Name,Dims,')',UnaryExpressionNotPlusMinus),
	'Name'(Name,S0,S1),
	'Dims'(Dims,S1,S2),
	S2=[tok(Tok,TN)|S3],
	(Tok==')' -> true ; error1(') expected',TN)),
	'UnaryExpressionNotPlusMinus'(UnaryExpressionNotPlusMinus,S3,S).


%MultiplicativeExpression:
%       UnaryExpression MultiplicativeExpressionRestopt
'MultiplicativeExpression'('MultiplicativeExpression'(
				UnaryExpression,
				MultiplicativeExpressionRestopt)) -->
	'UnaryExpression'(UnaryExpression),
	'MultiplicativeExpressionRestopt'(MultiplicativeExpressionRestopt).

%MultiplicativeExpressionRest:
%       * MultiplicativeExpression
%       / MultiplicativeExpression
%       % MultiplicativeExpression
'MultiplicativeExpressionRest'(T,[tok('*',_)|S0],S):-!,
	T='MultiplicativeExpressionRest'('*',MultiplicativeExpression),
        'MultiplicativeExpression'(MultiplicativeExpression,S0,S).
'MultiplicativeExpressionRest'(T,[tok('/',_)|S0],S):-!,
	T='MultiplicativeExpressionRest'('/',MultiplicativeExpression),
        'MultiplicativeExpression'(MultiplicativeExpression,S0,S).
'MultiplicativeExpressionRest'(T,[tok('%',_)|S0],S):-
	T='MultiplicativeExpressionRest'('%',MultiplicativeExpression),
        'MultiplicativeExpression'(MultiplicativeExpression,S0,S).

'MultiplicativeExpressionRestopt'(MultiplicativeExpressionRest) -->
	'MultiplicativeExpressionRest'(MultiplicativeExpressionRest),{!}.
'MultiplicativeExpressionRestopt'(nil) --> [].

%AdditiveExpression:
%       MultiplicativeExpression AdditiveExpressionRestopt
'AdditiveExpression'('AdditiveExpression'(
				MultiplicativeExpression,
				AdditiveExpressionRestopt)) -->
	'MultiplicativeExpression'(MultiplicativeExpression),
	'AdditiveExpressionRestopt'(AdditiveExpressionRestopt).

%AdditiveExpressionRest:
%       + AdditiveExpression
%       - AdditiveExpression
'AdditiveExpressionRest'(T,[tok('+',_)|S0],S):-!,
	T='AdditiveExpressionRest'('+',AdditiveExpression),
        'AdditiveExpression'(AdditiveExpression,S0,S).
'AdditiveExpressionRest'(T,[tok('-',_)|S0],S):-
	T='AdditiveExpressionRest'('-',AdditiveExpression),
        'AdditiveExpression'(AdditiveExpression,S0,S).


'AdditiveExpressionRestopt'(AdditiveExpressionRest) --> 
	'AdditiveExpressionRest'(AdditiveExpressionRest),{!}.
'AdditiveExpressionRestopt'(nil) --> [].

%ShiftExpression:
%        AdditiveExpression ShiftExpressionRestopt
'ShiftExpression'('ShiftExpression'(
			AdditiveExpression,
			ShiftExpressionRestopt)) -->
        'AdditiveExpression'(AdditiveExpression),
	'ShiftExpressionRestopt'(ShiftExpressionRestopt).

%ShiftExpressionRest:
%        << ShiftExpression
%        >> ShiftExpression
%        >>> ShiftExpression
'ShiftExpressionRest'(T,[tok('<',_),tok('<',_)|S0],S):-!,
	T='ShiftExpressionRest'('<<',ShiftExpression),
        'ShiftExpression'(ShiftExpression,S0,S).
'ShiftExpressionRest'(T,[tok('>',_),tok('>',_)|S0],S):-!,
	T='ShiftExpressionRest'('>>',ShiftExpression),
        'ShiftExpression'(ShiftExpression,S0,S).
'ShiftExpressionRest'(T,[tok('>',_),tok('>',_),tok('>',_)|S0],S):-
	T='ShiftExpressionRest'('>>>',ShiftExpression),
        'ShiftExpression'(ShiftExpression,S0,S).

'ShiftExpressionRestopt'(ShiftExpressionRest) -->
	'ShiftExpressionRest'(ShiftExpressionRest),{!}.
'ShiftExpressionRestopt'(nil) --> [].

%RelationalExpression:
%       ShiftExpression RelationalExpressionRestopt
'RelationalExpression'('RelationalExpression'(
                                ShiftExpression,
				RelationalExpressionRestopt)) -->
        'ShiftExpression'(ShiftExpression),
	'RelationalExpressionRestopt'(RelationalExpressionRestopt).

%RelationalExpressionRest:
%       <= RelationalExpression
%       >= RelationalExpression
%       < RelationalExpression
%       > RelationalExpression
%       instanceof ReferenceType
'RelationalExpressionRest'(T,[tok('<',_),tok('=',_)|S0],S):-!,
	T='RelationalExpressionRest'('<=',RelationalExpression),
        'RelationalExpression'(RelationalExpression,S0,S).
'RelationalExpressionRest'(T,[tok('>',_),tok('=',_)|S0],S):-!,
	T='RelationalExpressionRest'('>=',RelationalExpression),
        'RelationalExpression'(RelationalExpression,S0,S).
'RelationalExpressionRest'(T,[tok('<',_)|S0],S):-!,
	T='RelationalExpressionRest'('<',RelationalExpression),
        'RelationalExpression'(RelationalExpression,S0,S).
'RelationalExpressionRest'(T,[tok('>',_)|S0],S):-!,
	T='RelationalExpressionRest'('>',RelationalExpression),
        'RelationalExpression'(RelationalExpression,S0,S).
'RelationalExpressionRest'(T,[tok(instanceof,_)|S0],S):-
	T='RelationalExpressionRest'(instanceof,ReferenceType),
        'ReferenceType'(ReferenceType,S0,S).

'RelationalExpressionRestopt'(RelationalExpressionRest) --> 
	'RelationalExpressionRest'(RelationalExpressionRest),{!}.
'RelationalExpressionRestopt'(nil) --> [].

%EqualityExpression:
%       RelationalExpression EqualityExpressionRestopt
'EqualityExpression'('EqualityExpression'(
		                RelationalExpression,
				EqualityExpressionRestopt)) -->
        'RelationalExpression'(RelationalExpression),
	'EqualityExpressionRestopt'(EqualityExpressionRestopt).

%EqualityExpressionRest:
%       == EqualityExpression
%       != EqualityExpression
'EqualityExpressionRest'(T,[tok('=',_),tok('=',_)|S0],S):-!,
	T='EqualityExpressionRest'('==',EqualityExpression),
        'EqualityExpression'(EqualityExpression,S0,S).
'EqualityExpressionRest'(T,[tok('!',_),tok('=',_)|S0],S):-
	T='EqualityExpressionRest'('!=',EqualityExpression),
        'EqualityExpression'(EqualityExpression,S0,S).

'EqualityExpressionRestopt'(EqualityExpressionRest) -->
	'EqualityExpressionRest'(EqualityExpressionRest),{!}.
'EqualityExpressionRestopt'(nil) --> [].

%AndExpression:
%        EqualityExpression AndExpressionRestopt
'AndExpression'('AndExpression'(
	                EqualityExpression,
			AndExpressionRestopt)) -->
        'EqualityExpression'(EqualityExpression),
	'AndExpressionRestopt'(AndExpressionRestopt).

%AndExpressionRest:
%        & AndExpression
'AndExpressionRest'(T,[tok('&',_)|S0],S):-
	T='AndExpressionRest'('&',AndExpression),
        'AndExpression'(AndExpression,S0,S).

'AndExpressionRestopt'(AndExpressionRest) -->
	'AndExpressionRest'(AndExpressionRest),{!}.
'AndExpressionRestopt'(nil) --> [].

%ExclusiveOrExpression:
%        AndExpression ExclusiveOrExpressionRestopt
'ExclusiveOrExpression'('ExclusiveOrExpression'(
                                AndExpression,
				ExclusiveOrExpressionRestopt)) -->
        'AndExpression'(AndExpression),
	'ExclusiveOrExpressionRestopt'(ExclusiveOrExpressionRestopt).

%ExclusiveOrExpressionRest:
%        ^ ExclusiveOrExpression
'ExclusiveOrExpressionRest'(T,[tok('^',_)|S0],S):-
	T='ExclusiveOrExpressionRest'('^',ExclusiveOrExpression),
        'ExclusiveOrExpression'(ExclusiveOrExpression,S0,S).

'ExclusiveOrExpressionRestopt'(ExclusiveOrExpressionRest) -->
	'ExclusiveOrExpressionRest'(ExclusiveOrExpressionRest),{!}.
'ExclusiveOrExpressionRestopt'(nil) --> [].

%InclusiveOrExpression:
%        ExclusiveOrExpression InclusiveOrExpressionRestopt
'InclusiveOrExpression'('InclusiveOrExpression'(
                                ExclusiveOrExpression,
				InclusiveOrExpressionRestopt)) -->
        'ExclusiveOrExpression'(ExclusiveOrExpression),
	'InclusiveOrExpressionRestopt'(InclusiveOrExpressionRestopt).

%InclusiveOrExpressionRest:
%        | InclusiveOrExpression
'InclusiveOrExpressionRest'(T,[tok('|',_)|S0],S):-
	T='InclusiveOrExpressionRest'('|',InclusiveOrExpression),
        'InclusiveOrExpression'(InclusiveOrExpression,S0,S).

'InclusiveOrExpressionRestopt'(InclusiveOrExpressionRest) -->
	'InclusiveOrExpressionRest'(InclusiveOrExpressionRest),{!}.
'InclusiveOrExpressionRestopt'(nil) --> [].

%ConditionalAndExpression:
%       InclusiveOrExpression ConditionalAndExpressionRestopt
'ConditionalAndExpression'('ConditionalAndExpression'(
                                InclusiveOrExpression,
				ConditionalAndExpressionRestopt)) -->
        'InclusiveOrExpression'(InclusiveOrExpression),
	'ConditionalAndExpressionRestopt'(ConditionalAndExpressionRestopt).

%ConditionalAndExpressionRest:
%       && ConditionalAndExpression
'ConditionalAndExpressionRest'(T,[tok('&',_),tok('&',_)|S0],S):-
	T='ConditionalAndExpressionRest'('&&',ConditionalAndExpression),
        'ConditionalAndExpression'(ConditionalAndExpression,S0,S).

'ConditionalAndExpressionRestopt'(ConditionalAndExpressionRest)  -->
	'ConditionalAndExpressionRest'(ConditionalAndExpressionRest),{!}.
'ConditionalAndExpressionRestopt'(nil)--> [].

%ConditionalOrExpression:
%       ConditionalAndExpression ConditionalOrExpressionRestopt
'ConditionalOrExpression'('ConditionalOrExpression'(
                                ConditionalAndExpression,
				ConditionalOrExpressionRestopt)) -->
        'ConditionalAndExpression'(ConditionalAndExpression),
	'ConditionalOrExpressionRestopt'(ConditionalOrExpressionRestopt).

%ConditionalOrExpressionRest:
%       || ConditionalOrExpression
'ConditionalOrExpressionRest'(T,[tok('|',_),tok('|',_)|S0],S):-
	T='ConditionalOrExpressionRest'('||',ConditionalOrExpression),
        'ConditionalOrExpression'(ConditionalOrExpression,S0,S).

'ConditionalOrExpressionRestopt'(ConditionalOrExpressionRest) -->
	'ConditionalOrExpressionRest'(ConditionalOrExpressionRest),{!}.
'ConditionalOrExpressionRestopt'(nil) --> [].

%ConditionalExpression:
%        ConditionalOrExpression ConditionalExpressionRestopt
'ConditionalExpression'('ConditionalExpression'(
                            ConditionalOrExpression,
			    ConditionalExpressionRestopt)) -->
        'ConditionalOrExpression'(ConditionalOrExpression),
	'ConditionalExpressionRestopt'(ConditionalExpressionRestopt).

%ConditionalExpressionRest:
%        ? Expression : ConditionalExpression
'ConditionalExpressionRest'(T,[tok('?',_)|S0],S):-
	T='ConditionalExpressionRest'('?',Expression,':',ConditionalExpression),
        'Expression'(Expression,S0,S1),
        S1=[tok(Tok,TN)|S2],
	(Tok==':' -> true ; error1(': expected',TN)),
        'ConditionalExpression'(ConditionalExpression,S2,S).

'ConditionalExpressionRestopt'(ConditionalExpressionRest) -->
	'ConditionalExpressionRest'(ConditionalExpressionRest),{!}.
'ConditionalExpressionRestopt'(nil) --> [].

%AssignmentExpression:
%       Assignment
%       ConditionalExpression
'AssignmentExpression'('AssignmentExpression'(
                           Assignment)) -->
        'Assignment'(Assignment),{!}.
'AssignmentExpression'('AssignmentExpression'(
                           ConditionalExpression)) -->
        'ConditionalExpression'(ConditionalExpression),{!}.

%Assignment:
%       LeftHandSide AssignmentOperator AssignmentExpression
'Assignment'('Assignment'(
                 LeftHandSide,
                 AssignmentOperator,
                 AssignmentExpression)) -->
        'LeftHandSide'(LeftHandSide),
        'AssignmentOperator'(AssignmentOperator),
        'AssignmentExpression'(AssignmentExpression).

%LeftHandSide:
%       FieldAccess
%       ArrayAccess
%       Name
'LeftHandSide'('LeftHandSide'(
                   AssignmentFieldAccess)) -->
        'AssignmentFieldAccess'(AssignmentFieldAccess),{!}.
'LeftHandSide'('LeftHandSide'(
                   AssignmentArrayAccess)) -->
        'AssignmentArrayAccess'(ArrayAccess),{!}.
'LeftHandSide'('LeftHandSide'(
                   Name)) -->
        'Name'(Name).

%AssignmentOperator: one of
%       = *= /= %= += -= <<= >>= >>>= &= ^= |=
:-mode 'AssignmentOperator'(-,+,-).
'AssignmentOperator'(T,[tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('=').
'AssignmentOperator'(T,[tok('*',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('*=').
'AssignmentOperator'(T,[tok('/',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('/=').
'AssignmentOperator'(T,[tok('%',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('%=').
'AssignmentOperator'(T,[tok('+',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('+=').
'AssignmentOperator'(T,[tok('-',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('-=').
'AssignmentOperator'(T,[tok('<',_),tok('<',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('<<=').
'AssignmentOperator'(T,[tok('>',_),tok('>',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('>>=').
'AssignmentOperator'(T,[tok('>',_),tok('>',_),tok('>',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('>>>=').
'AssignmentOperator'(T,[tok('&',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('&=').
'AssignmentOperator'(T,[tok('^',_),tok('=',_)|S0],S):-!,
	S0=S,T='AssignmentOperator'('^=').
'AssignmentOperator'(T,[tok('|',_),tok('=',_)|S0],S):-
	S0=S,T='AssignmentOperator'('|=').

%Expression:
%       AssignmentExpression
'Expression'('Expression'(
                 AssignmentExpression)) -->
        'AssignmentExpression'(AssignmentExpression).

'Expressionopt'(Expression) -->
	'Expression'(Expression),{!}.
'Expressionopt'(nil) --> [].

%ConstantExpression:
%       Expression
'ConstantExpression'('ConstantExpression'(
                         Expression)) -->
        'Expression'(Expression).

%AssignmentFieldAccess:		<- FieldAccess
%	Primary . Identifier
%	super . Identifier
'AssignmentFieldAccess'(T,S0,S):-
	T='FieldAccess'(Primary,'.',Identifier),
	'Primary'(Primary,S0,S1),
	S1=[tok('.',_)|S2],
	'Identifier'(Identifier,S2,S),!.
'AssignmentFieldAccess'(T,[tok(super,_),tok('.',_)|S0],S):-
	T='FieldAccess'(super,'.',Identifier),
	'Identifier'(Identifier,S0,S).

%AssignmentArrayAccess:		<- ArrayAccess
%	PrimaryNoNewArray [ Expresion ]
%	Name [ Expression ]
'AssignmentArrayAccess'(T,S0,S):-
	T='ArrayAccess'(PrimaryNoNewArray,'[',Expression,']'),
	'PrimaryNoNewArray'(PrimaryNoNewArray,S0,S1),
	S1=[tok('[',_)|S2],
	'Expression'(Expression,S2,S3),
	S3=[tok(']',_)|S],!.
'AssignmentArrayAccess'(T,S0,S):-
	T='ArrayAccess'(Name,'[',Expression,']'),
	'Name'(Name,S0,S1),
	S1=[tok('[',_)|S2],
	'Expression'(Expression,S2,S3),
	S3=[tok(']',_)|S].

%StatementMethodInvocation:	<- MethodInvocation
%        Primary . Identifier ( ArgumentListopt )
%        super . Identifier ( ArgumentListopt )
%        Name ( ArgumentListopt )
'StatementMethodInvocation'(T,S0,S):- 
	T='MethodInvocation'(Primary,'.',Identifier,'(',ArgumentListopt,')'),
	'Primary'(Primary,S0,S1),
	S1=[tok('.',_)|S2],
	'Identifier'(Identifier,S2,S3),
	S3=[tok('(',_)|S4],
	'ArgumentListopt'(ArgumentListopt,S4,S5),
	S5=[tok(Tok,TN)|S],
	(Tok==')' -> true ; error1(') expected',TN)),!.
'StatementMethodInvocation'(T,[tok(super,_),tok('.',_)|S0],S):- 
	T='MethodInvocation'(super,'.',Identifier,'(',ArgumentListopt,')'),
	'Identifier'(Identifier,S0,S1),
	S1=[tok('(',_)|S2],
	'ArgumentListopt'(ArgumentListopt,S2,S3),
	S3=[tok(Tok,TN)|S],
	(Tok==')' -> true ; error1(') expected',TN)),!.
'StatementMethodInvocation'(T,S0,S):-
	'Name'(Name,S0,S1),
	T='MethodInvocation'(Name,'(',ArgumentListopt,')'),
	S1=[tok('(',_)|S2],
	'ArgumentListopt'(ArgumentListopt,S2,S3),
	S3=[tok(')',_)|S].
%	S3=[tok(Tok,TN)|S],
%	(Tok==')' -> true ; error1(') expected',TN)).
