%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
go:-
    whatpreds([djMain,dj2pro,extractCSP,createInstance,baseConstraints,solveCSP,baseClasses,util,
	       postConstraint,djEval,djDelay,generateJava,collectAttributes,star]).


displayObj(nil,Name):-!.
displayObj(object(ObjectNo,Identifier,Constants,SuperObject,Hashtable,Bound),Name):-!,
    displayObj(SuperObject,Name),
    Bound=$bound(X1,Y1,Width,Height),
    write_domain_var(my_x,[Identifier|Name],X1),
    write_domain_var(my_y,[Identifier|Name],Y1),
    write_domain_var(my_width,[Identifier|Name],Width),
    write_domain_var(my_height,[Identifier|Name],Height),
    write(Identifier),write('.my_x'),
    hashtableCollect(Hashtable,ACList),
    displayObjs(ACList,Name),
    write('%%%%%%%%%%%%%%%%%'),nl.
displayObj(array(Size,Type,Components),Name):-!,
    hashtableCollect(Components,All),
    displayObjs(All,Name).
displayObj(BaseObj,Name):-
    displayBaseObj(BaseObj,Name),
    functor(BaseObj,F,N),
    (F=='Circle'->
     getBaseAttribute(centerX,CenterX,_,BaseObj),
     getBaseAttribute(centerY,CenterY,_,BaseObj),
     write_domain_var(centerX,Name,CenterX),    
     write_domain_var(centerY,Name,CenterY);
     F=='Line'->
     getBaseAttribute(x1,X1,_,BaseObj),
     getBaseAttribute(y1,Y1,_,BaseObj),
     getBaseAttribute(x2,X2,_,BaseObj),
     getBaseAttribute(y2,Y2,_,BaseObj),
     write_domain_var(x1,Name,X1),
     write_domain_var(y1,Name,Y1),
     write_domain_var(x2,Name,X2),
     write_domain_var(y2,Name,Y2);
     true).
     

displayBaseObj(BaseObj,Name):-
    getBaseAttribute(x,X,_,BaseObj),
    getBaseAttribute(y,Y,_,BaseObj),
    getBaseAttribute(width,W,_,BaseObj),
    getBaseAttribute(height,H,_,BaseObj),
    getBaseAttribute(color,Color,_,BaseObj),
    write_domain_var(x,Name,X),
    write_domain_var(y,Name,Y),
    write_domain_var(width,Name,W),
    write_domain_var(height,Name,H),
    write_domain_var(color,Name,Color).

displayObjs([],Name).
displayObjs([elm(Id,component(Class,Obj))|Cs],Name):-
    displayObj(Obj,[Id|Name]),
    displayObjs(Cs,Name).
displayObjs([elm(Id,attribute(Type,DVar))|Cs],Name):-
    write_domain_var(Id,Name,DVar),
    displayObjs(Cs,Name).

displayAttributeValue(Object,Name):-!,
    object(ObjectNo,Identifier,Constants,SuperObject,Hashtable,Bound)<=Object :
    (getTypeAndValueFromHashtable(Name,_,Elm,ObjAttributes)->write((Name,Elm)),nl;
     hashtableCollect(Hashtable,All),
     displayAttributeValue(All,Name)).
displayAttributeValue(array(Size,Type,Components),Name):-!,
    hashtableCollect(Components,All),
    displayAttributeValue(All,Name).
displayAttributeValue([],Name):-!.
displayAttributeValue([elm(Id,component(Class,Obj))|Cs],Name):-!,
    displayAttributeValue(Obj,Name),
    displayAttributeValue(Cs,Name).
displayAttributeValue(_,Name).

write_domain_var(Id,Name,X):-
    write_identifier(Id,Name),
    write(' : '),
    write(X),nl.
    
write_identifier(Id,Name):-
    write_name(Name),
    write(Id).
    
write_name([]).
write_name([A|As]):-
    write_name(As),
    write(A),write('.').

writeDVars([]).
writeDVars([int(Var)|Vars]):-!,
    fd_min(Var,Min),fd_max(Var,Max),
    write(int(Var)),write(':'),write(Min),write('..'),write(Max),nl,
    writeDVars(Vars).
writeDVars([_|Vars]):-
    writeDVars(Vars).
    
