%   File   : main.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: implement command dj
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
dj:-
    '_$savecp'(Cp),
    global_set('_$interrupt',0,Cp),
    initialize_bp,
    write('DJ compiler version 0.2 beta, (C) All rights reserved, 1998'),nl,
    get_main_args(L),  % builtin in B-Prolog 
    process_main_args(L,Files),
    initializeDJ,
    dj1(Files).
dj:-write(user,'no solution'),nl(user).

process_main_args(['-w',WidthAtom|L],Files):-
    true :
    atom_to_integer(WidthAtom,Width),
    global_set(screenWidth,Width),
    process_main_args(L,Files).
process_main_args(['-h',HeightAtom|L],Files):-
    true :
    atom_to_integer(HeightAtom,Height),
    global_set(screenHeight,Height),
    process_main_args(L,Files).
process_main_args(['-tm',MarginAtom|L],Files):-
    true :
    atom_to_integer(MarginAtom,Margin),
    global_set(topMargin,Margin),
    process_main_args(L,Files).
process_main_args(['-lm',MarginAtom|L],Files):-
    true :
    atom_to_integer(MarginAtom,Margin),
    global_set(leftMargin,Margin),
    process_main_args(L,Files).
process_main_args(['-rm',MarginAtom|L],Files):-
    true :
    atom_to_integer(MarginAtom,Margin),
    global_set(rightMargin,Margin),
    process_main_args(L,Files).
process_main_args(['-bm',MarginAtom|L],Files):-
    true :
    atom_to_integer(MarginAtom,Margin),
    global_set(bottomMargin,Margin),
    process_main_args(L,Files).
process_main_args(['-help'|L],Files):-
    true :
    print_help,
    halt.
process_main_args([File|L],Files):-
    true :
    (checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml)->true;
     write('File not found: '),write(File),nl,
     print_help,halt),
    Files=[InDj|FilesRest],
    process_main_args(L,FilesRest).
process_main_args([],Files):-true : Files=[].

print_help:-
    write('Usage: dj [-w Int] [-h Int] [-tm Int] [-lm Int] [-bm Int] [-rm] file ... file'),nl.
    
    
dj1([]):-true : 
    print_help,
    halt.
dj1(Files):-
    parseMultiFiles(Files,Trees),!,
    write(user,'parsed successfully'),nl(user),
    extractCSP(Trees,ClassDecls,DVars,MainObject),
    (getClassName(MainObject,MainClassName)->true;
     cmpError(['No main class specified'])),
    solveCSP(DVars),
    name(MainClassName,MainFileString),
    name('.java',StringJava),
    append(MainFileString,StringJava,StringOutJava),
    name(OutJava,StringOutJava),
    name('.html',StringHtml),
    append(MainFileString,StringHtml,StringOutHtml),
    name(OutHtml,StringOutHtml),
    tell(OutJava),
    generateJava(ClassDecls,MainObject),
    told,
    write('The generated Java program is stored in '),write(OutJava),nl,
    tell(OutHtml),
    generateHtml(MainFileString),
    told.

checkCmpFiles([],DjFiles):-
    true : DjFiles=[].
checkCmpFiles([File|Files],DjFiles):-
    true :
    checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml),
    DjFiles=[InDj|DjFilesRest],
    checkCmpFiles(Files,DjFilesRest).

parseMultiFiles([],Trees):-true : Trees=[].
parseMultiFiles([File|Files],Trees):-
    true :
    parse(File,Tree),
    Trees=[Tree|Trees1],
    parseMultiFiles(Files,Trees1).

dj(File):-
    atom(File) :
    checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml),
    initializeDJ,
    parse(InDj,Tree),!,
    write(user,'parsed successfully'),nl(user),
    extractCSP(Tree,ClassDecls,DVars,MainObject),
    solveCSP(DVars),
    tell(OutJava),
    generateJava(ClassDecls,MainObject),
    told,
    write('The generated Java program is stored in '),write(OutJava),nl,
    tell(OutHtml),
    generateHtml(MainFileString),
    told.
dj(File):-
    true :
    cmpError(['File error:',File]).

testdj(File):-
    checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml),
    initializeDJ,
    parse(InDj,Tree),!,
    extractCSP(Tree,ClassDecls,DVars,MainObject),
    solveCSP(DVars),
    displayObj(MainObject,[]),
    generateJava(ClassDecls,MainObject).

checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml):-
    exists(File),
    name(File,FileString),
    append(MainFileString,".dj",FileString),!,
    InDj=File,
    append(MainFileString,".token",InTokenString),
    name(InToken,InTokenString),
    append(MainFileString,".java",OutJavaString),
    name(OutJava,OutJavaString),
    append(MainFileString,".html",OutHtmlString),
    name(OutHtml,OutHtmlString).  
checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml):-
    MainFile=File,
    name(MainFile,MainFileString),
    append(MainFileString,".dj",InDjString),
    name(InDj,InDjString),
    exists(InDj),!,
    append(MainFileString,".token",InTokenString),
    name(InToken,InTokenString),
    append(MainFileString,".java",OutJavaString),
    name(OutJava,OutJavaString),
    append(MainFileString,".html",OutHtmlString),
    name(OutHtml,OutHtmlString).
checkCmpFile(File,MainFileString,InDj,InToken,OutJava,OutHtml):-
    runError(['No such file:',File]).

initializeDJ:-
    (isglobal(screenWidth,0)->true;global_set(screenWidth,500)),
    (isglobal(screenHeight,0)->true;global_set(screenHeight,500)),
    (isglobal(leftMargin,0)->true;global_set(leftMargin,0)),
    (isglobal(topMargin,0)->true;global_set(topMargin,0)),
    (isglobal(bottomMargin,0)->true;global_set(bottomMargin,0)),
    (isglobal(rightMargin,0)->true;global_set(rightMargin,0)),
    global_set($instance_no,0).
    
copyFile(File):-
    see(File),
    get0(X),
    copyFileByByte(X),
    seen.

copyFileByByte(-1):-true : true.
copyFileByByte(X):-true : 
    put(X),
    get0(AnotherX),
    copyFileByByte(AnotherX).

generateHtml(MainFileString):-
    name(MainFile,MainFileString),
    write('<html>'),nl,
    write('<head>'),nl,
    write('<title>'),write(MainFile),write('</title>'),nl,
    write('</head>'),nl,
    write('<body>'),nl,
    write('<hr>'),nl,
    write('<applet'),nl,
    tab(4),write('code = '),write(MainFile),nl,
    global_get(screenWidth,Width),
    tab(4),write('width = '),write(Width),nl,
    global_get(screenHeight,Height),
    tab(4),write('height = '),write(Height),write('>'),nl,
    write('</applet>'),nl,
    write('<hr>'),nl,
    write('</body>'),nl,
    write('</html>'),nl.




    
