%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : djEval.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: evaluate constraints
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evalConstrRange(L..U,NewE,Type,ClassDecls,Object,Replaces):-
    true :
    NewE=(NewL..NewU),
    evalConstrExp(L,NewL,Type1,ClassDecls,Object,Replaces,_),
    evalConstrExp(U,NewU,Type2,ClassDecls,Object,Replaces,_),
    (Type1==Type2->Type=Type1;
     cmpError(['Types mismatch: ',L,U])).
evalConstrRange(Range,NewE,Type,ClassDecls,Object,Replaces):-
    [X|Set]<=Range : 
    evalConstrExp(X,NewX,Type1,ClassDecls,Object,Replaces,_),
    NewE=[NewX|NewE1],
    evalConstrSet(Set,NewE1,Type1,Type,ClassDecls,Object,Replaces).

evalConstrSet([],NewSet,Type1,Type,ClassDecls,Object,Replaces):-
    true : Type=Type1,NewSet=[].
evalConstrSet([E|Es],NewSet,Type1,Type,ClassDecls,Object,Replaces):-
    true :
    evalConstrExp(E,NewE,Type2,ClassDecls,Object,Replaces,_),
    (Type1==Type2->true;
     cmpError(['Types mismatch in range [... ',E,' ...'])),
     NewSet=[NewE|NewSet1],
     evalConstrSet(Es,NewSet1,Type1,Type,ClassDecls,Object,Replaces).
    
evalCondition(Condition,Result,ClassDecls,Object,Replaces):-
    true :
    evalConstrAsExp(Condition,NewCondition,Type,ClassDecls,Object,Replaces),
    evalConstrCondition1(NewCondition,Result).
    
evalConstrCondition1(Condition,Result):-
    ground(Condition),!,
    (call(Condition)->Result=true;Result=false).
evalConstrCondition1(Condition,Result):-
    true :
    vars_set(Condition,Vars),
    Result=susp(Vars,Condition).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evalConstrArgs([],NArgs,Types,ClassDecls,Object,Replaces):-true : NArgs=[],Types=[].
evalConstrArgs([Arg|Args],NArgs,Types,ClassDecls,Object,Replaces):-
    true :
    NArgs=[NArg|NArgs1],
    Types=[Type|Types1],
    evalConstrArg(Arg,NArg,Type,ClassDecls,Object,Replaces),
    evalConstrArgs(Args,NArgs1,Types1,ClassDecls,Object,Replaces).
    
evalConstrArg(anonymousArray(Size,Elements),NArg,Type,ClassDecls,Object,Replaces):-
    true :
    hashtableCreate(Size,Hashtable),
    evalAnonymousArray(Elements,0,bottom,TypeLub,Hashtable,ClassDecls,Object,Replaces),
    Type=array(TypeLub),
    NArg=array(Size,TypeLub,Hashtable).
evalConstrArg(Arg,NArg,Type,ClassDecls,Object,Replaces):-
    true :
    evalConstrExp(Arg,NArg,Type,ClassDecls,Object,Replaces,_).

evalAnonymousArray([],N0,TypeLub0,TypeLub,Hashtable,ClassDecls,Object,Replaces):-
    true : TypeLub = TypeLub0.
evalAnonymousArray([Elm|Elms],N0,TypeLub0,TypeLub,Hashtable,ClassDecls,Object,Replaces):-
    true : 
    evalConstrArg(Elm,NElm,TypeLub1,ClassDecls,Object,Replaces),
    hashtableSet(N0,unknown(TypeLub1,NElm),Hashtable),
    typeLub(TypeLub0,TypeLub1,TypeLub2),
    N1 is N0+1,
    evalAnonymousArray(Elms,N1,TypeLub2,TypeLub,Hashtable,ClassDecls,Object,Replaces).
    
evalConstrAsExp([],NewE,Type,ClassDecls,Object,Replaces):-
    true : NewE=[].
evalConstrAsExp([E|Es],NewEs,Type,ClassDecls,Object,Replaces):-
    true : 
    NewEs=[NewE|NewEs1],
    evalConstrAsExp(E,NewE,Type,ClassDecls,Object,Replaces),
    evalConstrAsExp(Es,NewEs1,Type,ClassDecls,Object,Replaces).
evalConstrAsExp({Constr},NewE,Type,ClassDecls,Object,Replaces):-
    true :
    evalConstrAsExp(Constr,NewE,Type,ClassDecls,Object,Replaces).
evalConstrAsExp(E,NewE,Type,ClassDecls,Object,Replaces):-
    true :
    evalConstrExp(E,NewE,Type,ClassDecls,Object,Replaces,_).

evalConstrExp(my_x,NewE,Type,ClassDecls,Object,Replaces,_):-
    true : 
    getGeometricAttribute(my_x,NewE,Object),
    Type=int.
evalConstrExp(my_y,NewE,Type,ClassDecls,Object,Replaces,_):-
    true : 
    getGeometricAttribute(my_y,NewE,Object),
    Type=int.
evalConstrExp(my_width,NewE,Type,ClassDecls,Object,Replaces,_):-
    true : 
    getGeometricAttribute(my_width,NewE,Object),
    Type=int.
evalConstrExp(my_height,NewE,Type,ClassDecls,Object,Replaces,_):-
    true : 
    getGeometricAttribute(my_height,NewE,Object),
    Type=int.
evalConstrExp(true,NewE,Type,ClassDecls,Object,Replaces,_):-
    true : NewE=true,Type=boolean.
evalConstrExp(false,NewE,Type,ClassDecls,Object,Replaces,_):-
    true : NewE=false,Type=boolean.
evalConstrExp(leftMargin,NewE,Type,ClassDecls,Object,Replaces,_):-
    true :
    global_get(leftMargin,0,NewE),
    Type=int.
evalConstrExp(rightMargin,NewE,Type,ClassDecls,Object,Replaces,_):-
    true :
    global_get(rightMargin,0,NewE),
    Type=int.
evalConstrExp(topMargin,NewE,Type,ClassDecls,Object,Replaces,_):-
    true :
    global_get(topMargin,0,NewE),
    Type=int.
evalConstrExp(bottomMargin,NewE,Type,ClassDecls,Object,Replaces,_):-
    true :
    global_get(bottomMargin,0,NewE),
    Type=int.
evalConstrExp(screenWidth,NewE,Type,ClassDecls,Object,Replaces,_):-
    true :
    global_get(screenWidth,0,NewE),
    Type=int.
evalConstrExp(screenHeight,NewE,Type,ClassDecls,Object,Replaces,_):-
    true :
    global_get(screenHeight,0,NewE),
    Type=int.
evalConstrExp('StringConst'(S),NewE,Type,ClassDecls,Object,Replaces,_):-
    true : 
    NewE=S,Type='String'.
evalConstrExp('String'(S),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true : 
    evalConstrExp(S,NewS,Type1,ClassDecls,Object,Replaces,TOP),
    convertToString(NewS,Type1,NewE,Type).
evalConstrExp(this,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    NewE=Object,
    getClassName(Object,Type).
evalConstrExp(length,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    array(Size,ElmType,Hashtable)<=Object :
    NewE=Size,
    Type=int.
evalConstrExp((super.Name),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    superInstance(Object,SuperObject),
    evalConstrExp(Name,NewE,Type,ClassDecls,SuperObject,Replaces,false).
evalConstrExp(('Color'.Name),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    checkTypeColor(Name) :
    NewE=Name,
    Type='Color'.
evalConstrExp((Pre.Name),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    (atom(Pre),hashtableGet(Pre,Class,ClassDecls)->
     Class=class(PIdentifier,Constants,SuperClass,CompAttributes,Constrs,ClassBody,_,_),
     lookupConstant(public,Type,Name,NewE,Constants);
     evalConstrExp(Pre,Component,_,ClassDecls,Object,Replaces,TOP),
     evalConstrExp(Name,NewE,Type,_,Component,Replaces,false)).
evalConstrExp('+'(E),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(E,NewE,Type,ClassDecls,Object,Replaces,TOP).
evalConstrExp(E1+E2,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NewE2,Type2,ClassDecls,Object,Replaces,TOP),
    (integer(NewE1),integer(NewE2)->NewE is NewE1+NewE2;
     NewE=(NewE1 + NewE2)),
    (Type1==int,Type2==int->Type=int;
     cmpError(['Types mismatch ',E1,E2])).
evalConstrExp(-E1,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,TOP),
    (integer(NewE1) -> NewE is -NewE1; NewE = -NewE1),
    (Type1==int->Type=int;
     cmpError(['Types mismatch ',-E1])).
evalConstrExp(E1-E2,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NewE2,Type2,ClassDecls,Object,Replaces,TOP),
    (integer(NewE1),integer(NewE2)->NewE is NewE1-NewE2;
     NewE=(NewE1 - NewE2)),
    (Type1==int,Type2==int->Type=int;
     cmpError(['Types mismatch ',E1,E2])).
evalConstrExp(E1*E2,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NewE2,Type2,ClassDecls,Object,Replaces,TOP),
    (integer(NewE1),integer(NewE2)->NewE is NewE1*NewE2;
     NewE=(NewE1 * NewE2)),
    (Type1==int,Type2==int->Type=int;
     cmpError(['Types mismatch ',E1,E2])).
evalConstrExp(E1/E2,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NewE2,Type2,ClassDecls,Object,Replaces,TOP),
    (integer(NewE1),integer(NewE2)->NewE is NewE1//NewE2;
     NewE=(NewE1 / NewE2)),
    (Type1==int,Type2==int->Type=int;
     cmpError(['Types mismatch ',E1,E2])).
evalConstrExp(Exp,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    array(Pre,Index0)<=Exp :
    evalArrayAccess(Exp,NewE,Type,ClassDecls,Object,Replaces,TOP).
evalConstrExp(E1 #= E2,NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #= NE2),
    evalConstrExp(E1,NE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NE2,Type2,ClassDecls,Object,Replaces,TOP),
    sameType(Type1,Type2,'==').
evalConstrExp(E1 #\= E2,NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #\= NE2),
    evalConstrExp(E1,NE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NE2,Type2,ClassDecls,Object,Replaces,TOP),
    sameType(Type1,Type2,'!=').
evalConstrExp(E1 #> E2,NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #> NE2),
    evalConstrExp(E1,NE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NE2,Type2,ClassDecls,Object,Replaces,TOP),
    arithType(Type1,Type2,'>').
evalConstrExp(E1 #>= E2,NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #>= NE2),
    evalConstrExp(E1,NE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NE2,Type2,ClassDecls,Object,Replaces,TOP),
    arithType(Type1,Type2,'>=').
evalConstrExp(E1 #< E2,NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #< NE2),
    evalConstrExp(E1,NE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NE2,Type2,ClassDecls,Object,Replaces,TOP),
    arithType(Type1,Type2,'<').
evalConstrExp(E1 #=< E2,NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #=< NE2),
    evalConstrExp(E1,NE1,Type1,ClassDecls,Object,Replaces,TOP),
    evalConstrExp(E2,NE2,Type2,ClassDecls,Object,Replaces,TOP),
    arithType(Type1,Type2,'=<').
evalConstrExp('$not'(E),NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(#\ NewE),
    evalConstrAsExp(E,NE,Type,ClassDecls,Object,Replaces).
evalConstrExp('$entail'(E1,E2),NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #=> NE2),
    evalConstrAsExp(E1,NE1,Type1,ClassDecls,Object,Replaces),
    evalConstrAsExp(E2,NE2,Type2,ClassDecls,Object,Replaces).
evalConstrExp('$and'(E1,E2),NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #/\ NE2),
    evalConstrAsExp(E1,NE1,Type1,ClassDecls,Object,Replaces),
    evalConstrAsExp(E2,NE2,Type2,ClassDecls,Object,Replaces).
evalConstrExp('$or'(E1,E2),NConstr,_,ClassDecls,Object,Replaces,TOP):-
    true :
    NConstr=(NE1 #\/ NE2),
    evalConstrAsExp(E1,NE1,Type1,ClassDecls,Object,Replaces),
    evalConstrAsExp(E2,NE2,Type2,ClassDecls,Object,Replaces).
evalConstrExp('$sum'(Template,ECList),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    createDomainVar(NewE),
    evalAggregationTop(sum,ECList,Template,NewE,Type,ClassDecls,Object,Replaces).
evalConstrExp('$minimum'(Template,ECList),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    createDomainVar(NewE),
    evalAggregationTop(min,ECList,Template,NewE,Type,ClassDecls,Object,Replaces).
evalConstrExp('$maximum'(Template,ECList),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    createDomainVar(NewE),
    evalAggregationTop(max,ECList,Template,NewE,Type,ClassDecls,Object,Replaces).
evalConstrExp(distance(X1,Y1,X2,Y2),NewE,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(X1,NX1,Type1,ClassDecls,Object,Replaces,_),
    checkType(X1,Type1,int),
    evalConstrExp(X2,NX2,Type2,ClassDecls,Object,Replaces,_),
    checkType(X2,Type2,int),
    evalConstrExp(Y1,NY1,Type3,ClassDecls,Object,Replaces,_),
    checkType(Y1,Type3,int),
    evalConstrExp(Y2,NY2,Type4,ClassDecls,Object,Replaces,_),
    checkType(Y2,Type4,int),
    global_get(screenWidth,0,Width),
    global_get(screenHeight,0,Height),
    Max is Width+Height,
    domain(Dis,0,Max),
    NewE=Dis,Type=int,
    $distanceConstraint(NX1,NY1,NX2,NY2,Dis).
evalConstrExp(E,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    integer(E) : NewE=E,Type=int.
evalConstrExp(Color,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    checkTypeColor(Color) :
    NewE=Color,
    Type='Color'.
evalConstrExp(Identifier,NewE,Type,ClassDecls,Object,Replaces,TOP):-
    atom(Identifier) :
    (replaceIdentifier(Identifier,NewE,Type,Replaces,TOP)->true;
     getComponentOrAttributeOrConstant(Identifier,NewE,Type,Object)).

evalArrayAccess(array(Pre,Index),NewExp,Type,ClassDecls,Object,Replaces,TOP):-
    true :
    evalConstrExp(Index,NewIndex,IndexType,ClassDecls,Object,Replaces,_),
    (IndexType==int->true;cmpError(['Array index must be an integer: ',Index])),
    evalConstrExp(Pre,ComponentArray,ComponentType,ClassDecls,Object,Replaces,TOP),
    getArrayElm(NewIndex,ComponentArray,NewExp,Type).

getArrayElm(Index,ComponentArray,NewExp,Type):-
    array(Size,ElmType,Hashtable) <= ComponentArray :
    (getTypeAndValueFromHashtable(Index,Type,NewExp,Hashtable)->true;
     cmpError(['Out of array range:',Index])).
getArrayElm(Index,ComponentArray,NewExp,Type):-
    true :
    cmpError(['Accessing a non-array as an array:','...[',Index,']']).

replaceIdentifier(Old,New,ValType,Replaces,TOP):-var(TOP) : 
    replaceIdentifier(Old,New,ValType,Replaces).

replaceIdentifier(Old,New,ValType,[fa(Old,Type,Value)|_]):-true : New=Value,ValType=Type.
replaceIdentifier(Old,New,ValType,[_|Pairs]):-true : replaceIdentifier(Old,New,ValType,Pairs).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
evalAggregationTop(AggreType,ECList,Template,NewE,Type,ClassDecls,Object,Replaces):-
    true :
    Type=int,
    evalAggregation(ECList,Template,[],Terms,Type,ClassDecls,Object,Replaces),  % Type is integer only 
    relateTermsToExp(AggreType,Terms,NewE).

relateTermsToExp(sum,Terms,NewE):-
    true : 
    sumTermsToExp(Terms,NewE).
relateTermsToExp(min,Terms,NewE):-
    true : minimumConstraint(Terms,NewE).
relateTermsToExp(max,Terms,NewE):-
    true : maximumConstraint(Terms,NewE).
    
sumTermsToExp([],NewE):-true : NewE=0.
sumTermsToExp([X],NewE):-true : NewE=X.
sumTermsToExp([X1,X2],NewE):-true : createDomainVar(NewE),NewE #= X1+X2.
sumTermsToExp([X1,X2,X3],NewE):-true : createDomainVar(NewE),NewE #= X1+X2+X3.
sumTermsToExp([X1,X2,X3,X4],NewE):-true : createDomainVar(NewE),NewE #= X1+X2+X3+X4.
sumTermsToExp([X1,X2,X3,X4,X5],NewE):-true : createDomainVar(NewE),NewE #= X1+X2+X3+X4+X5.
sumTermsToExp([X1,X2,X3,X4,X5|Rest],NewE):-true : createDomainVar(T),T #= X1+X2+X3+X4+X5,sumTermsToExp([T|Rest],NewE).
    
evalAggregation([],Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true : 
    evalConstrExp(Template,Value,Type1,ClassDecls,Object,Replaces,_), % type should be checked here
    (Type1\==int->cmpError(['Not an integer expression:',Template]);true),
    Res=[Value|Res0].
evalAggregation([X in Exp|ECList],Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalConstrRange(Exp,NewE,ElmType,ClassDecls,Object,Replaces),
    evalAggregationLoop(X,NewE,ElmType,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).
evalAggregation([Condition|ECList],Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalCondition(Condition,Result,ClassDecls,Object,Replaces),
    evalAggregationCondition(Result,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).

evalAggregationLoop(X,L..U,ElmType,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalAggregationLoop1(X,L,U,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).
evalAggregationLoop(X,Range,ElmType,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalAggregationLoop2(X,Range,ElmType,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).

evalAggregationLoop1(X,L,U,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    L>U : Res=Res0.
evalAggregationLoop1(X,L,U,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    Pair=fa(X,int,L),
    NewReplaces=[Pair|Replaces],
    evalAggregation(ECList,Template,Res0,Res1,Type,ClassDecls,Object,NewReplaces),
    L1 is L+1,
    evalAggregationLoop1(X,L1,U,ECList,Template,Res1,Res,Type,ClassDecls,Object,Replaces).
    
evalAggregationLoop2(X,[],ElmType,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true : Res=Res0.
evalAggregationLoop2(X,[Elm|Elms],ElmType,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    Pair=pa(X,ElmType,Elm),
    NewReplaces=[Pair|Replaces],
    evalAggregation(ECList,Template,Res0,Res1,Type,ClassDecls,Object,NewReplaces),
    evalAggregationLoop2(X,Elms,ElmType,ECList,Template,Res1,Res,Type,ClassDecls,Object,Replaces).
    
evalAggregationCondition(true,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalAggregation(ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).
evalAggregationCondition(false,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true : Res=Res0.
evalAggregationCondition(susp(Vars,Condition),ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalAggregationConditionSusp(Vars,Condition,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
getComponentOrAttributeOrConstant(E,NewE,Type,Object):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object ?
    getTypeAndValueFromHashtable(E,Type,NewE,Hashtable),!.
getComponentOrAttributeOrConstant(E,NewE,Type,Object):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object ?
    getConstant(_,Type,E,NewE,Object),!.
getComponentOrAttributeOrConstant(E,NewE,Type,Object):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object ?
    getComponentOrAttributeOrConstant(E,NewE,Type,SuperObject),!.
getComponentOrAttributeOrConstant(E,NewE,Type,Object):-
    isBaseClassObject(Object) :
    getBaseAttribute(E,NewE,Type,Object).
getComponentOrAttributeOrConstant(E,NewE,Type,Object):-
    true :
    cmpError([E,' used but not defined']).

getAttribute(E,NewE,Type,Object):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object ?
    getTypeAndValueFromHashtable(E,Type,NewE,Hashtable),!.
getAttribute(E,NewE,Type,Object):-
    isBaseClassObject(Object) :
    getBaseAttribute(E,NewE,Type,Object).
getAttribute(E,NewE,Type,Object):-
    true :
    cmpError([E,' used but not defined']).

getComponentErrorIfNo(Identifier,Component,Object):-
    getComponent(Identifier,Component,Object),!.
getComponentErrorIfNo(Identifier,Component,Object):-
    cmpError(['Class ',Identifier,' used but not defined']).

getComponent(Identifier,Component,Object):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object ?
    getTypeAndValueFromHashtable(Identifier,_,Component,Hashtable),!.
getComponent(Identifier,Component,Object):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object :
    getComponent(Identifier,Component,SuperObject).

getConstant(Public,Type,E,NewE,object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)):-true :
    lookupConstant(Public,Type,E,NewE,Constants).
    
lookupConstant(Public1,Type,Name,Value,Constants):-var(Constants) : fail.
lookupConstant(Public1,Type,Name,Value,[constant(Public2,Type1,Name,Value1)|Constants]):-true :
    (Public1==private-> Value=Value1,Type=Type1;
     Public1=Public2-> Value=Value1,Type=Type1).
lookupConstant(Public,Type,Name,Value,[_|Constants]):-
    true : lookupConstant(Public,Type,Name,Value,Constants).
    
superInstance(object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound),SuperInstance):-
    true : SuperInstance=SuperObject.

convertToString(E,int,NewE,Type):-true : NewE=E,Type='String'.

checkType(X1,Type,ExpectedType):-
    Type==ExpectedType : true.
checkType(X1,Type,ExpectedType):-
    true :
    cmpError([ExpectedType,' expected for ',X1]).

sameType(Type1,Type2,R):-
    Type1==Type2 :
    true.
sameType(Type1,Type2,R):-
    true :
    cmpError(['types mismatch in constraint: ',Type1,R,Type2]).

arithType(int,int,R):-
    true : true.
arithType(Type1,Type2,R):-
    true :
    cmpError(['wrong types in arithmetic constraint: ',Type1,R,Type2]).
    





    

 
