%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : djDelay.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: constraint solvers needed for DJ
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postForConstraintSuspCondition([],Condition,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postForConstraintCondition(Condition,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).
delay postForConstraintSuspCondition([X|Xs],Condition,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    var(X) : {ins(X)}.
postForConstraintSuspCondition([X|Xs],Condition,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postForConstraintSuspCondition(Xs,Condition,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).

evalAggregationConditionSusp([],Condition,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalAggregationCondition(Condition,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).
delay evalAggregationConditionSusp([X|Xs],Condition,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    var(X) : {ins(X)}.
evalAggregationConditionSusp([X|Xs],Condition,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces):-
    true :
    evalAggregationConditionSusp(Xs,Condition,ECList,Template,Res0,Res,Type,ClassDecls,Object,Replaces).

delay postBoundConstraintAux(X,Y,Width,Height,Bounds):-
      no_vars_gt(1,0) : 
      {ins(Bounds)},true.
postBoundConstraintAux(X,Y,Width,Height,Bounds):-
    true :
    fixBound(X,Y,Width,Height,Bounds).

delay aggregateMaxFix(Max,Xs):-no_vars_gt(1,0) : {ins(Xs)},true.
aggregateMaxFix(Max,Xs):-true :
    aggregateMax(Max,Xs).

aggregateMax(Max,[X|Xs]):-
    aggregateMax(Max,X,Xs).
    
aggregateMax(Max,X,[]):-true : Max=X.
aggregateMax(Max,X,[Y|Ys]):-
    Y>X :
    aggregateMax(Max,Y,Ys).
aggregateMax(Max,X,[Y|Ys]):-
    true :
    aggregateMax(Max,X,Ys).

delay aggregateMinFix(Min,Xs):-no_vars_gt(1,0) : {ins(Xs)}.
aggregateMinFix(Min,Xs):-true :
    aggregateMin(Min,Xs).

aggregateMin(Min,[X|Xs]):-
    aggregateMin(Min,X,Xs).
    
aggregateMin(Min,X,[]):-true : Min=X.
aggregateMin(Min,X,[Y|Ys]):-
    Y<X :
    aggregateMin(Min,Y,Ys).
aggregateMin(Min,X,[Y|Ys]):-
    true :
    aggregateMin(Min,X,Ys).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
$distanceConstraint(X1,Y1,X2,Y2,D):-
    $distanceConstraintDelay(X1,Y1,X2,Y2,D),
    $distanceConstraintConsistency(X1,Y1,X2,Y2,D,Constrs,[]),
    postIfThenConstraints(Constrs).

delay $distanceConstraintDelay(X1,Y1,X2,Y2,D):-
    no_vars_gt(5,1) : 
    {ins(X1),ins(Y1),ins(X2),ins(Y2),ins(D)},
    true.
$distanceConstraintDelay(X1,Y1,X2,Y2,D):-
    var(X1) : 
    (Y2>Y1->A is Y2-Y1;A is Y1-Y2),
    D>=A,
    Z is round(sqrt(D*D-A*A)),
    (X1 is X2-Z; X1 is X2+Z),
    $testDistanceConstraint(X1,Y1,X2,Y2,D).
$distanceConstraintDelay(X1,Y1,X2,Y2,D):-
    var(X2) : 
    (Y2>Y1->A is Y2-Y1;A is Y1-Y2),
    D>=A,
    Z is round(sqrt(D*D-A*A)),
    (X2 is X1-Z; X2 is X1+Z),
    $testDistanceConstraint(X1,Y1,X2,Y2,D).
$distanceConstraintDelay(X1,Y1,X2,Y2,D):-
    var(Y1) : 
    (X2>=X1->A is X2-X1;A is X1-X2),
    D>A,
    Z is round(sqrt(D*D-A*A)),
    (Y1 is Y2-Z; Y1 is Y2+Z),
    $testDistanceConstraint(X1,Y1,X2,Y2,D).
$distanceConstraintDelay(X1,Y1,X2,Y2,D):-
    var(Y2) :
    (X2>=X1->A is X2-X1;A is X1-X2),
    D>A,
    Z is round(sqrt(D*D-A*A)),
    (Y2 is Y1-Z; Y2 is Y1+Z),
    $testDistanceConstraint(X1,Y1,X2,Y2,D).
$distanceConstraintDelay(X1,Y1,X2,Y2,D):-
    true :
    A is X2-X1,
    B is Y2-Y1,
    D is round(sqrt(A*A+B*B)),
%    write(D is round(sqrt(A*A+B*B))),nl,
    $testDistanceConstraint(X1,Y1,X2,Y2,D).

$testDistanceConstraint(X1,Y1,X2,Y2,D):-
%    write($testDistanceConstraint(X1,Y1,X2,Y2,D)),nl,
    A is X2-X1,
    B is Y2-Y1,
    A*A+B*B=:=D*D.
    

$distanceConstraintConsistency(X1,Y1,X2,Y2,D,Constrs,ConstrsR):-
    nonvar(X1),
    nonvar(Y1) :
    fd_min_max(D,Min,Max),
    MinMin is Min*Min,
    MaxMax is Max*Max,
    $distanceConstraintConsistencyAux1(X1,Y1,X2,Y2,MinMin,MaxMax,Constrs,ConstrsR).
$distanceConstraintConsistency(X1,Y1,X2,Y2,D,Constrs,ConstrsR):-
    nonvar(X2),
    nonvar(Y2) :
    fd_min_max(D,Min,Max),
    MinMin is Min*Min,
    MaxMax is Max*Max,
    $distanceConstraintConsistencyAux1(X2,Y2,X1,Y1,MinMin,MaxMax,Constrs,ConstrsR).
$distanceConstraintConsistency(X1,Y1,X2,Y2,D,Constrs,ConstrsR):-
    nonvar(X1),
    nonvar(X2) :
    fd_min_max(D,Min,Max),
    MinMin is Min*Min,
    MaxMax is Max*Max,
    X is X2-X1,
    XX is X*X,
    MinMin1 is MinMin-XX,
    MaxMax1 is MaxMax-XX,
    $distanceConstraintConsistencyAux2(X1,X2,MinMin1,MaxMax1,Constrs,ConstrsR).
$distanceConstraintConsistency(X1,Y1,X2,Y2,D,Constrs,ConstrsR):-
    nonvar(Y1),
    nonvar(Y2) :
    fd_min_max(D,Min,Max),
    MinMin is Min*Min,
    MaxMax is Max*Max,
    Y is Y2-Y1,
    YY is Y*Y,
    MinMin1 is MinMin-YY,
    MaxMax1 is MaxMax-YY,
    $distanceConstraintConsistencyAux2(X1,X2,MinMin1,MaxMax1,Constrs,ConstrsR).
$distanceConstraintConsistency(X1,Y1,X2,Y2,D,Constrs,ConstrsR):-
    true : Constrs=ConstrsR.

$distanceConstraintConsistencyAux1(X1,Y1,X2,Y2,MinMin,MaxMax,Constrs,ConstrsR):-
    true :
    fd_min_max(X2,MinX,MaxX),
    fd_min_max(Y2,MinY,MaxY),
    $distanceConstraintConsistencyAux1Loop1(X1,Y1,X2,MinX,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs,ConstrsR).

$distanceConstraintConsistencyAux1Loop1(X1,Y1,X2,MinX,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs,ConstrsR):-
    MinX>MaxX : Constrs=ConstrsR.
$distanceConstraintConsistencyAux1Loop1(X1,Y1,X2,MinX,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs,ConstrsR):-
    true :
    $distanceConstraintConsistencyAux1Loop2(X1,Y1,X2,MinX,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs,Constrs1),
    MinX1 is MinX+1,
    $distanceConstraintConsistencyAux1Loop1(X1,Y1,X2,MinX1,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs1,ConstrsR).
    
$distanceConstraintConsistencyAux1Loop2(X1,Y1,X2,MinX,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs,ConstrsR):-
    MinY>MaxY : Constrs=ConstrsR.
$distanceConstraintConsistencyAux1Loop2(X1,Y1,X2,MinX,MaxX,Y2,MinY,MaxY,MinMin,MaxMax,Constrs,ConstrsR):-
    true :
    X is MinX-X1,
    XX is X*X,
    Y is MinY-Y1,
    YY is Y*Y,
    XXYY is XX+YY,
    (XXYY=<MaxMax,XXYY>=MinMin->Constrs=Constrs1; Constrs=[if_then_constraint(X2,MinX,Y2,MinY)|Constrs1]),
    MinY1 is MinY+1,
    $distanceConstraintConsistencyAux1Loop2(X1,Y1,X2,MinX,MaxX,Y2,MinY1,MaxY,MinMin,MaxMax,Constrs1,ConstrsR).
    
$distanceConstraintConsistencyAux2(X1,X2,MinMin,MaxMax,Constrs,ConstrsR):-
    true :
    fd_min_max(X1,Min1,Max1),
    fd_min_max(X2,Min2,Max2),
    $distanceConstraintConsistencyAux2Loop1(X1,Min1,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs,ConstrsR).

$distanceConstraintConsistencyAux2Loop1(X1,Min1,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs,ConstrsR):-
    Min1 > Max1 : Constrs=ConstrsR.
$distanceConstraintConsistencyAux2Loop1(X1,Min1,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs,ConstrsR):-
    true :
    $distanceConstraintConsistencyAux2Loop2(X1,Min1,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs,Constrs1),
    Min11 is Min1+1,
    $distanceConstraintConsistencyAux2Loop1(X1,Min11,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs1,ConstrsR).
    
$distanceConstraintConsistencyAux2Loop2(X1,Min1,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs,ConstrsR):-
    Min2 > Max2 : Constrs=ConstrsR.
$distanceConstraintConsistencyAux2Loop2(X1,Min1,Max1,X2,Min2,Max2,MinMin,MaxMax,Constrs,ConstrsR):-
    true :
    X is Min2-Min1,
    XX is X*X,
    (XX=<MaxMax,XX>=MinMin->Constrs=Constrs1; Constrs=[if_then_constraint(X1,Min1,X2,Min2)|Constrs1]),
    Min22 is Min2+1,
    $distanceConstraintConsistencyAux2Loop2(X1,Min1,Max1,X2,Min22,Max2,MinMin,MaxMax,Constrs1,ConstrsR).

postIfThenConstraints([]).
postIfThenConstraints([if_then_constraint(X,X1,Y,Y1)|Constrs]):-
    true :
    if_then_constraint(X,X1,Y,Y1),
    postIfThenConstraints(Constrs).
    

%X#=X1->Y#\=Y1 && Y #= Y1 -> X #\= X1
delay if_then_constraint(X,X1,Y,Y1):-dvar(X),dvar(Y) : {ins(X),ins(Y)},true.
if_then_constraint(X,X1,Y,Y1):-dvar(X),Y=:=Y1 : X#\=X1.
if_then_constraint(X,X1,Y,Y1):-dvar(Y), X=:=X1 : Y#\=Y1.
if_then_constraint(X,X1,Y,Y1):-true : true.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
delay createXYArraysWhenNIsFixed(N,Polygon):-dvar(N) : {ins(N)}.
createXYArraysWhenNIsFixed(N,Polygon):-
    true :
    getBaseAttribute(xs,array(_,_,HashtableX),_,Polygon),
    getBaseAttribute(ys,array(_,_,HashtableY),_,Polygon),
    getBaseAttribute(x,X,_,Polygon),
    getBaseAttribute(y,Y,_,Polygon),
    getBaseAttribute(width,Width,_,Polygon),
    getBaseAttribute(height,Height,_,Polygon),
    positionInsideScreen(X1,Y1),
    Width #= X1-X,
    Height #= Y1-Y,
    createXYArrays(0,N,X,Y,X1,Y1,[],HashtableX,[],HashtableY).

createXYArrays(N0,N,X0,Y0,X1,Y1,Xs,HashtableX,Ys,HashtableY):-
    N0>=N :
    minimumConstraint(Xs,X0),
    minimumConstraint(Xs,Y0),
    maximumConstraint(Xs,X1),
    maximumConstraint(Ys,Y1).
createXYArrays(N0,N,X0,Y0,X1,Y1,Xs,HashtableX,Ys,HashtableY):-
    true :
    positionInsideScreen(X,Y),
    hashtableSet(N0,attribute(int,X),HashtableX),
    hashtableSet(N0,attribute(int,Y),HashtableY),
    N1 is N0+1,
    createXYArrays(N1,N,X0,Y0,X1,Y1,[X|Xs],HashtableX,[Y|Ys],HashtableY).

    
    
    

    

    
