%% file  : dj.pl
%% author: Sosuke Kaneko
%% date  : Dec.1997 - Apr.1998
%   COPYRIGHT (C) 1998 Sosuke Kaneko


%%%%%%%%%%%%%%%%% Constraint Declarations %%%%%%%%%%%%%%%%%%%%%%

%ConstraintDeclaration :
%       constraint Identifier ( FormalParameterList ) ConstraintBody
'ConstraintDeclaration'(T,[tok(constraint,TN)|S0],S):-
	T='ConstraintDeclaration'(
                            constraint,
                            Identifier,
                            '(',
                            FormalParameterList,
                            ')',
                            ConstraintBody),
        ('Identifier'(Identifier,S0,S1) -> true ; error('invalid identifier',TN)),
        S1=[tok(Tok1,TN1)|S2],
	(Tok1=='(' -> true ; error1('( expected',TN1)),
        'FormalParameterList'(FormalParameterList,S2,S3),
        S3=[tok(Tok2,TN2)|S4],
	(Tok2==')' -> true ; error1(') expected',TN2)),
        'ConstraintBody'(ConstraintBody,S4,S).

%ConstraintBody : 
%	ConstraintBlock
'ConstraintBody'('ConstraintBody'(ConstraintBlock)) -->
        'ConstraintBlock'(ConstraintBlock).





%%%%%%%%%%%%%%% Component Declarations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ComponentDeclaration :
%       component Type ComponentAttributeDeclarators ;
'ComponentDeclaration'(T,[tok(component,TN)|S0],S):-
	T='ComponentDeclaration'(component,Type,ComponentAttributeDeclarators,';'),
        ('Type'(Type,S0,S1) -> true ; error('invalid type',TN)),
        'ComponentAttributeDeclarators'(ComponentAttributeDeclarators,S1,S2),
	S2=[tok(Tok1,TN1)|S],
	(Tok1==';' -> true ; error1('; expected',TN1)).

%ComponentAttributeDeclarators :
%       ComponentAttributeDeclarator ComponentAttributeDeclaratorsRestopt
'ComponentAttributeDeclarators'('ComponentAttributeDeclarators'(
				   ComponentAttributeDeclarator,
				   ComponentAttributeDeclaratorsRestopt)) -->
        'ComponentAttributeDeclarator'(ComponentAttributeDeclarator),
	'ComponentAttributeDeclaratorsRestopt'(ComponentAttributeDeclaratorsRestopt).

%ComponentAttributeDeclaratorsRest :
%       , ComponentAttributeDeclarators
'ComponentAttributeDeclaratorsRest'(T,[tok(',',_)|S0],S):-
	T='ComponentAttributeDeclaratorsRest'(',',ComponentAttributeDeclarators),
        'ComponentAttributeDeclarators'(ComponentAttributeDeclarators,S0,S).

'ComponentAttributeDeclaratorsRestopt'(ComponentAttributeDeclaratorsRest) -->
	'ComponentAttributeDeclaratorsRest'(ComponentAttributeDeclaratorsRest).
	{!}.
'ComponentAttributeDeclaratorsRestopt'(nil) --> [].

%ComponentAttributeDeclarator :
%       IdentifierOrArray ComponentAttributeDeclaratorRestopt
'ComponentAttributeDeclarator'('ComponentAttributeDeclarator'(
				   IdentifierOrArray,
				   ComponentAttributeDeclaratorRestopt)) -->
	'IdentifierOrArray'(IdentifierOrArray),
	'ComponentAttributeDeclaratorRestopt'(ComponentAttributeDeclaratorRestopt).

%IdentifierOrArray:
%	Identifier DimExprs
%	Identifier
'IdentifierOrArray'('IdentifierOrArray'(Identifier,DimExprs)) -->
	'Identifier'(Identifier),
	'DimExprs'(DimExprs),!.
'IdentifierOrArray'('IdentifierOrArray'(Identifier)) -->
	('Identifier'(Identifier) -> [] ;
	 [tok(_,TN)] ,{error1('identifier expected',TN)}).

%ComponentAttributeDeclaratorRest:
%	{ ConstraintBlocks }
%	{ Constraints }
%	in Range 
%	ArithmeticConstraintRest
'ComponentAttributeDeclaratorRest'(T,[tok('{',_)|S0],S):-
	T='ComponentAttributeDeclaratorRest'('{',ConstraintBlocks,'}'),
	'ConstraintBlocks'(ConstraintBlocks,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok=='}' -> true ; error1('} expected',TN)),!.
'ComponentAttributeDeclaratorRest'(T,[tok('{',_)|S0],S):-
	T='ComponentAttributeDeclaratorRest'('{',Constraints,'}'),
	'Constraints'(Constraints,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok=='}' -> true ; error1('} expected',TN)),!.
'ComponentAttributeDeclaratorRest'(T,[tok(in,_)|S0],S):-!,
	T='ComponentAttributeDeclaratorRest'(in,Range),
	'Range'(Range,S0,S).
'ComponentAttributeDeclaratorRest'('ComponentAttributeDeclaratorRest'(
					ArithmeticConstraintRest)) -->
	'ArithmeticConstraintRest'(ArithmeticConstraintRest).

'ComponentAttributeDeclaratorRestopt'(ComponentAttributeDeclaratorRest) -->
	'ComponentAttributeDeclaratorRest'(ComponentAttributeDeclaratorRest),
	{!}.
'ComponentAttributeDeclaratorRestopt'(nil) --> [].



%%%%%%%%%%%%%%% Attribute Declarations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%AttributeDeclaration :
%       attribute Type ComponentAttributeDeclarators ;
'AttributeDeclaration'(T,[tok(attribute,TN)|S0],S):-
	T='AttributeDeclaration'(attribute,Type,ComponentAttributeDeclarators,';'),
	('Type'(Type,S0,S1) -> true ; error('invalid type',TN)),
	'ComponentAttributeDeclarators'(ComponentAttributeDeclarators,S1,S2),
	S2=[tok(Tok1,TN1)|S],
	(Tok1==';' -> true ; error1('; expected',TN1)).



%%%%%%%%%%%%%%% Action Declarations %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*
%ActionDeclaration :
%       when ( EventCondition ) Action
'ActionDeclaration'('ActionDeclaration'(
			when,
			'(',
			EventCondition,
			')',
			Action)) -->
	[when,'('],
	'EventCondition'(EventCondition),
	[')'],
	'Action'(Action).

%EventCondition : 
%       event ( ArgumentList )
'EventCondition'('EventCondition'(
		     event,
		     '(',
		     ArgumentList,
		     ')')) -->
	[event,'('],
	'ArgumentList'(ArgumentList),
	[')'].

%Action : MethodBody (see Java)
'Action'('Action'(
	     MethodBody)) -->
	'MethodBody'(MethodBody).
*/




%%%%%%%%%%%%%%% Constraints %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ConstraintBlocks :
%	ConstraintBlock ConstraintBlocksRestopt
'ConstraintBlocks'('ConstraintBlocks'(
			ConstraintBlock,
			ConstraintBlocksRestopt)) -->
	'ConstraintBlock'(ConstraintBlock),
	'ConstraintBlocksRestopt'(ConstraintBlocksRestopt).

%ConstraintBlocksRest:
%	, ConstraintBlocks
'ConstraintBlocksRest'(T,[tok(',',_)|S0],S):-
	T='ConstraintBlocksRest'(',',ConstraintBlocks),
	'ConstraintBlocks'(ConstraintBlocks,S0,S).

'ConstraintBlocksRestopt'(ConstraintBlocksRest) -->
	'ConstraintBlocksRest'(ConstraintBlocksRest).
	{!}.
'ConstraintBlocksRestopt'(nil) --> [].

%ConstraintBlock : 
%	{ Constraintsopt }
'ConstraintBlock'(T,[tok('{',_)|S0],S):-
	T='ConstraintBlock'('{',Constraintsopt,'}'),
        'Constraintsopt'(Constraintsopt,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok=='}' -> true ; error1('} expected',TN)).

%Constraints :
%	Constraint ConstraintsRestopt
'Constraints'('Constraints'(
                  Constraint,
                  ConstraintsRestopt)) -->
        'Constraint'(Constraint),
        'ConstraintsRestopt'(ConstraintsRestopt).

'Constraintsopt'(Constraints) -->
	'Constraints'(Constraints).
	{!}.
'Constraintsopt'(nil) --> [].

%ConstraintsRest :
%	; Constraintsopt
'ConstraintsRest'(T,[tok(';',_)|S0],S):-
	T='ConstraintsRest'(';',Constraintsopt),
	'Constraintsopt'(Constraintsopt,S0,S).

'ConstraintsRestopt'(ConstraintsRest) -->
	'ConstraintsRest'(ConstraintsRest).
	{!}.
'ConstraintsRestopt'(nil) --> [].

%Constraint :
%       ConstraintFactor CompositeConstraintRestopt
%       ~ Constraint
%	ForConstraint
'Constraint'('Constraint'(
			ConstraintFactor,
			CompositeConstraintRestopt)) -->
	'ConstraintFactor'(ConstraintFactor),{!},
	'CompositeConstraintRestopt'(CompositeConstraintRestopt).
'Constraint'(T,[tok('~',_)|S0],S):-!,
	T='Constraint'('~',Constraint),
	'Constraint'(Constraint,S0,S).
'Constraint'('Constraint'(
			ForConstraint)) -->
	'ForConstraint'(ForConstraint).

%ConstraintFactor :
%       ConstraintBlock
%       Name in Range
%       ArithmeticConstraint
%       ConstraintCall
%	( Constraint )
'ConstraintFactor'('ConstraintFactor'(
			ConstraintBlock)) -->
        'ConstraintBlock'(ConstraintBlock),{!}.
'ConstraintFactor'('ConstraintFactor'(
			Name,
		      	in,
		      	Range)) -->
	'Name'(Name),
	[tok(in,_)],{!},
	'Range'(Range).
'ConstraintFactor'('ConstraintFactor'(
                      	ArithmeticConstraint)) -->
        'ArithmeticConstraint'(ArithmeticConstraint),{!}.
'ConstraintFactor'('ConstraintFactor'(
                      	ConstraintCall)) -->
	'ConstraintCall'(ConstraintCall),{!}.      
'ConstraintFactor'(T,[tok('(',_)|S0],S):-
	T='ConstraintFactor'('(',Constraint,')'),
	'Constraint'(Constraint,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok==')' -> true ; error1(') expected',TN)).

%ArithmeticConstraint :
%	DJExpression ArithmeticConstraintRest
'ArithmeticConstraint'('ArithmeticConstraint'(
				DJExpression,
				ArithmeticConstraintRest)) -->
	'DJExpression'(DJExpression),
	'ArithmeticConstraintRest'(ArithmeticConstraintRest).

%ArithmeticConstraintRest:
%       == DJExpression
%       != DJExpression 
%       >= DJExpression
%       > DJExpression
%       <= DJExpression
%       < DJExpression
%	= DJExpression 	% a grammar rule for error handling
'ArithmeticConstraintRest'(T,[tok('=',_),tok('=',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('==',DJExpression),
        'DJExpression'(DJExpression,S0,S).
'ArithmeticConstraintRest'(T,[tok('!',_),tok('=',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('!=',DJExpression),
        'DJExpression'(DJExpression,S0,S).
'ArithmeticConstraintRest'(T,[tok('>',_),tok('=',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('>=',DJExpression),
        'DJExpression'(DJExpression,S0,S).
'ArithmeticConstraintRest'(T,[tok('>',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('>',DJExpression),
        'DJExpression'(DJExpression,S0,S).
'ArithmeticConstraintRest'(T,[tok('<',_),tok('=',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('<=',DJExpression),
        'DJExpression'(DJExpression,S0,S).
'ArithmeticConstraintRest'(T,[tok('<',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('<',DJExpression),
        'DJExpression'(DJExpression,S0,S).
%%a grammar rule for error handling of ArithmeticConstraintRest
%%accepts '=' as '=='
'ArithmeticConstraintRest'(T,[tok('=',_)|S0],S):-!,
	T='ArithmeticConstraintRest'('==',DJExpression),
	write('Warning: ''='' for constraint must be ''=='''),nl,nl,
        'DJExpression'(DJExpression,S0,S).

%ConstraintCall
%       Identifier ( ConstraintArgumentList )
'ConstraintCall'('ConstraintCall'(
                            Identifier,
                            '(',
                            ConstraintArgumentList,
                            ')')) -->
        'Identifier'(Identifier),
        [tok('(',_)],
        'ConstraintArgumentList'(ConstraintArgumentList),
        [tok(Tok,TN)],
	{Tok==')' -> true ; error1(') expected',TN)}.

%ConstraintArgumentList:
%	ConstraintArgument ConstraintArgumentListRestopt
'ConstraintArgumentList'('ConstraintArgumentList'(
				ConstraintArgument,
				ConstraintArgumentListRestopt)) -->
	'ConstraintArgument'(ConstraintArgument),
	'ConstraintArgumentListRestopt'(ConstraintArgumentListRestopt).

%ConstraintArgumentListRest:
%	, ConstraintArgumentList
'ConstraintArgumentListRest'(T,[tok(',',_)|S0],S):-
	T='ConstraintArgumentListRest'(',',ConstraintArgumentList),
	'ConstraintArgumentList'(ConstraintArgumentList,S0,S).

'ConstraintArgumentListRestopt'(ConstraintArgumentListRest) -->
	'ConstraintArgumentListRest'(ConstraintArgumentListRest).
	{!}.
'ConstraintArgumentListRestopt'(nil) --> [].

%ConstraintArgument:
%	AnonymousArray
%	Expression
'ConstraintArgument'('ConstraintArgument'(
				AnonymousArray)) -->
	'AnonymousArray'(AnonymousArray),{!}.
'ConstraintArgument'('ConstraintArgument'(
				Expression)) -->
	'Expression'(Expression).

%AnonymousArray:
%	{ AnonymousArrayElements }
'AnonymousArray'(T,[tok('{',_)|S0],S):-
	T='AnonymousArray'('{',AnonymousArrayElements,'}'),
	'AnonymousArrayElements'(AnonymousArrayElements,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok=='}' -> true ; error1('} expected',TN)).

%AnonymousArrayElements:
%	ConstraintArgument AnonymousArrayElementsRestopt
'AnonymousArrayElements'('AnonymousArrayElements'(
				ConstraintArgument,
				AnonymousArrayElementsRestopt)) -->
	'ConstraintArgument'(ConstraintArgument),
	'AnonymousArrayElementsRestopt'(AnonymousArrayElementsRestopt).

%AnonymousArrayElementsRest:
%	, AnonymousArrayElements
'AnonymousArrayElementsRest'(T,[tok(',',_)|S0],S):-
	T='AnonymousArrayElementsRest'(',',AnonymousArrayElements),
	'AnonymousArrayElements'(AnonymousArrayElements,S0,S).

'AnonymousArrayElementsRestopt'(AnonymousArrayElementsRest) -->
	'AnonymousArrayElementsRest'(AnonymousArrayElementsRest).
	{!}.
'AnonymousArrayElementsRestopt'(nil) --> [].

%ForConstraint:
%	for ( EnumeratorConditionList ) Constraint 
'ForConstraint'(T,[tok(for,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='ForConstraint'(for,'(',EnumeratorConditionList,')',Constraint),
	'EnumeratorConditionList'(EnumeratorConditionList,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'Constraint'(Constraint,S3,S).

%CompositeConstraintRest;
%       -> Constraint
%       || Constraint
%       && Constraint
'CompositeConstraintRest'(T,[tok('-',_),tok('>',_)|S0],S):-!,
	T='CompositeConstraintRest'('->',Constraint),
        'Constraint'(Constraint,S0,S).
'CompositeConstraintRest'(T,[tok('|',_),tok('|',_)|S0],S):-!,
	T='CompositeConstraintRest'('||',Constraint),
        'Constraint'(Constraint,S0,S).
'CompositeConstraintRest'(T,[tok('&',_),tok('&',_)|S0],S):-
	T='CompositeConstraintRest'('&&',Constraint),
        'Constraint'(Constraint,S0,S).

'CompositeConstraintRestopt'(CompositeConstraintRest) -->
	'CompositeConstraintRest'(CompositeConstraintRest),{!}.
'CompositeConstraintRestopt'(nil) --> [].


%%%%%%%%%%%%%%% Other Nonterminal Symbols %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ComponentArray :
%       Identifier DimExprs
'ComponentArray'('ComponentArray'(
                     Identifier,
                     DimExprs)) -->
        'Identifier'(Identifier),
        'DimExprs'(DimExprs).

%DJExpression :
%	AdditiveExpression
'DJExpression'('DJExpression'(Expression)) -->
        'AdditiveExpression'(Expression).

%Template :
%	Expression
'Template'('Template'(
               Expression)) -->
        'Expression'(Expression).

%EnumeratorConditionList :
%        EnumeratorOrCondition EnumeratorConditionListRestopt
'EnumeratorConditionList'('EnumeratorConditionList'(
        	               EnumeratorOrCondition,
                     	       EnumeratorConditionListRestopt)) -->
        'EnumeratorOrCondition'(EnumeratorOrCondition),
        'EnumeratorConditionListRestopt'(EnumeratorConditionListRestopt).

%EnumeratorConditionListRest :
%	 , EnumeratorConditionList
'EnumeratorConditionListRest'(T,[tok(',',_)|S0],S):-
	T='EnumeratorConditionListRest'(',',EnumeratorConditionList),
	'EnumeratorConditionList'(EnumeratorConditionList,S0,S).

'EnumeratorConditionListRestopt'(EnumeratorConditionListRest) -->
	'EnumeratorConditionListRest'(EnumeratorConditionListRest).
	{!}.
'EnumeratorConditionListRestopt'(nil) --> [].

%EnumeratorOrCondition :
%	Constraint
'EnumeratorOrCondition'('EnumeratorOrCondition'(
				Constraint)) -->
	'Constraint'(Constraint).

%Range :
%	  DJExpression .. DJExpression
%         { ArgumentList }
'Range'('Range'(
            DJExpression1,
            '..',
            DJExpression2)) -->
        'DJExpression'(DJExpression1),
        ([tok('.',_),tok('.',_)] ;
	 [tok(_,TN)] -> [] ; {error1('.. expected',TN)}),!,
        'DJExpression'(DJExpression2).
'Range'(T,[tok('{',_)|S0],S):-
	T='Range'('{',ArgumentList,'}'),
        'ArgumentList'(ArgumentList,S0,S1),
        S1=[tok(Tok,TN)|S],
	(Tok=='}' ; error1('} expected',TN)).


