%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : createInstance.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: execute DJ program
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
createClassInstance0(MainClass,ClassDecls,ConstrDecls,DVars,Object):-var(MainClass) : 
    cmpError(['No main class specified']).
createClassInstance0(MainClass,ClassDecls,ConstrDecls,DVars,Object):-true :
    createClassInstance(MainClass,ClassDecls,ConstrDecls,DVars,[],Object).

createClassInstance(nil,ClassDecls,ConstrDecls,DVars,DVarsR,Object):-true :
    Object=nil,DVars=DVarsR.
createClassInstance(
    class(Identifier,Constants,SuperClass,CompAttributes,Constrs,Body,Args,TAPairs),
    ClassDecls,ConstrDecls,DVars,DVarsR,Object):-true :
    hashtableCreate(11,Hashtable),
    createSuperClassInstance(SuperClass,ClassDecls,ConstrDecls,DVars,DVars1,SuperObject),
    createCompAttributeInstances(CompAttributes,ClassDecls,ConstrDecls,DVars1,DVarsR,Hashtable),
    Bound=$bound(X,Y,Width,Height),
    positionInsideScreen(X,Y),
    sizeInsideScreen(Width,Height),
    nextInstanceNo(ObjectNo),
    Object=object(ObjectNo,Identifier,Constants,SuperObject,Hashtable,Bound),
    (SuperObject==nil->Bounds0=[];
     getComponentBound(SuperObject,SuperBound),
     Bounds0=[SuperBound],
     SuperBound=$bound(SuperX,SuperY,SuperWidth,SuperHeight),
     SuperWidth #=< Width,
     SuperHeight #=< Height,
     X #=< SuperX,
     Y #=< SuperY),
    hashtableCollect(Hashtable,SubComponents),
    getComponentsBounds(SubComponents,Bounds,Bounds0,X,Y,Width,Height),
%    write(postBoundConstraint(X,Y,Width,Height,Bounds)),nl,
    postBoundConstraint(X,Y,Width,Height,Bounds),
    postConstraints(Constrs,ClassDecls,ConstrDecls,Object,[]).

createSuperClassInstance(nil,ClassDecls,ConstrDecls,DVars,DVarsR,SuperObject):-
    true : 
    DVars=DVarsR,SuperObject=nil.
createSuperClassInstance(SuperClass,ClassDecls,ConstrDecls,DVars,DVarsR,SuperObject):-
    baseClass(SuperClass),!,
    createBaseClassInstance(SuperClass,DVars,DVarsR,SuperObject).
createSuperClassInstance(SuperClass,ClassDecls,ConstrDecls,DVars,DVarsR,SuperObject):-
    hashtableGet(SuperClass,SuperClassDecl,ClassDecls),!,
    createClassInstance(SuperClassDecl,ClassDecls,ConstrDecls,DVars,DVarsR,SuperObject).
createSuperClassInstance(SuperClass,ClassDecls,ConstrDecls,DVars,DVarsR,SuperObject):-
    true :
    cmpError(['Superclass ',SuperClass,' not declared']).

createCompAttributeInstances(CompAttributes,ClassDecls,ConstrDecls,DVars,DVarsR,Hashtable):-var(CompAttributes) : DVars=DVarsR,CompAttributes=[].
createCompAttributeInstances([],ClassDecls,ConstrDecls,DVars,DVarsR,Hashtable):-true : DVars=DVarsR.
createCompAttributeInstances([component(Identifier,Type)|CompAttributes],ClassDecls,ConstrDecls,DVars,DVarsR,Hashtable):-
    attributeType(Type) :
    (Type == int -> createDomainVar(NewDVar); true),
    TypeDVar=..[Type,NewDVar],
    DVars=[TypeDVar|DVars1],
    hashtableSet(Identifier,attribute(Type,NewDVar),Hashtable),
    createCompAttributeInstances(CompAttributes,ClassDecls,ConstrDecls,DVars1,DVarsR,Hashtable).
createCompAttributeInstances([component(Name,Class)|CompAttributes],ClassDecls,ConstrDecls,DVars,DVarsR,Hashtable):-
    true :
    createComponentInstance(Class,ClassDecls,ConstrDecls,DVars,DVars1,Object),
    hashtableSet(Name,component(Class,Object),Hashtable),
    createCompAttributeInstances(CompAttributes,ClassDecls,ConstrDecls,DVars1,DVarsR,Hashtable).

createComponentInstance(array(Size,PType,Components),ClassDecls,ConstrDecls,DVars,DVarsR,Object):-true :
    Object=array(Size,PType,ArrayObjects),
    hashtableCreate(Size,ArrayObjects),
    createCompAttributeInstances(Components,ClassDecls,ConstrDecls,DVars,DVarsR,ArrayObjects).
createComponentInstance(ClassName,ClassDecls,ConstrDecls,DVars,DVarsR,Object):-
    baseClass(ClassName),!,
    createBaseClassInstance(ClassName,DVars,DVarsR,Object).
createComponentInstance(ClassName,ClassDecls,ConstrDecls,DVars,DVarsR,Object):-
    hashtableGet(ClassName,Class,ClassDecls),!,
    createClassInstance(Class,ClassDecls,ConstrDecls,DVars,DVarsR,Object).
createComponentInstance(ClassName,ClassDecls,ConstrDecls,DVars,DVarsR,Object):-
    cmpError(['Class ',ClassName, ' not defined']).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addFullNameConstraint({Constr},Type,Identifier,ClassDecls,NConstr):-
    true :
    NConstr={NConstr1},
    addFullNameConstraint(Constr,Type,Identifier,ClassDecls,NConstr1).
addFullNameConstraint([],Type,Identifier,ClassDecls,NConstr):-
    true : NConstr=[].
addFullNameConstraint([Constr|Constrs],Type,Identifier,ClassDecls,NConstr):-
    true :
    NConstr=[NConstr1|NConstrs],
    addFullNameConstraint(Constr,Type,Identifier,ClassDecls,NConstr1),
    addFullNameConstraint(Constrs,Type,Identifier,ClassDecls,NConstrs).
addFullNameConstraint(Constr,Type,Identifier,ClassDecls,NConstr):-
    functor(Constr,F,2) :
%    arithmeticConstraintSymbol(F) :
    arg(1,Constr,Exp1),
    arg(2,Constr,Exp2),
    NConstr=..[F,NExp1,NExp2],
    addFullNameExp(Exp1,Type,Identifier,ClassDecls,NExp1),
    addFullNameExp(Exp2,Type,Identifier,ClassDecls,NExp2).

addFullNameExp(true,Type,Identifier,ClassDecls,NExp):-true : NExp=true.
addFullNameExp(false,Type,Identifier,ClassDecls,NExp):-true : NExp=false.
addFullNameExp(Exp1+Exp2,Type,Identifier,ClassDecls,NExp):-
    true :
    NExp=(NExp1+NExp2),
    addFullNameExp(Exp1,Type,Identifier,ClassDecls,NExp1),
    addFullNameExp(Exp2,Type,Identifier,ClassDecls,NExp2).
addFullNameExp(Exp1-Exp2,Type,Identifier,ClassDecls,NExp):-
    true :
    NExp=(NExp1-NExp2),
    addFullNameExp(Exp1,Type,Identifier,ClassDecls,NExp1),
    addFullNameExp(Exp2,Type,Identifier,ClassDecls,NExp2).
addFullNameExp(Exp,Type,Identifier,ClassDecls,NExp):-
    Component.Rest <= Exp :
    ((atom(Component),checkCompAttr(Type,Component,ClassDecls)) ->
     NExp=(Identifier.Exp);
     NExp=Exp).
addFullNameExp(Exp,Type,Identifier,ClassDecls,NExp):-
    atom(Exp),
    checkCompAttr(Type,Exp,ClassDecls),!,
    NExp=(Identifier.Exp).
addFullNameExp(Exp,Type,Identifier,ClassDecls,NExp):-true :
    NExp=Exp.
    
checkCompAttr(nil,_,_):-true : fail.
checkCompAttr(Type,Identifier,ClassDecls):-
    baseClass(Type),!,
    checkBaseCompAttr(Type,Identifier).
checkCompAttr(Type,Identifier,ClassDecls):-
    hashtableGet(Type,ClassDecl,ClassDecls),!,
    checkCompAttrAux(Identifier,ClassDecl,ClassDecls).
checkCompAttr(Type,Identifier,ClassDecls):-
    runError(['Class ',Type,' not defined but used']).

checkCompAttrAux(Identifier,class(_,Constants,SuperClass,CompAttributes,Constrs,_,_,_),ClassDecls):-true ?
    lookupCompAttrList(Identifier,CompAttributes),!.
checkCompAttrAux(Identifier,class(_,Constants,SuperClass,CompAttributes,Constrs,_,_,_),ClassDecls):-true :
    checkCompAttr(SuperClass,Identifier,ClassDecls).




    
    

    


