%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : collectAttributes.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: collect attributes of classes
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
collectAttributeNames(Classes,AllClassDecls):-var(Classes) : true.
collectAttributeNames([],AllClassDecls):-true : true.
collectAttributeNames([Class|Classes],AllClassDecls):-
    class(PIdentifier,Constants,SuperClass,CompAttributes,Constrs,ClassBody,Args,TAPairs)<=Class :
    Args=[my_x,my_y,my_width,my_height|Args1],
    TAPairs=[pair(int,my_x),pair(int,my_y),pair(int,my_width),pair(int,my_height)|TAPairs1],
    (SuperClass==nil->Args1=Args2,TAPairs1=TAPairs2;
     lookupAttributeNames(super,SuperClass,Arg,TAPair,ClassDecls),
     Args1=[Arg|Args2],TAPairs1=[Pair|TAPairs2]),
    collectAttributeNames(CompAttributes,Args2,TAPairs2,AllClassDecls),
    collectAttributeNames(Classes,AllClassDecls).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
collectAttributeNames(CompAttributes,Args,TAPairs,ClassDecls):-
    var(CompAttributes) : 
    collectAttributeNames([],Args,TAPairs,ClassDecls).
/*
collectAttributeNames(nil,Args,TAPairs,ClassDecls):-
    true :
    collectAttributeNames([],Args,TAPairs,ClassDecls)
*/
collectAttributeNames([],Args,TAPairs,ClassDecls):-
    true :
    Args=[],TAPairs=[].
collectAttributeNames([component(Identifier,Type)|Rest],Args,TAPairs,ClassDecls):-
    attributeType(Type),!,
    Args=[Identifier|Args1],
    TAPairs=[pair(Type,Identifier)|TAPairs1],
    collectAttributeNames(Rest,Args1,TAPairs1,ClassDecls).
collectAttributeNames([component(Identifier,Class)|Rest],Args,TAPairs,ClassDecls):-
    true :
    lookupAttributeNames(Identifier,Class,Arg,TAPair,ClassDecls),
    Args=[Arg|Args1],
    TAPairs=[TAPair|TAPairs1],
    collectAttributeNames(Rest,Args1,TAPairs1,ClassDecls).

lookupAttributeNames(Identifier,Class,Arg,TAPair,ClassDecls):-
    array(Size,Type,Components)<=Class :
    Arg=component(Identifier,Args),
    TAPair=component(Identifier,TAPairs),
    collectAttributeNames(Components,Args,TAPairs,ClassDecls).
lookupAttributeNames(Identifier,Class,Arg,TAPair,ClassDecls):-
    baseClass(Class) :
    Arg=component(Identifier,Args),
    TAPair=component(Identifier,TAPairs),
    collectBaseAttributes(Class,Args,TAPairs).
lookupAttributeNames(Identifier,Class,Arg,TAPair,ClassDecls):-
    true :
    hashtableGet(Class,ClassDecl,ClassDecls),
    Arg=component(Identifier,Args),
    TAPair=component(Identifier,TAPairs),
    ClassDecl=class(PIdentifier,Constants,SuperClass,CompAttributes,Constrs,ClassBody,Args,TAPairs).
    
extractArgsFromTAPairs([],Args):-true : Args=[].
extractArgsFromTAPairs([pair(Type,Arg)|Pairs],Args):-true : 
    Args=[Arg|Args1],
    extractArgsFromTAPairs(Pairs,Args1).
    
