%% file  : blocks_statements.pl
%% author: Sosuke Kaneko
%% date  : Dec.1997 - Apr.1998
%   COPYRIGHT (C) 1998 Sosuke Kaneko

%--------  19.11  Blocks and Statements  --------%

%Block:
%        { BlockStatementsopt }
'Block'(T,[tok('{',_)|S0],S):-
	T='Block'('{',BlockStatementsopt,'}'),
	'BlockStatementsopt'(BlockStatementsopt,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok=='}' -> true ; error1('} expected',TN)).
/*
%error handling
'Block'(T,[tok(_,TN)|S0],S):-
	T=nil,S0=S,
	error1('{ expected',TN).
*/

%BlockStatements:
%        BlockStatement BlockStatementsopt
'BlockStatements'('BlockStatements'(
		      BlockStatement,
		      BlockStatementsopt)) -->
	'BlockStatement'(BlockStatement),
	'BlockStatementsopt'(BlockStatementsopt).

'BlockStatementsopt'(BlockStatements) -->
	'BlockStatements'(BlockStatements),
	{!}.
'BlockStatementsopt'(nil) --> [].

%BlockStatement:
%        LocalVariableDeclarationStatement
%        Statement
'BlockStatement'('BlockStatement'(
		     LocalVariableDeclarationStatement)) -->
	'LocalVariableDeclarationStatement'(LocalVariableDeclarationStatement),
	{!}.
'BlockStatement'('BlockStatement'(
		     Statement)) -->
	'Statement'(Statement),{!}.
% error handling
'BlockStatement'(T,S0,S):-
	S0=[tok(Tok,TN)|_],
	Tok\='}',Tok\=case,Tok\=default,
	error1('invalid statement',TN).
'BlockStatement'(T,S0,S):-
	T=nil,
	S0=[tok(Token,_)|_],
	Token\='}',Token\=case,Token\=default,
	errorRecovery(S0,S,WrongStatements).
%	reportError(['wrong block statement'|WrongStatements]).


%LocalVariableDeclarationStatement:
%        LocalVariableDeclaration ;
'LocalVariableDeclarationStatement'('LocalVariableDeclarationStatement'(
					LocalVariableDeclaration)) -->
	'LocalVariableDeclaration'(LocalVariableDeclaration),
	[tok(Tok,TN)],
	{Tok==';' -> true ; error1('; expected',TN)}.

%LocalVariableDeclaration:
%        Type VariableDeclarators
'LocalVariableDeclaration'('LocalVariableDeclaration'(
			       Type,
			       VariableDeclarators)) -->
	'Type'(Type),
	'VariableDeclarators'(VariableDeclarators).

%Statement:
%        StatementWithoutTrailingSubstatement
%        LabeledStatement
%        IfThenElseStatement
%        IfThenStatement
%        WhileStatement
%        ForStatement
'Statement'('Statement'(
		StatementWithoutTrailingSubstatement)) -->
	'StatementWithoutTrailingSubstatement'(StatementWithoutTrailingSubstatement),{!}.
'Statement'('Statement'(
		LabeledStatement)) -->
	'LabeledStatement'(LabeledStatement),{!}.
'Statement'('Statement'(
		IfThenElseStatement)) -->
	'IfThenElseStatement'(IfThenElseStatement),{!}.
'Statement'('Statement'(
		IfThenStatement)) -->
	'IfThenStatement'(IfThenStatement),{!}.
'Statement'('Statement'(
		WhileStatement)) -->
	'WhileStatement'(WhileStatement),{!}.
'Statement'('Statement'(
		ForStatement)) -->
	'ForStatement'(ForStatement).

%StatementNoShortIf:
%        StatementWithoutTrailingSubstatement
%        LabeledStatementNoShortIf
%        IfThenElseStatementNoShortIf
%        WhileStatementNoShortIf
%        ForStatementNoShortIf
'StatementNoShortIf'('StatementNoShortIf'(
			 StatementWithoutTrailingSubstatement)) -->
	'StatementWithoutTrailingSubstatement'(StatementWithoutTrailingSubstatement),{!}.
'StatementNoShortIf'('StatementNoShortIf'(
			 LabeledStatementNoShortIf)) -->
	'LabeledStatementNoShortIf'(LabeledStatementNoShortIf),{!}.
'StatementNoShortIf'('StatementNoShortIf'(
			 IfThenElseStatementNoShortIf)) -->
	'IfThenElseStatementNoShortIf'(IfThenElseStatementNoShortIf),{!}.
'StatementNoShortIf'('StatementNoShortIf'(
			 WhileStatementNoShortIf)) -->
	'WhileStatementNoShortIf'(WhileStatementNoShortIf),{!}.
'StatementNoShortIf'('StatementNoShortIf'(
			 ForStatementNoShortIf)) -->
	'ForStatementNoShortIf'(ForStatementNoShortIf).

%StatementWithoutTrailingSubstatement:
%        Block
%        EmptyStatement
%        SwitchStatement
%        DoStatement
%        BreakStatement
%        ContinueStatement
%        ReturnStatement
%        SynchronizedStatement
%        ThrowStatement
%        TryStatement
%        ExpressionStatement
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   Block)) -->
	'Block'(Block),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   EmptyStatement)) -->
	'EmptyStatement'(EmptyStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   SwitchStatement)) -->
	'SwitchStatement'(SwitchStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   DoStatement)) -->
	'DoStatement'(DoStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   BreakStatement)) -->
	'BreakStatement'(BreakStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   ContinueStatement)) -->
	'ContinueStatement'(ContinueStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   ReturnStatement)) -->
	'ReturnStatement'(ReturnStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   SynchronizedStatement)) -->
	'SynchronizedStatement'(SynchronizedStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   ThrowStatement)) -->
	'ThrowStatement'(ThrowStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   TryStatement)) -->
	'TryStatement'(TryStatement),{!}.
'StatementWithoutTrailingSubstatement'('StatementWithoutTrailingSubstatement'(
					   ExpressionStatement)) -->
	'ExpressionStatement'(ExpressionStatement).

%EmptyStatement:
%        ;
'EmptyStatement'(T,[tok(';',_)|S0],S):-
	S0=S,
	T='EmptyStatement'(';').

%LabeledStatement:
%        Identifier : Statement
'LabeledStatement'('LabeledStatement'(
		       Identifier,
		       ':',
		       Statement)) -->
	'Identifier'(Identifier),
	[tok(':',_)],
	'Statement'(Statement).

%LabeledStatementNoShortIf:
%        Identifier : StatementNoShortIf
'LabeledStatementNoShortIf'('LabeledStatementNoShortIf'(
				Identifier,
			        ':',
			        StatementNoShortIf)) -->
	'Identifier'(Identifier),
	[tok(':',_)],
	'StatementNoShortIf'(StatementNoShortIf).

%ExpressionStatement:
%        StatementExpression ;
'ExpressionStatement'('ExpressionStatement'(
			   StatementExpression,
			   ';')) -->
	'StatementExpression'(StatementExpression),
	[tok(Tok,TN)],
	{Tok==';' -> true ; error1('; expected',TN)}.

%StatementExpression:
%        Assignment
%        PreIncrementExpression
%        PreDecrementExpression
%        PostIncrementOrDecrementExpression
%        MethodInvocation
%        ClassInstanceCreationExpression
'StatementExpression'('StatementExpression'(
                          Assignment)) -->
        'Assignment'(Assignment),{!}.
'StatementExpression'('StatementExpression'(
                          PreIncrementExpression)) -->
        'PreIncrementExpression'(PreIncrementExpression),{!}.
'StatementExpression'('StatementExpression'(
                          PreDecrementExpression)) -->
        'PreDecrementExpression'(PreDecrementExpression),{!}.
'StatementExpression'('StatementExpression'(
                          PostIncrementOrDecrementExpression)) -->
        'PostIncrementOrDecrementExpression'(PostIncrementOrDecrementExpression),{!}. 
'StatementExpression'('StatementExpression'(
                          StatementMethodInvocation)) -->
        'StatementMethodInvocation'(StatementMethodInvocation),{!}.
'StatementExpression'('StatementExpression'(
                          ClassInstanceCreationExpression)) -->
        'ClassInstanceCreationExpression'(ClassInstanceCreationExpression).

%IfThenStatement:
%        if ( Expression ) Statement
'IfThenStatement'(T,[tok(if,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='IfThenStatement'(if,'(',Expression,')',Statement),
	'Expression'(Expression,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'Statement'(Statement,S3,S).

%IfThenElseStatement:
%        if ( Expression ) StatementNoShortIf else Statement
'IfThenElseStatement'(T,[tok(if,_),tok('(',_)|S0],S):-
	T='IfThenElseStatement'(if,'(',Expression,')',StatementNoShortIf,else,Statement),
	'Expression'(Expression,S0,S1),
	S1=[tok(')',_)|S2],
	'StatementNoShortIf'(StatementNoShortIf,S2,S3),
	S3=[tok(else,_)|S4],
	'Statement'(Statement,S4,S).

%IfThenElseStatementNoShortIf:
%        if ( Expression ) StatementNoShortIf else StatementNoShortIf
'IfThenElseStatementNoShortIf'(T,[tok(if,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='IfThenElseStatementNoShortIf'(if,'(',Expression,')',StatementNoShortIf1,else,StatementNoShortIf2),
	'Expression'(Expression,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'StatementNoShortIf'(StatementNoShortIf1,S3,S4),
	S4=[tok(else,_)|S5],
	'StatementNoShortIf'(StatementNoShortIf2,S5,S).

%SwitchStatement:
%        switch ( Expression ) SwitchBlock
'SwitchStatement'(T,[tok(switch,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='SwitchStatement'(switch,'(',Expression,')',SwitchBlock),
	'Expression'(Expression,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'SwitchBlock'(SwitchBlock,S3,S).

%SwitchBlock:
%        { SwitchBlockStatementGroupsopt SwitchLabelsopt }
'SwitchBlock'(T,[tok('{',_)|S0],S):-!,
	T='SwitchBlock'('{',SwitchBlockStatementGroupsopt,SwitchLabelsopt,'}'),
	'SwitchBlockStatementGroupsopt'(SwitchBlockStatementGroupsopt,S0,S1),
	'SwitchLabelsopt'(SwitchLabelsopt,S1,S2),
	S2=[tok(Tok,TN)|S],
	(Tok=='}' -> true ; error1('} expected',TN)).
%error handling
'SwitchBlock'(T,[tok(_,TN)|S0],S):-
	T=nil,S0=S,
	error1('{ expected',TN).

%SwitchBlockStatementGroups:
%        SwitchBlockStatementGroup SwitchBlockStatementGroupsopt
'SwitchBlockStatementGroups'('SwitchBlockStatementGroups'(
				 SwitchBlockStatementGroup,
				 SwitchBlockStatementGroupsopt)) -->
	'SwitchBlockStatementGroup'(SwitchBlockStatementGroup),
	'SwitchBlockStatementGroupsopt'(SwitchBlockStatementGroupsopt).

'SwitchBlockStatementGroupsopt'(SwitchBlockStatementGroups) -->
	'SwitchBlockStatementGroups'(SwitchBlockStatementGroups).
	{!}.
'SwitchBlockStatementGroupsopt'(nil) --> [].

%SwitchBlockStatementGroup:
%        SwitchLabels BlockStatements
'SwitchBlockStatementGroup'('SwitchBlockStatementGroup'(
				SwitchLabels,
			       	BlockStatements)) -->
	'SwitchLabels'(SwitchLabels),
	'BlockStatements'(BlockStatements).

%SwitchLabels:
%        SwitchLabel SwitchLabels
'SwitchLabels'('SwitchLabels'(
		   SwitchLabel,
		   SwitchLabelsopt)) -->
	'SwitchLabel'(SwitchLabel),
	'SwitchLabelsopt'(SwitchLabelsopt).

'SwitchLabelsopt'(SwitchLabels) -->
	'SwitchLabels'(SwitchLabels).
	{!}.
'SwitchLabelsopt'(nil) --> [].

%SwitchLabel:
%        case ConstantExpression :
%        default :
'SwitchLabel'(T,[tok(case,_)|S0],S):-!,
	T='SwitchLabel'(case,ConstantExpression,':'),
	'ConstantExpression'(ConstantExpression,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok==':' -> true ; error1(': expected',TN)).
'SwitchLabel'(T,[tok(default,TN)|S0],S):-
	(S0=[tok(':',_)|S] -> true ; error(': expected',TN)),
	T='SwitchLabel'(default,':').
	

%WhileStatement:
%        while ( Expression ) Statement
'WhileStatement'(T,[tok(while,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='WhileStatement'(while,'(',Expression,')',Statement),
	'Expression'(Expression,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'Statement'(Statement,S3,S).

%WhileStatementNoShortIf:
%        while ( Expression ) StatementNoShortIf
'WhileStatementNoShortIf'(T,[tok(while,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='WhileStatementNoShortIf'(while,'(',Expression,')',StatementNoShortIf),
	'Expression'(Expression,S0,S1),
	S1=[tok(Tok1,TN1)|S2],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'StatementNoShortIf'(StatementNoShortIf,S2,S).

%DoStatement:
%        do Statement while ( Expression ) ;
'DoStatement'(T,[tok(do,_)|S0],S):-
	T='DoStatement'(do,Statement,while,'(',Expression,')',';'),
	'Statement'(Statement,S0,S1),
	S1=[tok(Tok1,TN1)|S2],
	(Tok1==while -> true ; error1('keyword while expected',TN1)),
	(S2=[tok('(',_)|S3] -> true ; error('( expected',TN1)),
	'Expression'(Expression,S3,S4),
	S4=[tok(Tok2,TN2)|S5],
	(Tok2==')' -> true ; error1(') expected',TN2)),
	(S5=[tok(';',_)|S] -> true ; error('; expected',TN2)).

%ForStatement:
%        for ( ForInitopt ; Expressionopt ; ForUpdateopt ) Statement
'ForStatement'(T,[tok(for,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='ForStatement'(for,'(',ForInitopt,';',Expressionopt,';',ForUpdateopt,')',Statement),
        'ForInitopt'(ForInitopt,S1,S2),
        S2=[tok(Tok1,TN1)|S3],
	(Tok1==';' -> true ; error1('; expected',TN1)),
        'Expressionopt'(Expressionopt,S3,S4),
        S4=[tok(Tok2,TN2)|S5],
	(Tok2==';' -> true ; error1('; expected',TN2)),
        'ForUpdateopt'(ForUpdateopt,S5,S6),
        S6=[tok(Tok3,TN3)|S7],
	(Tok3==')' -> true ; error1(') expected',TN3)),
        'Statement'(Statement,S7,S).

%ForStatementNoShortIf:
%        for ( ForInitopt ; Expressionopt ; ForUpdateopt ) StatementNoShortIf
'ForStatementNoShortIf'(T,[tok(for,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='ForStatementNoShortIf'(for,'(',ForInitopt,';',Expressionopt,';',ForUpdateopt,')',StatementNoShortIf),
        'ForInitopt'(ForInitopt,S1,S2),
        S2=[tok(Tok1,TN1)|S3],
	(Tok1==';' -> true ; error1('; expected',TN1)),
        'Expressionopt'(Expressionopt,S3,S4),
        S4=[tok(Tok2,TN2)|S5],
	(Tok2==';' -> true ; error1('; expected',TN2)),
        'ForUpdateopt'(ForUpdateopt,S5,S6),
        S6=[tok(Tok3,TN3)|S7],
	(Tok==')' -> true ; error1(') expected',TN3)),
        'StatementNoShortIf'(StatementNoShortIf,S7,S).

%ForInit:
%        StatementExpressionList
%        LocalVariableDeclaration
'ForInit'('ForInit'(
              StatementExpressionList)) -->
        'StatementExpressionList'(StatementExpressionList).
'ForInit'('ForInit'(
              LocalVariableDeclaration)) -->
        'LocalVariableDeclaration'(LocalVariableDeclaration).

'ForInitopt'(ForInit) --> 'ForInit'(ForInit),{!}.
'ForInitopt'(nil) --> [].

%ForUpdate:
%        StatementExpressionList
'ForUpdate'('ForUpdate'(
                StatementExpressionList)) -->
        'StatementExpressionList'(StatementExpressionList).

'ForUpdateopt'(ForUpdate) --> 'ForUpdate'(ForUpdate). %,{!}.
'ForUpdateopt'(nil) --> [].

%StatementExpressionList:
%        StatementExpression StatementExpressionListRestopt
'StatementExpressionList'('StatementExpressionList'(
				StatementExpression,
				StatementExpressionListRestopt)) -->
	'StatementExpression'(StatementExpression),
	'StatementExpressionListRestopt'(StatementExpressionListRestopt).

%StatementExpressionListRest:
%        , StatementExpressionList
'StatementExpressionListRest'(T,[tok(',',_)|S0],S):-
	T='StatementExpressionListRest'(',',StatementExpressionList),
        'StatementExpressionList'(StatementExpressionList,S0,S).

'StatementExpressionListRestopt'(StatementExpressionListRest) -->
	'StatementExpressionListRest'(StatementExpressionListRest).
	{!}.
'StatementExpressionListRestopt'(nil) --> [].

%BreakStatement:
%        break Identifieropt ;
'BreakStatement'(T,[tok(break,_)|S0],S):-
	T='BreakStatement'(break,Identifieropt,';'),
	'Identifieropt'(Identifieropt,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok==';' -> true ; error1('; expected',TN)).

%ContinueStatement:
%        continue Identifieropt ;
'ContinueStatement'(T,[tok(continue,_)|S0],S):-
	T='ContinueStatement'(continue,Identifieropt,';'),
	'Identifieropt'(Identifieropt,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok==';' -> true ; error1('; expected',TN)).

%ReturnStatement:
%        return Expressionopt ;
'ReturnStatement'(T,[tok(return,_)|S0],S):-
	T='ReturnStatement'(return,Expressionopt,';'),
	'Expressionopt'(Expressionopt,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok==';' -> true ; error1('; expected',TN)).

%ThrowStatement:
%        throw Expression ;
'ThrowStatement'(T,[tok(throw,_)|S0],S):-
	T='ThrowStatement'(throw,Expression,';'),
	'Expression'(Expression,S0,S1),
	S1=[tok(Tok,TN)|S],
	(Tok==';' -> true ; error1('; expected',TN)).

%SynchronizedStatement:
%        synchronized ( Expression ) Block
'SynchronizedStatement'(T,[tok(synchronized,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='SynchronizedStatement'(synchronized,'(',Expression,')',Block),
	'Expression'(Expression,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'Block'(Block,S3,S).

%TryStatement:
%        try Block Catchesopt Finally
%        try Block Catches
'TryStatement'(T,[tok(try,_)|S0],S):-
	T='TryStatement'(try,Block,Catchesopt,Finally),
	'Block'(Block,S0,S1),
	'Catchesopt'(Catchesopt,S1,S2),
	'Finally'(Finally,S2,S),!.
'TryStatement'(T,[tok(try,_)|S0],S):-
	T='TryStatement'(try,Block,Catches),
	'Block'(Block,S0,S1),
	'Catches'(Catches,S1,S).

%Catches:
%        CatchClause Catchesopt
'Catches'('Catches'(
	      CatchClause,
	      Catchesopt)) -->
	'CatchClause'(CatchClause),
	'Catchesopt'(Catchesopt).

'Catchesopt'(Catches) --> 'Catches'(Catches),{!}.
'Catchesopt'(nil) --> [].

%CatchClause:
%        catch ( FormalParameter ) Block
'CatchClause'(T,[tok(catch,TN)|S0],S):-
	(S0=[tok('(',_)|S1] -> true ; error('( expected',TN)),
	T='CatchClause'(catch,'(',FormalParameter,')',Block),
	'FormalParameter'(FormalParameter,S1,S2),
	S2=[tok(Tok1,TN1)|S3],
	(Tok1==')' -> true ; error1(') expected',TN1)),
	'Block'(Block,S3,S).

%Finally:
%        finally Block
'Finally'(T,[tok(finally,_)|S0],S):-
	T='Finally'(finally,Block),
	'Block'(Block,S0,S).
