%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : baseConstraints.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: post base constraints
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:-mode isBuiltinConstraint(+,+).
isBuiltinConstraint(inside,2).
isBuiltinConstraint(outside,2).
isBuiltinConstraint(above,2).
isBuiltinConstraint(below,2).
isBuiltinConstraint(left,2).
isBuiltinConstraint(right,2).
isBuiltinConstraint(sameWidth,_).
isBuiltinConstraint(sameHeight,_).
isBuiltinConstraint(sameSize,_).
isBuiltinConstraint(sameDiameter,_).
isBuiltinConstraint(sameFont,_).
isBuiltinConstraint(sameX,_).
isBuiltinConstraint(sameY,_).
isBuiltinConstraint(sameCenterX,_).
isBuiltinConstraint(sameCenterY,_).
isBuiltinConstraint(sameRow,_).
isBuiltinConstraint(sameColumn,_).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postInsideConstraint(O1,O2):-
    checkObject(O1,inside),
    checkObject(O2,inside),!,
    getComponentsBounds(O1,Bounds1,[]),
    getComponentsBounds(O2,Bounds2,[]),
    postInsideConstraintBounds(Bounds1,Bounds2).
    
postInsideConstraintBounds([],Bounds2):-true : true.
postInsideConstraintBounds([Bound1|Bounds1],Bounds2):-
    true :
    postInsideConstraintBoundsAux(Bound1,Bounds2),
    postInsideConstraintBounds(Bounds1,Bounds2).

postInsideConstraintBoundsAux(Bound1,[]):-true : true.
postInsideConstraintBoundsAux(Bound1,[Bound2|Bounds2]):-
    true :
    postInsideConstraintBoundBound(Bound1,Bound2),
    postInsideConstraintBoundsAux(Bound1,Bounds2).
    
postInsideConstraintBoundBound(Bound1,Bound2):-
    $bound(X1,Y1,Width1,Height1)<=Bound1,
    $bound(X2,Y2,Width2,Height2)<=Bound2 :
    X1 #>= X2,
    Y1 #>= Y2,
    Width1 #=< Width2,
    Height1 #=< Height2,
    X1+Width1 #=< X2+Width2,
    Y1+Height1 #=< Y2+Height2.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postAboveConstraint(O1,O2):-
    checkObject(O1,above),
    checkObject(O2,above),!,
    getComponentsBounds(O1,Bounds1,[]),
    getComponentsBounds(O2,Bounds2,[]),
    postAboveConstraintBounds(Bounds1,Bounds2).
    
postAboveConstraintBounds([],Bounds2):-true : true.
postAboveConstraintBounds([Bound1|Bounds1],Bounds2):-
    true :
    postAboveConstraintBoundsAux(Bound1,Bounds2),
    postAboveConstraintBounds(Bounds1,Bounds2).

postAboveConstraintBoundsAux(Bound1,[]):-true : true.
postAboveConstraintBoundsAux(Bound1,[Bound2|Bounds2]):-
    true :
    postAboveConstraintBoundBound(Bound1,Bound2),
    postAboveConstraintBoundsAux(Bound1,Bounds2).
    
postAboveConstraintBoundBound(Bound1,Bound2):-
    $bound(X1,Y1,Width1,Height1)<=Bound1,
    $bound(X2,Y2,Width2,Height2)<=Bound2 :
    Y1+Height1 #=< Y2.
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postLeftConstraint(O1,O2):-
    checkObject(O1,left),
    checkObject(O2,left),!,
    getComponentsBounds(O1,Bounds1,[]),
    getComponentsBounds(O2,Bounds2,[]),
    postLeftConstraintBounds(Bounds1,Bounds2).
    
postLeftConstraintBounds([],Bounds2):-true : true.
postLeftConstraintBounds([Bound1|Bounds1],Bounds2):-
    true :
    postLeftConstraintBoundsAux(Bound1,Bounds2),
    postLeftConstraintBounds(Bounds1,Bounds2).

postLeftConstraintBoundsAux(Bound1,[]):-true : true.
postLeftConstraintBoundsAux(Bound1,[Bound2|Bounds2]):-
    true :
    postLeftConstraintBoundBound(Bound1,Bound2),
    postLeftConstraintBoundsAux(Bound1,Bounds2).
    
postLeftConstraintBoundBound(Bound1,Bound2):-
    $bound(X1,Y1,Width1,Height1)<=Bound1,
    $bound(X2,Y2,Width2,Height2)<=Bound2 :
    X1+Width1 #=< X2.
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postSameGeometricConstraint(Attr,[]):-true : true.
postSameGeometricConstraint(Attr,[_]):-true : true.
postSameGeometricConstraint(Attr,[Arg|Args]):-true :
    getGeometricAttribute(Attr,Val,Arg),
    postSameGeometricConstraint(Attr,Val,Args).

postSameGeometricConstraint(Attr,Val,[]):-true : true.
postSameGeometricConstraint(Attr,Val,[Arg|Args]):-true :
    getGeometricAttribute(Attr,Val1,Arg),
    Val1=Val,
    postSameGeometricConstraint(Attr,Val,Args).

getGeometricAttribute(Attr,Val,Object):-
    isObject(Object),!,
    getComponentBound(Object,X,Y,Width,Height),
    getGeometricAttribute(Attr,Val,X,Y,Width,Height).
getGeometricAttribute(Attr,Val,Object):-
    array(Size,Type,Hashtable)<=Object :
    hashtableCollect(Hashtable,SubComponents),
    positionInsideScreen(X,Y),
    sizeInsideScreen(Width,Height),
    getComponentsBounds(SubComponents,Bounds,[],X,Y,Width,Height),
    postBoundConstraint(X,Y,Width,Height,Bounds),
    getGeometricAttribute(Attr,Val,X,Y,Width,Height).
getGeometricAttribute(Attr,Val,Object):-
    true :
    cmpError(['Wrong attribute name: ',Attr]).

getGeometricAttribute(my_x,Val,X,Y,Width,Height):-
    true :
    Val=X.
getGeometricAttribute(my_y,Val,X,Y,Width,Height):-
    true :
    Val=Y.
getGeometricAttribute(my_width,Val,X,Y,Width,Height):-
    true :
    Val=Width.
getGeometricAttribute(my_height,Val,X,Y,Width,Height):-
    true :
    Val=Height.
getGeometricAttribute(x,Val,X,Y,Width,Height):-
    true :
    Val=X.
getGeometricAttribute(y,Val,X,Y,Width,Height):-
    true :
    Val=Y.
getGeometricAttribute(width,Val,X,Y,Width,Height):-
    true :
    Val=Width.
getGeometricAttribute(height,Val,X,Y,Width,Height):-
    true :
    Val=Height.
getGeometricAttribute(size,Val,X,Y,Width,Height):-
    true :
    Val=size(Width,Height).
getGeometricAttribute(position,Val,X,Y,Width,Height):-
    true :
    Val=point(X,Y).
getGeometricAttribute(centerX,Val,X,Y,Width,Height):-
    true :
    createDomainVar(Val),
    2*Val #= 2*X+Width.
getGeometricAttribute(centerY,Val,X,Y,Width,Height):-
    true :
    createDomainVar(Val),
    2*Val #= 2*Y+Height.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postSameConstraint(Attr,[]):-true : true.
postSameConstraint(Attr,[_]):-true : true.
postSameConstraint(Attr,[Arg|Args]):-true :
    getAttribute(Attr,Val,Type,Arg),
    postSameConstraint(Attr,Val,Type,Args).

postSameConstraint(Attr,Val,Type,[]):-true : true.
postSameConstraint(Attr,Val,Type,[Arg|Args]):-true :
    (getAttribute(Attr,Val1,Type1,Arg) -> true;
     cmpError(['Attribute ', Attr,' does not exist'])),
    (Type==Type1->true;
     cmpError(['Types mismatch in same', Attr,' constraintt',Type1,Type2])),
    Val1=Val,
    postSameConstraint(Attr,Val,Type,Args).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postGridConstraint(Rows,PadX,PadY):-
    array(Size,Type,Hashtable)<=Rows :
    global_set('$error_is_here',0,grid),
    sizeInsideScreen(GridWidth,GridHeight),
    GridHeight=GridWidth,
    sizeInsideScreen(TotalWidth,TotalHeight),
    positionInsideScreen(StartX,StartY),
    checkAndGetGridColumns(0,Size,Hashtable,0,NoColumns),
%    cmpError(['Two rows in grid do not have the same number of items'])),
    TotalWidth #= NoColumns*GridWidth,
    TotalHeight #= Size*GridHeight,
    postGridRows(0,Size,Hashtable,StartX,PadX,GridWidth,TotalWidth),
    postGridColumns(0,NoColumns,Size,Hashtable,StartY,PadY,GridHeight).
postGridConstraint(Rows,PadX,PadY):-true : true.

postGridRows(N0,N,RowsHashtable,StartX,PadX,GridWidth,TotalWidth):-N0>=N : true.
postGridRows(N0,N,RowsHashtable,StartX,PadX,GridWidth,TotalWidth):-
    true :
    getTypeAndValueFromHashtable(N0,_,Row,RowsHashtable),
    postGridRow(Row,StartX,PadX,GridWidth,TotalWidth),
    N1 is N0+1,
    postGridRows(N1,N,RowsHashtable,StartX,PadX,GridWidth,TotalWidth).
    
postGridRow(Row,StartX,PadX,GridWidth,TotalWidth):-
    array(Size,Type,Hashtable)<=Row,
    Size>1 :
    getTypeAndValueFromHashtable(0,_,FirstItem,Hashtable),
    getComponentBound(FirstItem,X1,Y1,Width1,Height1),
    X1 = StartX,
    postGridRowItems(1,Size,Hashtable,FirstItem,1,X1,Width1,PadX,GridWidth).
postGridRow(Row,StartX,PadX,GridWidth,TotalWidth):-
    array(Size,Type,Hashtable)<=Row,
    Size=:=1 :
    getTypeAndValueFromHashtable(0,_,Item,Hashtable),
    postGridOneItemRow(Item,StartX,PadX,TotalWidth).
postGridRow(Row,StartX,PadX,GridWidth,TotalWidth):-
    true :
    postGridOneItemRow(Row,StartX,PadX,TotalWidth).

postGridOneItemRow(Item,StartX,PadX,TotalWidth):-
    true :
    getComponentBound(Item,X1,Y1,Width1,Height1),
    Width1 #= TotalWidth-2*PadX,
    X1 = StartX.
    
postGridRowItems(N0,N,Hashtable,PrevItem,NoOccurs,PrevX,PrevWidth,PadX,GridWidth):-
    N0>=N : 
    PrevWidth #= NoOccurs*GridWidth-2*PadX.
%    write_dvar(PrevWidth),nl.
postGridRowItems(N0,N,Hashtable,PrevItem,NoOccurs,PrevX,PrevWidth,PadX,GridWidth):-
    true :
    getTypeAndValueFromHashtable(N0,_,Item,Hashtable),
    getComponentBound(Item,X1,Y1,Width1,Height1),
    (Item==PrevItem -> NoOccurs1 is NoOccurs+1,PrevX1=PrevX,PrevWidth1=PrevWidth
      ;
     X1 #= PrevX+NoOccurs*GridWidth, PrevWidth #= NoOccurs*GridWidth-2*PadX,
     NoOccurs1=1,PrevX1=X1,PrevWidth1=Width1),
%    write_dvar(PrevWidth),nl,
    N1 is N0+1,
    postGridRowItems(N1,N,Hashtable,Item,NoOccurs1,PrevX1,PrevWidth1,PadX,GridWidth).

postGridColumns(N0,N,NoRows,Hashtable,StartY,PadY,GridHeight):-N0>=N : true.
postGridColumns(N0,N,NoRows,Hashtable,StartY,PadY,GridHeight):-
    true :
    postGridColumn(N0,NoRows,Hashtable,StartY,PadY,GridHeight),
    N1 is N0+1,
    postGridColumns(N1,N,NoRows,Hashtable,StartY,PadY,GridHeight).
    
postGridColumn(ColumnNo,RowNo,Hashtable,StartY,PadY,GridHeight):-
    true :
    getTypeAndValueFromHashtable(0,_,FirstRow,Hashtable),
    getItemInRow(ColumnNo,FirstItem,FirstRow),
    getComponentBound(FirstItem,X1,Y1,Width1,Height1),
    Y1 = StartY,
    postGridColumnItems(ColumnNo,1,RowNo,Hashtable,FirstItem,1,Y1,Height1,PadY,GridHeight).
    
postGridColumnItems(ColumnNo,RowNo0,RowNo,Hashtable,PrevItem,NoOccurs,PrevY,PrevHeight,PadY,GridHeight):-
    RowNo0>=RowNo : 
    PrevHeight #= NoOccurs*GridHeight-2*PadY.
postGridColumnItems(ColumnNo,RowNo0,RowNo,Hashtable,PrevItem,NoOccurs,PrevY,PrevHeight,PadY,GridHeight):-
    true :
    getTypeAndValueFromHashtable(RowNo0,_,Row,Hashtable),
    getItemInRow(ColumnNo,Item,Row),
    getComponentBound(Item,X1,Y1,Width1,Height1),
    (Item==PrevItem -> NoOccurs1 is NoOccurs+1,PrevY1=PrevY,PrevHeight1=PrevHeight
      ;
     Y1 #= PrevY+NoOccurs*GridHeight, PrevHeight #= NoOccurs*GridHeight-2*PadY,
     NoOccurs1=1,PrevY1=Y1,PrevHeight1=Height1),
    RowNo1 is RowNo0+1,
    postGridColumnItems(ColumnNo,RowNo1,RowNo,Hashtable,Item,NoOccurs1,PrevY1,PrevHeight1,PadY,GridHeight).
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
getItemInRow(ColumnNo,Item,Row):-
    array(Size,Type,Hashtable)<=Row,
    ColumnNo<Size :
    getTypeAndValueFromHashtable(ColumnNo,_,Item,Hashtable).
getItemInRow(ColumnNo,Item,Row):-
    array(Size,Type,Hashtable)<=Row,
    Size=:=1 :
    getTypeAndValueFromHashtable(0,_,Item,Hashtable).
getItemInRow(ColumnNo,Item,Row):-
    true :
    Item=Row. % only one item in this row

checkAndGetGridColumns(N0,N,Hashtable,No0,NoColumns):-
    N0>=N : NoColumns=No0.
checkAndGetGridColumns(N0,N,Hashtable,No0,NoColumns):-
    true :
    getTypeAndValueFromHashtable(N0,_,Row,Hashtable),
    checkAndGetGridColumnsInRow(Row,NoColumns1),
    (NoColumns1>No0->No1 = NoColumns1;No1=No0),
    N1 is N0+1,
    checkAndGetGridColumns(N1,N,Hashtable,No1,NoColumns).
     
checkAndGetGridColumnsInRow(Row,NoColumns):-
    array(Size,Type,Hashtable)<=Row :
    NoColumns=Size.
checkAndGetGridColumnsInRow(Row,NoColumns):-
    true : NoColumns=1.
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postBoundConstraint(X,Y,Width,Height,[]):-true : true.
postBoundConstraint(X,Y,Width,Height,[$bound(X1,Y1,Width1,Height1)]):-
    true : 
    X=X1, Y=Y1,Width=Width1, Height=Height1.
postBoundConstraint(X,Y,Width,Height,Bounds):-
    true :
    postBoundConstraintAux(X,Y,Width,Height,Bounds).

fixBound(MinX,MinY,Width,Height,[$bound(X1,Y1,Width1,Height1)|Bounds]):-
    true : 
    RightX is X1+Width1,
    RightY is Y1+Height1,
    fixBound(MinX,MinY,MaxX,MaxY,X1,Y1,RightX,RightY,Bounds),
    Width is MaxX-MinX,
    Height is MaxY-MinY.

fixBound(MinX,MinY,MaxX,MaxY,X1,Y1,X2,Y2,[]):-
    true :
    MinX=X1, MinY=Y1,MaxX=X2,MaxY=Y2.
fixBound(MinX,MinY,MaxX,MaxY,X1,Y1,X2,Y2,[$bound(X,Y,Width,Height)|Bounds]):-
    true :
    (X<X1->X11=X;X11=X1),
    (Y<Y1->Y11=Y;Y11=Y1),
    RightX is X+Width,
    RightY is Y+Height,
    (RightX>X2->X22=RightX;X22=X2),
    (RightY>Y2->Y22=RightY;Y22=Y2),
    fixBound(MinX,MinY,MaxX,MaxY,X11,Y11,X22,Y22,Bounds).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkObject(O,Where):-
    isObject(O),!.
checkObject(O,Where):-
    array(Size,Type,Hashtable)<=O : true.
checkObject(O,Where):-
    cmpError(['A non-object argument in constraint: ',Where]).
    





    
    
    
