%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : baseClasses.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: information about base classes
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:-mode baseClass(+).
baseClass('Button').
baseClass('Checkbox').
baseClass('Choice').
baseClass('Label').
baseClass('List').
baseClass('Scrollbar').
baseClass('TextArea').
baseClass('TextField').
baseClass('Arc').
baseClass('Circle').
baseClass('Line').
baseClass('Oval').
baseClass('Polygon').
baseClass('Rectangle').
baseClass('Square').
baseClass('RoundRectangle').
baseClass('Star').
baseClass('Triangle').

:-mode isGraphicsClass(+).
isGraphicsClass('Arc').
isGraphicsClass('Circle').
isGraphicsClass('Line').
isGraphicsClass('Oval').
isGraphicsClass('Polygon').
isGraphicsClass('Square').
isGraphicsClass('Rectangle').
isGraphicsClass('RoundRectangle').
isGraphicsClass('Star').
isGraphicsClass('Triangle').
isGraphicsClass('DJArc').
isGraphicsClass('DJCircle').
isGraphicsClass('DJLine').
isGraphicsClass('DJOval').
isGraphicsClass('DJSquare').
isGraphicsClass('DJRectangle').
isGraphicsClass('DJRoundRectangle').
isGraphicsClass('DJStar').
isGraphicsClass('DJTriangle').

:-mode djGraphicsClassName(+,-).
djGraphicsClassName('Arc',Y):-true : Y='DJArc'.
djGraphicsClassName('Circle',Y):-true : Y='DJCircle'.
djGraphicsClassName('Line',Y):-true : Y='DJLine'.
djGraphicsClassName('Oval',Y):-true : Y='DJOval'.
djGraphicsClassName('Polygon',Y):-true : Y='DJPolygon'.
djGraphicsClassName('Square',Y):-true : Y='DJSquare'.
djGraphicsClassName('Rectangle',Y):-true : Y='DJRectangle'.
djGraphicsClassName('RoundRectangle',Y):-true : Y='DJRoundRectangle'.
djGraphicsClassName('Star',Y):-true : Y='DJStar'.
djGraphicsClassName('Triangle',Y):-true : Y='DJTriangle'.
djGraphicsClassName(X,Y):-true : Y=X.

isBaseClassObject(Object):-
    isBaseClassObject(Object,Type).

:-mode isBaseClassObject(+,?).
isBaseClassObject('Button'(ObjectNo,Component,Label),'Button').
isBaseClassObject('Checkbox'(ObjectNo,Component,Label,State,CheckboxGroup),'Checkbox').
isBaseClassObject('Choice'(ObjectNo,Component,Items,ItemCount,Selected),'Choice').
isBaseClassObject('Label'(ObjectNo,Component,Text,Alignment),'Label').
isBaseClassObject('List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected),'List').
isBaseClassObject('Scrollbar'(ObjectNo,Component,Orientation,Value,Minimum,Maximum),'Scrollbar').
isBaseClassObject('TextArea'(ObjectNo,Component,Text,Rows,Columns,MinimumSize,PreferredSize),'TextArea').
isBaseClassObject('TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize),'TextField').
isBaseClassObject('Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill),'Arc').
isBaseClassObject('Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill),'Circle').
isBaseClassObject('Line'(ObjectNo,Component,X1,Y1,X2,Y2),'Line').
isBaseClassObject('Oval'(ObjectNo,Component,Fill),'Oval').
isBaseClassObject('Polygon'(ObjectNo,Component,N,Xs,Ys,Fill),'Polygon').
isBaseClassObject('Square'(ObjectNo,Component,Fill),'Square').
isBaseClassObject('Rectangle'(ObjectNo,Component,Fill),'Rectangle').
isBaseClassObject('RoundRectangle'(ObjectNo,Component,ArcWidth,ArcHeight,Fill),'RoundRectangle').
isBaseClassObject('Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill),'Star').
isBaseClassObject('Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill),'Triangle').

%%%change isBaseClassObject, getBaseAttribute, and collectBaseAttributes when updated
createBaseClassInstance('Component',DVars,DVarsR,Component):-true :
    positionInsideScreen(X,Y),
    sizeInsideScreen(Width,Height),
    Bound=$bound(X,Y,Width,Height),
    Font = $font(FontName,FontSize,FontStyle),
    BFColor = $bf(Background,Foreground),
    Component='Component'(Bound,Font,BFColor,Visible),
    DVars=[rect(X,Y,Width,Height),bool(Visible),BFColor,Font|DVarsR],%Color is also ForgroundColor
    global_get(screenWidth,ScreenWidth),
    global_get(screenHeight,ScreenHeight),
    X+Width#=<ScreenWidth,
    Y+Height#=<ScreenHeight.

createBaseClassInstance('Button',DVars,DVarsR,Button):-true :
    nextInstanceNo(ObjectNo),
    Button='Button'(ObjectNo,Component,Label),
    DVars=['String'(Label)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('Checkbox',DVars,DVarsR,Checkbox):-true :
    nextInstanceNo(ObjectNo),
    Checkbox = 'Checkbox'(ObjectNo,Component,Label,State,CheckboxGroup),
    DVars=['String'(Label)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('Choice',DVars,DVarsR,Choice):-true :
    nextInstanceNo(ObjectNo),
    Choice = 'Choice'(ObjectNo,Component,Items,ItemCount,Selected),
    createBaseClassInstance('Component',DVars,DVarsR,Component).

createBaseClassInstance('List',DVars,DVarsR,List):-true :
    nextInstanceNo(ObjectNo),
    List = 'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected),
    createBaseClassInstance('Component',DVars,DVarsR,Component).

createBaseClassInstance('Scrollbar',DVars,DVarsR,Scrollbar):-true :
    nextInstanceNo(ObjectNo),
    Scrollbar = 'Scrollbar'(ObjectNo,Component,Orientation,Value,Minimum,Maximum),
    createBaseClassInstance('Component',DVars,DVarsR,Component).

createBaseClassInstance('TextArea',DVars,DVarsR,TextArea):-true :
    nextInstanceNo(ObjectNo),
    TextArea = 'TextArea'(ObjectNo,Component,Text,Rows,Columns,MinimumSize,PreferredSize),
    DVars=['String'(Text)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('TextField',DVars,DVarsR,TextField):-true :
    nextInstanceNo(ObjectNo),
    TextField = 'TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize),
    DVars=['String'(Text)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component),
    getBaseAttribute(height,Height,_,Component),
    Height#<50.
createBaseClassInstance('Label',DVars,DVarsR,Label):-true :
    nextInstanceNo(ObjectNo),
    Label = 'Label'(ObjectNo,Component,Text,Alignment),
    DVars=['String'(Text)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component),
    getBaseAttribute(height,Height,_,Component),
    Height#<50.
createBaseClassInstance('Arc',DVars,DVarsR,Arc):-true :
    nextInstanceNo(ObjectNo),
    Arc='Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill),
    positionInsideScreen(CenterX,CenterY),
    domain(StartAngle,0,360),
    domain(ArcAngle,0,360),
    DVars=[int(CenterX),int(CenterY),int(StartAngle),int(ArcAngle),bool(Fill)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component),
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(height,H,_,Component),
    W=H,
    2*CenterX #= 2*X+W,
    2*CenterY #= 2*Y+W.

createBaseClassInstance('Circle',DVars,DVarsR,Circle):-true :
    nextInstanceNo(ObjectNo),
    Circle='Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill),
    positionInsideScreen(CenterX,CenterY),
    DVars=[int(CenterX),int(CenterY),bool(Fill)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component),
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(height,H,_,Component),
    W=H,
    Diameter=W,
    2*CenterX #= 2*X+W,
    2*CenterY #= 2*Y+W.

createBaseClassInstance('Line',DVars,DVarsR,Line):-true :
    nextInstanceNo(ObjectNo),
    Line='Line'(ObjectNo,Component,X1,Y1,X2,Y2),
    DVars=[int(Width),int(Height),int(X1),int(Y1),int(X2),int(Y2),'Color'(Color)|DVarsR],
    positionInsideScreen(X1,Y1),
    positionInsideScreen(X2,Y2),
    createBaseClassInstance('Component',_,_,Component),
    getBaseAttribute(color,Color,_,Component),
    getBaseAttribute(x,MinX,_,Component),
    getBaseAttribute(y,MinY,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    minimumConstraint([X1,X2],MinX),
    minimumConstraint([Y1,Y2],MinY),
    positionInsideScreen(MaxX,MaxY),
    maximumConstraint([X1,X2],MaxX),
    maximumConstraint([Y1,Y2],MaxY),
    Width #= MaxX-MinX,
    Height #= MaxY-MinY.

createBaseClassInstance('Oval',DVars,DVarsR,Oval):-true :
    nextInstanceNo(ObjectNo),
    Oval='Oval'(ObjectNo,Component,Fill),
    DVars=[bool(Fill)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('Polygon',DVars,DVarsR,Polygon):-true :
    nextInstanceNo(ObjectNo),
    Polygon='Polygon'(ObjectNo,Component,N,Xs,Ys,Fill),
    DVars=[polygon(Polygon),bool(Fill)|DVars1],
    createDomainVar(N),
    createXYArraysWhenNIsFixed(N,Polygon),
    hashtableCreate(7,HashtableX),
    Xs=array(N,int,HashtableX),
    hashtableCreate(7,HashtableY),
    Ys=array(N,int,HashtableY),
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('Square',DVars,DVarsR,Square):-true :
    nextInstanceNo(ObjectNo),
    Square='Square'(ObjectNo,Component,Fill),
    DVars=[bool(Fill)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    Width=Height.

createBaseClassInstance('Rectangle',DVars,DVarsR,Rectangle):-true :
    nextInstanceNo(ObjectNo),
    Rectangle='Rectangle'(ObjectNo,Component,Fill),
    DVars=[bool(Fill)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('RoundRectangle',DVars,DVarsR,RoundRectangle):-true :
    nextInstanceNo(ObjectNo),
    RoundRectangle='RoundRectangle'(ObjectNo,Component,ArcWidth,ArcHeight,Fill),
    sizeInsideScreen(ArcWidth,ArcHeight),
    DVars=[bool(Fill),int(ArcWidth),int(ArcHeight)|DVars1],
    createBaseClassInstance('Component',DVars1,DVarsR,Component).

createBaseClassInstance('Star',DVars,DVarsR,Star):-true :
    nextInstanceNo(ObjectNo),
    Star='Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill),
    DVars=[rect(X,Y,Width,Width),int(CenterX),int(CenterY),'Color'(Color),bool(Fill)|DVarsR],
    positionInsideScreen(X0,Y0),
    positionInsideScreen(CenterX,CenterY),
    sizeInsideScreen(SmallDiameter,LargeDiameter),
    createBaseClassInstance('Component',_,_,Component),
    getBaseAttribute(color,Color,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    Width=Height,Width=LargeDiameter,
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    2*X #= 2*CenterX - LargeDiameter,
    2*Y #= 2*CenterY - LargeDiameter.
    

createBaseClassInstance('Triangle',DVars,DVarsR,Triangle):-true :
    nextInstanceNo(ObjectNo),
    Triangle='Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill),
    DVars=[int(X1),int(Y1),int(X2),int(Y2),int(X3),int(Y3),'Color'(Color),bool(Fill)|DVarsR],
    positionInsideScreen(X1,Y1),
    positionInsideScreen(X2,Y2),
    positionInsideScreen(X3,Y3),
    createBaseClassInstance('Component',_,_,Component),
    getBaseAttribute(color,Color,_,Component),
    getBaseAttribute(x,MinX,_,Component),
    getBaseAttribute(y,MinY,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    minimumConstraint([X1,X2,X3],MinX),
    minimumConstraint([Y1,Y2,Y3],MinY),
    positionInsideScreen(MaxX,MaxY),
    maximumConstraint([X1,X2,X3],MaxX),
    maximumConstraint([Y1,Y2,Y3],MaxY),
    Width #= MaxX-MinX,
    Height #= MaxY-MinY.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    bound<=Id :
    Attr=Bound,Type=bound.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    position<=Id,
    $bound(X,Y,Width,Height)<=Bound :
    Attr=$position(X,Y),Type=postion.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    x<=Id,
    $bound(X,Y,Width,Height)<=Bound :
    Attr=X,Type=int.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    y<=Id,
    $bound(X,Y,Width,Height)<=Bound :
    Attr=Y,Type=int.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    size<=Id,
    $bound(X,Y,Width,Height)<=Bound :
    Attr=$size(Width,Height),Type=size.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    width<=Id,
    $bound(X,Y,Width,Height)<=Bound :
    Attr=Width,Type=int.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    height<=Id,
    $bound(X,Y,Width,Height)<=Bound :
    Attr=Height,Type=int.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    background<=Id,
    $bf(Background,Foreground)<=BFColor :
    Attr=Background,Type='Color'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    foreground<=Id,
    $bf(Background,Foreground)<=BFColor :
    Attr=Foreground,Type='Color'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    twoColors<=Id :
    Attr=BFColor,Type='TwoColors'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    color<=Id,
    $bf(Background,Foreground)<=BFColor :
    Attr=Foreground,Type='Color'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    backgroundColor<=Id :
    $bf(Background,Foreground)<=BFColor :
    Attr=Background,Type='Color'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    visible<=Id :
    Attr=Visible,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    font<=Id :
    Attr=Font,Type=font.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    fontName<=Id,
    $font(FontName,FontSize,FontStyle)<=Font :
    Attr=FontName,Type='String'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    fontSize<=Id,
    $font(FontName,FontSize,FontStyle)<=Font :
    Attr=FontSize,Type=int.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    fontStyle<=Id,
    $font(FontName,FontSize,FontStyle)<=Font :
    Attr=FontStyle,Type='String'.
getBaseAttribute(Id,Attr,Type,'Component'(Bound,Font,BFColor,Visible)):-
    true :
    runError(['Attribute ',Id,' is used but not defined']).

getBaseAttribute(Id,Attr,Type,'Button'(ObjectNo,Component,Label)):-
    label<=Id :
    Attr=Label,Type='String'.
getBaseAttribute(Id,Attr,Type,'Button'(ObjectNo,Component,Label)):-
    text<=Id :
    Attr=Label,Type='String'.
getBaseAttribute(Id,Attr,Type,'Checkbox'(ObjectNo,Component,Label,State,CheckboxGroup)):-
    label<=Id :
    Attr=Label,Type='String'.
getBaseAttribute(Id,Attr,Type,'Checkbox'(ObjectNo,Component,Label,State,CheckboxGroup)):-
    state<=Id :
    Attr=State,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Checkbox'(ObjectNo,Component,Label,State,CheckboxGroup)):-
    checkboxGroup<=Id :
    Attr=CheckboxGroup,Type='String'.
getBaseAttribute(Id,Attr,Type,'Choice'(ObjectNo,Component,Items,ItemCount,Selected)):-
    items <= Id :
    Attr=Items,Type=list.
getBaseAttribute(Id,Attr,Type,'Choice'(ObjectNo,Component,Items,ItemCount,Selected)):-
    itemCount <= Id :
    Attr=ItemCount,Type=int.
getBaseAttribute(Id,Attr,Type,'Choice'(ObjectNo,Component,Items,ItemCount,Selected)):-
    selected <= Id :
    Attr=Selected,Type='String'.
getBaseAttribute(Id,Attr,Type,'Label'(ObjectNo,Component,Text,Alignment)):-
    text<=Id :
    Attr=Text,Type='String'.
getBaseAttribute(Id,Attr,Type,'Label'(ObjectNo,Component,Text,Alignment)):-
    alignment<=Id :
    Attr=Alignment,Type=int.
getBaseAttribute(Id,Attr,Type,'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected)):-
    items<=Id :
    Attr=Items,Type=list.
getBaseAttribute(Id,Attr,Type,'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected)):-
    itemCount<=Id :
    Attr=ItemCount,Type=int.
getBaseAttribute(Id,Attr,Type,'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected)):-
    rows<=Id :
    Attr=Rows,Type=int.
getBaseAttribute(Id,Attr,Type,'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected)):-
    minimumSize<=Id :
    Attr=MinimumSize,Type=size.
getBaseAttribute(Id,Attr,Type,'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected)):-
    preferredSize<=Id :
    Attr=PreferredSize,Type=size.
getBaseAttribute(Id,Attr,Type,'List'(ObjectNo,Component,Items,ItemCount,Rows,MinimumSize,PreferredSize,Selected)):-
    selected<=Id :
    Attr=Selected,Type='String'.
getBaseAttribute(Id,Attr,Type,'Scrollbar'(ObjectNo,Component,Orientation,Value,Minimum,Maximum)):-
    orientation<=Id :
    Attr=Orientation,Type='String'.
getBaseAttribute(Id,Attr,Type,'Scrollbar'(ObjectNo,Component,Orientation,Value,Minimum,Maximum)):-
    value<=Id :
    Attr=Value,Type=int.
getBaseAttribute(Id,Attr,Type,'Scrollbar'(ObjectNo,Component,Orientation,Value,Minimum,Maximum)):-
    minimum<=Id :
    Attr=Minimum,Type=int.
getBaseAttribute(Id,Attr,Type,'Scrollbar'(ObjectNo,Component,Orientation,Value,Minimum,Maximum)):-
    maximum<=Id :
    Attr=Maximum,Type=int.
getBaseAttribute(Id,Attr,Type,'TextArea'(ObjectNo,TextComponent,Text,Rows,Columns,MinimumSize,PreferredSize)):-
    text<=Id :
    Attr=Text,Type='String'.
getBaseAttribute(Id,Attr,Type,'TextArea'(ObjectNo,TextComponent,Text,Rows,Columns,MinimumSize,PreferredSize)):-
    rows<=Id :
    Attr=Rows,Type=int.
getBaseAttribute(Id,Attr,Type,'TextArea'(ObjectNo,TextComponent,Text,Rows,Columns,MinimumSize,PreferredSize)):-
    columns<=Id :
    Attr=Columns,Type=int.
getBaseAttribute(Id,Attr,Type,'TextArea'(ObjectNo,Component,Text,Rows,Columns,MinimumSize,PreferredSize)):-
    minimumSize<=Id :
    Attr=MinimumSize,Type=size.
getBaseAttribute(Id,Attr,Type,'TextArea'(ObjectNo,Component,Text,Rows,Columns,MinimumSize,PreferredSize)):-
    preferredSize<=Id :
    Attr=PreferredSize,Type=size.

getBaseAttribute(Id,Attr,Type,'TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize)):-
    text<=Id :
    Attr=Text,Type='String'.
getBaseAttribute(Id,Attr,Type,'TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize)):-
    columns<=Id :
    Attr=Columns,Type=int.
getBaseAttribute(Id,Attr,Type,'TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize)):-
    minimumSize<=Id :
    Attr=MinimumSize,Type=size.
getBaseAttribute(Id,Attr,Type,'TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize)):-
    preferredSize<=Id :
    Attr=PreferredSize,Type=size.
getBaseAttribute(Id,Attr,Type,'Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill)):-
    centerX<=Id :
    Attr=CenterX,Type=int.
getBaseAttribute(Id,Attr,Type,'Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill)):-
    centerY<=Id :
    Attr=CenterY,Type=int.
getBaseAttribute(Id,Attr,Type,'Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill)):-
    startAngle<=Id :
    Attr=StartAngle,Type=int.
getBaseAttribute(Id,Attr,Type,'Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill)):-
    arcAngle<=Id :
    Attr=ArcAngle,Type=int.
getBaseAttribute(Id,Attr,Type,'Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill)):-
    centerX<=Id :
    Attr=CenterX,Type=int.
getBaseAttribute(Id,Attr,Type,'Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill)):-
    centerY<=Id :
    Attr=CenterY,Type=int.
getBaseAttribute(Id,Attr,Type,'Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill)):-
    diameter<=Id :
    Attr=Diameter,Type=int.
getBaseAttribute(Id,Attr,Type,'Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Line'(ObjectNo,Component,X1,Y1,X2,Y2)):-
    x1<=Id :
    Attr=X1,Type=int.
getBaseAttribute(Id,Attr,Type,'Line'(ObjectNo,Component,X1,Y1,X2,Y2)):-
    x2<=Id :
    Attr=X2,Type=int.
getBaseAttribute(Id,Attr,Type,'Line'(ObjectNo,Component,X1,Y1,X2,Y2)):-
    y1<=Id :
    Attr=Y1,Type=int.
getBaseAttribute(Id,Attr,Type,'Line'(ObjectNo,Component,X1,Y1,X2,Y2)):-
    y2<=Id :
    Attr=Y2,Type=int.
getBaseAttribute(Id,Attr,Type,'Oval'(ObjectNo,Component,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Polygon'(ObjectNo,Component,N,Xs,Ys,Fill)):-
    n<=Id :
    Attr=N,Type=int.
getBaseAttribute(Id,Attr,Type,'Polygon'(ObjectNo,Component,N,Xs,Ys,Fill)):-
    xs<=Id :
    (var(N)->cmpError(['xs cannot be accessed before n is given a value in Polygon']);true),
    Attr=Xs,Type=array(N,int).
getBaseAttribute(Id,Attr,Type,'Polygon'(ObjectNo,Component,N,Xs,Ys,Fill)):-
    ys<=Id :
    (var(N)->cmpError(['ys cannot be accessed before n is given a value in Polygon']);true),
    Attr=Ys,Type=array(N,int).
getBaseAttribute(Id,Attr,Type,'Polygon'(ObjectNo,Component,N,Xs,Ys,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Square'(ObjectNo,Component,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Rectangle'(ObjectNo,Component,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'RoundRectangle'(ObjectNo,Component,ArcWidth,ArcHeight,Fill)):-
    arcWidth <= Id :
    Attr=ArcWidth,Type=int.
getBaseAttribute(Id,Attr,Type,'RoundRectangle'(ObjectNo,Component,ArcWidth,ArcHeight,Fill)):-
    arcHeight <= Id :
    Attr=ArcHeight,Type=int.
getBaseAttribute(Id,Attr,Type,'RoundRectangle'(ObjectNo,Component,ArcWidth,ArcHeight,Fill)):-
    fill <= Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    x1<=Id :
    Attr=X1,Type=int.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    x2<=Id :
    Attr=X2,Type=int.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    x3<=Id :
    Attr=X3,Type=int.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    y1<=Id :
    Attr=Y1,Type=int.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    y2<=Id :
    Attr=Y2,Type=int.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    y3<=Id :
    Attr=Y3,Type=int.
getBaseAttribute(Id,Attr,Type,'Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    n<=Id :
    Attr=N,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    centerX<=Id :
    Attr=CenterX,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    centerY<=Id :
    Attr=CenterY,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    x0<=Id :
    Attr=X0,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    y0<=Id :
    Attr=Y0,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    angle0<=Id :
    Attr=Angle0,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    largeDiameter<=Id :
    Attr=LargeDiameter,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    smallDiameter<=Id :
    Attr=SmallDiameter,Type=int.
getBaseAttribute(Id,Attr,Type,'Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    fill<=Id :
    Attr=Fill,Type=boolean.
getBaseAttribute(Id,Attr,Type,Object):-
    true :
    arg(2,Object,Component),
    getBaseAttribute(Id,Attr,Type,Component).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
collectComponentAttributes(Args,TAPairs):-
    Args=[x,y,width,height,twoColors,font,visible],
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),
	     pair('TwoColors',twoColors),pair('Font',font),pair(boolean,visible)].

collectBaseAttributes('Button',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].
collectBaseAttributes('Checkbox',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].
collectBaseAttributes('Choice',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].
collectBaseAttributes('List',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].
collectBaseAttributes('Scrollbar',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].
collectBaseAttributes('TextArea',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].
collectBaseAttributes('TextField',Args,TAPairs):-
    true :
    collectComponentAttributes(Args1,TAPairs1),
    TAPairs=[pair('String',text)|TAPairs1],
    Args=[text|Args1].

collectBaseAttributes('Label',Args,TAPairs):-
    true :
    TAPairs=[pair('String',text),pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair('Font',font),pair(boolean,visible)],
    Args=[text,x,y,width,height,color,font,visible].
collectBaseAttributes('Arc',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair(boolean,fill),
	     pair(int,startAngle),pair(int,arcAngle),pair(boolean,visible)],
    Args=[x,y,width,height,color,fill,startAngle,arcAngle,visible].
collectBaseAttributes('Circle',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair('Color',color),pair(boolean,fill),pair(boolean,visible)],
    Args=[x,y,width,color,fill,visible].
collectBaseAttributes('Line',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x1),pair(int,y1),pair(int,x2),pair(int,y2),pair('Color',color),pair(boolean,visible)],
    Args=[x1,y1,x2,y2,color,visible].
collectBaseAttributes('Oval',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair(boolean,fill),pair(boolean,visible)],
    Args=[x,y,width,height,color,fill,visible].
collectBaseAttributes('Polygon',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair(boolean,fill),pair(boolean,visible),pair(int,n)],
    Args=[x,y,width,height,color,fill,visible,n].
collectBaseAttributes('Square',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair(boolean,fill),pair(boolean,visible)],
    Args=[x,y,width,height,color,fill,visible].
collectBaseAttributes('Rectangle',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair(boolean,fill),pair(boolean,visible)],
    Args=[x,y,width,height,color,fill,visible].
collectBaseAttributes('RoundRectangle',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x),pair(int,y),pair(int,width),pair(int,height),pair('Color',color),pair(boolean,fill),pair(int,arcWidth),pair(int,arcHeight),pair(boolean,visible)],
    Args=[x,y,width,height,color,fill,arcWidth,arcHeight,visible].
collectBaseAttributes('Triangle',Args,TAPairs):-
    true :
    TAPairs=[pair(int,x1),pair(int,y1),pair(int,x2),pair(int,y2),pair(int,x3),pair(int,y3),pair('Color',color),pair(boolean,fill),pair(boolean,visible)],
    Args=[x1,y1,x2,y2,x3,y3,color,fill,visible].
collectBaseAttributes('Star',Args,TAPairs):-
    true :
    TAPairs=[pair(int,n),pair(int,centerX),pair(int,centerY),pair(int,x0),pair(int,y0),pair(angle0),pair(int,largeDiameter),pair(int,smallDiameter),pair('Color',color),pair(boolean,fill),pair(boolean,visible)],
    Args=[n,centerX,centerY,x0,y0,angle0,largeDiameter,smallDiameter,color,fill,visible].

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generateDrawSentencesBase(Component,DSentences,DSentencesR):- 
    getBaseAttribute(visible,Visible,_,Component),
    Visible==false,!,
    DSentences=DSentencesR.
generateDrawSentencesBase(Component,DSentences,DSentencesR):- 
    true :
    DSentences=[Component|DSentencesR].

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
generateAddSentencesBase(Component,ASentences,ASentencesR):-
    getBaseAttribute(visible,Visible,_,Component),
    Visible==false,!,
    ASentences=ASentencesR.
generateAddSentencesBase(Component,ASentences,ASentencesR):-
    true :
    ASentences=[Component|ASentencesR].
/*
generateAddSentencesBase('Label'(ObjectNo,Component,Label,Alignment),
			 ASentences,ASentencesR):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    getBaseAttribute(color,Color,_,Component),
    ASentences=[addLabel(Label,X,Y,Width,Height,Color)|ASentencesR].
generateAddSentencesBase('Button'(ObjectNo,Component,Label),
			 ASentences,ASentencesR):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    ASentences=[addButton(Label,X,Y,Width,Height)|ASentencesR].
generateAddSentencesBase('TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize),
			 ASentences,ASentencesR):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    ASentences=[addTextField(Text,Columns,X,Y,Width,Height)|ASentencesR].
generateAddSentencesBase('TextArea'(ObjectNo,Component,Text,Rows,Columns,MinimumSize,PreferredSize),
			 ASentences,ASentencesR):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    ASentences=[addTextArea(Text,Rows,Columns,X,Y,Width,Height)|ASentencesR].
generateAddSentencesBase(_,ASentences,ASentencesR):-
    true :
    ASentences=ASentencesR.
*/    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-mode checkBaseCompAttr(+,+).
checkBaseCompAttr(Type,Identifier):-
    checkComponentCompAttr('Component',Identifier),!.
checkBaseCompAttr(Type,Identifier):-
    checkComponentCompAttr(Type,Identifier).

:-mode checkComponentCompAttr(+,+).
checkComponentCompAttr('Component',position).
checkComponentCompAttr('Component',x).
checkComponentCompAttr('Component',y).
checkComponentCompAttr('Component',size).
checkComponentCompAttr('Component',width).
checkComponentCompAttr('Component',height).
checkComponentCompAttr('Component',backgroundColor).
checkComponentCompAttr('Component',forgroundColor).
checkComponentCompAttr('Component',color).
checkComponentCompAttr('Component',visible).
checkComponentCompAttr('Component',font).
checkComponentCompAttr('Component',fontName).
checkComponentCompAttr('Component',fontSize).
checkComponentCompAttr('Component',fontStyle).
checkComponentCompAttr('Button',label).
checkComponentCompAttr('Button',text).
checkComponentCompAttr('Checkbox',label).
checkComponentCompAttr('Checkbox',state).
checkComponentCompAttr('Checkbox',checkboxGroup).
checkComponentCompAttr('Choice',items).
checkComponentCompAttr('Choice',itemCount).
checkComponentCompAttr('Choice',selected).
checkComponentCompAttr('Label',text).
checkComponentCompAttr('Label',alignment).
checkComponentCompAttr('List',items).
checkComponentCompAttr('List',itemCount).
checkComponentCompAttr('List',rows).
checkComponentCompAttr('List',minimumSize).
checkComponentCompAttr('List',preferredSize).
checkComponentCompAttr('List',selected).
checkComponentCompAttr('Scrollbar',orientation).
checkComponentCompAttr('Scrollbar',value).
checkComponentCompAttr('Scrollbar',minimum).
checkComponentCompAttr('Scrollbar',maximum).
checkComponentCompAttr('TextArea',text).
checkComponentCompAttr('TextArea',rows).
checkComponentCompAttr('TextArea',columns).
checkComponentCompAttr('TextArea',minimumSize).
checkComponentCompAttr('TextArea',preferredSize).
checkComponentCompAttr('TextField',text).
checkComponentCompAttr('TextField',columns).
checkComponentCompAttr('TextField',minimumSize).
checkComponentCompAttr('TextField',preferredSize).
checkComponentCompAttr('Arc',centerX).
checkComponentCompAttr('Arc',centerY).
checkComponentCompAttr('Arc',startAngle).
checkComponentCompAttr('Arc',arcAngle).
checkComponentCompAttr('Arc',fill).
checkComponentCompAttr('Circle',centerX).
checkComponentCompAttr('Circle',centerY).
checkComponentCompAttr('Circle',diameter).
checkComponentCompAttr('Circle',fill).
checkComponentCompAttr('Line',x1).
checkComponentCompAttr('Line',x2).
checkComponentCompAttr('Line',y1).
checkComponentCompAttr('Line',y2).
checkComponentCompAttr('Oval',fill).
checkComponentCompAttr('Polygon',n).
checkComponentCompAttr('Polygon',xs).
checkComponentCompAttr('Polygon',ys).
checkComponentCompAttr('Polygon',fill).
checkComponentCompAttr('Rectangle',fill).
checkComponentCompAttr('Square',fill).
checkComponentCompAttr('RoundRectangle',arcWidth).
checkComponentCompAttr('RoundRectangle',arcHeight).
checkComponentCompAttr('RoundRectangle',fill).
checkComponentCompAttr('Triangle',x1).
checkComponentCompAttr('Triangle',x2).
checkComponentCompAttr('Triangle',x3).
checkComponentCompAttr('Triangle',y1).
checkComponentCompAttr('Triangle',y2).
checkComponentCompAttr('Triangle',y3).
checkComponentCompAttr('Triangle',fill).
checkComponentCompAttr('Star',n).
checkComponentCompAttr('Star',centerX).
checkComponentCompAttr('Star',centerY).
checkComponentCompAttr('Star',x0).
checkComponentCompAttr('Star',y0).
checkComponentCompAttr('Star',angle0).
checkComponentCompAttr('Star',largeDiameter).
checkComponentCompAttr('Star',smallDiameter).
checkComponentCompAttr('Star',fill).

:-mode checkTypeColor(+).
checkTypeColor(black).
checkTypeColor(blue).
checkTypeColor(cyan).
checkTypeColor(darkGray).
checkTypeColor(gray).
checkTypeColor(green).
checkTypeColor(lightGray).
checkTypeColor(magenta).
checkTypeColor(orange).
checkTypeColor(pink).
checkTypeColor(red).
checkTypeColor(white).
checkTypeColor(yellow).


    
