// Copyright (C) 1996-1998 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
//

/*
	Tag
*/
import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;


// ====================================================
//	Tag
public class Tag extends Object {
	public boolean display = false;
	public String variable = null;
	public boolean group = false;
	public int function = -1;
	public String condition = null;
	public String constant = null;
	public boolean different = false;
	public String havingCondition = null;
	public String havingConstant = null;

	public String body;
	public Attribute attribute;

	public Tag() {
		super();
	}

	public Tag(boolean b1, String s, Attribute a) {
		setTag(b1, s, a);
	}

	public void setTag(boolean b1, String s, Attribute a) {
		display = b1;
		body = s;
		attribute = a;
		if(!s.equals("")) {
			parseBody(s);
		}
	}

	// parse body
	//
	// _constant
	// > constant
	// group.count.> constatnt
	public void parseBody(String in) {
		StreamTokenizer st;
		String s;
		int i;

		Reader r = new StringReader(in);
		st = new StreamTokenizer(r);
		try {
			st.slashSlashComments(false);
			st.slashStarComments(false);
			st.quoteChar('"');

			while((i = st.nextToken()) != st.TT_EOF) {
				switch(i) {
				case '_':	// constant
					pbVariable(st);
					break;
				case StreamTokenizer.TT_NUMBER:
					st.pushBack();
					pbConstant(st);
					break;
				case '<':
					pbCondition(st, "<");
					break;
				case '=':
					pbCondition(st, "=");
					break;
				case '>':
					pbCondition(st, ">");
					break;

				case StreamTokenizer.TT_WORD:
					pbWord(st);
					break;
				default:	// $BL5;kL5;k(B
					break;
				}
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
		}

	}

	// _[!]varname
	private void pbVariable(StreamTokenizer st) {
		int i;

		try {
			if((i = st.nextToken()) == '!') {
				// $B!V(B!$B!W$O:9=89g%U%i%0(B
				different = true;
				i = st.nextToken();
			}
			switch(i) {
			case StreamTokenizer.TT_NUMBER:
				System.out.println("error");
				break;
			default:	// word or string
				variable = st.sval;
				break;
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
		}
	}

	private void pbConstant(StreamTokenizer st) {
		int i;

		try {
			switch(i = st.nextToken()) {
			case StreamTokenizer.TT_NUMBER:
				i = (new Double(st.nval)).intValue();
				constant = "" + i;	// st.nval;
				break;
			default:	// word or string
				constant = "\"" + st.sval + "\"";
				break;
			}
			if(condition == null) {
				condition = "=";
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
		}

		if(condition == null) {
			condition = "=";
		}

	}

	// "> const"
	private void pbCondition(StreamTokenizer st, String cond) {
		int i;

			
		condition = cond;

		// $B<!$O(Bconstant$B$N$O$:!#(B
		if(constant != null) {
			// $B$9$G$K$"$k$N$O$X$s$@!#(B
			System.out.println("constant is invalid position");
		}

		// >= <=$BBP1~!#(B
		if(condition.equals(">") || condition.equals("<")) {
		try {
			i = st.nextToken();
			if(i == '=') {
				condition += "=";
			} else {
				st.pushBack();
			}
			} catch(IOException e) {
				System.out.println("IOException " + e);
			}
		}

		pbConstant(st);
	}	

	// group [having cond]
	private void pbGroup(StreamTokenizer st) {
		group = true;
	}


	private void pbHaving(StreamTokenizer st) {
		int i;

		try {
			switch(i = st.nextToken()) {
			case StreamTokenizer.TT_EOF:
				return;
			case '<':
				pbHavingCondition(st, "<");
				break;
			case '=':
				pbHavingCondition(st, "=");
				break;
			case '>':
				pbHavingCondition(st, ">");
				break;
			case StreamTokenizer.TT_NUMBER:
				st.pushBack();
				pbHavingCondition(st, "=");
				break;
			default:
				st.pushBack();
				pbHavingCondition(st, "=");
				break;
			}
			
		} catch(IOException e) {
			System.out.println("IOException " + e);
		}
	}	

	// "> const"
	private void pbHavingCondition(StreamTokenizer st, String cond) {
		int i;

		havingCondition = cond;

		// $B<!$O(Bconstant$B$N$O$:!#(B
		if(havingConstant != null) {
			// $B$9$G$K$"$k$N$O$X$s$@!#(B
			System.out.println("havingConstant is invalid position");
		}

		// >= <=$BBP1~!#(B
		if(cond.equals(">") || cond.equals("<")) {
			try {
				i = st.nextToken();
				if(i == '=') {
					havingCondition += "=";
				} else {
					st.pushBack();
				}
			} catch(IOException e) {
				System.out.println("IOException " + e);
			}
		}

		pbHavingConstant(st);
	}	

	private void pbHavingConstant(StreamTokenizer st) {
		int i;

		try {
			switch(i = st.nextToken()) {
			case StreamTokenizer.TT_NUMBER:
				i = (new Double(st.nval)).intValue();
				havingConstant = "" + i;	// st.nval;
				break;
			default:	// word or string
				havingConstant = "\"" + st.sval + "\"";
				break;
			}
			if(havingCondition == null) {
				havingCondition = "=";
			}
		} catch(IOException e) {
			System.out.println("IOException " + e);
		}

		if(havingCondition == null) {
			havingCondition = "=";
		}

	}

	private void pbWord(StreamTokenizer st) {
		String s;

		s = st.sval;
		if(s.equals("group")) {
			pbGroup(st);
		} else if(s.equals("having")) {
			pbHaving(st);
		} else if(s.equals("count")) {
			function = Const.fnCount;
		} else if(s.equals("avg")) {
			function = Const.fnAverage;
		} else if(s.equals("max")) {
			function = Const.fnMax;
		} else if(s.equals("min")) {
			function = Const.fnMin;
		} else if(s.equals("sum")) {
			function = Const.fnSum;
		} else {
			st.pushBack();
			pbConstant(st);
		}
	}		

	// ==========================================================
	// Attribute$B$N(Bserno$B=g$K(Bname$B$r(BVector$B$XF~$l$k!#(B
	// $B$*$=$m$7$/Hs8zN(E*$@$1$I$5$7$F(Belement$B$bB?$/$J$$$7(B($B8@$$Lu(B)$B!#(B
	public Tag[] makeTagArray(AttributeTable at, QbeSettingPanel q) {
		Enumeration en;
		Vector v;
		int i, max;
		Attribute a;
		String s;
		Tag t;
		Tag ta[];

		v = new Vector();
		max = at.size();
		for(i = 0; i < max; i++) {
			en = at.keys();
			while(en.hasMoreElements()) {
				s = (String)en.nextElement();
				a = at.get(s);
				if(a.getSerno() != (i + 1)) {
					continue;
				}
				t = new Tag(q.getChecked(i), q.getItem(i), a);
				v.addElement(t);
				break;
			}
		}

		ta = new Tag[v.size()];
		en = v.elements();
		for(i = 0; en.hasMoreElements(); i++) {
			ta[i] = (Tag)en.nextElement();
		}

		return ta;
	}
}	// Tag

/* Takashi Ishikawa / tishi@jaist.ac.jp */

