// Copyright (C) 1996-1998 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
//

//
// QBE$BE*$K@_Dj$9$k$?$a$NI=$rI=<($9$k(B

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class QbePanel extends ScrollableTable {
	boolean bChecked[];
	int currentItem;
	boolean canSelect;	// can yellow/red toggle

	// *************
	//	$B=i4|2=(B
	// *************
	public QbePanel() {
		;
	}	// QbeTable

	public QbePanel(Vector v, boolean b) {
		init(v, b);
	}	// QbeTable

	// ================================================
	public void init(Vector v, boolean b) {
		canSelect = b;
		createLayout();
		setData(v);
	}

	// ================================================
	public void createLayout() {
		this.setLayout(new BorderLayout(0, 0));
		this.add("South", hbar);

		// $B%9%/%m!<%k%P!<@_Dj(B
		setScrollbar(0, 0, rows, columns);
	}

	// *****************************
	//	$BI=<($9$k%G!<%?$r<u$1<h$k(B
	// *****************************
	public void setData(Vector v) {
		int i;
		String asTuple[];

		if(v == null || v.size() == 0) {
			// $B$J$K$b$O$$$C$F$J$$$H$-$O!"$=$N$^$^(Breturn$B!#(B
			rows = 2;	// $B>l=j3NJ]$N$?$a(B
			columns = 0;
			return;
		}

		vData = v;

		// rows$B$H(Bcolumns$B$r7W;;$9$k(B
		rows = vData.size();	// $B$?$V$s(B2$B$G8GDj!#(B
		asTuple = (String [])vData.firstElement();
		columns = asTuple.length;
		bChecked = new boolean[columns];
		for(i = 0; i < columns; i++) {
			bChecked[i] = true;
		}

		// $B%9%/%m!<%k%P!<:F@_Dj(B	
		setScrollbar(0, 0, rows, columns);
		
		// $B:FIA2h(B
		//printComponents(getGraphics());

	}

	// ================================================
	// $B$Z$$$s$H(B
	public synchronized void paint(Graphics og) {
		Graphics g;
		Dimension d;
		int scWidth, scHeight;
		Insets is;

		// $B$=$l$>$l$NIA2hNN0hJ,$K(Bgraphics$B$r8BDj$5$;$k!#(B
		// inset$B$b9MN8$7$J$$$H$^$:$$!#$1$I!"$7$F$J$$!#(B
		is = getInsets();
		d = vbar.getSize();
		scWidth = d.width;
		d = hbar.getSize();
		scHeight = d.height;

		d = getSize();

		og.setColor(getBackground());
		og.draw3DRect(2, 2, d.width - 4, d.height - 4, false);

		d.height -= scHeight;

//		g = og.create(0, 0, d.width, d.height);
		g = og.create(is.right, is.top,
			d.width - is.right - is.left,
			d.height - is.top - is.bottom);
		paintTable(g);
		g.dispose();

	}

	// =============================================
	// $B%^!<%8%s$OMW$k$h$J!<!#(B
	public Insets getInsets() {
		return new Insets(0, 0, 0, 0);
	}


	// =============================================
	public void drawItem(Graphics g, int i, int j, int cx, int cy, String s) {
		if(s == null) {
			// $B$^$"!"(Bnull$B$J$H$-$b$"$k$5!#(B
			return;
		}

		if(i == 0) {
			// $B0l9TL\(B
			if(!canSelect) {
				// yellow/red toggle disabled
				g.setColor(Color.blue);
			} else if(bChecked[j]) {
				// display
				g.setColor(Color.yellow);
			} else {
				// ommit
				g.setColor(Color.red);
			}
		} else {
			g.setColor(Color.red);
		}
		g.drawString(s, cx, cy);
	}

	// =============================================
	public void setBChecked(int i, boolean b) {
		bChecked[i] = b;
	}

	// =============================================
	//	$B%Q%M%k$N?d>)%5%$%:(B
	public Dimension getPreferredSize() {
		Dimension d = hbar.getSize();
		Insets is;

		// $B$=$l$>$l$NIA2hNN0hJ,$K(Bgraphics$B$r8BDj$5$;$k!#(B
		// inset$B$b9MN8$7$J$$$H$^$:$$!#$1$I!"$7$F$J$$!#(B
		is = getInsets();
		if(d.height == 0) {
			d.height = Const.hLineWidth + Const.cellHeight;
		}
		d.height += Const.hLineWidth; // + Const.cellHeight;
		d.height += rows * Const.cellHeight;
		d.width = 500 + is.right + is.left;

		return new Dimension(d.width, d.height);
	}

	// =============================================
	//	$B%Q%M%k$N:G>.%5%$%:(B
	public Dimension getMinimumSize() {
		Dimension d = hbar.getSize();
		Insets is;

		// $B$=$l$>$l$NIA2hNN0hJ,$K(Bgraphics$B$r8BDj$5$;$k!#(B
		// inset$B$b9MN8$7$J$$$H$^$:$$!#$1$I!"$7$F$J$$!#(B
		is = getInsets();
		if(d.height == 0) {
			d.height = Const.hLineWidth + Const.cellHeight;
		}
		d.height += Const.hLineWidth; // + Const.cellHeight;
		d.height += rows * Const.cellHeight;
		d.width = 100 + is.right + is.left;

		return new Dimension(d.width, d.height);
	}

	// ============================================
	public boolean handleEvent(Event e) {
		boolean b;

		if(super.handleEvent(e)) {
			return true;
		}

		if(e.id == e.MOUSE_DOWN) {
			if(e.y < Const.cellHeight) {
				// $B$&$($N$@$s(B
				handleEventUpper(e);
			} else {
				// $B$7$?$N$@$s(B
				handleEventLower(e);
				return super.handleEvent(e);
				// $B$5$i$K(Bevent$B=hM}$r$9$k!#(B
			}

			return true;
		}

		return super.handleEvent(e);
	}

	// $B$&$($N$@$s$N(Bevent$B=hM}(B
	public boolean handleEventUpper(Event e) {
		int px;

		px = (e.x + offsetX - Const.hLineWidth) / Const.cellWidth;
		bChecked[px] = !bChecked[px];
		update(getGraphics());

		return true;
	}

	// $B$7$?$N$@$s$N(Bevent$B=hM}(B
	public boolean handleEventLower(Event e) {
		int px;

		px = (e.x + offsetX - Const.hLineWidth) / Const.cellWidth;
		if(px >= bChecked.length) {	// length$B$O(B1$BBg$-$$(B
			px = bChecked.length - 1;
		}
		currentItem = px;

		return false;
	}

	public String getCurrentName() {
		String as[];

		as = (String[])vData.elementAt(0);
		return as[currentItem];
	}

	public String getCurrentItem() {
		String as[];

		as = (String[])vData.elementAt(1);
		return as[currentItem];
	}

	public void setCurrentItem(String s) {
		String as[];

		as = (String[])vData.elementAt(1);
		as[currentItem] = s;

		update(getGraphics());
	}		

	public void setItem(String item, String s) {
		String as[];
		int i;

		as = (String[])vData.elementAt(1);
		for(i = 0; i < as.length; i++) {
			if(s.equals(item)) {
				as[currentItem] = s;
				break;
			}
		}

		update(getGraphics());
	}		

			
	// ============================================
	// $B3F<o(Breference
	public boolean[] getChecked() {
		return bChecked;
	}

	public boolean getChecked(int i) {
		return bChecked[i];
	}

	public String getItem(int i) {
		return ((String [])vData.elementAt(1))[i];
	}

	public String[] getItems() {
		return (String [])vData.elementAt(1);
	}

}	// end of QbePanel


/* Takashi Ishikawa / tishi@jaist.ac.jp */

