// Copyright (C) 1996-1998 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
//

//
// GroupTable
//
// $B$H$j$"$($:!"(BAttribute$B$r$9$Y$FG<$a$k(Bobject$B$r:n$k!#(B
// $B$"$H(Bcell$B$NFs<!85G[Ns$K$J$k(BVector$B$b$D$/$i$J$$$H$J!<!#(B

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

// ===========================================
//
//	GroupTable extends Hashtable:
//		groupname(key)
//		AttributeTable extends Hashtable:
//			group
//			Attribute:... elements
//				name
//				serno
//				type
//				columns
//
public class GroupTable extends Hashtable {

	public void GroupTable() {
		clear();
	}

	public void GroupTable(Vector v) {
		clear();
		addGroup(v);
	}

	// ===============================================
	// $B0z$-?t$NCM$G(BAttributeTable$B$r2C$($F$$$/!#(B
	public void addGroup(Vector v) {
		int i, max;
		String as[];

		max = v.size();
		for(i = 0; i < max; i++) {
			as = (String [])v.elementAt(i);
			this.addGroup(as);
		}

		return;
	}

	// ===============================================
	// $B0z$-?t$NCM$G(BAttributeTable$B$r2C$($F$$$/!#(B
	public void addGroup(String as[]) {
		if(as.length != 5) {
			;	// $B%(%i!<$@$M$(!#(B
		}

		addGroup(as[0], as[1], as[2], as[3], as[4]);
	}

	public synchronized void addGroup(String g, String n, String s, String t, String c) {
		AttributeTable al;	// it extends Hashtable
/*
		System.out.print("group=" + g);
		System.out.print(",name=" + n);
		System.out.print(",serno=" + s);
		System.out.print(",type=" + t);
		System.out.print(",columns=" + c);
		System.out.print("\n");
		System.out.flush();
*/
		if((al = (AttributeTable)get(g)) == null) {
			// $B8+$D$+$i$J$+$C$?$N$G?7$7$/:n$k!#(B
			al = new AttributeTable(g);
			al.putAttribute(n, s, t, c);
			put(g, al);
		} else {
			// $B$"$C$?$N$GDI2C$9$k!#(B
			al.putAttribute(n, s, t, c);
		}
	}	// addGroup

	// groupName$B$,(Bg$B$N(BAttributeTable$B$r<hF@$9$k!#(B
	public AttributeTable get(String g) {
		return (AttributeTable)super.get(g);
	}

}	// public class GroupTable

/* Takashi Ishikawa / tishi@jaist.ac.jp */
