// Copyright (C) 1996-1998 by Haruo Yokota, 
//	Japan Advanced Inst. of Sci. and Tech.,
//	1-1 Asahidai, Tatsunokuchi, Ishikawa 923-1292, Japan.
//

//
// $@I=:n@.(BPanel

import java.awt.Graphics;
import java.awt.*;
import java.applet.Applet;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;

public class CreatePanel extends Panel {
	Choice choice;
	TextField tableName;
	AttributePanel ap[];

	CreatePanel() {
		addComponents(10);
	}

	CreatePanel(int max) {
		addComponents(max);
	}

	private void addComponents(int max) {
		int i;
		Panel p;

		setLayout(new VStackLayout());

		p = new Panel();
		p.add(new Label("Table name:"));
		tableName = new TextField(15);
		p.add(tableName);
		add(p);
		
		ap = new AttributePanel[10];
		for(i = 0; i < max; i++) {
			ap[i] = new AttributePanel(i + 1);
			add(ap[i]);
		}
	}

	public String getScript() {
		int i, max;
		String s, script;
		
		s = tableName.getText();
		if(s == null) {
			return null;
		}

		script = "create(\"" + s + "\",[";
		for(i = 0; i < ap.length; i++) {
			s = ap[i].getAttributeFunction();
			if(s == null) {
				break;
			}
			if(i > 0) {
				script += ",";
			}
			script += "[" + s + "]";	// 19980410 tishi
		}

		if(i == 0) {
			// nothing
			return null;
		}
		
		// [partitions(..)]  append?
		s = tableName.getText();
		script += ",[partitions(flat,\"" + Const.newrelPath + s + "\")]])";
		
		return script;

	}

	public boolean handleEvent(Event e) {
		if(e.target instanceof Choice && e.id == e.ACTION_EVENT) {
			return true;
		}
		return super.handleEvent(e);
	}
	
	public String getAttributeFunction(int i) {
		return ap[i - 1].getAttributeFunction();
	}
/*
	// =============================================
	// $@%^!<%8%s$OMW$k$h$J!<!#(B
	public Insets insets() {
		return new Insets(0, 0, 0, 0);
	}

	// =============================================
	public synchronized void paint(Graphics g) {
		Dimension d = size();

		g.setColor(getBackground());
		g.draw3DRect(2, 2, d.width - 4, d.height - 4, false);
	}
*/

} // CreatePanel

/* Takashi Ishikawa / tishi@jaist.ac.jp */

