/**********************************************************************/
/*                                                                    */
/*      program of goal.c                                             */
/*      Go to goal                                                    */
/*                                                                    */
/*      Copyright (c) 1998  Fumio Mizoguchi                           */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#include <math.h>
#include "Jclient.h"
#include "goal.setup"



/***** FUNCTION PROTOTYPE *****/
double trans_freeness(int, int*, double*);
int    align_goal(int, int);
double goal_openess(int, int, int*);
int    avoid(int, int, int*, double, double, double, double*);
int    goal(int, int, int*, int*, int*);


/***** EXTERNALDATA *****/
int turn_dir = 0;
int panicp   = 0;
int sv_old   = 0;
int tv_old   = 0;


/***** TRANCE_FREENESS FUNCTION ***************************************/
double trans_freeness(int panic_dist, int abs_sensor[16],
		      double sensor_weight[16])
{
    /***** INTERNALDATA *****/
    double weight_sum = 0.0;
    double freeness = 0.0;
    int i;
    double sensed_dist, free_to_move_range;

    /***** PROCESS *****/
    free_to_move_range = Max_trans*Free_to_move_factor;

    for(i=12; i<=20; i++){
	sensed_dist = (double)abs_sensor[i%16];
	if(sensed_dist < panic_dist*sensor_weight[i%16]){
	    return (0.0);
	}
	if(sensed_dist > free_to_move_range*sensor_weight[i%16]){
	    freeness = 
	      freeness + free_to_move_range*sensor_weight[i%16];
	}
	else{
	    freeness = 
	      freeness + sensed_dist*sensor_weight[i%16];
	}
	weight_sum = weight_sum + sensor_weight[i%16];
    }
    freeness = (freeness - weight_sum*panic_dist)/
      (weight_sum*(free_to_move_range - panic_dist));

    return (freeness);
}
/***** END OF TRANCE_FREENESS FUNCTION ********************************/


/***** ALIGN_GOAL FUNCTION ********************************************/
int align_goal(int gx, int gy)
{
    /***** INTERNALDATA *****/
    int x, y, th, gth, dth;
    int sg_v;

    /***** PROCESS *****/
    x = State[34];
    y = State[35];
    th = State[36];
    if(th < 0){
	th = th + 3600;
    }
    
    gth = (int)(atan2((double)(gy-y),(double)(gx-x))*1800.0/PAI);
    if(gth < 0){
	gth = gth + 3600;
    }

    dth = gth - th;
    if(dth < 0){
	dth = dth + 3600;
    }
    if(dth > 1800){
	dth = dth - 3600;
    }
    
    if(abs(dth) > Goal_alignment){
	sg_v = Steer_goal_factor * dth;
    }
    else{
	sg_v = 0;
    }
    
    return (sg_v);
}
/***** END OF ALIGN_GOAL FUNCTION *************************************/


/***** GOAL_OPENESS FUNCTION ******************************************/
double goal_openess(int gx, int gy, int *abs_sensor)
{
    /***** INTERNALDATA *****/
    int x, y, th, gth, dth;
    int i, sr_num;
    double weight_sum = 0.0;
    double openess = 0.0;
    double goal_dist, sensed_dist;

    /***** PROCESS *****/
    x = State[34];
    y = State[35];
    th = State[36];
    if(th < 0){
	th = th + 3600;
    }

    goal_dist = sqrt((x-gx)*(x-gx) + (y-gy)*(y-gy)) - ROBOT_RADIUS;

    gth = (int)(atan2((double)(gy-y),(double)(gx-x))*1800.0/PAI);
    if(gth < 0){
	gth = gth + 3600;
    }

    dth = gth - th;
    if(dth < 0){
	dth = dth + 3600;
    }
    
    sr_num = (dth/225) % 16;
    
    for(i=12; i<=20; i++){
	sensed_dist = (double)abs_sensor[(sr_num+i)%16];
	if((sensed_dist > Max_sensor_range) || 
	   (sensed_dist > goal_dist)){
	    openess = openess + Max_sensor_range*Goal_weight[i-12];
	}
	else{
	    openess = openess + sensed_dist*Goal_weight[i-12];
	}
	weight_sum = weight_sum + Goal_weight[i-12];
    }

    openess = (openess - weight_sum * Min_sensor_range)/
      (weight_sum*(Max_sensor_range - Min_sensor_range));
    if(openess < 0){
	openess = 0;
    }
    
    return (openess);
}
/***** END OF GOAL_OPENESS FUNCTION ***********************************/


/***** AVOID FUNCTION *************************************************/
int avoid(int gx, int gy, int abs_sensor[16], double openess,
	  double avoid_range, double panic_range, double *sensor_weight)
{
    /***** INTERNALDATA *****/
    double left_val = 0, right_val = 0;
    int i, x, y, th;
    int unexpected_obs[16] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
    int useful_sensor1[16] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};
    int useful_sensor2[16] = {1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1};
    int *sensor_ptr;
    int gth, dth, sr_num;

    /***** PROCESS *****/
    if(State[33] != 0){
	return(Max_steer+1);
    }

    x = State[34];
    y = State[35];
    th = State[36];



    /* the goal direction */
    gth = (int)(atan2((double)(gy-y),(double)(gx-x))*1800.0/PAI);
    if(gth < 0){
	gth = gth + 3600;
    }
    
    dth = gth - th;
    if(dth < 0){
	dth = dth + 3600;
    }

    sr_num = (dth/225) % 16;
    
    if(openess > Open_enough){
	sensor_ptr = useful_sensor2;
    }
    else{
	sensor_ptr = useful_sensor1;
    }
    
    
    if(abs_sensor[sr_num] < avoid_range){
	left_val = (avoid_range - abs_sensor[sr_num])*
	  sensor_ptr[sr_num];
	right_val = (avoid_range - abs_sensor[sr_num])*
	  sensor_ptr[sr_num];
    }

    for(i=sr_num+1; i<sr_num+9; i++){
	if(abs_sensor[i%16] < avoid_range){
	    left_val = left_val + 
	      (avoid_range - abs_sensor[i%16])*sensor_ptr[i%16];
	}
    }
    for(i=16+sr_num-1; i>16+sr_num-9; i--){
	if(abs_sensor[i%16] < avoid_range){
	    right_val = right_val + 
	      (avoid_range - abs_sensor[i%16])*sensor_ptr[i%16];
	}
    }

    if((left_val > Min_force) || (right_val > Min_force)){
	if(turn_dir > 0){
	    if(left_val > right_val + Min_switch_diff){
		turn_dir = -1;
	    }
	}
	else{
	    if(turn_dir < 0){
		if(right_val > left_val + Min_switch_diff){
		    turn_dir = 1;
		}
	    }
	    else{
		if(left_val > right_val){
		    turn_dir = -1;
		}
		else{
		    turn_dir = 1;
		}
	    }
	}
    }
    else{
	turn_dir = 0;
    }
	
    
    /* 3 */
    sr_num = 0;
    
    if(((unexpected_obs[sr_num]) && 
	(abs_sensor[sr_num] < avoid_range)) || 
       (abs_sensor[sr_num] <=(int)(panic_range*sensor_weight[sr_num]))){
	left_val = 
	  (avoid_range - abs_sensor[sr_num]) * sensor_weight[sr_num];
	right_val = 
	  (avoid_range - abs_sensor[sr_num]) * sensor_weight[sr_num];
    }
    else{
	left_val = 0;
	right_val = 0;
    }
    
    for(i=sr_num+1; i<sr_num+5; i++){
	if(((unexpected_obs[i%16]) &&
	    (abs_sensor[i%16] < avoid_range)) ||
	   (abs_sensor[i%16] <=(int)(panic_range*sensor_weight[i%16]))){
	    left_val = left_val +
	      (avoid_range - abs_sensor[i%16]) * sensor_weight[i%16];
	}
    }

    for(i=16+sr_num-1; i>16+sr_num-5; i--){
	if(((unexpected_obs[i%16]) &&
	    (abs_sensor[i%16] < avoid_range)) ||
	   (abs_sensor[i%16] <=(int)(panic_range*sensor_weight[i%16]))){
	    right_val = right_val +
	      (avoid_range - abs_sensor[i%16]) * sensor_weight[i%16];
	}
    }
    

    if(left_val > Max_steer){
	left_val = Max_steer;
    }
    if(right_val > Max_steer){
	right_val = Max_steer;
    }

    if(left_val > right_val){
	return left_val;
    }
    else{
	return right_val;
    }
}
/***** END OF AVOID FUNCTION ******************************************/


/***** GOTOGOAL FUNCTION **********************************************/
int goal(int gx, int gy, int abs_sensor[16], 
	     int *trans_v, int *steer_v)
{
    /***** INTERNALDATA *****/
    int sg_v = 0, so_v = 0, t_v = 0, s_v = 0;
    int x, y, th;
    double openess, freeness, closeness;
    int d;
    
    /***** PROCESS *****/
    openess = goal_openess(gx, gy, abs_sensor);
    
    so_v = avoid(gx, gy, abs_sensor, openess, Avoid_range, 
		 Panic_range, Sensor_weight);
    
    
    if(abs(so_v) > Max_steer){     /* bumper hit */
	*steer_v = 0;
	*trans_v = Backup_speed;
	return -1;
    }
    
    x = State[34];
    y = State[35];
    th = State[36];
    d = sqrt((gx-x)*(gx-x) + (gy-y)*(gy-y));
    if(d < Goal_range){     /* goal acheive */
	*trans_v = 0;
	*steer_v = 0;
	return 1;
    }
    
    
    sg_v = align_goal(gx,gy);

    closeness = (double)d/Closeness_factor*Goal_range;
    if(closeness > 1.0){
	closeness = 1.0;
    }

    freeness = trans_freeness(Panic_range, abs_sensor, Sensor_weight);
    
    if((openess > Open_enough) && (abs(sg_v) > Max_misalign)){
	if(sg_v > 0){
	    turn_dir = 1;
	}
	else{
	    turn_dir = -1;
	}
    }
    so_v = turn_dir * so_v;
    
    if((abs(so_v) > Too_much_steer) || (panicp) || 
       (freeness < Too_clutter)){
	s_v = (int)((double)Avoid_factor * so_v *closeness);
	panicp = 1;
    }
    else{
	s_v = (int)((double)Avoid_factor * so_v * closeness +
		    (double)Goal_factor * sg_v * openess);
    }

    if(s_v > Max_steer){
	s_v = Max_steer;
    }
    if(s_v < -1*Max_steer){
	s_v = -1*Max_steer;
    }
    
    t_v = Trans_goal_factor*d;
    if(t_v > Max_trans){
	t_v = Max_trans;
    }
    
    t_v = (int)(freeness*t_v - Trans_steer_factor*abs(s_v));
    
    if(t_v > Out_of_panic_speed){
	panicp = 0;
    }
    
    if((abs(s_v) > Too_much_steer_mul1 * Too_much_steer) &&
       (abs(so_v) < Too_much_steer_mul2 * Too_much_steer)){
	t_v = 0;
    }
    
    if(t_v < 0){
	t_v = 0;
    }


    if(sv_old*s_v < 0){
	s_v = (1-Steer_history)*s_v + Steer_history*sv_old;
    }
    sv_old = s_v;
    
    if(t_v > 0){
	t_v = (1-Trans_history)*t_v + Trans_history*tv_old;
    }
    tv_old = t_v;
    
    *trans_v = t_v;
    *steer_v = s_v;
    
    return 0;
}
/***** END OF GOTOGOAL FUNCTION ***************************************/

    
	

