//
//   Sonar.java
//   Program of Sonar Sensor for Nomad200 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//
import java.awt.*;
import java.lang.*;
import java.util.*;
import java.util.Date;
import java.applet.*;

//
// Sonar.
//
public class Sonar implements Runnable {
    
    public Sonar(Nomad nomad, Obstacle Obstacle){
	
    }

    //
    // get sonar data.
    public int[] get_sonar_data(Nomad nomad, Graphics g){
	int[] data = new int[16];
	int i, j, flg_x, flg_y;
	boolean flg = false;
	double nomad_t, v_x, v_y, data_x, data_y, tmp_x, tmp_y, tmp_t;
	int obs_x, obs_y, obs_width, obs_height;
	Nomad   other_nomad;
	
	for(i=0; i<16; i++){
	    data[i] = 255;
	}
	
	flg_x = flg_y = 1;
	nomad_t = nomad.get_nomad_t();
	g.setColor(Color.blue);
	
	
	// degree 0.
	tmp_t = (nomad_t+225*0)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad0_x();
	data_y = tmp_y = nomad.get_nomad0_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[0] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);


	// degree 225.
	tmp_t = (nomad_t+225*1)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad225_x();
	data_y = tmp_y = nomad.get_nomad225_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[1] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 450.
	tmp_t = (nomad_t+225*2)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad450_x();
	data_y = tmp_y = nomad.get_nomad450_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[2] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);
	
	// degree 675.
	tmp_t = (nomad_t+225*3)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad675_x();
	data_y = tmp_y = nomad.get_nomad675_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[3] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 900.
	tmp_t = (nomad_t+225*4)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad900_x();
	data_y = tmp_y = nomad.get_nomad900_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[4] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 1125.
	tmp_t = (nomad_t+225*5)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad1125_x();
	data_y = tmp_y = nomad.get_nomad1125_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[5] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 225.
	tmp_t = (nomad_t+225*6)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad1350_x();
	data_y = tmp_y = nomad.get_nomad1350_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[6] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 1575.
	tmp_t = (nomad_t+225*7)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad1575_x();
	data_y = tmp_y = nomad.get_nomad1575_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[7] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 1800.
	tmp_t = (nomad_t+225*8)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad1800_x();
	data_y = tmp_y = nomad.get_nomad1800_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[8] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 2025.
	tmp_t = (nomad_t+225*9)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad2025_x();
	data_y = tmp_y = nomad.get_nomad2025_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[9] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 2250.
	tmp_t = (nomad_t+225*10)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad2250_x();
	data_y = tmp_y = nomad.get_nomad2250_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[10] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 2475.
	tmp_t = (nomad_t+225*11)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad2475_x();
	data_y = tmp_y = nomad.get_nomad2475_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[11] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 2700.
	tmp_t = (nomad_t+225*12)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad2700_x();
	data_y = tmp_y = nomad.get_nomad2700_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[12] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 2925.
	tmp_t = (nomad_t+225*13)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad2925_x();
	data_y = tmp_y = nomad.get_nomad2925_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[13] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 3150.
	tmp_t = (nomad_t+225*14)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad3150_x();
	data_y = tmp_y = nomad.get_nomad3150_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[14] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);

	// degree 3375.
	tmp_t = (nomad_t+225*15)%3600;
	v_x = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	v_y = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	data_x = tmp_x = nomad.get_nomad3375_x();
	data_y = tmp_y = nomad.get_nomad3375_y();
	if(0 <= tmp_t && tmp_t <= 900){
	    flg_x = 1;
	    flg_y = 1;
	}
	else if(900 < tmp_t && tmp_t <= 1800){
	    flg_x = -1;
	    flg_y = 1;
	}
	else if(1800 < tmp_t && tmp_t <= 2700){
	    flg_x = -1;
	    flg_y = -1;
	}
	else if(2700 < tmp_t && tmp_t < 3600){
	    flg_x = 1;
	    flg_y = -1;
	}
	for(i=18; i<256; i++){
	    tmp_x = data_x + v_x*flg_x*i;
	    tmp_y = data_y + v_y*flg_y*i;
	    for(j=0; j<obstacle.obstacle.size(); j++){
		obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(j));
		Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
					       obs.get_obstacle_y2(),
					       obs.get_obstacle_width(),
					       obs.get_obstacle_height());
		if(rect.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}		
	    }
	    if(flg){
		break;
	    }
	    for(j=0; j<nomad_Win.size(); j++){
		NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(j));
		other_nomad = nomad_win.get_nomad();
		int[] point_x = new int[8];
		int[] point_y = new int[8];
		
		point_x[0] = (int)other_nomad.get_nomad0_x();
		point_y[0] = (int)other_nomad.get_nomad0_y();
		point_x[1] = (int)other_nomad.get_nomad450_x();
		point_y[1] = (int)other_nomad.get_nomad450_y();
		point_x[2] = (int)other_nomad.get_nomad900_x();
		point_y[2] = (int)other_nomad.get_nomad900_y();
		point_x[3] = (int)other_nomad.get_nomad1350_x();
		point_y[3] = (int)other_nomad.get_nomad1350_y();
		point_x[4] = (int)other_nomad.get_nomad1800_x();
		point_y[4] = (int)other_nomad.get_nomad1800_y();
		point_x[5] = (int)other_nomad.get_nomad2250_x();
		point_y[5] = (int)other_nomad.get_nomad2250_y();
		point_x[6] = (int)other_nomad.get_nomad2700_x();
		point_y[6] = (int)other_nomad.get_nomad2700_y();
		point_x[7] = (int)other_nomad.get_nomad3150_x();
		point_y[7] = (int)other_nomad.get_nomad3150_y();

		Polygon poly = new Polygon(point_x, point_y, 8);
		if(poly.inside((int)tmp_x, (int)tmp_y)){
		    flg = true;
		    break;
		}	
	    }
	    if(flg){
		break;
	    }
	}
	data[15] = i-1;
	g.fillOval((int)(width/2+tmp_x/10), (int)(height/2-tmp_y/10), 2, 2);
	
	return data;
    }
}
