//
//   Simulator.java
//   Program of Simulator for Nomad200 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//

import java.awt.*;
import java.lang.*;
import java.util.Date;
import java.applet.*;

 
//
// Class Simulator. 
//
public class Simulator extends Applet {
    Scrollbar vert, horz;
    Environment env;

    int width, height;              // Window demension.
    int speed = 400;                // Draw speed.

    public MenuBar mb;
    public Menu m;
    public static String value;
    public Panel center;
    
    //
    // Initialize Process.
    //
    public void init(){
	setLayout(new BorderLayout());
        m = new Menu("File");
	m.add(new MenuItem("Quit"));
	center = new Panel();
	center.setBackground(Color.lightGray);
        center.setLayout(new BorderLayout());
	env  =  new Environment();
        vert = new Scrollbar(Scrollbar.VERTICAL,   230, 500, -10000, 10000);
        horz = new Scrollbar(Scrollbar.HORIZONTAL, 625, 500, -10000, 10000);
	center.add("Center", env);
        center.add("East", vert);
        center.add("South", horz);
	add("Center",center);
	Panel south = new Panel();
	south.setBackground(Color.lightGray);
        south.setLayout(new GridLayout(1, 4, 2, 2));
	south.add(new Button("Create Robot"));
	south.add(new Button("Obstacle"));
	south.add(new Button("Graphic"));
	add("South",south);
	width = 700;
	height = 480;
	resize(width, height);
	env.transxy(625, 230);
    }
    
    //
    // Scrollbar Event.
    //
    public boolean handleEvent(Event e){
        if(e.target instanceof Scrollbar){
            env.transxy(horz.getValue(), vert.getValue());
            return true;
        }
        return super.handleEvent(e);
    }
    
    //
    // Button Event.
    //
    public boolean action(Event e, Object arg) {
        String label = (String)arg;
	if(label.equals("Create Robot")){
	    env.create_Nomad();
	}
	if(label.equals("Obstacle")){
	    env.obstacle_Menu();
	}
	if(label.equals("Graphic")){
	    env.graphic_Menu();
	}
	return true;
    }
}



