//
//   Obstacle.java
//   Program of Obstacle for Simulator. 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//

import java.awt.*;
import java.lang.*;
import java.util.*;
import java.util.Date;
import java.applet.*;

//
// Class Obstacle.
//
class Obstacle extends Dialog {
    int obstacle_flg = 0;
    Vector obstacle = new Vector();
    boolean clear_flg = false;
    
    //
    // Initialize Process.
    //
    public Obstacle(Frame parent){
        super(parent, "Obstacle", false);
	setLayout(new BorderLayout());
	
	parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("Helvetica", Font.PLAIN, 12));
        parent.setLayout(new BorderLayout());	
	parent.setResizable(false);
	parent.pack();
	
	Panel center = new Panel();
        center.setLayout(new GridLayout(3,1,1,1));
	center.add(new Button("Add Obstacle"));
	center.add(new Button("All Clear"));
	center.add(new Button("Quit"));
	add("Center", center);
	resize(100, 150);
    }
    
    
    //
    // Geting object_flg.
    //
    public int get_obstacle_flg(){
	return obstacle_flg;
    }
    public boolean get_clear_flg(){
	boolean ret_val = false;
	if(clear_flg == true){
	    ret_val = true;
	}
	clear_flg = false;
	return ret_val;
    }
    
    //
    // Button action Process.
    //
    public boolean action(Event e, Object arg) {
        String label = (String)arg;
	if(label.equals("Add Obstacle")) {
	    obstacle_flg = 1;
	}
	if(label.equals("All Clear")) {
	    clear_object();
	    clear_flg = true;
	}	
	if(label.equals("Quit")) {
	    obstacle_flg = 0;
            hide();
        } 
        return true;
    }
    
    
    //
    // Obstacle Process.
    //
    
    // clear object.
    public void clear_object(){
	obstacle.removeAllElements();
    }


    public void add_obstacle(int x1, int y1, int x2, int y2, 
			   int x3, int y3, int x4, int y4){
	obstacle.addElement(new obstacleData(x1, y1, x2, y2, 
					     x3, y3, x4, y4));
    }
}


class obstacleData {
    int x1, y1, x2, y2, x3, y3, x4, y4;
    int width, height;
    
    public obstacleData(int ox1, int oy1, int ox2, int oy2, 
			int ox3, int oy3, int ox4, int oy4){
	x1 = ox1;
	y1 = oy1;
	x2 = ox2;
	y2 = oy2;
	x3 = ox3;
	y3 = oy3;
	x4 = ox4;
	y4 = oy4;
	width  = ox4 - ox2;
	height = oy4 - oy2; 
    }
      
    public int get_obstacle_x1(){
        return x1;
    }
    public int get_obstacle_y1(){
        return y1;
    }
    public int get_obstacle_x2(){
        return x2;
    }
    public int get_obstacle_y2(){
        return y2;
    }
    public int get_obstacle_width(){
	return width;
    }
    public int get_obstacle_height(){
	return height;
    }
}
      

