//
//   NomadWindow.java
//   Program of Nomad Window for Simulator. 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//
import java.net.*;
import java.io.*;
import java.awt.*;
import java.lang.*;
import java.util.Date;
import java.applet.*;

//
// Class NomadWindow.
//
public class NomadWindow extends Dialog implements Runnable {
    Thread nomadwindow;
    int   speed = 400;
    Environment env;
    Nomad nomad;
    int   nomad_ID;
    TextField x, y, s, t;
        
    Command   nomadcommand;
    TextField command;
    boolean   command_flg = false;

    TextField machine;
    TextField port;
    Button connectWait;
    Label status;
    boolean connect = false;
    SocketFunction sf;
    
    JoyStick joystick;
    Label    joylabel;
    String   string = " Both Turn";
    int      joy_flg = 0;

    public NomadWindow(Frame parent, int ID, Environment environment) {
	super(parent, "Nomad Window", false);
	setLayout(new BorderLayout());
	parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("Helvetica", Font.PLAIN, 12));
        parent.setLayout(new BorderLayout());	
	parent.setResizable(false);
	parent.pack();	
	
	Panel north = new Panel();
	north.setLayout(new BorderLayout());
	Panel northnorth  = new Panel();
	northnorth.setLayout(new FlowLayout());
	northnorth.add(new Label("       Nomad"));
	northnorth.add(new Label(Integer.toString(ID)));
	Panel northcenter = new Panel();
	northcenter.setLayout(new FlowLayout());
	northcenter.add(new Label("X"));
	northcenter.add(x = new TextField("        "));
	northcenter.add(new Label("Y"));
	northcenter.add(y = new TextField("        "));
	northcenter.add(new Label("S"));
	northcenter.add(s = new TextField("        "));
	northcenter.add(new Label("T"));
	northcenter.add(t = new TextField("        "));
	Panel northeast = new Panel();
	northeast.add(new Button("Change"));
	north.add("North", northnorth);
	north.add("Center",northcenter);
	north.add("East", northeast);
	
	Panel west = new Panel();
 	west.setLayout(new BorderLayout());
	Panel westup = new Panel();
	westup.setLayout(new BorderLayout());
	Label westupnorth = new Label("           Nomad Command");
	Panel westupcenter = new Panel();
	westupcenter.setLayout(new FlowLayout());
	westupcenter.add(new Button("Execute"));
	westup.add("North", westupnorth);
	westup.add("West", new Label(" "));
	westup.add("Center", command = new TextField("                    "));
	westup.add("East", westupcenter);
	
	Panel westdown = new Panel();
	westdown.setLayout(new BorderLayout());
	Label westdownnorth = new Label("        Connect user Program");
	Panel westdowncenter = new Panel();
	westdowncenter.setLayout(new GridLayout(2, 2, 2, 2));
//	westdowncenter.add(new Label("  Machine name"));
//      westdowncenter.add(machine = new TextField("machine"));
        westdowncenter.add(new Label("  Port number"));

	int portNum = 15000+ID;

        westdowncenter.add(port = new TextField(""+portNum));
        westdowncenter.add(new Label("  Status"));
        westdowncenter.add(status = new Label("Not connect"));
	Panel westdownsouth = new Panel();
	westdownsouth.setLayout(new FlowLayout());
	westdownsouth.add(connectWait = new Button("Connect Wait"));
	
	westdown.add("North" ,westdownnorth);
	westdown.add("Center",westdowncenter);
	westdown.add("South" ,westdownsouth);
	west.add("North",westup);
	west.add("Center",westdown);
	
	Panel center = new Panel();
	center.setLayout(new BorderLayout());
	center.add("North", new Label("                  JoyStick"));
	center.add("Center", joystick = new JoyStick());
	Panel centersouth = new Panel();
	centersouth.setLayout(new FlowLayout());
	centersouth.add(joylabel = new Label(string));
	centersouth.add(new Button("Changing"));
	center.add("South", centersouth);
	
	Panel centersouthsouth = new Panel();
	centersouthsouth.setLayout(new BorderLayout());
	centersouthsouth.add("South",new Label(""));
	centersouth.add("South", centersouthsouth);
	center.add("South", centersouth);

	Panel south = new Panel();
	south.setLayout(new FlowLayout());
	south.add(new Button("Destroy Nomad"));

	add("North", north);
	add("West",  west);
	add("Center",center);
	add("South", south);
	
	resize(430, 360);
	show();
	
	nomad = new Nomad((ID-1)*150+8750, (ID-1)*150-1250, 0, 0, ID);
	nomadcommand = new Command();
	x.setText(Integer.toString((ID-1)*150+8750));
	y.setText(Integer.toString((ID-1)*150-1250));
	s.setText(Integer.toString(0));
	t.setText(Integer.toString(0));	
	env = environment;
	nomad_ID = ID;
	sf = new SocketFunction(this);
	start();
    }
    
    
    //
    // Geting Nomad.
    //
    public Nomad get_nomad(){
	return nomad;
    }

    //
    // Geting Nomad ID.
    //
    public int get_nomadID(){
	return nomad_ID;
    }
    
    
    //
    // JoyStick event.
    //
    // Moving Nomad with JoyStick.
    public void JoyStick_Move(){
        double v_x, v_y, tmp_x, tmp_y, tmp_s, tmp_t, joy_x, joy_y;

	joy_x = joystick.get_joy_x();
	joy_y = joystick.get_joy_y();
	if(joy_x == 0 && joy_y == 0){
	    return;
	}	
	
        tmp_x = nomad.get_nomad_x();
        tmp_y = nomad.get_nomad_y();
        tmp_s = nomad.get_nomad_s();
        tmp_t = nomad.get_nomad_t();
	
	if(joy_flg == 0 || joy_flg == 1){
            tmp_s=tmp_s-joy_x*5;
            if(tmp_s >= 3600){
                tmp_s = tmp_s-3600;
            }
            else if(tmp_s < 0){
                tmp_s = tmp_s+3600;
            }
        }
	if(joy_flg == 0 || joy_flg == 2){
            tmp_t=tmp_t-joy_x*5;
            if(tmp_t > 3600){
                tmp_t = tmp_t-3600;
            }
            else if(tmp_t < 0){
                tmp_t = tmp_t+3600;
            }
        }
        v_x = 
          Math.abs((double)
                   (joy_y*Math.cos((-1*Math.PI/1800*tmp_s))));
        v_y = 
          Math.abs((double)
                   (joy_y*Math.sin((-1*Math.PI/1800*tmp_s))));
	
        if(0 <= tmp_s && tmp_s <= 900){
            if(joy_y >= 0){
                tmp_x = tmp_x+v_x;
                tmp_y = tmp_y+v_y;
            }
            else{
                tmp_x = tmp_x-v_x;
                tmp_y = tmp_y-v_y;
            }
	}
        else if(900 < tmp_s && tmp_s <= 1800){
            if(joy_y >= 0){
                tmp_x = tmp_x-v_x;
                tmp_y = tmp_y+v_y;
            }
            else{
                tmp_x = tmp_x+v_x;
                tmp_y = tmp_y-v_y;
            }
        }
        else if(1800 < tmp_s && tmp_s <= 2700){
            if(joy_y >= 0){
                tmp_x = tmp_x-v_x;
                tmp_y = tmp_y-v_y;
            }
            else{
                tmp_x = tmp_x+v_x;
                tmp_y = tmp_y+v_y;
            }
        }
        else if(2700 < tmp_s && tmp_s < 3600){
            if(joy_y >= 0){
                tmp_x = tmp_x+v_x;
                tmp_y = tmp_y-v_y;
            }
            else{
                tmp_x = tmp_x-v_x;
                tmp_y = tmp_y+v_y;
            }
        }
	nomad.set_nomad(tmp_x, tmp_y, tmp_s, tmp_t);
	env.get_sonar_data(nomad);
    }
    
    
    //
    // Button Event.
    //
    public boolean action(Event e, Object arg) {
        String label = (String)arg;
	if(label.equals("Change")){
	    nomad.set_nomad(Integer.parseInt(x.getText()),
			    Integer.parseInt(y.getText()),
			    Integer.parseInt(s.getText()), 
			    Integer.parseInt(t.getText()));
	}
	if(label.equals("Execute")){
	    nomadcommand.command(command.getText(), nomad);
	}
	if(label.equals("Connect Wait")){
            status.setText("Connect Wait");
	    String S2 = new String(port.getText());
	    sf.serverStart(Integer.parseInt(S2));
	    connectWait.setLabel("Accepted");
	}
	if(label.equals("Changing")){
	    switch(joy_flg){
	    case 0:
		string = " Steer only";
		joy_flg = 1;
		break;
	    case 1:
		string = " Turret only";
		joy_flg = 2;
		break;
 	    case 2:
		string = " Both Turn";
		joy_flg = 0;
		break;
	    }
	    joylabel.setText(string);
	}
	if(label.equals("Destroy Nomad")){
	    env.delete_Nomad(nomad_ID);
	    hide();
	    stop();
	}	
	return true;
    }
    
    //
    // Main loop.
    //
    public void start() {
        nomadwindow = new Thread(this);
        nomadwindow.start();
    }
    public void stop() {
        nomadwindow.stop();
    }
    public void run() {
        while (true) {
            try {
                Thread.currentThread().sleep(speed);
            } catch (InterruptedException e){}
        
	    if(connect == true ||
	       (int)nomad.get_old_nomad_x() != (int)nomad.get_nomad_x() ||
	       (int)nomad.get_old_nomad_y() != (int)nomad.get_nomad_y() ||
	       (int)nomad.get_old_nomad_s() != (int)nomad.get_nomad_s() ||
	       (int)nomad.get_old_nomad_t() !=(int) nomad.get_nomad_t()){
		x.setText(Integer.toString((int)nomad.get_nomad_x()));
		y.setText(Integer.toString((int)nomad.get_nomad_y()));
		s.setText(Integer.toString((int)nomad.get_nomad_s()));
		t.setText(Integer.toString((int)nomad.get_nomad_t()));	
	    }
	    
	    JoyStick_Move();
	}
    }

    public void getCommand(String S){
	if(S == null) {
	    connect = false;
	    status.setText("Not connect");
	}
	else{
	    command.setText(S);
	    sf.send("ok\n");
	    switch(nomadcommand.command(S, nomad)){
	    case 1:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		break;
	    case 2:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		break;
	    case 3:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		break;
	    case 4:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		break;
	    case 5:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		break;
	    case 6:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		break;
	    default:
		sf.send(nomadcommand.get_Nomad_state(nomad));
		sf.send(nomadcommand.get_Sonar_data(nomad, env));
		System.out.println("not command");
		;
	    }
	}
    }
}


//
// Socket Watcher
//
class SocketWatcher implements Runnable {
    Thread thread = null;
    NomadWindow nw = null;
    SocketFunction sf = null;

    SocketWatcher(SocketFunction sf, NomadWindow nw) {
	this.sf = sf;
	this.nw = nw;
	start();
    }

    public void start() {
        if (thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if (thread != null) {
            thread.stop();
            thread = null;
        }
    }

    public void run() {
	while (thread != null) {
	     String S = null;
	     S  = sf.receive();
	     nw.getCommand(S);
	     try {
		 Thread.currentThread().sleep(200);
	     } catch (InterruptedException e){}
	}
    }
}



//
// Socket Function.
//
class SocketFunction implements Runnable {
    Thread thread = null;
    NomadWindow nw = null;
    ServerSocket serversocket = null;
    
    BufferedReader datainput;
    OutputStreamWriter dataoutput;
    int portNum = 0;

    SocketFunction(NomadWindow nomad){
	nw = nomad;
    }

    public void start() {
        if (thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if (thread != null) {
            thread.stop();
            thread = null;
        }
    }

    public boolean serverStart(int port){
	if(socket_server(port)){
	    start();
	}
	else {
	    nw.status.setText("Change Port Num!!");
	    nw.connectWait.setLabel("Connect Wait");
	    return false;
	}
	return true;
    }

    public void run() {
	while (thread != null) {
	    if(socket_wait()){
		new SocketWatcher(this,nw);
		nw.status.setText("Connect OK");
	    }
	    else {
		nw.status.setText("Connect Broken");
		nw.connectWait.setLabel("Connect Wait");
		thread = null;
	    }
	}
    }

    public boolean socket_server(int port_number){
        System.out.println(port_number);
	try{
	    serversocket = new ServerSocket(port_number,10);
	}
	catch(IOException e){
	    System.out.println("Can not open socket");
	    return false;
	}
	return true;
    }

    public boolean socket_wait(){
        try{
	    Socket sock = null;
            sock = serversocket.accept();
	    datainput = null;
	    dataoutput = null;
            datainput = new BufferedReader( 
                        new InputStreamReader(sock.getInputStream()));
            dataoutput = new OutputStreamWriter(sock.getOutputStream());
        }
        catch(Exception e) {
	    System.out.println("Exception caught:" + e.getMessage() );
	    e.printStackTrace();
	    return false;
	}
	return true;
    }

    public void send(String Message) {
        try{
	    String OutMessage = null; 
            OutMessage = Message;
            dataoutput.write(OutMessage);
            dataoutput.flush();
        }
        catch(Exception e) {}
    }
    
    public String receive() {
	String sendstring = null;
	try{
	    sendstring = datainput.readLine();
	}
        catch(Exception e) {
	    sendstring = "Can't send message !!!";
	}
        return (sendstring);
    }
    
    
    public void serverclose() {
	try{
	    serversocket.close();
	}
	catch(Exception e){}
    }
}

















