//
//   NomadGraphic.java
//   Program of NomadGraphic for Simulator. 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//

import java.awt.*;
import java.lang.*;
import java.util.*;
import java.util.Date;
import java.applet.*;

//
// Class NomadGraphic.
//
class NomadGraphic extends Dialog {
    int obstacle_flg = 0;
    Vector obstacle = new Vector();
    Label   sonar;
    boolean sonar_flg = false;
    Label   trace;
    boolean trace_flg = false;
    boolean clear_flg = false;

    //
    // Initialize Process.
    //
    public NomadGraphic(Frame parent){
        super(parent, "Graphic", false);
	setLayout(new BorderLayout());
	
	parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("Helvetica", Font.PLAIN, 12));
        parent.setLayout(new BorderLayout());	
	parent.setResizable(false);
	parent.pack();
	
	
	setLayout(new GridLayout(1,2,1,1));
	
	Panel left = new Panel();
	left.setLayout(new GridLayout(4,1,1,1));
	left.add(new Button("Show Sonar"));
	left.add(new Button("Robot Trace"));
	left.add(new Button("All Clear"));
	left.add(new Button("Quit"));
	
	Panel right = new Panel();
	right.setLayout(new GridLayout(4,1,1,1));
	right.add(sonar = new Label("      off"));
	right.add(trace = new Label("      off"));
	right.add(new Label(""));
	right.add(new Label(""));
	
	add(left);
	add(right);

	resize(190, 200);
    }
    
    //
    // Button action Process.
    //
    public boolean action(Event e, Object arg) {
        String label = (String)arg;
	if(label.equals("Show Sonar")) {
	    if(sonar_flg){
		sonar.setText("      off");
		sonar_flg = false;
	    }
	    else{
		sonar.setText("      on");
		sonar_flg = true;
	    }
	}
	if(label.equals("Robot Trace")) {
	    if(trace_flg){
		trace.setText("      off");
		trace_flg = false;
	    }
	    else{
		trace.setText("      on");
		trace_flg = true;
	    }
	}
	if(label.equals("All Clear")) {
	    System.out.println("111");
	    clear_flg = true;
	}	
	if(label.equals("Quit")) {
	    hide();
	} 
        return true;
    }

    //
    // Getting flag.
    //
    public boolean get_sonar_flg(){
	return sonar_flg;
    }
    public boolean get_trace_flg(){
	return trace_flg;
    }
    public boolean get_clear_flg(){
	boolean ret_val = false;
	if(clear_flg == true){
	    ret_val = true;
	}
	clear_flg = false;
	return ret_val;
    }
}      


