//
//   Nomad.java
//   Program of Simulator for TransPort Robot with Nomad200 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//

import java.awt.*;
import java.lang.*;
import java.util.Date;
import java.applet.*;


//
// Nomad class.
//
public class Nomad extends Applet {
    double  x, y, s, t;                  // Nomad State.
    boolean Device_flg = false;         // Device ON/OFF.
    int     nomad_ID;
    int     redraw_flg = 2;
    
    double nomad0_x,    nomad0_y,    nomad225_x,   nomad225_y;
    double nomad450_x,  nomad450_y,  nomad675_x,   nomad675_y; 
    double nomad900_x,  nomad900_y,  nomad1125_x,  nomad1125_y;
    double nomad1350_x, nomad1350_y, nomad1575_x,  nomad1575_y;
    double nomad1800_x, nomad1800_y, nomad2025_x,  nomad2025_y;
    double nomad2250_x, nomad2250_y, nomad2475_x,  nomad2475_y;
    double nomad2700_x, nomad2700_y, nomad2925_x,  nomad2925_y;
    double nomad3150_x, nomad3150_y, nomad3375_x,  nomad3375_y;
    double start_st_x, start_st_y, end_st_x, end_st_y;
    double start_tu_x, start_tu_y, end_tu_x, end_tu_y;
    double start_bar_x, start_bar_y, end_bar_x, end_bar_y;
    double start_bum_x, start_bum_y, end_bum_x, end_bum_y;
    double start_bum, end_bum;
    
    double old_x, old_y,old_s, old_t;   // Old Nomad State.
    double old_nomad0_x,    old_nomad0_y,    old_nomad225_x,   old_nomad225_y;
    double old_nomad450_x,  old_nomad450_y,  old_nomad675_x,   old_nomad675_y; 
    double old_nomad900_x,  old_nomad900_y,  old_nomad1125_x,  old_nomad1125_y;
    double old_nomad1350_x, old_nomad1350_y, old_nomad1575_x,  old_nomad1575_y;
    double old_nomad1800_x, old_nomad1800_y, old_nomad2025_x,  old_nomad2025_y;
    double old_nomad2250_x, old_nomad2250_y, old_nomad2475_x,  old_nomad2475_y;
    double old_nomad2700_x, old_nomad2700_y, old_nomad2925_x,  old_nomad2925_y;
    double old_nomad3150_x, old_nomad3150_y, old_nomad3375_x,  old_nomad3375_y;
    double old_start_st_x, old_start_st_y, old_end_st_x, old_end_st_y;
    double old_start_tu_x, old_start_tu_y, old_end_tu_x, old_end_tu_y;
    double old_start_bar_x,old_start_bar_y,old_end_bar_x,old_end_bar_y;
    double old_start_bum_x,old_start_bum_y,old_end_bum_x,old_end_bum_y;
    

    public Nomad(double n_x, double n_y, double n_s, double n_t, int ID){
	double tmp_t;
	
	x = n_x; y = n_y; s = n_s; t = n_t; nomad_ID = ID;
	tmp_t = n_t;
	tmp_t = (tmp_t+0)%3600;
	nomad0_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad0_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad225_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad225_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad450_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad450_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad675_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad675_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad900_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad900_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1125_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1125_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1350_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1350_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1575_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1575_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1800_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1800_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2025_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2025_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2250_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2250_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2475_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2475_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2700_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2700_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2925_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2925_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad3150_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad3150_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad3375_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad3375_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);	

	set_nomad(n_x, n_y, n_s, n_t);
    }

    public void set_nomad(double n_x,double n_y,double n_s,double n_t){
	double tmp_t;
	
	old_x = x; old_y = y; old_s = s; old_t = t;
	
	old_nomad0_x=nomad0_x;   old_nomad0_y=nomad0_y;
	old_nomad225_x=nomad225_x;   old_nomad225_y=nomad225_y;
	old_nomad450_x=nomad450_x;   old_nomad450_y=nomad450_y;
	old_nomad675_x=nomad675_x;   old_nomad675_y=nomad675_y;
	old_nomad900_x=nomad900_x;   old_nomad900_y=nomad900_y;
	old_nomad1125_x=nomad1125_x;   old_nomad1125_y=nomad1125_y;
	old_nomad1350_x=nomad1350_x; old_nomad1350_y=nomad1350_y;
	old_nomad1575_x=nomad1575_x; old_nomad1575_y=nomad1575_y;
	old_nomad1800_x=nomad1800_x; old_nomad1800_y=nomad1800_y;
	old_nomad2025_x=nomad2025_x; old_nomad2025_y=nomad2025_y;
	old_nomad2250_x=nomad2250_x; old_nomad2250_y=nomad2250_y;
	old_nomad2475_x=nomad2475_x; old_nomad2475_y=nomad2475_y;
	old_nomad2700_x=nomad2700_x; old_nomad2700_y=nomad2700_y;
	old_nomad2925_x=nomad2925_x; old_nomad2925_y=nomad2925_y;
	old_nomad3150_x=nomad3150_x; old_nomad3150_y=nomad3150_y;
	old_nomad3375_x=nomad3375_x; old_nomad3375_y=nomad3375_y;

	old_start_st_x  = start_st_x;  old_start_st_y  = start_st_y;
	old_end_st_x    = end_st_x;    old_end_st_y    = end_st_y;
	old_start_tu_x  = start_tu_x;  old_start_tu_y  = start_tu_y; 
	old_end_tu_x    = end_tu_x;    old_end_tu_y    = end_tu_y;
	old_start_bar_x = start_bar_x; old_start_bar_y = start_bar_y;
	old_end_bar_x   = end_bar_x;   old_end_bar_y   = end_bar_y;
	old_start_bum_x = start_bum_x; old_start_bum_y = start_bum_y;
	old_end_bum_x   = end_bum_x;   old_end_bum_y   = end_bum_y;
	
	x = n_x; y = n_y; s = n_s; t = n_t;
	
	tmp_t = n_t;
	nomad0_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad0_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad225_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad225_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad450_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad450_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad675_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad675_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad900_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad900_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1125_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1125_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1350_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1350_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1575_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1575_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad1800_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad1800_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2025_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2025_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2250_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2250_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2475_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2475_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2700_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2700_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad2925_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad2925_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad3150_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad3150_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	tmp_t = (tmp_t+225)%3600;
	nomad3375_x = (double)(100*Math.cos((Math.PI/1800*tmp_t))+x);
	nomad3375_y = (double)(100*Math.sin((Math.PI/1800*tmp_t))+y);
	
	start_st_x = x;
	start_st_y = y;
	end_st_x = (double)(100/2*Math.cos((Math.PI/1800*s))+x);
	end_st_y = (double)(100/2*Math.sin((Math.PI/1800*s))+y);
	
	start_tu_x = (double)(100/2*Math.cos((Math.PI/1800*t))+x);
	start_tu_y = (double)(100/2*Math.sin((Math.PI/1800*t))+y);
	end_tu_x = (double)(100*Math.cos((Math.PI/1800*t))+x);
	end_tu_y = (double)(100*Math.sin((Math.PI/1800*t))+y);
	
	start_bar_x = start_tu_x;
	start_bar_y = start_tu_y;
	
	start_bum = t+300;
	if(start_bum >= 3600){
	    start_bum = start_bum - 3600;
	}
	end_bum = t-300;
	if(start_bum < 0 ){
	    start_bum = start_bum + 3600;
	}
	
	start_bum_x 
	  = (double)(100*9/5*Math.cos((Math.PI/1800*start_bum))+x);
	start_bum_y 
	  = (double)(100*9/5*Math.sin((Math.PI/1800*start_bum))+y);
	end_bum_x 
	  = (double)(100*9/5*Math.cos((Math.PI/1800*end_bum))+x);
	end_bum_y 
	  = (double)(100*9/5*Math.sin((Math.PI/1800*end_bum))+y);
	
	end_bar_x = (start_bum_x + end_bum_x)/2;
	end_bar_y = (start_bum_y + end_bum_y)/2;
    }

    
    //
    // Device ON/OFF.
    //
    public void device_on(){
	Device_flg = true;
    }
    public void device_off(){
	Device_flg = false;
    }
    public boolean device_check(){
	return Device_flg;
    }


    //
    // Now State.
    //
    
    public double get_nomad_x(){
	return x;
    }
    public double get_nomad_y(){
	return y;
    }
    public double get_nomad_s(){
	return s;
    }
    public double get_nomad_t(){
	return t;
    }
    public int get_nomadID(){
	return nomad_ID;
    }
    

    //
    public double get_nomad_point_x(int degree){
	double return_val = 0;
	
	switch(degree){
	case 0:
	    return_val =  nomad0_x;
	    break;
	case 255:
	    return_val = nomad225_x;
	    break;
	case 450:
	    return_val = nomad450_x;
	    break;
	case 675:
	    return_val = nomad675_x;
	    break;
	case 900:
	    return_val = nomad900_x;
	    break;
	case 1125:
	    return_val = nomad1125_x;
	    break;
	case 1350:
	    return_val = nomad1350_x;
	    break;
	case 1575:
	    return_val = nomad1575_x;
	    break;
	case 1800:
	    return_val = nomad1800_x;
	    break;
	case 2025:
	    return_val = nomad2025_x;
	    break;
	case 2250:
	    return_val = nomad2250_x;
	    break;
	case 2475:
	    return_val = nomad2475_x;
	    break;
	case 2700:
	    return_val = nomad2700_x;
	    break;
	case 2925:
	    return_val = nomad2925_x;
	    break;
	case 3150:
	    return_val = nomad3150_x;
	    break;
	case 3375:
	    return_val = nomad3375_x;
	    break;
	}
	return return_val;
    }
	
    public double get_nomad_point_y(int degree){
	double return_val = 0;

	switch(degree){	
	case 0:
	    return_val =  nomad0_y;
	    break;
	case 225:
	    return_val =  nomad225_y;
	    break;
	case 450:
	    return_val =  nomad450_y;
	    break;
	case 675:
	    return_val =  nomad675_y;
	    break;
	case 900:
	    return_val =  nomad900_y;
	    break;
	case 1125:
	    return_val =  nomad1125_y;
	    break;
	case 1350:
	    return_val =  nomad1350_y;
	    break;
	case 1575:
	    return_val =  nomad1575_y;
	    break;
	case 1800:
	    return_val =  nomad1800_y;
	    break;
	case 2025:
	    return_val =  nomad2025_y;
	    break;
	case 2250:
	    return_val =  nomad2250_y;
	    break;
	case 2475:
	    return_val =  nomad2475_y;
	    break;
	case 2700:
	    return_val =  nomad2700_y;
	    break;
	case 2925:
	    return_val =  nomad2925_y;
	    break;
	case 3150:
	    return_val =  nomad3150_y;
	    break;
	case 3375:
	    return_val =  nomad3375_y;
	    break;
	}
	return return_val;
    }
   
    //
    public double get_start_st_x(){
	return start_st_x;
    }
    public double get_start_st_y(){
	return start_st_y;
    }
    public double get_end_st_x(){
	return end_st_x;
    }
    public double get_end_st_y(){
	return end_st_y;
    }

    //
    public double get_start_tu_x(){
	return start_tu_x;
    }
    public double get_start_tu_y(){
	return start_tu_y;
    }
    public double get_end_tu_x(){
	return end_tu_x;
    }
    public double get_end_tu_y(){
	return end_tu_y;
    }

    //
    public double get_start_bar_x(){
	return start_bar_x;
    }
    public double get_start_bar_y(){
	return start_bar_y;
    }
    public double get_end_bar_x(){
	return end_bar_x;
    }
    public double get_end_bar_y(){
	return end_bar_y;
    }
    
    //
    public double get_start_bum_x(){
	return start_bum_x;
    }
    public double get_start_bum_y(){
	return start_bum_y;
    }
    public double get_end_bum_x(){
	return end_bum_x;
    }
    public double get_end_bum_y(){
	return end_bum_y;
    }


    //
    // Old State
    //
    public double get_old_nomad_x(){
	return old_x;
    }
    public double get_old_nomad_y(){
	return old_y;
    }
    public double get_old_nomad_s(){
	return old_s;
    }
    public double get_old_nomad_t(){
	return old_t;
    }
    
    //
    //
    public double get_old_nomad_point_x(int degree){
	double return_val = 0;

	switch(degree){
	case 0:
	    return_val =  old_nomad0_x;
	    break;
	case 255:
	    return_val = old_nomad225_x;
	    break;
	case 450:
	    return_val = old_nomad450_x;
	    break;
	case 675:
	    return_val = old_nomad675_x;
	    break;
	case 900:
	    return_val = old_nomad900_x;
	    break;
	case 1125:
	    return_val = old_nomad1125_x;
	    break;
	case 1350:
	    return_val = old_nomad1350_x;
	    break;
	case 1575:
	    return_val = old_nomad1575_x;
	    break;
	case 1800:
	    return_val = old_nomad1800_x;
	    break;
	case 2025:
	    return_val = old_nomad2025_x;
	    break;
	case 2250:
	    return_val = old_nomad2250_x;
	    break;
	case 2475:
	    return_val = old_nomad2475_x;
	    break;
	case 2700:
	    return_val = old_nomad2700_x;
	    break;
	case 2925:
	    return_val = old_nomad2925_x;
	    break;
	case 3150:
	    return_val = old_nomad3150_x;
	    break;
	case 3375:
	    return_val = old_nomad3375_x;
	    break;
	}
	return return_val;
    }
	
    public double get_old_nomad_point_y(int degree){
	double return_val = 0;
	
	switch(degree){	
	case 0:
	    return_val = old_nomad0_y;
	    break;
	case 225:
	    return_val = old_nomad225_y;
	    break;
	case 450:
	    return_val = old_nomad450_y;
	    break;
	case 675:
	    return_val = old_nomad675_y;
	    break;
	case 900:
	    return_val = old_nomad900_y;
	    break;
	case 1125:
	    return_val = old_nomad1125_y;
	    break;
	case 1350:
	    return_val = old_nomad1350_y;
	    break;
	case 1575:
	    return_val = old_nomad1575_y;
	    break;
	case 1800:
	    return_val = old_nomad1800_y;
	    break;
	case 2025:
	    return_val = old_nomad2025_y;
	    break;
	case 2250:
	    return_val = old_nomad2250_y;
	    break;
	case 2475:
	    return_val = old_nomad2475_y;
	    break;
	case 2700:
	    return_val = old_nomad2700_y;
	    break;
	case 2925:
	    return_val = old_nomad2925_y;
	    break;
	case 3150:
	    return_val = old_nomad3150_y;
	    break;
	case 3375:
	    return_val = old_nomad3375_y;
	    break;
	}
	return return_val;
    }

    //
    public double get_old_start_st_x(){
	return old_start_st_x;
    }
    public double get_old_start_st_y(){
	return old_start_st_y;
    }
    public double get_old_end_st_x(){
	return old_end_st_x;
    }
    public double get_old_end_st_y(){
	return old_end_st_y;
    }

    //
    public double get_old_start_tu_x(){
	return old_start_tu_x;
    }
    public double get_old_start_tu_y(){
	return old_start_tu_y;
    }
    public double get_old_end_tu_x(){
	return old_end_tu_x;
    }
    public double get_old_end_tu_y(){
	return old_end_tu_y;
    }

    public double get_old_start_bar_x(){
	return old_start_bar_x;
    }
    public double get_old_start_bar_y(){
	return old_start_bar_y;
    }
    public double get_old_end_bar_x(){
	return old_end_bar_x;
    }
    public double get_old_end_bar_y(){
	return old_end_bar_y;
    }

    public double get_old_start_bum_x(){
	return old_start_bum_x;
    }
    public double get_old_start_bum_y(){
	return old_start_bum_y;
    }
    public double get_old_end_bum_x(){
	return old_end_bum_x;
    }
    public double get_old_end_bum_y(){
	return old_end_bum_y;
    }
}






