//
//   JoyStick.java
//   Program of JoyStick for Simulator. 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//

import java.awt.*;
import java.lang.*;
import java.util.Date;
import java.applet.*;

//
// Class JoyStick.
//
class JoyStick extends Applet {
    int Jwidth=190;
    int Jheight=150;
    int joy_x, joy_y;           // Joystick point.
    
    public JoyStick() {
	joy_x = joy_y = 0;
    }
    
    public int get_joy_x(){
	return joy_x;
    }
    public int get_joy_y(){
	return joy_y;
    }
    
    //
    // Draw Joystick.
    //
    public void draw_joystick(Graphics g){
	g.setColor(Color.black);
	g.drawLine(30, 10, 160, 10);
	g.drawLine(160, 10, 160, 140);
	g.drawLine(160, 140, 30, 140);
	g.drawLine(30, 140, 30, 10);
	g.drawLine(95, 140, 95, 10);
	g.drawLine(30, 75, 160, 75);
	g.fillOval(95+joy_x-7, 75-joy_y-7, 14, 14);
    }

    //
    // Mouse moving event.
    //
    public boolean mouseDrag(java.awt.Event e,int x,int y){
	if(20 < x && x < 170 &&
	   0 < y && y < 150){
	    joy_x = x-(Jwidth-95);
	    joy_y = (Jheight-75)-y;
	}
	else{
	    joy_x = 0;
	    joy_y = 0;
	}
	
	repaint();
	return true;
    }

    //
    // Mouse down event.
    //
    public boolean mouseDown(java.awt.Event e,int x,int y){
	if(20 < x && x < 170 &&
	   0 < y && y < 150){
	    joy_x = x-(Jwidth-95);
	    joy_y = (Jheight-75)-y;
	}
	else{
	    joy_x = 0;
	    joy_y = 0;
	}
	
	repaint();
	return true;
    }
    
    //
    // Mouse up event.
    //
    public boolean mouseUp(java.awt.Event e,int x,int y){
	joy_x = 0;
	joy_y = 0;
	repaint();
	return true;
    }
    
    public void paint(Graphics g) {
	draw_joystick(g);	    
    }
}


















