//
//   Environment.java
//   Program of Simulator for Nomad200 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//
import java.awt.*;
import java.lang.*;
import java.util.*;
import java.util.Date;
import java.applet.*;


//
// Nomad Environment.
//
public class Environment extends Canvas implements Runnable {
    Thread environment;
    int speed = 400;
    int transx = 0;
    int transy = 0;
    int pre_transx = 0;
    int pre_transy = 0;
    int tx = 0;
    int ty = 0;
    int width, height;
    int nomad_ID = 1;
    Random rand = new Random();

    int oldoldx[] = new int[20];
    int oldoldy[] = new int[20];
    
    
    Vector nomad_Win = new Vector();
    
    public Obstacle obstacle;       // Obstacle Window.
    public Frame frame3 = new Frame("Obstacle");
    int    obstacle_x, obstacle_y, obstacle_width, obstacle_height;
    int    pre_width,  pre_height;
    boolean draw_obstacle_flg = false;
    boolean delete_flg = false;
    
    public NomadGraphic graphic;      // Nomad Graphic Window.
    public Frame frame4 = new Frame("NomadGraphic");

    int[] sonar_x = new int[16];
    int[] sonar_y = new int[16];



    //
    // Initialize.
    //
    public Environment(){
	width  = 700;
	height = 480;
	obstacle = new Obstacle(frame3);
	graphic  = new NomadGraphic(frame4);
	create_Nomad();
	repaint();
    	start();


	//
	// Setting the obstacles.
	obstacle.add_obstacle(3460,   -50, 3460,  -100, 9400,  -100, 9400,   -50);
	obstacle.add_obstacle(9400,   -50, 9400, -4110, 9450, -4110, 9450,   -50);
	obstacle.add_obstacle(3460, -4060, 3460, -4110, 9400, -4110, 9400, -4060);
	obstacle.add_obstacle(3132,   -52, 3132,  -232, 4812,  -232, 4812,   -52);
	obstacle.add_obstacle(3460, -1060, 3460, -3100, 3580, -3100, 3580, -1060); 
	obstacle.add_obstacle(3460, -3820, 3460, -4060, 5860, -4060, 5860, -3820);
	obstacle.add_obstacle(3580, -2800, 3580, -3100, 4900, -3100, 4900, -2800);
	obstacle.add_obstacle(4260, -1360, 4260, -2800, 4900, -2800, 4900, -1360);
	obstacle.add_obstacle(4180, -1060, 4180, -1360, 4900, -1360, 4900, -1060);
	obstacle.add_obstacle(5620, -1900, 5620, -2200, 8380, -2200, 8380, -1900);
	obstacle.add_obstacle(5620, -1540, 5620, -1900, 5860, -1900, 5860, -1540);
	obstacle.add_obstacle(5620, -2920, 5620, -3220, 6640, -3220, 6640, -2920);
	obstacle.add_obstacle(5620, -2624, 5620, -3044, 5920, -3044, 5920, -2624);
	obstacle.add_obstacle(7060, -1480, 7060, -3220, 7360, -3220, 7360, -1480);
	obstacle.add_obstacle(8080, -1480, 8080, -2200, 8380, -2200, 8380, -1480);
	obstacle.add_obstacle(7060, -2920, 7060, -3220, 8500, -3220, 8500, -2920);
	obstacle.add_obstacle(9100, -1000, 9100, -1720, 9400, -1720, 9400, -1000);
	obstacle.add_obstacle(3136,  -543, 3136, -4103, 3584, -4103, 3584,  -543);
	obstacle.add_obstacle(5620,  -100, 5620, -1000, 9410, -1000, 9410,  -100);	
    }

    //
    // Scroll.
    //
    public void transxy(int x, int y){
        transx = x; 
	transy = y;
        repaint();
    }

    //
    //  Drawing Process.
    //
    public void update(Graphics g){
	tx = transx-pre_transx;
	ty = transy-pre_transy;
	pre_transx = transx;
	pre_transy = transy;
	if(obstacle.get_clear_flg() || graphic.get_clear_flg() || delete_flg ||
	   tx != 0 || ty != 0){
	    g.clearRect(-10000, -10000, 20000, 20000);
	    if(delete_flg){
		delete_flg = false;
	    }
	}

	g.translate(-transx, -transy);
	draw_nomad(g);
	draw_obstacle(g);
	if(graphic.get_sonar_flg()){
	    draw_sonar(g);
	}
    }
    
    // draw Nomad.
    public void draw_nomad(Graphics g){
	int i, nomad_x, nomad_y;
	int start_st_x, start_st_y, end_st_x, end_st_y;
	int start_tu_x, start_tu_y, end_tu_x, end_tu_y;
	int start_bar_x, start_bar_y, end_bar_x, end_bar_y;
	int start_bum_x, start_bum_y, end_bum_x, end_bum_y;
	Nomad nomad;

	for(i=0; i<nomad_Win.size(); i++){
	    NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(i));
	    nomad = nomad_win.get_nomad();
	    
	    if(graphic.get_trace_flg() == false && 
	       (nomad.get_nomad_x() != nomad.get_old_nomad_x() ||
		nomad.get_nomad_y() != nomad.get_old_nomad_x() ||
		nomad.get_nomad_s() != nomad.get_old_nomad_s() ||
		nomad.get_nomad_t() != nomad.get_old_nomad_t())){
		nomad_x = (int)(width/2+nomad.get_old_nomad_x()/10);
		nomad_y = (int)(height/2-nomad.get_old_nomad_y()/10);
		g.setColor(Color.lightGray);
//		g.fillOval(nomad_x-15, nomad_y-15, 30, 30);
//		g.fillRect(nomad_x-4, nomad_y-22, 15, 13);
		g.fillOval(oldoldx[i]-15, oldoldy[i]-15, 30, 30);
		g.fillRect(oldoldx[i]-4, oldoldy[i]-22, 15, 13);
	    }
	    
	    nomad_x = (int)(width/2+nomad.get_nomad_x()/10);
	    nomad_y = (int)(height/2-nomad.get_nomad_y()/10);
	    start_st_x = (int)(width/2+nomad.get_start_st_x()/10);
	    start_st_y = (int)(height/2-nomad.get_start_st_y()/10);
	    end_st_x = (int)(width/2+nomad.get_end_st_x()/10);
	    end_st_y = (int)(height/2-nomad.get_end_st_y()/10);
	    start_tu_x = (int)(width/2+nomad.get_start_tu_x()/10);
	    start_tu_y = (int)(height/2-nomad.get_start_tu_y()/10);
	    end_tu_x = (int)(width/2+nomad.get_end_tu_x()/10);
	    end_tu_y = (int)(height/2-nomad.get_end_tu_y()/10);
	    g.setColor(new Color(180, 30, 30));
	    
	    oldoldx[i] = nomad_x;
	    oldoldy[i] = nomad_y;

	    g.fillOval(nomad_x-10, nomad_y-10, 20, 20);
	    g.setColor(Color.lightGray);
	    g.drawLine(start_st_x, start_st_y, end_st_x, end_st_y);
	    g.drawLine(start_tu_x, start_tu_y, end_tu_x, end_tu_y);
	    g.setColor(Color.black);
	    g.drawString(Integer.toString(nomad.get_nomadID()), 
			 nomad_x-4, nomad_y-11);
	}
    }
    
    // draw obstacle.
    public void draw_obstacle(Graphics g){
	int x, y, obs_width, obs_height, i;
	
	if(draw_obstacle_flg){
	    g.setColor(Color.lightGray);
	    g.fillRect(obstacle_x, obstacle_y, pre_width+10, pre_height+10);
	    g.setColor(Color.gray);
	    g.drawRect(obstacle_x, obstacle_y, obstacle_width, obstacle_height);
	}
	
	g.setColor(Color.black);
	for(i=0; i<obstacle.obstacle.size(); i++){
	    obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(i));
	    x = (int)(width/2+obs.get_obstacle_x1()/10);
            y = (int)(height/2-obs.get_obstacle_y1()/10);
	    obs_width = obs.get_obstacle_width()/10;
	    obs_height = obs.get_obstacle_height()/10;
	    g.fillRect(x, y, obs_width, obs_height);
	}
    }

    // draw sonar data.
    public void draw_sonar(Graphics g){
	int[] data = new int[16];
	int   i,j ;
	Nomad nomad;

	g.setColor(Color.blue);
	for(i=0; i<nomad_Win.size(); i++){
	    NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(i));
	    nomad = nomad_win.get_nomad();
	    	    
	    get_sonar_data(nomad);
	    for(j=0; j<16; j++){
		g.fillOval(sonar_x[j], sonar_y[j], 3, 3);
	    }	    
	}
    }

    //
    // get sonar data.
    public int[] get_sonar_data(Nomad nomad){
	int[] data = new int[16];
	int i, j, k, l, m, flg_x, flg_y;
	boolean flg = false;
	double nomad_t;
	double[] v_x = new double[16];
	double[] v_y = new double[16];
	double[] data_x = new double[16];
	double[] data_y = new double[16];
	double tmp_x, tmp_y, tmp_t;
	int obs_x, obs_y, obs_width, obs_height;
	Nomad   other_nomad;
	
	for(i=0; i<16; i++){
	    data[i] = 255;
	}
	
	tmp_x = tmp_y = 0;
	flg_x = flg_y = 1;
	nomad_t = nomad.get_nomad_t();
	
	for(i=0; i<16; i++){
	    tmp_t = (nomad_t+i*225)%3600;
	    v_x[i] = Math.abs((double)(10*Math.cos((-1*Math.PI/1800*tmp_t))));
	    v_y[i] = Math.abs((double)(10*Math.sin((-1*Math.PI/1800*tmp_t))));
	    data_x[i] = nomad.get_nomad_point_x(i*225);
	    data_y[i] = nomad.get_nomad_point_y(i*225);
	    if(0 <= tmp_t && tmp_t <= 900){
		flg_x = 1;
		flg_y = 1;
	    }
	    else if(900 < tmp_t && tmp_t <= 1800){
		flg_x = -1;
		flg_y = 1;
	    }
	    else if(1800 < tmp_t && tmp_t <= 2700){
		flg_x = -1;
		flg_y = -1;
	    }
	    else if(2700 < tmp_t && tmp_t < 3600){
		flg_x = 1;
		flg_y = -1;
	    }
	    v_x[i] = flg_x*v_x[i];
	    v_y[i] = flg_y*v_y[i];
	}
	
	for(j=0; j<16; j++){
	    flg = false;
	    for(i=5; i<256; i+=10){
		tmp_x = data_x[j] + v_x[j]*i;
		tmp_y = data_y[j] + v_y[j]*i;
		for(k=0; k<obstacle.obstacle.size(); k++){
		    obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(k));
		    Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
						   obs.get_obstacle_y2(),
						   obs.get_obstacle_width(),
						   obs.get_obstacle_height());
		    if(rect.inside((int)tmp_x, (int)tmp_y)){
			flg = true;
			break;
		    }		
		}
		if(flg){
		    break;
		}

/*		for(k=0; k<nomad_Win.size(); k++){
		    NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(k));
		    other_nomad = nomad_win.get_nomad();
		    int[] point_x = new int[8];
		    int[] point_y = new int[8];
		    
		    for(l=0; l<8; l++){
			point_x[l] = (int)other_nomad.get_nomad_point_x(450*l);
			point_y[l] = (int)other_nomad.get_nomad_point_y(450*l);
		    }
		    
		    Polygon poly = new Polygon(point_x, point_y, 8);
		    if(poly.inside((int)tmp_x, (int)tmp_y)){
			flg = true;
			break;
		    }	
		}
		if(flg){
		    break;
		}*/

	    }
	    if(i >= 255){
		data[j] = 255;
	    }
	    else {
		flg = false;
		for(m=i-10; m<=i; m++){
		    tmp_x = data_x[j] + v_x[j]*m;
		    tmp_y = data_y[j] + v_y[j]*m;
		    for(k=0; k<obstacle.obstacle.size(); k++){
			obstacleData obs = (obstacleData)(obstacle.obstacle.elementAt(k));
			Rectangle rect = new Rectangle(obs.get_obstacle_x2(), 
						       obs.get_obstacle_y2(),
						       obs.get_obstacle_width(),
						       obs.get_obstacle_height());
			if(rect.inside((int)tmp_x, (int)tmp_y)){
			    flg = true;
			    break;
			}		
		    }
		    if(flg){
			break;
		    }
		    for(k=0; k<nomad_Win.size(); k++){
			NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(k));
			other_nomad = nomad_win.get_nomad();
			int[] point_x = new int[8];
			int[] point_y = new int[8];
			
			for(l=0; l<8; l++){
			    point_x[l] = (int)other_nomad.get_nomad_point_x(450*l);
			    point_y[l] = (int)other_nomad.get_nomad_point_y(450*l);
			}
			
			Polygon poly = new Polygon(point_x, point_y, 8);
			if(poly.inside((int)tmp_x, (int)tmp_y)){
			    flg = true;
			    break;
			}	
		    }
		    if(flg){
			break;
		    }
		}
		data[j] = m-1;
	    }
	    sonar_x[j] = (int)(width/2 +(data_x[j]+v_x[j]*(data[j]-1))/10-1); 
	    sonar_y[j] = (int)(height/2-(data_y[j]+v_y[j]*(data[j]-1))/10-1);
	}
	return data;
    }
    
    //
    // Nomad menu.
    //
    public void create_Nomad(){
	nomad_Win.addElement(new 
		  NomadWindow(new Frame("Nomad Window"), nomad_ID, this));
	nomad_ID++;
    }
    public void delete_Nomad(int ID){
	int i;
	for(i=0; i<nomad_Win.size(); i++){
	    NomadWindow nomad_win = (NomadWindow)(nomad_Win.elementAt(i));
	    
	    if(nomad_win.get_nomadID() == ID){
		nomad_Win.removeElement(nomad_win);
	    }
	}
	delete_flg = true;
    }
    

    public void obstacle_Menu(){
	obstacle.show();
    }
    public void graphic_Menu(){
	graphic.show();
    }
    

    //
    // Mouse Event Process.
    //

    // Mouse down event.
    public boolean mouseDown(java.awt.Event e,int x,int y){
	switch(obstacle.get_obstacle_flg()){
	case 1:
	    obstacle_x = x+transx;
	    obstacle_y = y+transy;
	    obstacle_width = obstacle_height = pre_width = pre_height = 0;
	    draw_obstacle_flg = true;
	    break;
        case 2:
	    break;
        case 3:    
	    break;
	default:
	    ;
	}
	repaint();
        return true;
    }
    
    // Mouse moving event.
    public boolean mouseDrag(java.awt.Event e,int x,int y){
	switch(obstacle.get_obstacle_flg()){
	case 1:
	    pre_width  = obstacle_width;
	    pre_height = obstacle_height; 
	    obstacle_width  = x-obstacle_x+transx;
	    obstacle_height = y-obstacle_y+transy;
	    break;
	case 3:
	    break;
	default:
	    ;
	}
        repaint();
        return true;
    }

    // Mouse up event.
    public boolean mouseUp(java.awt.Event e,int x,int y){
	switch(obstacle.get_obstacle_flg()){
	case 1:
	    if(obstacle_width > 0 && obstacle_height > 0){
		int x1, y1, x2, y2, x3, y3, x4, y4;
		x1 = (obstacle_x-width/2)*10;
		y1 = (height/2-obstacle_y)*10;
		x3 = (obstacle_x+obstacle_width-width/2)*10;
		y3 = (height/2-obstacle_y-obstacle_height)*10;
		x2 = x1;
		y2 = y3;
		x4 = x3;
		y4 = y1;
		obstacle.add_obstacle(x1, y1, x2, y2, x3, y3, x4, y4);
	    }
	    draw_obstacle_flg = false;
	    break;
	case 3:
	    break;
	default:
	    ;
	}

        repaint();
        return true;
    }
    
    
    //
    // Main loop.
    //
    public void start() {
        environment = new Thread(this);
        environment.start();
    }
    public void stop() {
        environment.stop();
    }
    public void run() {
        while (true) {
	    




            try {
                Thread.currentThread().sleep(speed);
            } catch (InterruptedException e){}
	    repaint();
        }
    }
}



