//
//   Command.java
//   Program of JoyStick for TransPort Robot Simulator. 
//
//   Copyright (c) 1998  Fumio Mizoguchi
//

import java.awt.*;
import java.lang.*;
import java.util.Date;
import java.applet.*;

//
// Class Command.
//
class Command {
    String[] data = new String[20];
    String[] pre_data = new String[20];
    long  pre_time, now_time;
    
    long sp_speed = 100;
    long st_speed = 200;
    long tu_speed = 200;
    long time_out = 1000;
        
    String Nomad_state;
    String Sonar_data;
    
    public Command() {
	int i;
	pre_data[0] = new String("nothing");
	for(i=0; i<20; i++){
	    data[i] = new String("nothing");
	}
    }
    
    //
    // Command Process.
    //
    public int command(String comstring, Nomad nomad){
	int len, i, j, k, para_num, pre_index, return_val;
	long interval;
	
		
	len = comstring.length();
	para_num  = pre_index = 0;
	return_val = 0;
	
	for(i=0; i<len; i++){
	    if(comstring.charAt(i) == '('){ 
		data[para_num] = new String(comstring.substring(pre_index, i));
//		System.out.println("get string = "+data[para_num]);
		pre_index = ++i;
		para_num++;
		break;
	    }
	}
	
	for( ; i<len; i++){
	    if(comstring.charAt(i) == ','){ 
		data[para_num] = new String(comstring.substring(pre_index, i));
		pre_index = ++i;
		para_num++;
	    }
	    if(comstring.charAt(i) == ')'){ 
		data[para_num] = new String(comstring.substring(pre_index, i));
		pre_index = ++i;
		para_num++;
		break;
	    }
	}
	if(para_num == 0){
	    data[para_num] = new String(comstring);
	    para_num++;
	}
	
	// Delete ' ' .
	for(i=0; i<para_num; i++){
	    k = 0;
	    for(j=0; j<data[i].length(); j++){
		if(data[i].charAt(j) != ' '){
		    k++;
		}
	    }
	    char[] charactor = new char[k];
	    k=0;
	    for(j=0; j<data[i].length(); j++){
		if(data[i].charAt(j) != ' '){
		    charactor[k] = data[i].charAt(j);
		    k++;
		}
	    }
	    data[i] = new String(charactor);
	}
	
	now_time = System.currentTimeMillis();
	interval = now_time - pre_time;
	
	if(data[0].compareTo("gs") == 0){
	    return_val = 1;
	}
	if(data[0].compareTo("vm") == 0){
	    return_val = 2;
	}
	if(data[0].compareTo("zr") == 0){
	    zr(nomad, interval);
	    pre_data[0] = new String("zr");
	    return_val = 3;
	}
	if(data[0].compareTo("st") == 0){
	    st(nomad, interval);
	    pre_data[0] = new String("st");
	    return_val = 4;
	}
	if(data[0].compareTo("place_robot") == 0){
	    place_robot(nomad, interval);
	    pre_data[0] = new String("place_robot");
	    return_val = 5;
	}
	if(data[0].compareTo("pr") == 0){
	    return_val = 6;
	}
	


	
	if(pre_data[0].compareTo("vm") == 0){
	    vm(nomad, interval);
	}
	if(pre_data[0].compareTo("pr") == 0){
	    pr(nomad, interval);
	}
	
	//System.out.println(interval);
	pre_time = now_time;
	for(i=0; i<20; i++){
	    pre_data[i] = new String(data[i]);
	}
	return return_val;
    }
    
    // zr command.
    public void zr(Nomad nomad, long interval){
	nomad.set_nomad(0, 0, 0, 0);
    }
    
    // stop command.
    public void st(Nomad nomad, long interval){
	
    }
    
    // vm command.
    public void vm(Nomad nomad, long interval){
	double trans, steer, turet;
	double x, y, s, t, nx, ny, ns, nt;
	double v_x, v_y;
	
	x = nomad.get_nomad_x();
	y = nomad.get_nomad_y();
	s = nomad.get_nomad_s();
	t = nomad.get_nomad_t();

	if(interval > time_out){
	    interval = time_out;
	}
	
	trans = (double)((Integer.parseInt(pre_data[1])*interval)/1000);
	steer = (double)((Integer.parseInt(pre_data[2])*interval)/1000);
	turet = (double)((Integer.parseInt(pre_data[3])*interval)/1000);

	
	ns = s + steer;
	if(ns >= 3600){
	    ns = ns-3600;
	}
	else if(ns < 0){
	    ns = ns+3600;
	}
    
	nt = t + turet; 
	if(nt > 3600){
	    nt = nt-3600;
	}
	else if(nt < 0){
	    nt = nt+3600;
	}
	
	v_x = 
          Math.abs((double)
                   (trans*Math.cos((-1*Math.PI/1800*ns))));
        v_y = 
          Math.abs((double)
                   (trans*Math.sin((-1*Math.PI/1800*ns))));
	
        nx = x;
	ny = y;
	
	if(0 <= ns && ns <= 900){
            if(trans >= 0){
                nx = x+v_x;
                ny = y+v_y;
            }
            else{
                nx = x-v_x;
                ny = y-v_y;
            }
	}
        else if(900 < ns && ns <= 1800){
            if(trans >= 0){
                nx = x-v_x;
                ny = y+v_y;
            }
            else{
                nx = x+v_x;
                ny = y-v_y;
            }
        }
        else if(1800 < ns && ns <= 2700){
            if(trans >= 0){
                nx = x-v_x;
                ny = y-v_y;
            }
            else{
                nx = x+v_x;
                ny = y+v_y;
            }
        }
        else if(2700 < ns && ns < 3600){
            if(trans >= 0){
                nx = x+v_x;
                ny = y-v_y;
            }
            else{
                nx = x-v_x;
                ny = y+v_y;
            }
        }
	nomad.set_nomad(nx, ny, ns, nt);
    }


    // place_robot command.
    public void place_robot(Nomad nomad, long interval){
	double x, y, s, t;
	
	x = (double)Integer.parseInt(data[1]);
	y = (double)Integer.parseInt(data[2]);
	s = (double)Integer.parseInt(data[3]);
	t = (double)Integer.parseInt(data[4]);
	
	nomad.set_nomad(x, y, s, t);
    }

    // pr command.
    public void pr(Nomad nomad, long interval){
	
    }
    
    
    //
    // Getting Nomad State.
    public String get_Nomad_state(Nomad nomad){
	String value = new String();
	
	value = "state," + (int)nomad.get_nomad_x() + "," + (int)nomad.get_nomad_y() + "," +
	  (int)nomad.get_nomad_s()+ "," + (int)nomad.get_nomad_t() + "\n";
	
	return value;
    }
    
    //
    // 
    public String get_Sonar_data(Nomad nomad, Environment env){
	String value = new String();
	int[] data = new int[16];
	
	data = env.get_sonar_data(nomad);
	
	value = "sonar," + data[0] + "," + data[1] + "," + data[2] + "," + data[3] + "," 
	  + data[4] + "," + data[5] + "," + data[6] + "," + data[7] + "," + data[8] + "," 
	    + data[9] + "," + data[10] + "," + data[11] + "," + data[12] + "," + data[13] + "," 
	      + data[14] + "," + data[1] + "\n";
	
	return value;
    }
}



















