/***

      $BF14|@)8f$K$h$k>WFM2sHr%W%m%0%i%`%W%m%0%i%`(B
      $B#2Bf$N0\F0%m%\%C%H$rJB9T$KA`:n$7!$(B
      $B8_$$$N>WFM2sHr$r9T$J$&!%(B
      robot1$B=i4|0LCV%N!<%I(Bn3
      robot2$B=i4|0LCV%N!<%I(Bn7
   
   Copyright (c) 1998  Fumio Mizoguchi 

 $B<B9TJ}K!!'(B
    compile mobile3
    klic -o mobile3 mobile3.kl1 util.kl1 mapdata.kl1 machine.kl1
    mobile3

***/

:- agent(root).

 new :- init,
	*place_robot(robot1, n3),
	*place_robot(robot2, n7),
 	run.

 init :- 
    machine:nomadServer(Machine),
    #robotic_agent:new(robot1,robot(Machine,13001,13002)),
    #robotic_agent:new(robot2,robot(Machine,13003,13004)).

 run :- 
    List1 = [move(n4)+[[ok],C1],
             move(n5)+[[C1],C2],
             move(room3)+[[C2],C3],
             end+[[C3],_]],
    List2 = [move(n6)+[[ok],C4],
             move(n5)+[[C4,C2],C5],
             move(n4)+[[C5,C1],C6],
             move(room2)+[[C6],C7],
             end+[[C7],_]],
    *do(robot1, actionList(List1)),
    *do(robot2, actionList(List2)).


:- agent(robotic_agent).

 new(Name,Robot) :- init(Robot), run(Name,inactive).

 init(Robot) :- #nomad:new(Robot).

 run(Name,inactive) :- 
    ^do(Name, actionList(List)) |
    run(Name, action(List)).
 run(Name, action([])) :- run(Name, inactive).
 run(Name, action([Act+Com|Next])) :-
    Com = [[],End] |
    *do(Act, [ok,End]),
    run(Name, action(Next)).
 run(Name, action([Act+Com|Next])) :-
    Com = [[ok|Start],End] |
    NewCom = [Start, End],
    NewAction = action([Act+NewCom|Next]),
    run(Name, NewAction).
 run(Name, Action) :-
    ^place_robot(Name, Node) |
    *do(place_robot(Node), [ok,_]),
    run(Name, Action).


:- agent(nomad).

 new(Robot) :- init(Robot), run.

 init(robot(Host, OutPort, InPort)) :-
    #socket:new(Host, OutPort, InPort).

 run :-
    ^do(move(Node), [ok,Com]) |
    mapdata:point(Node, [X,Y], _),
    *do(gotogoal(X,Y), [ok,Com]),
    run.
 run :-
    ^do(stop) |
    *do(stop, [ok,_]),
    run.
 run :-
    ^do(end, [ok,Com]) |
    *do(end, [ok,Com]).
 run :-
    ^do(place_robot(Node), [ok,_]) |
    mapdata:point(Node, [X,Y], _),
    *do(place_robot(X,Y,0,0),[ok,_]),
    run.


:- agent(socket).

 new(Host,OutPort,InPort) :-
    util:connect(Host,OutPort) +Out,
    util:connect(Host,InPort) +In,
    run +Out +In.

 run +Out +In:- ^do(X, [ok,Com]) |
    util:command_to_string(X,Str),
    Out <= fwrite(Str,N),
    Out <= fflush(_),
    In <= fread(4,C),                        
    util:wait_ok(C,Com),
    run +Out +In.  

 check(Str) :- wait(Str) |
    builtin:print(check(Str)).


