/***

   $B4D6-Fb$rGPk_$9$k%W%m%0%i%`(B
   
   Copyright (c) 1998  Fumio Mizoguchi 

 $B<B9TJ}K!!'(B
    compile wandering
    klic -o wandering wandering.kl1 util.kl1 machine.kl1 controlJ.kl1 Jclient.o utility.o goal.o
    wandering

***/

:- agent(root).

 new :- machine:nomadSimulator(Machine),
        init(robot(1,Machine,15001)).

 init(Robot) :- 
    #wander:new(Robot).


:- agent(wander).

 new(robot(Num,Host,Port)) :- 
    nomadUtil:connectRobot(Num,Host,Port),
    nomadUtil:sensorOn,
    init,
    run.

 init :-
     #soner:new,
     #mover:new.

 run :-
    *obstacle(clear) |
    *do(turn(straight)),
    run.
 run :-
    *obstacle(left) |
    *do(turn(right)),
    run.
 run :-
    *obstacle(right) |
    *do(turn(left)),
    run.


:- agent(mover).

 new :- run(straight, ok).

 run(_,Com) :- ^do(turn(NewCource)) |
    run(NewCource, Com).

 run(Cource, ok) :-  Cource = right |
    nomadUtil:move(0,-100,-100, Com),
    run(Cource, Com).
 run(Cource, ok) :-  Cource = left |
    nomadUtil:move(0,100,100, Com),
    run(Cource, Com).
 run(Cource, ok) :-  Cource = straight |
    nomadUtil:move(100,0,0, Com),
    run(Cource, Com).


:- agent(soner).

 new :-
    run(clear, ok).

 run(Obstacle, ok) :- 
    nomadUtil:nowSensor(Data),
    checkSensor(Data,Obstacle, NewObstacle, Next),
    run(NewObstacle, Next).

 checkSensor(Data, Obstacle, NewObstacle, Next) :- list(Data) |
    getLeftData(Data,Left),
    getRightData(Data,Right),
    getLengeMin(Left,LeftMin),
    getLengeMin(Right,RightMin),
    compareMin(LeftMin,RightMin,Which),
    sendAvoidCommand(Which, Obstacle, NewObstacle, Next).

 
 sendAvoidCommand(Which, Obstacle, NewObstacle, Next) :- 
    Which = left(Lenge),
    Lenge < 25 |
    NewObstacle = left,
    checkChange(Obstacle, NewObstacle, Next).
 sendAvoidCommand(Which, Obstacle, NewObstacle, Next) :- 
    Which = right(Lenge),
    Lenge < 25 |
    NewObstacle = right,
    checkChange(Obstacle, NewObstacle, Next).
otherwise.
 sendAvoidCommand(_, Obstacle, NewObstacle, Next) :- 
    NewObstacle = clear,
    checkChange(Obstacle, NewObstacle, Next).

 checkChange(Obstacle, NewObstacle, Next) :-
    Obstacle \= NewObstacle |
    ^obstacle(NewObstacle),
    Next = ok.
 checkChange(Obstacle, NewObstacle, Next) :-
    Obstacle = NewObstacle |
    Next = ok.

 compareMin(Left, Right, Which) :-
    Left >= Right |
    Which = right(Right).
 compareMin(Left, Right, Which) :-
    Left < Right |
    Which = left(Left).


 getLengeMin(List, Min) :-
    getMin(List, 255, Min).

 getMin([], Now, Min) :- Min = Now.
 getMin([Data|Next],Now,Min) :- Data < Now |
    getMin(Next, Data, Min).
 getMin([Data|Next],Now,Min) :- Data >= Now |
    getMin(Next, Now, Min).

 getLeftData(Data,Left) :-
    Num = 3,
    getNumData(Num,Data,Left).
 getRightData(Data,Right) :-
    revers(Data,[],ReversData),
    Num = 3,
    getNumData(Num,ReversData,Right).
    
 getNumData(0,_,Data) :- Data = [].
 getNumData(Num, Master, Data) :- 
    Num > 0,
    Master = [One|Next] |
    Data = [One|NextData],
    NextNum := Num -1,
    getNumData(NextNum, Next, NextData).

 revers([], Process, Revers) :- Revers = Process.
 revers([Data|Next], Process, Revers) :-
    NextProcess = [Data|Process],
    revers(Next, NextProcess, Revers).
    
