/***

   $BOS7?%m%\%C%H!'%^%k%A%(!<%8%'%s%H%7%9%F%`(B

   arm1.rd $B!A(B arm5.rd$B$r3HD%$7!$$5$i$K%(!<%8%'%s%H4V$N(B
   $B8r>D%W%m%H%3%k$rMQ0U$9$k!%!%(B
   $B;k3P%;%s%5$HO"F0$7!$4D6->e$K@QLZ$,CV$+$l$?$iJRIU$1$k!%(B
   $BJ#?t%m%\%C%H$,6(D4$7$F:n6H$r9T$J$&!%(B
   
 $B<B9TJ}K!!'(B
    compile multiagent
    klic -o multiagent multiagent.kl1 util.kl1 machine.kl1
    multiagent

       Copyright (c) 1998  Fumio Mizoguchi 

***/

/*** Root$B%(!<%8%'%s%H(B ***/
/* $B6%9g2r>C$r9T$J$&!%(B   */
:- agent(root).

 new :-
    init,
    run([]).

 init :- 
    R1 = [r1,0.0,0.0,0.0,500.0],
    R2 = [r2,0.0,800.0,180.0,500.0],
    R3 = [r3,800.0,800.0,180.0,500.0],
    R4 = [r4,800.0,0.0,0.0,500.0],
    machine:armSimulator(Machine),
    #robotic_filterAgent:new(robot(R1,Machine,12001,12002)),
    #robotic_filterAgent:new(robot(R2,Machine,12003,12004)),
    #robotic_filterAgent:new(robot(R3,Machine,12005,12006)),
    #robotic_filterAgent:new(robot(R4,Machine,12007,12008)),
    #senser_agent:new(vision(Machine,12401)).


 run(State) :- *before(Action,C) |
    put_occupation(State,NewState,Action,C),
    run(NewState).
 run(State) :- *after(Action,C) |
    delete_occupation(State,NewState,Action,C),
    run(NewState).
otherwise.
 run(State)  :- *X |  
    klicio:klicio([stdout(normal([putt(insight),nl]))]),
    *X,
    run(State).

  delete_occupation([],NewState,Action,C) :-
    NewState = [].
 delete_occupation(State,NewState,Action,C) :- 
    State = [Action|NextState] |
    C = ok,
    delete_occupation(NextState,NewState,Action,C).
otherwise.
 delete_occupation([S|State],NewState,Action,C) :-
    NewState = [S|State2],
    delete_occupation(State,State2,Action,C).

 put_occupation([],NewState,Action,C) :-
    C = ok,
    NewState = [Action].
 put_occupation(State,NewState,Action,C) :-
    State = [Action|_] |
    C = no,
    NewState = State.
otherwise.
 put_occupation([S|State],NewState,Action,C) :-
    NewState = [S|State2],
    put_occupation(State,State2,Action,C).


/*** Sensor_agent$B%(!<%8%'%s%H(B ***/
/* $B@QLZ$rH/8+$7$?$i@QLZ$rJRIU$1$k$h$&$K;X<($9$k(B */
:- agent(senser_agent).

 new(Vision) :-
    init(Vision),
    run([],[]).

 init(vision(Host,InPort)) :-
    #vision:new(Host,InPort).

 run(Block,Box) :- *box(X,Y) |
    checkNewBox(box(X,Y),Box,Ret),
    newBox(Ret,box(X,Y),Block,Box).
 run(Block,Box) :- *block(X,Y,R) |
    checkOldBlock(Block,Block1),
    checkNewBlock(block(X,Y,R),Block1,Ret1),
    checkOutsideBox(block(X,Y,R),Box,Ret2),
    newBlock(Ret1,Ret2,block(X,Y,R)+F,Block1,Box).

 checkOldBlock([block(X,Y,R)+F|Block],Block1) :-
    F = out |
    checkOldBlock(Block,Block1).
alternatively.
 checkOldBlock([],Block1) :- Block1 = [].
 checkOldBlock([block(X,Y,R)+F|Block],Block1) :-
    Block1 = [block(X,Y,R)+F|Block2],
    checkOldBlock(Block,Block2).

 newBox(Ret,NewBox,Block,Box) :- Ret = true |
    ^NewBox,
    Box1 = [NewBox|Box],
    run(Block,Box1).
 newBox(Ret,_,Block,Box) :- Ret = false |
    run(Block,Box).

 newBlock(Ret1,Ret2,NewBlock,Block,Box) :- Ret1 = true, Ret2 = true |
    ^NewBlock,
    Block1 = [NewBlock|Block],
    run(Block1,Box).
otherwise.
  newBlock(_,_,_,Block,Box) :- 
    run(Block,Box).

 checkNewBox(_,[],Ret) :- Ret = true.
 checkNewBox(box(X,Y),[box(X1,Y1)|_],Ret) :-
    X1-20 < X , X < X1+20 , Y1-20 < Y , Y < Y1+20 |
    Ret = false.
otherwise.
 checkNewBox(NewBox,[_|Box],Ret) :-
    checkNewBox(NewBox,Box,Ret).

 checkNewBlock(_,[],Ret) :- Ret = true.
 checkNewBlock(block(X,Y,_),[block(X1,Y1,_)+_|_],Ret) :-
    X1-50 < X , X < X1+50 , Y1-50 < Y , Y < Y1+50 |
    Ret = false.
otherwise.
 checkNewBlock(NewBlock,[_|Block],Ret) :-
    checkNewBlock(NewBlock,Block,Ret).

 checkOutsideBox(_,[],Ret) :- Ret = true.
 checkOutsideBox(block(X,Y,_),[box(X1,Y1)|_],Ret) :-
    X1-70 < X , X < X1+70 , Y1-70 < Y , Y < Y1+70 |
    Ret = false.
otherwise.
 checkOutsideBox(B,[_|Box],Ret) :-
    checkOutsideBox(B,Box,Ret).


/*** Vision$B%(!<%8%'%s%H(B ***/
/* $B4D6->pJs$r4F;k$9$k(B */
:- agent(vision).

 new(Host,InPort) :-
    util:connect(Host,InPort) +In,
    In <= fread(1024,Str),
    run(Str) +In,

    % $B%\%C%/%9$rEjF~(B
    util:connect(Host,12402) +Out,
    Data = "0,0,300,0,1,300,800,0,1,800,500,0:\0",
    Out <= fwrite(Data,N),
    Out <= fflush(_).

 run(Str) +In :- string(Str) |
%    klicio:klicio([stdout(normal([putt(Str),nl,nl]))]),
    util:to_list(Str,List),
    newObject(List),
    In <= fread(1024,Str1),
    run(Str1) +In.

 newObject(List) :- List = [] | true.
 newObject(List) :- List = [0,X,Y,_|List1] |
    ^box(X,Y),
    newObject(List1).
 newObject(List) :- List = [1,X,Y,R|List1] |
    ^block(X,Y,R),
    newObject(List1).
otherwise.
 newObject(List) :- List = [_,_,_,_|List1] |
    newObject(List1).


/*** Robotic_filter$B%(!<%8%'%s%H(B ***/
/* $BDL?.MQ%(!<%8%'%s%H(B                 */
/* $B<+J,$K4XO"$7$?%a%C%;!<%8$r<u$1<h$k(B */
:- agent(robotic_filterAgent).

 new(robot(Robot,Host,InPort,OutPort)) :-
    init(robot(Robot,Host,InPort,OutPort)),
    run(Robot).

 init(robot(Robot,Host,InPort,OutPort)) :-
    #robotic_agent:new(robot(Robot,Host,InPort,OutPort)).

 run(Robot) :- 
    ^Message ,
    Message = block(X,Y,R)+F |
    distance(Robot,[X,Y],D),
    run_block(D,Message),
    run(Robot).
 run(Robot) :- 
    ^Message ,
    Message = box(X,Y) |
    distance(Robot,[X,Y],D),
    run_box(D,Message),
    run(Robot).
 run(Robot) :- 
    ^Message ,
    Message = request(Client,Action,info(robot(Rx,Ry),Path,Cost,Canel))+F |
    checkPath(Robot,[Client|Path],Boolean),
    distance(Robot,[Rx,Ry],Distance),
    run_robot(Boolean,Distance,Message),
    run(Robot).
 run(Robot) :- 
    ^Message ,
    Robot = [Client|_],
    Message = accept(Client,Action,Cost,Canel) |
    klicio:klicio([stdout(normal([putt(Client),putt(accept(Action,Cost)),nl]))]),
    *Message,
    run(Robot).
 run(Robot) :- 
    ^Message ,
    Robot = [Name|_],
    Message = accept(Client,Action,Cost,Canel) ,
    Name \= Client |
    klicio:klicio([stdout(normal([putt(Client),putt(nonaccept(Action,Cost)),nl]))]),
    run(Robot).

 run(Robot) :- *X |
    ^X,
    run(Robot).

 checkDeliver(Name1,Name2,Message) :-
    Name1 = Name2|
    *Message.
otherwise.
 checkDeliver(_,_,_) :- A=B.

 checkPath(Robot,Path,Boolean) :-
    Path = [] |
    Boolean = true.
 checkPath(Robot,Path,Boolean) :-
    Robot = [Name1|_],
    Path = [Name2|_],
    Name1 = Name2 |
    Boolean = false.
 checkPath(Robot,Path,Boolean) :- 
    Robot = [Name1|_],
    Path = [Name2|Next],
    Name1 \= Name2 |
    checkPath(Robot,Next,Boolean).

 run_robot(Boolean,D,Message) :-
    Boolean = true,
    D > 780, D < 1100 |
    *Message.
otherwise.
 run_robot(_,_,_) :- A = B.
 
 run_block(D,B) :-
    D > 240, D < 400 |              /* $B;YG[NN0hFb$N>l9g(B */
    *B.
otherwise.
 run_block(_,_) :- A = B.

 run_box(D,B) :-
    D > 270, D < 400 |             /* $B;YG[NN0hFb$N>l9g(B */
    *B.
otherwise.
 run_box(_,_) :- A = B.

/*****************************************************
        $B#2E@4V$N5wN%(B
*****************************************************/

 distance([Name,X1,Y1,_,G],[X,Y],D) :- 
    integer(X), integer(Y) |
    X2 $:= float(X), Y2 $:= float(Y),
    distance1(X1,X2,Y1,Y2,G,D).

 distance([Name,X1,Y1,_,G],[X2,Y2],D) :- 
    float(X2), float(Y2) |
    distance1(X1,X2,Y1,Y2,G,D).

 distance1(X1,X2,Y1,Y2,G,D) :-
    float(X1), float(X2), float(Y1), float(Y2), float(G) |
    Dis $:= sqrt((X1-X2)*(X1-X2)+(Y1-Y2)*(Y1-Y2)) * 500.0 / G,
    util:to_int(Dis,D).


/*** Robotic_agent$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%?%9%/$r2r<a$7(B          */
/* robot$B%(!<%8%'%s%H$X%3%^%s%I$rAw?.(B.            */
/* $BB>(BRobotic_agent$B%(!<%8%'%s%H$H8r>D$r9T$J$&(B.    */
:- agent(robotic_agent). 

 new(robot(R,Host,InPort,OutPort)) :-
    init(robot(Host,InPort,OutPort)),
    run(R,ok,[],[],[],[]).

 init(robot(Host,InPort,OutPort)) :-
    #robot:new(robot(Host,InPort,OutPort)).

 /** $B=*N;$7$?%?%9%/$N=|5n(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    Block = [block(_,_,_)+out|Block1] |
    run(Robot,C0,NowTask,Request,Block1,Box).
 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = gripBlock+out |
    run(Robot,C0,[],Request,Block1,Box).
 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = request(clear(block(_)))+out |
    run(Robot,C0,[],Request,Block,Box).
 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = commit(_, _,_,_)+out |
    run(Robot,C0,[],Request,Block,Box).
 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = accept(_,cancel) |
    run(Robot,C0,[],Request,Block,Box).
 run(Robot,C0,NowTask,Request,Block,Box) :-
    Request = [request(_,_)+out|Request1] |
    run(Robot,C0,NowTask,Request1,Block,Box).
alternatively.

 /* $BH"$rG'<1(B */
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    ^box(Bx,By) |
    klicio:klicio([stdout(normal([putt(Robot),putt(boxIn),nl]))]),
    Box1 = box(Bx,By),
    run(Robot,C0,NowTask,Request,Block,Box1).
 /** $B@QLZ$rG'<1(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    ^block(X,Y,R)+F |
    klicio:klicio([stdout(normal([putt(Robot),putt(blockIn([X,Y])),nl]))]),
    Block1 = [block(X,Y,R)+F|Block],
    run(Robot,C0,NowTask,Request,Block1,Box).

 /* $B@QLZ$rG'<1$7$?8e$KH"$rG'<1$7$?>l9g(B */
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    C0 = ok,
    NowTask = [],
    Block = [block(X,Y,R)+F|Block1],
    Box = box(Bx,By) |
    do(Robot,pickup(X,Y,R),[C0,C1],F),
    do(Robot,release(Bx,By),[C1,C2]),
    run(Robot,C2,NowTask,Request,Block1,Box).
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    C0 = ok,
    NowTask = gripBlock+F,
    Box = box(Bx,By) |
    F = out,
    do(Robot,release(Bx,By),[C0,C1]),
    run(Robot,C1,[],Request,Block,Box).
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    C0 = ok,
    NowTask = request(clear(block([X,Y,R])))+F,
    Box = box(Bx,By) |
    do(Robot,pickup(X,Y,R),[C0,C1],F),
    do(Robot,release(Bx,By),[C1,C2]),
    run(Robot,C2,[],Request,Block,Box).
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    C0 = ok,
    NowTask = request(clear(block(grip)))+F,
    Box = box(Bx,By) |
    do(Robot,release(Bx,By),[C0,C1]),
    run(Robot,C1,[],Request,Block,Box).

 /** $BNY@\%m%\%C%H$KBP$9$k%W%i%s:n@.0MMj!J@QLZ$r;}$C$F$$$J$$>uBV!K(B */
 /* $BNY@\8!:w0MMj$r9T$J$$!$%W%i%sBT$A>uBV$X(B */
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    C0 = ok,
    NowTask = [],
    Block = [block(X,Y,R) +F|B2],
    Box = []|
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(requestPlan),nl]))]),
    ^request(Name,clear(block([X,Y,R])),info(robot(Rx,Ry),[],0,[]))+F,
    NowTask1 = request(clear(block([X,Y,R])))+F,
    run(Robot,C0,NowTask1,Request,Block,Box).

 /** $BNY@\%m%\%C%H$KBP$9$k%W%i%s:n@.0MMj!J@QLZ$r;}$C$F$$$k>uBV!K(B */
 /* $BNY@\8!:w0MMj$r9T$J$$!$%W%i%sBT$A>uBV$X(B */
 run(Robot,C0,NowTask,Request,Block,Box)  :- 
    C0 = ok,
    NowTask = gripBlock+F,
    Box = []|
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(requestHavePlan),nl]))]),
    ^request(Name,clear(block(grip)),info(robot(Rx,Ry),[],0,[]))+F,
    NowTask1 = request(clear(block(grip)))+F,
    run(Robot,C0,NowTask1,Request,Block,Box).
    
 /** $BNY@\8!:w0MMj$r<u$1!$H"$,B8:_$9$k>l9g!JNY@\%m%\%C%H!K(B */
 /* $B<+J,$N%m%\%C%H%J%s%P!<!$:BI8$r%G!<%?$H$7$F!$%W%i%s$r0MMj85$KJV$9(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    Box = box(Bx,By) ,
    ^request(Client,Action,info(_,Path,Cost,_))+F ,
    Action = clear(block(_)),
    Path = [], Cost = 0 |
    computeCost(Block,LocalCost),
    TotalCost := Cost + LocalCost + 1,
    Robot = [Name|_],
    klicio:klicio([stdout(normal([putt(Name),putt(requestOK0),nl]))]),
    ^accept(Client,Action,cost([Name],TotalCost),Canel),
    Request1 = request(Action, Canel) +F,
    Request2 = [Request1|Request],
    run(Robot,C0,NowTask,Request2,Block,Box).

 /** $BNY@\8!:w0MMj$r<u$1!$H"$,B8:_$9$k>l9g!JHsNY@\%m%\%C%H!K(B */
 /* $B<+J,$N%m%\%C%H%J%s%P!<!$:BI8$r%G!<%?$H$7$F!$%W%i%s$r0MMj85$KJV$9(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    Box = box(Bx,By) ,
    ^request(Client,Action,info(_,Path,Cost,Canel))+F ,
    list(Path), Cost > 0, 
    Action = clear(block(_)) |
    computeCost(Block,LocalCost),
    TotalCost := Cost + LocalCost + 1,
    Robot = [Name|_],
    klicio:klicio([stdout(normal([putt(Name),putt(requestOK1),nl]))]),
    util:append(Path,[Name],Path1),
    ^accept(Client,Action,cost(Path1,TotalCost),Canel),
    run(Robot,C0,NowTask,Request,Block,Box).

 /** $BNY@\8!:w0MMj$r<u$1!$H"$,B8:_$7$J$$>l9g(B $B!JNY@\%m%\%C%H!K(B */
 /* $B<+J,$N%m%\%C%H%J%s%P!<!$:BI8$r%G!<%?$H$7$F!$(B
    $B%W%i%s:n@.0MMj$rNY@\%m%\%C%H$KBP$7$F9T$J$&!%(B
    $B$3$N:]!$NY@\8!:w0MMj$r<u$1$?;v<B$rJ];}!%(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    Box = [] ,
    ^request(Client,Action,info(_,Path,Cost,_))+F ,
    Action = clear(block(_)),
    Path = [], Cost = 0 |
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(requestNext0),nl]))]),
    computeCost(Block,LocalCost),
    TotalCost := Cost + LocalCost + 1,
    util:append(Path,[Name],Path1),
    ^request(Client,Action,info(robot(Rx,Ry),Path1,TotalCost,Canel))+F,
    Request1 = request(Action, Canel) +F,
    Request2 = [Request1|Request],
    run(Robot,C0,NowTask,Request2,Block,Box).

 /** $BNY@\8!:w0MMj$r<u$1!$H"$,B8:_$7$J$$>l9g(B $B!JHsNY@\%m%\%C%H!K(B */
 /* $B<+J,$N%m%\%C%H%J%s%P!<!$:BI8$r%G!<%?$H$7$F!$(B
    $B%W%i%s:n@.0MMj$rNY@\%m%\%C%H$KBP$7$F9T$J$&!%(B
    $B$3$N:]!$NY@\8!:w0MMj$r<u$1$?;v<B$rJ];}!%(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    Box = [] ,
    ^request(Client,Action,info(_,Path,Cost,Canel))+F ,
    list(Path), Cost > 0,
    Action = clear(block(_)) |
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(requestNext1),nl]))]),
    computeCost(Block,LocalCost),
    TotalCost := Cost + LocalCost + 1,
    util:append(Path,[Name],Path1),
    ^request(Client,Action,info(robot(Rx,Ry),Path1,TotalCost,Canel))+F,
    run(Robot,C0,NowTask,Request,Block,Box).

 /** $B0MMj$7$?%W%i%s:n@.$,=*N;$7$?>l9g(B */
 /* Commit $B%a%C%;!<%8H/F0(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    C0 = ok,
    NowTask = request(Action)+F,
    Box = [] ,
    ^accept(_,Action,cost(Plan,Cost),Canel) |
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(planReceive1),nl]))]),
    Canel = commit(deliver(client(Rx,Ry),Server),E),
    NowTask1 = commit(Action, deliver(Server),Cost,E)+F,
    run(Robot,C0,NowTask1,Request,Block,Box).

 /** $B$5$i$K0MMj$7$?%W%i%s:n@.$,=*N;$7$?>l9g(B */
 /* $B%a%C%;!<%8:o=|(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = commit(_,_,_,_)+_,
    ^accept(_,Action,cost(Plan,Cost),Canel) |
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(planReceiveDrop1),nl]))]),
    run(Robot,C0,NowTask,Request,Block,Box).

 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = [],
    ^accept(_,Action,cost(Plan,Cost),Canel) |
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(planReceiveDrop2),nl]))]),
    run(Robot,C0,NowTask,Request,Block,Box).

 /** Commit$B$N<uBw(B*/ 
 run(Robot,C0,NowTask,Request,Block,Box) :-
    C0 = ok,
    NowTask = [],
    Block = [],
    Request = [request(Action, Canel) +F|Request1],
    Canel = commit(deliver(Client,Server),E) |
    Robot = [Name,Rx,Ry|_],
    klicio:klicio([stdout(normal([putt(Name),putt(receiveCommit0),nl]))]),
    Server = server(Rx,Ry),
    NowTask1 = accept(deliver(Client),E),
    run(Robot,C0,NowTask1,Request1,Block,Box).

 /** Commit$B%a%C%;!<%8$N<uBw$r3NG'(B*/
 /* $B<uEO$7:n6H$N3+;O(B */
  run(Robot,C0,NowTask,Request,Block,Box) :-
    C0 = ok,
    Box = [] ,
    NowTask = commit(Action, deliver(Server),Cost,E)+F,
    Server = server(Sx,Sy) |
    klicio:klicio([stdout(normal([putt(Robot),putt(startDeliver0),nl]))]),
    E = deliver([D0,D1,D2,D3])+F,
    do_deliver(Robot, Action, deliver(Server)+F,[C0,D0,D1,D2,D3,C1]),
    run(Robot,C1,[],Request,Block,Box).

 /** $B<u$1$H$j:n6H(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    NowTask = accept(deliver(Client),E) ,
    E = deliver([D0,D1,D2,D3])+F|
    klicio:klicio([stdout(normal([putt(Robot),putt(receiveBlockStart),nl]))]),
    do(Robot,receive(Client),[C0,D0,D1,D2,D3,C1]),
    NowTask1 = receive(block),
    run(Robot,C1,NowTask1,Request,Block,Box).

 /** $B<u$1$H$j:n6H=*N;(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    C0 = ok,
    NowTask = receive(block) |
    klicio:klicio([stdout(normal([putt(Robot),putt(successReceive),nl]))]),
    NowTask1 = gripBlock+NewF,
    run(Robot,C0,NowTask1,Request,Block,Box).

 /** $B%?%9%/$,ESCf$GCfCG(B */
 run(Robot,C0,NowTask,Request,Block,Box) :-
    C0 = no |
    klicio:klicio([stdout(normal([putt(Robot),putt(missTask),nl]))]),
    do(Robot,home,[ok,C1]),
    NowTask1 = [],
    run(Robot,C1,NewTask1,Request,Block,Box).



 run(Robot,C0,Task,R,Block,Box) :- 
    *X |
    ^X,
    run(Robot,C0,Task,R,Block,Box).

 do_deliver(Robot,Action,deliver(Server)+F,C) :-
    Action = clear(block([X,Y,R])) |
    C = [C1|C2],
    do(Robot,pickup(X,Y,R),[C1,C3], F),
    do(Robot,deliver(Server),[C3|C2], F).    
 do_deliver(Robot,Action,deliver(Server)+F,C) :-
    Action = clear(block(grip)) |
    do(Robot,deliver(Server),C, F).    

 computeCost([],Cost) :- Cost := 0.
 computeCost([_|X],Cost) :-
    Cost := Cost1 + 1,
    computeCost(X,Cost1).

 do(Robot,Action,[ok|C]):-
    *do(Robot,Action,[ok|C]).
 do(Robot,Action,[no,C]):-
    C = no.

 do(_,_,[no,C],_) :- C = no.
 do(Robot,Action,[ok,C],F) :-
    Action = pickup(X,Y,R)|
    before(Action,[ok,C1], F),
    do_it(Robot,Action,[C1,C2], F),
    after(Action,[C2,C], F).
otherwise.
 do(Robot,Action,C,F) :-
    do_it(Robot,Action,C, F).

 before(Action,[_,C], out) :- C = no.
alternatively.
 before(Action,[ok,C], F) :-
    ^before(Action,C).

 do_it(Robot,Action,[ok|C], F) :-
    *do(Robot,Action,[ok|C], F).
 do_it(_,_,[no,C]) :-
    C = no.

 after(Action,[ok,C], F) :-
    F = out,
    ^after(Action,C).
 after(_,[no,C], _) :-
    C = no.


/*** robot$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%3%^%s%I$r2r<a$7(B     */
/* Socket$B%(!<%8%'%s%H$X%m%\%C%H%3%^%s%I$rAw?.(B */
:- agent(robot).
     
 new(Robot) :-
    init(Robot),
    run.

 init(robot(Host,OutPort,InPort)) :-
    #socket:new(Host,OutPort,InPort).

 run  :- ^do(Robot,pickup(X,Y,R),[ok,C], F) |
    util:pointLocal(Robot,world(X,Y,R),local(XL,YL,RL)),
    do(mp(XL,YL,70,-90,RL),[ok,C1], F),
    do(mp(XL,YL,40,-90,RL),[C1,C2], F),
    do(gc,[C2,C3], F),
    do(mp(XL,YL,70,-90,RL),[C3,C4], F),
    do(mp(0,160,371,-90,0),[C4,C], F),
    run.
 run :- ^do(Robot,release(X,Y),[ok,C]) |
    util:pointLocal(Robot,world(X,Y,0),local(XL,YL,_)),
    do(mp(XL,YL,150,-70,0),[ok,C1]),
    do(go,[C1,C2]),
    do(mp(0,160,371,-90,0),[C2,C]),
    run.
 run :- ^do(Robot,deliver(server(Rx,Ry)),[ok,D0,D1,D2,D3,C], F) |
    util:deliverPoint(Robot,[Rx,Ry],[X,Y]),
    do(mp(X,Y,410,0,0),[ok,D0], F),
    do(go,[D1,D2], F),
    do(mp(0,160,371,-90,0),[D3,C], F),
    run.
 run :- ^do(Robot,receive(client(Rx,Ry)),[ok,D0,D1,D2,D3,C]) |
    util:deliverPoint(Robot,[Rx,Ry],[X1,Y1],[X2,Y2]),
    do(mp(X2,Y2,400,0,90),[ok,_]),
    do(mp(X1,Y1,400,0,90),[D0,C1]),
    do(gc,[C1,D1]),
    do(mp(X2,Y2,400,0,80),[D2,D3]),
    do(mp(0,160,371,-90,0),[D3,C]),
    run.

 run :- ^do(Robot,home,[ok,C]) |
    do(mp(0,160,371,-90,0),[ok,C]).

 do(_,[_,C],cancel) :- C = no.
alternatively.
 do(Command,[ok,C], E) :-
    *do(Command,[ok,C]).
 do(_,[no,C], E) :- C = no.

 do(Command,[ok,C]) :-
    *do(Command,[ok,C]).
 do(Command,[no,C]) :- C = no.


/*** Socket$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%3%^%s%I$r%m%\%C%H%7%9%F%`$XAw?.(B */
:- agent(socket).

 new(Host,OutPort,InPort) :-
    util:connect(Host,OutPort) +Out,
    util:connect(Host,InPort) +In,
    run +Out +In.

 run +Out +In :- ^[] | true.
 run +Out +In :- ^do(X,[no,OK]) |
    OK = no,
    run +Out +In.
 run +Out +In:- ^do(X,[ok,OK]) |
    util:command_to_string(X,Str),
    Out <= fwrite(Str,N),
    Out <= fflush(_),
    In <= fread(4,C),                        
    util:wait_ok(C,OK),
    run +Out +In.  


