/***

   $BOS7?%m%\%C%H!'C1BN$K$h$k@QLZ$NJRIU$1(B

   arm4.rd$B$r3HD%!%(B
   $B;k3P%;%s%5$HO"F0$7!$4D6->e$K@QLZ$,CV$+$l$?$iJRIU$1!$(B
   $BJRIU$1$kA0$K@QLZ$,L5$/$J$C$?$iCfCG$9$k!%(B
   
 $B<B9TJ}K!!'(B
    compile arm5
    klic -o arm5 arm5.kl1 util.kl1 machine.kl1
    arm5

       Copyright (c) 1998  Fumio Mizoguchi 

***/


/*** Root$B%(!<%8%'%s%H(B ***/
:- agent(root).

 new :- 
    init, run.
 
 init :-
    machine:armSimulator(Machine),
    #robotic_agent:new(robot(Machine,12001,12002)),
    #sensor_agent:new(vision(Machine,12401)).


 run :- *clean(block(X,Y,R), E) |
    *clean(block(X,Y,R), E),
    run.


/*** sensor_agent$B%(!<%8%'%s%H(B ***/
/* $B@QLZ$rH/8+$7$?$i@QLZ$rJRIU$1$k$h$&$K;X<($9$k(B   */
/* $B@QLZ$,L5$/$J$C$?$i!$%?%9%/$N%-%c%s%;%k$r9T$J$&(B */
:- agent(sensor_agent).

 new(Vision) :-
    init(Vision),   run([]).

 init(vision(Host,InPort)) :-
    #vision:new(Host,InPort).

 run(State) :- *block(X,Y,R) |
    ^clean(block(X,Y,R), E),
    add_block(block(X,Y,R)+E,State,NewState),
    run(NewState).
 run(State) :- *block_out(X,Y,R) |
    find(block(X,Y,R),State, E),
    E = cancel,
    run(State).

 add_block(Block,State,NewState) :-
    NewState = [Block|State].

 find(_,[],_) :- true.
 find(block(X,Y,R),[block(X,Y,R)+E|_],C) :- C = E.
otherwise.
 find(Block,[_|State],C) :-
    find(Block,State,C).


/*** Vision$B%(!<%8%'%s%H(B ***/
/* $B4D6->pJs$r4F;k$9$k(B */
:- agent(vision).

 new(Host,InPort) :-
    util:connect(Host,InPort) +In,
    In <= fread(1024,Str),
    run(Str) +In,

    % $B%\%C%/%9!"@QLZ$rEjF~(B
    util:connect(Host,12402) +Out,
    Data = "0,0,350,0,1,300,0,0:\0",
    Out <= fwrite(Data,N),
    Out <= fflush(_).


 run(Str) +In :- string(Str) |
    util:to_list(Str,List),
    newObject(List),
    In <= fread(1024,Str1),
    run(Str1) +In.

 newObject(List) :- List = [] | true.
 newObject(List) :- List = [1,X,Y,R|List1] |
    ^block(X,Y,R),
    newObject(List1).
 newObject(List) :- List = [2,X,Y,R|List1] |
    ^block_out(X,Y,R),
    newObject(List1).
otherwise.
 newObject(List) :- List = [_,_,_,_|List1] |
    newObject(List1).


/*** Robotic_agent$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%?%9%/$r2r<a$7(B               */
/* robot$B%(!<%8%'%s%H$X%3%^%s%I$rAw?.(B.                 */
:- agent(robotic_agent). 

 new(Robot) :-
    init(Robot),  run(ok).

 init(Robot) :-
    #robot:new(Robot).

 run(ok)  :- ^clean(block(X,Y,R), E)|
    *do(pickup(X,Y,R),[ok,C1], E),
    *do(release,[C1,C2]),
    run(C2).


/*** robot$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%3%^%s%I$r2r<a$7(B     */
/* Socket$B%(!<%8%'%s%H$X%m%\%C%H%3%^%s%I$rAw?.(B */
:- agent(robot).
     
 new(Robot) :-
    init(Robot),  run.

 init(robot(Host,OutPort,InPort)) :-
    #socket:new(Host,OutPort,InPort).

 run  :- ^do(pickup(XL,YL,RL),[ok,C], E) |
    do(mp(XL,YL,70,-90,RL),[ok,C1], E),
    do(mp(XL,YL,40,-90,RL),[C1,C2], E),
    do(gc,[C2,C3], E),
    do(mp(XL,YL,70,-90,RL),[C3,C4], E),
    do(mp(0,160,371,-90,0),[C4,C], E),
    run.
 run :- ^do(release,[ok,C]) |
    do(mp(0,350,150,-70,0),[ok,C1]),
    do(go,[C1,C2]),
    do(mp(0,160,371,-90,0),[C2,C]),
    run.
 run :- ^do(release,[no,C]) |
    do(mp(0,160,371,-90,0),[ok,C]),
    run.

 do(_,[_,C],cancel) :- C = no.
alternatively.
 do(Command,[ok,C], E) :-
    *do(Command,[ok,C]).
 do(_,[no,C], E) :- C = no.

 do(Command,[ok,C]) :-
    *do(Command,[ok,C]).
 do(Command,[no,C]) :- C = no.


/*** Socket$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%3%^%s%I$r%m%\%C%H%7%9%F%`$XAw?.(B */
:- agent(socket).

 new(Host,OutPort,InPort) :-
    util:connect(Host,OutPort) +Out,
    util:connect(Host,InPort) +In,
    run +Out +In.

 run +Out +In:- ^do(X,[ok,OK]) |
    util:command_to_string(X,Str),
    Out <= fwrite(Str,N),
    Out <= fflush(_),
    In <= fread(4,C),                        
    util:wait_ok(C,OK),
    run +Out +In.  


