/***

   $BOS7?%m%\%C%H!'#2Bf$K$h$k@QLZ$NJRIU$1(B
    
   $B#2Bf$,F1;~$KF10l$N@QLZ$rDO$b$&$H$7$?>u67$rA[Dj!%(B
   $B>e0L%(!<%8%'%s%H$K$h$k6%9g2r>C$r9T$J$&!%(B
   
 $B<B9TJ}K!!'(B
    compile arm3
    klic -o arm3 arm3.kl1 util.kl1 machine.kl1 
    arm3

       Copyright (c) 1998  Fumio Mizoguchi 

***/

/*** Root$B%(!<%8%'%s%H(B ***/
/* $B6%9g2r>C$r9T$J$&!%(B   */
:- agent(root).

 new :- 
    init,
    run([]).

 init :-
    machine:armSimulator(Machine),
    #robotic_agent:new(robot(Machine,12001,12002)),
    #robotic_agent:new(robot(Machine,12003,12004)).

 run(State) :- *before(Action,C) |
    put_occupation(State,NewState,Action,C),
    run(NewState).
 run(State) :- *after(Action,C) |
    delete_occupation(State,NewState,Action,C),
    run(NewState).


 delete_occupation([],NewState,Action,C) :-
    NewState = [].
 delete_occupation(State,NewState,Action,C) :- 
    State = [Action|NextState] |
    C = ok,
    delete_occupation(NextState,NewState,Action,C).
otherwise.
 delete_occupation([S|State],NewState,Action,C) :-
    NewState = [S|State2],
    delete_occupation(State,State2,Action,C).

 put_occupation([],NewState,Action,C) :-
    C = ok,
    NewState = [Action].
 put_occupation(State,NewState,Action,C) :-
    State = [Action|_] |
    C = no,
    NewState = State.
otherwise.
 put_occupation([S|State],NewState,Action,C) :-
    NewState = [S|State2],
    put_occupation(State,State2,Action,C).


/*** Robotic_agent$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%?%9%/$r2r<a$7(B               */
/* robot$B%(!<%8%'%s%H$X%3%^%s%I$rAw?.(B.                 */
/* $B$?$@$7!$Aw?.$9$kA0$K>e0L%(!<%8%'%s%H$K3NG'$r0MMj!%(B */
:- agent(robotic_agent). 

 new(Robot) :-
    init(Robot),  run.

 init(Robot) :-
    #robot:new(Robot).

 run :-
    do(pickup(0,350,0),[ok,C]).

 do(pickup(X,Y,R),[ok,C]) :-
    before(pickup(X,Y,R),[ok,C1]),
    do_it(pickup(X,Y,R),[C1,C2]),
    after(pickup(X,Y,R),[C2,C]).

 before(Action,[ok,C]) :-
    ^before(Action,C).

 do_it(Action,[ok,C]) :-
    *do(Action,[ok,C]).
 do_it(Action,[no,C]) :-
    C = no.

 after(Action,[ok,C]) :-
    ^after(X,Y,C).
 after(Action,[no,C]) :-
    C = no.


/*** robot$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%3%^%s%I$r2r<a$7(B     */
/* Socket$B%(!<%8%'%s%H$X%m%\%C%H%3%^%s%I$rAw?.(B */
:- agent(robot).
     
 new(Robot) :-
    init(Robot),
    run.

 init(robot(Host,OutPort,InPort)) :-
    #socket:new(Host,OutPort,InPort).

 run  :- ^do(pickup(XL,YL,RL),[ok,C]) |
    *do(mp(XL,YL,70,-90,RL),[ok,C1]),
    *do(mp(XL,YL,40,-90,RL),[C1,C2]),
    *do(gc,[C2,C3]),
    *do(mp(XL,YL,70,-90,RL),[C3,C4]),
    *do(mp(0,160,371,-90,0),[C4,C]),
    run.


/*** Socket$B%(!<%8%'%s%H(B ***/
/* $B>e0L%(!<%8%'%s%H$+$i$N%3%^%s%I$r%m%\%C%H%7%9%F%`$XAw?.(B */
:- agent(socket).

 new(Host,OutPort,InPort) :-
    util:connect(Host,OutPort) +Out,
    util:connect(Host,InPort) +In,
    run +Out +In.

 run +Out +In:- ^do(X,[ok,OK]) |
    util:command_to_string(X,Str),
    Out <= fwrite(Str,N),
    Out <= fflush(_),
    In <= fread(4,C),                        
    util:wait_ok(C,OK),
    run +Out +In.  


