/* 
 *  $B4D6-4F;k%7%9%F%`@\B3%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.net.URL;
import java.io.*;
import java.net.*;
import java.awt.*;


/* $B;k3P%;%s%5@\B3%&%$%s%I%&(B */
public class KL1Camera extends Dialog implements Runnable{
    PVS1 pvs;
    MessageDialog message;
    Thread thread = null;
    SocketConnect klic;
    KL1Watch kl1watch;
    TextField tx_mashin, tx_port;
    TextField kl1Port;
    String machine = "$Vision";
    int Robport = 12401;
    int klicP = 12401;
    int InPort = 12402;
    Panel p0 ;
    Panel p1 ;
    int mode;
    boolean connectC = false;

    public KL1Camera(PVS1 pvs, MessageDialog message, Frame parent) {
        super(parent, "ConnectCamera", false);
        setLayout(new BorderLayout());

        parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        parent.setLayout(new BorderLayout());
        parent.setResizable(false);
        parent.pack();

        this.pvs = pvs;
	this.message = message;
	this.mode = pvs.mode;
	kl1watch = new KL1Watch(pvs, InPort, message);
        p0 = new Panel();
        p1 = new Panel();
	
	p0.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        p0.add(new Label("Connect Camera"));
	add("North",p0);
	
	p1.setLayout(new GridLayout(2,4,5,5));

	p1.setFont(new Font("TimesRoman", Font.PLAIN, 14));
	p1.add(new Label("KL1Port = ",Label.RIGHT));
        p1.add(kl1Port = new TextField(""+klicP));
        p1.add(new Label("",Label.RIGHT));
        p1.add(new Label("",Label.RIGHT));
	p1.add(new Label("Server = ",Label.RIGHT));
        p1.add(tx_mashin = new TextField(machine));
        p1.add(new Label("Port = ",Label.RIGHT));
        p1.add(tx_port = new TextField(""+Robport));
	add("Center",p1);

	Panel south = new Panel();
        south.add(new Button("Connect"));
        south.add(new Button("KL1 Only"));
        south.add(new Button("Frash"));
        south.add(new Button("Quit"));
        add("South",south);

        resize(300, 180);
    }

    public void thread_start() {
        if(thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if(thread != null) {
            thread.stop();
            thread = null;
        }
    }

    public void thread_stop() {
        if(thread != null){
            thread = null;
        }
    }

    public synchronized void run(){
	Thread.currentThread().
              setPriority(Thread.MIN_PRIORITY);

        klic = new SocketConnect();
	// System.out.println("Connect Wait : Insight");
	
	boolean count = false;
	while(thread != null){
	    boolean a = klic.ServerConnect(klicP);
	    if(a == false) {
		String m = "Insight : can't open socket "+ klicP;
		message.message(m);
		thread_stop();
	    }
	    if(count) frash();
	    pvs.wd[mode].getInsightData(klic);
 	    // System.out.println("");
	    // System.out.println("Connect Success : Insight");
	    // System.out.println("");
	    count = true;
	}
    }

    public void frash(){
	pvs.wd[mode].vert = new VERT();
	pvs.wd[mode].block_num = 0;
	pvs.wd[mode].box_num = 0;
	pvs.wd[mode].md = null;
	pvs.layout = 0;
    }

    public boolean action(Event e, Object arg) {
        String label = (String)arg;
        if(label.equals("Quit")){
            hide();
            return true;
        }
	else if(label.equals("Frash")) {
	    frash();
	    return true;
	}
        else if(label.equals("Connect") || label.equals("KL1 Only") ||
		(e.target instanceof TextField)){
	    Double buffer;
	    String Mashin;
            int port;

	    klicP = Integer.valueOf(kl1Port.getText()).intValue();
	    
	    if(label.equals("KL1 Only") == false) {
		Mashin = tx_mashin.getText();
		buffer = Double.valueOf(tx_port.getText());
		Robport = (int)buffer.doubleValue();
		if(connectC == false){
		    boolean success = pvs.wd[mode].connectCamera(Mashin, Robport);
		    if(success) {
			connectC = true;
			//message.message("Connect Camera!");
		    }
		    else {
			message.message("Miss Connect !  Please Again");
			return true;
		    }
		}
	    }
	    this.thread_start();
	    hide();
	    return true;
	}

	else return false;
    }
}
