/* 
 *  $B4D6-4F;kMQ%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.net.URL;
import java.io.*;
import java.net.*;
import java.awt.*;

/*** $B4D6-4F;k%b%8%e!<%k(B ***/
class V_World implements Runnable{
    int Block = 2;
    int Box = 2;

    Model3D md;
    SocketConnect so_com;
    SocketConnect klic = null;
    boolean painted = true;
    boolean Robot = false;
    float xtheta, ytheta;
    String mdname = null;
    String message = null;
    VERT vert;
    MP_MJ mp_mj = new MP_MJ();
    double mpj_w = mp_mj.w, mpj_s = mp_mj.s;
    double mpj_e = mp_mj.e, mpj_p = mp_mj.p, mpj_r = mp_mj.r; 
    int fr_num;
    public boolean box=false,hold=false;
    boolean newobj = false;

    double obj[][] = new double[100][4];
    double box_data[][] = new double[10][7];
    double block_data[][] = new double[90][7];
    int obj_num = 0;
    int block_num = 0;
    int box_num = 0;
    double startTime = -1;

    String SS = "";
    Thread thread = null;
    PVS1 pvs;
    boolean obj_add = false;

    KL1Robot kr = null;
    int push_obj = 0;
    boolean calib = false;

    public V_World(PVS1 pvs){
	vert = new VERT();
	this.pvs = pvs;
    }

    public void calibStart(){
	calib = true;
    }

    public void kl1WatcherStart(SocketConnect klic) {
	so_com = klic;
	thread_start();
    }
    
    public void dataSend(){
	if(this.klic != null){
	    if(block_num > 0 || box_num > 0){
		boolean connect;
		String sendData = nowInsightData();
		connect = klic.SendKLIC(sendData);
		if(connect == false) {
		    System.out.println("KLIC Socket Close!!");
		    klic.Close();
		    klic = null;
		}
	    }
	}
    }

    public void pushObj(int num){
	push_obj = num;
    }

    public void changeStartTime(KL1Robot kr){
	this.kr = kr;
    }

    public void blockDrop(int db){
	block_data[db][3] = 20;
	for(int i=0; i<box_num; i++){
	    if(gosa(block_data[db][1],block_data[db][2],
		    box_data[i][1], box_data[i][2], 50) == false){
		block_data[db][0] = -1;
		i = box_num;
	    }
	}
    }

    public void getInsightData(SocketConnect klic){
	this.klic = klic;
	if(calib == false)
	  dataSend();
    }

    public int getBlockNumber(double p[]){
	int target = -1;
	for(int i=0; i<block_num; i++){
	    if(CheckGosaBlock(block_data[i], p, 20)){
		target = i+1;
		i = block_num;
	    }
	}
	return target;
    }

    public boolean CheckGosaBlock(double obj[], double p[], double go){
        double dx = -obj[1]-p[0];
        double dy = obj[2]-p[1];
        if (dx*dx + dy*dy  < go*go) {
            return true;
        }
        else return false;
    }

    public int[][] NowData(int me){
	int nowData[][] = new int[2][10];
	int nBlock = 0, nBox = 0;
	for(int i=0; i < box_num; i++){
	    if(box_data[i][5] == me){
		nBox ++;
		nowData[0][nBox] = i+1;
	    }
	}
	for(int i=0; i < block_num; i++){
	    if(block_data[i][5] == me && block_data[i][0] == 0){
		nBlock ++;
		nowData[1][nBlock] = i+1;
		// System.out.println("CheckX");
	    }
	}
	nowData[0][0] = nBox;
	nowData[1][0] = nBlock;
	return nowData;
    }
    
    /* $B?7$?$JJ*BN>pJs$N<u$1$H$j(B */
    public int GetWorld(double data[][]){
	for(int i=0; i<obj_num; i++){
	    for(int j=0; j<4; j++){
		data[i][j] = obj[i][j];
	    }
	}
	int num = obj_num;
	obj_num = 0;
	return(num);
    }

    /* $B;k3P%;%s%5%7%9%F%`$H$NO"F0(B */
    public boolean connectCamera(String Mashin, int port){
	/* $B;k3P%;%s%5%7%9%F%`$H$N%=%1%C%H@\B3(B */
	so_com = new SocketConnect();
	boolean success = so_com.ClientConnect(Mashin,port);
	if(success){
	    /* $B4D6-4F;k%9%l%C%I$N%9%?!<%H(B */
	    thread_start();
	    return true;
	}
	else  return false;
    }
    
    /* $B?7%*%V%8%'%/%H$NG'<1(B */
    public void AddObj(String SS){
	obj_num = Change.obj(SS,obj);
	
	if(obj_num>0) newobj = true;
	obj_add = check_blbo(obj_num,obj);
	
	if(obj_add) {
	    if(klic != null && calib == false){
		boolean connect;
		String sendData = nowInsightData();
		connect = klic.SendKLIC(sendData);
		if(connect == false) {
		    System.out.println("KLIC Socket Close!!");
		    klic.Close();
		    klic = null;
		}
	    }
	    ChengeENV();
	}
    }

    public void ChengeENV(){
	Model3D m = new Model3D (vert,Robot);
	md = m;
	m.findBB();
	m.compress();
    }

    /* $B%*%V%8%'%/%H0LCV$N0\F0(B */
    public void MoveObj(int obj, int num, double loc[]){
	if(obj == 1){
	    block_data[num][0] = 0;
	    block_data[num][1] = -loc[0];
	    block_data[num][2] = loc[1];
	    block_data[num][3] = 20;
	    block_data[num][4] = loc[2];
	    vert.change_block(num, -loc[0]/10, loc[1]/10, loc[2]);
	}
	else if(obj == 0){
	    box_data[num][0] = 0;
	    box_data[num][1] = -loc[0];
	    box_data[num][2] = loc[1];
	    box_data[num][3] = 0;
	    box_data[num][4] = loc[2];
	    vert.change_box(num, -loc[0]/10, loc[1]/10, loc[2]);
	}
	Model3D m = new Model3D (vert,Robot);
	md = m;
	m.findBB();
	m.compress();
    }

    public String CheckCoron(String s){
	String rs = "";
	int i = 0;
	int count = 0;
	boolean next = true;
	while(next){
	    rs += s.substring(i, i+1);
	    if(":".equals(s.substring(i, i+1)) ||
	       ",".equals(s.substring(i, i+1))){
		count ++;
	    }
	    if(":".equals(s.substring(i, i+1))){
		next = false;
	    }
	    else i++;
	}
	if(count%4 !=0 && count != 1) {
	    rs = null;
	    System.out.println();
	    System.out.println("It Emargency ERROR   "+s);
	    System.out.println();
	}
	else rs += "\0";
	return rs;
    }

    /* $B4D6-4F;k%9%l%C%I(B */
    public void run(){
	String testSS = "";
	// System.out.println("Read Start");
	while(thread != null){
	    Thread.currentThread().
              setPriority(Thread.MIN_PRIORITY);

	    /* $B;k3P%;%s%5$+$i>pJs$NFI$_$H$j(B */
	    boolean waitRead = true;
	    while(waitRead){
		testSS = "";
		testSS = so_com.ReadKLIC();
		if(testSS == null) {
		    testSS = ":";
		    waitRead = false;
		    so_com.Close();
		    thread = null;
		}
		SS = CheckCoron(testSS);
		if(SS != null) waitRead = false;
	    }
	    /*
	    if(klic != null){
		boolean connect = klic.SendKLIC(SS);
		if(connect == false) {
		    System.out.println("KLIC Socket Close!!");
		    klic.Close();
		    klic = null;
		}
	    }
	    */
	    //System.out.println("Read Data: "+SS);

	    /* $B%9%H%j%s%0%G!<%?$+$i?tCM%G!<%?$X(B */
	    if(":".equals(SS.substring(0,1)) == false) {
		obj_num = Change.obj(SS,obj);
		obj_add = check_blbo(obj_num,obj);
	    }
	    else obj_add = false;
	    if(obj_add) {
		if(klic != null && calib == false){
		    boolean connect;
		    String sendData = nowInsightData();
		    connect = klic.SendKLIC(sendData);
		    if(connect == false) {
			System.out.println("KLIC Socket Close!!");
			klic.Close();
			klic = null;
		    }
		}
		Model3D m = new Model3D (vert,Robot);
		md = m;
		m.findBB();
		m.compress();
		newobj = true;
	    }
	}
    }

    public String nowInsightData(){
	String Data = "";
	for(int i=0; i < box_num; i++){
	    Data += (int)box_data[i][6] + ",";
	    Data += -(int)box_data[i][1] + ",";
	    Data += (int)box_data[i][2] + ",";
	    Data += (int)box_data[i][4] + ",";
	}
	for(int i=0; i < block_num; i++){
	    if(block_data[i][0] == 0){
		Data += (int)block_data[i][6] + ",";
		Data += -(int)block_data[i][1] + ",";
		Data += (int)block_data[i][2] + ",";
		Data += (int)block_data[i][4] + ",";
	    }
	}
	Data = Data.substring(0, Data.length()-1);
	Data += ":\0";
	return Data;
    }

    /* $B%*%V%8%'%/%H>pJs$N%N%$%:=hM}(B */
    public boolean check_blbo(int num, double obj[][]){
	int owner = 0;
	boolean real , outrenge, add_O = false;
        for(int i=0;i<num;i++){
	    real = true;
	    for (int j=0; j<block_num && real == true; j++){
		real = gosa(block_data[j][1],block_data[j][2],
			    obj[i][1],obj[i][2],40);
	    }
	    for (int j=0; j<box_num && real == true; j++){
		real = gosa(box_data[j][1],box_data[j][2],
			    obj[i][1],obj[i][2],80);
	    }
	    for (int j=1; j<=pvs.robot_num[pvs.mode] && real == true; j++){
		real = gosa(pvs.LR[pvs.mode][j][0],pvs.LR[pvs.mode][j][1],
			    obj[i][1],obj[i][2],240);
	    }
	    outrenge = true;
	    for (int j=1; j<=pvs.robot_num[pvs.mode] && 
		 outrenge == true; j++){
		outrenge = gosa(pvs.LR[pvs.mode][j][0],pvs.LR[pvs.mode][j][1],
			    obj[i][1],obj[i][2],399);
		if(outrenge == false) {
		    outrenge = rob_or_obj(j,obj[i][1],obj[i][2],0);
		}
		if(outrenge == false) {
		    outrenge = rob_or_obj(j,obj[i][1],obj[i][2],1);
		}
		if(outrenge == false) {
		    owner = j;
		}
	    }

	    if(real == true && outrenge == false || calib){
		if((obj[i][0]==1 || obj[i][0]==3) && block_num < 90){
		    if(calib) {
			block_num = 0;
			box_num = 0;
		    }
		    add_O = true;
		    block_data[block_num][0] = 0;
		    block_data[block_num][1] = obj[i][1];
		    block_data[block_num][2] = obj[i][2];
		    block_data[block_num][3] = 20;
		    block_data[block_num][4] = obj[i][3];
		    block_data[block_num][5] = owner;
		    block_data[block_num][6] = obj[i][0];
		    vert.block(obj[i][1]/10,obj[i][2]/10,obj[i][3],obj[i][0]);
		    block_num ++;
		    if(kr != null)
		      kr.addBlock(block_num, owner, obj[i][0]);
		}
		else if(obj[i][0] == 0 || obj[i][0] == 2 ){
		    add_O = true;
		    //target.Box(1);
		    box_data[box_num][0] = 0;
		    box_data[box_num][1] = obj[i][1];
		    box_data[box_num][2] = obj[i][2];
		    box_data[box_num][3] = 0;
		    box_data[box_num][4] = obj[i][3];
		    box_data[box_num][5] = owner;
		    box_data[box_num][6] = obj[i][0];
		    vert.box(obj[i][1]/10,obj[i][2]/10,obj[i][3],obj[i][0]);
		    box_num ++;
		}
		pvs.ReLayout();
	    }
	    /* else if(real == false) System.out.println("double point!");
	    else if(outrenge == true)
	      System.out.println("Out point!");
	    else System.out.println("?????? point"); */
        }
	return add_O;
    }
    public boolean rob_or_obj(int r, double x, double y, int g){
	double xr,yr, xx = 1;
	if(g == 0){
	    xr = pvs.n[pvs.mode][r].point[0];
	    yr = pvs.n[pvs.mode][r].point[1];
	}
	else {
	    xr = pvs.n[pvs.mode][r].old_point[0];
	    yr = pvs.n[pvs.mode][r].old_point[1];
	}
	
	if(pvs.n[pvs.mode][r].running == true) 
	  xx = 4;
	if(pvs.n[pvs.mode][r].point[2] > 390)
	  xx = 9;

	double xy[] = {x,y};
	double oxy[] = RW_change(r, xy);

	double dx = xr-oxy[0];
        double dy = yr-oxy[1];

	/* 
	   System.out.println("xr = "+xr+", yr = "+yr);
	   System.out.println("oxy0 = "+oxy[0]+", oyr = "+oxy[1]);
	   System.out.println(dx+","+dy);
	   */

	if (dx*dx + dy*dy  <  100*100*xx) {
	    /*System.out.println(x+","+y+","+oxy[0]+","+oxy[1]+", is Robot");*/
	    
            return true;
        }
        else return false;
    }
    public boolean gosa(double x1, double y1, double x2, double y2, int len) {
	double dx = x1-x2;
        double dy = y1-y2;

	if (dx*dx + dy*dy  <  len*len) {
	    //System.out.println(x1+","+y1+","+x2+","+y2+","+len);
            return false;
        }
        else return true;
    }
    public double[] RW_change(int r, double obj[]){
        double Rx = pvs.LR[pvs.mode][r][0];
        double Ry = pvs.LR[pvs.mode][r][1];
        double Rz = pvs.LR[pvs.mode][r][2];
        double rw_obj[] = new double[2];
        double Rkr = -Rz*0.017453292;
        double Rrx = obj[0] - Rx;
        double Rry = obj[1] - Ry;
        double Rr = Math.sqrt(Rrx*Rrx+Rry*Rry);
        double S = Math.asin(Rry/Rr);
        if(Rrx < 0.0 && Rry >= 0.0) S = 3.141592 - S;
        else if(Rrx < 0.0 && Rry < 0.0) S = -3.141592 - S;
        rw_obj[0] = Rr*Math.cos(S-Rkr);
        rw_obj[1] = Rr*Math.sin(S-Rkr);
        return rw_obj;
    }

    public void thread_start() {
        if(thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    public void stop() {
        if(thread != null) {
	    if(klic != null){
		klic.Close();
		klic = null;
	    }
            thread.stop();
            thread = null;
        }
    }
}
