/* 
 *  $B%a%$%s%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.awt.*;

public class RS1 extends Applet{

/* $B=i4|%&%$%s%I%&(B $B5Z$S(B $B%5%V%&%$%s%I%&$N@_Dj(B */

    Panel P,p0,p1,p2;
    PVS1 pvs;
    MessageDialog message;
    Thread anime;
    Frame frame2, frame3, frame5, frame6;
    Frame frame11, frameKL1, frameKLC;
    Add_obj addobj = null;
    Mover mover = null;
    Location location = null;
    KL1Camera kl1Camera = null;
    ConnectKL1 kl1 = null;
    Viewwin viewwin = null;

    Button but1, but2, but3, but4, but5, but6, but7, but8;
    Image imgs[];

    boolean mover_open = false;
    boolean locate_open = false;

    /* $B=i4|@_Dj(B */
    public void init(){
	pvs = new PVS1(this);

	frame2 = new Frame("Add Obj");
	frame3 = new Frame("Mover");
	frame5 = new Frame("Message");
	frame6 = new Frame("Location");
	frame11 = new Frame("VIEWPOINT");
	frameKL1 = new Frame("KL1");
	frameKLC = new Frame("KL1 Camera");

	message = new MessageDialog(frame5);

	setLayout(new BorderLayout());
	P = new Panel();
	p0 = new Panel();
	p1 = new Panel();
	p2 = new Panel();
	
	setFont(new Font("TimesRoman", Font.PLAIN, 15));

	P.setLayout(new BorderLayout());
	p0.setLayout(new GridLayout(4,1,1,1));
	p1.setLayout(new GridLayout(4,1,1,1));
	p2.setLayout(new GridLayout(1,3,0,0));

	p0.add(but1 = new Button("Robot"));
	p0.add(but2 = new Button("Camera"));
	p0.add(but3 = new Button("Locate"));

	p1.add(but4 = new Button("Mover"));
	p1.add(but5 = new Button("Add Object"));
	p1.add(but6 = new Button("ViewPoint"));
	
	p2.add(new Label("     "));
	Choice mode = new Choice();
        mode.addItem("MONITOR");
        p2.add(mode);
	p2.add(new Label("     "));
	
	add("Center",pvs);
	add("North",P);
	P.add("West",p0);
	P.add("East",p1);
	add("South",p2);

	setSize(getSize().width <= 20 ? 400 : getSize().width,
		getSize().height <= 20 ? 400 : getSize().height); 
    }
    
    /* $B%"%K%a!<%7%g%s%9%l%C%I$N%9%?!<%H(B */
    public void start() {
	anime = new Thread(pvs);
	anime.start();
    }
    
    public void stop() {
	anime.stop();
    }
    
    
    /* $B%$%Y%s%H=hM}(B */
    public boolean handleEvent(Event e) {
	switch (e.id) {
        case Event.WINDOW_DESTROY:
            System.exit(0);
            return true;
        case Event.ACTION_EVENT:
	    /* $B%*%V%8%'%/%H$NDI2C(B */
	    if("Add Object".equals(e.arg)) {
		if(addobj == null)
		  addobj = new Add_obj(pvs, frame2);
		addobj.setVisible(true);
		//pvs.wd.AddObj("0,500,0,0,1,-500,0,0");
		return true;
	    }
	    else if("Camera".equals(e.arg)) {
		if(kl1Camera == null)
		  kl1Camera = new KL1Camera(pvs, message, frameKLC);
		kl1Camera.setVisible(true);
		return true;
	    }
	    /* $B:BI83NG'%&%$%s%I%&(B */
	    else if("Locate".equals(e.arg)) {
		if(locate_open) location.ender();
		location = new Location(pvs, frame6, this);
		location.setVisible(true);
		locate_open = true;
		return true;
	    }
	    /* $B%m%\%C%HF0:n%&%$%s%I%&(B */
	    else if("Mover".equals(e.arg) && pvs.robot_num[pvs.mode]>0) {
		if(mover_open) mover.setVisible(false);
		mover = new Mover(pvs, frame3);
		mover_open = true;
		mover.setVisible(true);
		return true;
	    }
	    /* VIEW$B%&%$%s%I%&(B */
	    else if("ViewPoint".equals(e.arg)) {
		if(viewwin == null)
		  viewwin = new Viewwin(pvs,frame11);
		viewwin.setVisible(true);
		return true;
	    }
	    else if("Robot".equals(e.arg)) {
		if(kl1 == null)
		  kl1 = new ConnectKL1(pvs, message, frameKL1);
		kl1.show_open();
		return true;
	    }
        default:            
            return false;
	}
    }

    public void locate_start(){
	if(locate_open) {
	    location.ender();
	    if(pvs.robot_num[pvs.mode] > 0) {
		location = new Location(pvs, frame6, this);
		location.setVisible(true);
	    }
	    else locate_open = false;
	}
    }

}


/* $B%*%V%8%'%/%HDI2C%&%$%s%I%&$N:n@.(B */
class Add_obj extends Dialog {
    public static final int Block = 1;
    public static final int Box = 0;
    
    PVS1 pvs;
    TextField tx,ty,tz;
    
    int o_mode = Block;
    
    /* $B=i4|@_Dj(B */
    public Add_obj(PVS1 pvs, Frame parent) {
	super(parent, "AddObj", false);
        setLayout(new BorderLayout());

        parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("TimesRoman", Font.PLAIN, 14));
        parent.setLayout(new BorderLayout());
        parent.setResizable(false);
        parent.pack();

	this.pvs = pvs;

	Panel p0 = new Panel();
	Choice Onum = new Choice();
	Onum.addItem("Block");
	Onum.addItem("Box");
        p0.add(Onum);
        p0.setFont(new Font("TimesRoman", Font.PLAIN, 18));
	p0.add(new Label("Object  Locate  "));

	add("North",p0);

	Panel p1 = new Panel();
	p1.setLayout(new GridLayout(1,6,2,5));
	p1.add(new Label("X =",Label.RIGHT));
	p1.add(tx = new TextField("0",5));
	p1.add(new Label("Y =",Label.RIGHT));
	p1.add(ty = new TextField("0",5));
	p1.add(new Label("R =",Label.RIGHT));
	p1.add(tz = new TextField("0",5));

	add("Center",p1);

        Panel south = new Panel();
        south.setFont(new Font("TimesRoman", Font.PLAIN, 18));
	south.add(new Button("Add"));
	south.add(new Button("Clear"));
        south.add(new Button("Quit"));
        add("South",south);

        setSize(320, 144);
    }

    /* $B%$%Y%s%H=hM}(B */
    public boolean action(Event e, Object arg) {
        String label = (String)arg;
	if(label.equals("Quit")){
            setVisible(false);
	    return true;
        }
	else if(label.equals("Clear")){
	    tx.setText("");
	    ty.setText("");
	    tz.setText("");
	    return true;
	}
	else if(label.equals("Add") || 
	  (e.target instanceof TextField)){
	    Double buffer;
	    double x,y,z;
	    buffer = Double.valueOf(tx.getText());
	    x = buffer.doubleValue();

	    buffer = Double.valueOf(ty.getText());
	    y = buffer.doubleValue();

	    buffer = Double.valueOf(tz.getText());
	    z = buffer.doubleValue();

	    String SS = o_mode+","+x+","+y+","+z+":";

	    pvs.wd[pvs.mode].AddObj(SS);
	    setVisible(false);
	    return true;
	}
	/* $B%\%C%/%9(B $B5Z$S(B $B%V%m%C%/$NJQ99(B */
	else if (e.target instanceof Choice) {
	    String choice = (String)arg;
	    
	    if(choice.equals("Block")){
		o_mode = Block;
		return true;
	    }
	    else if(choice.equals("Box")){
		o_mode = Box;
		return true;
	    }
	    return true;
	}
	else   return false;
    }
}


/* $B%m%\%C%HF0:n%&%$%s%I%&$N:n@.(B */
class Mover extends Dialog implements Runnable{
    public static final int NO[] = {0,1,2,3,4,5,6,7,8,9};
    int r_mode = NO[1];
    boolean real = false;
    int mode;
    PVS1 pvs;
    TextField command;
    Thread thread = null;
    
    /* $B=i4|@_Dj(B */
    public Mover(PVS1 pvs, Frame parent) {
        super(parent, "Mover", false);
        setLayout(new BorderLayout());

        parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("TimesRoman", Font.PLAIN, 14));
        parent.setLayout(new BorderLayout());
        parent.setResizable(false);
        parent.pack();

	this.pvs = pvs;
	this.mode = pvs.mode;

        Panel p0 = new Panel();
        Choice Rnum = new Choice();
	Choice Rmode = new Choice();

	if(mode == pvs.REAL || mode == pvs.MONITOR) {
	    Rmode.addItem("Real");
	    real = true;
	}
	else real = false;
	Rmode.addItem("Vertual");
	p0.add(Rmode);
        for(int i = 1; i <= pvs.robot_num[pvs.mode]; i++)
          Rnum.addItem("No."+i);
        p0.add(Rnum);
        p0.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        p0.add(new Label("Robot Mover : Input Command !!"));

        add("North",p0);

	Panel p1 = new Panel();
	Choice Com = new Choice();
	Com.addItem("World Point");
	Com.addItem("Move Command");
	Com.addItem("Grip Close");
	Com.addItem("Grip Open");
	Com.addItem("Home Position");
	p1.add(Com);
	p1.add(new Label(" "));
	p1.add(command = new TextField("",30));
	add("Center",p1);
	
	Panel south = new Panel();
        south.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        south.add(new Button("Send"));
        south.add(new Button("Clear"));
        south.add(new Button("Quit"));
        add("South",south);

        setSize(550, 150);
    }

    /* $B%m%\%C%HF0:n%9%l%C%I(B */
    public void run(){
	String S = command.getText();
	if(real == true) pvs.realCommand(r_mode,S);
	pvs.sendCommand(r_mode,mode,S);
	if(real == true && pvs.success[r_mode] == true) {
	    Thread.currentThread().
	      setPriority(Thread.MIN_PRIORITY);
	    pvs.returnCommandstart(r_mode);
	}
	thread = null;
    }

    public void thread_start() {
        if(thread == null) {
            thread = new Thread(this);
            thread.start();
        }
    }

    public void thread_stop() {
        if(thread != null) {
            thread.stop();
            thread = null;
        }
    }


    /* $B%$%Y%s%H=hM}(B */
    public boolean action(Event e, Object arg) {
        String label = (String)arg;
        if(label.equals("Quit")){
            setVisible(false);
            return true;
        }
	else if(label.equals("Clear")){
	    command.setText("");
	    return true;
	}
        else if(label.equals("Send") ||
          (e.target instanceof TextField)){
	    
	    /* $B%m%\%C%HF0:n%9%l%C%I%9%?!<%H(B */

	    thread_start();
	    return true;
	}
	else if (e.target instanceof Choice) {
            String choice = (String)arg;
	    if(choice.equals("Real")) {
		real = true;
		return true;
	    }
	    else if(choice.equals("Vertual")) {
		real = false;
		return true;
	    }
	    else if(choice.equals("World Point")) {
		command.setText("wmp ");
		return true;
	    }

	    else if(choice.equals("Move Command")) {
		command.setText("mp ");
		return true;
	    }
	    else if(choice.equals("Grip Close")) {
		command.setText("gc");
		return true;
	    }
	    else if(choice.equals("Grip Open")) {
		command.setText("go");
		return true;
	    }
	    else if(choice.equals("Home Position")) {
		command.setText("home");
		return true;
	    }
	    else for(int i = 1; i<=pvs.robot_num[pvs.mode]; i++){
                if(choice.equals("No."+i)){
                    r_mode = NO[i];
                    i = pvs.robot_num[pvs.mode]+1;
                    return true;
                }
            }
	    return true;
	}
	else   return false;
    }
}




/* $B:BI83NG'%&%$%s%I%&$N:n@.(B */
class Location extends Dialog {
    RS1 rs;
    PVS1 pvs;
    Panel p0,p1;
    int rob_num, blo_num, box_num, mode;
    boolean push = false;
    CheckboxGroup cg;

    public Location(PVS1 pvs, Frame parent, RS1 rs) {
	super(parent, "Location", false);
        setLayout(new BorderLayout());

        parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        parent.setLayout(new BorderLayout());
        parent.setResizable(false);
        parent.pack();

        this.pvs = pvs;
	this.rs = rs;
	locate();
    }

    public void locate() {
	p0 = new Panel();
	p1 = new Panel();

	p0.setFont(new Font("TimesRoman", Font.PLAIN, 24));
	p0.add(new Label("The Location",Label.CENTER));
	add("North",p0);
	
	p1.setFont(new Font("TimesRoman", Font.PLAIN, 18));
	mode = pvs.mode;
	rob_num = pvs.robot_num[mode];
	blo_num = pvs.wd[mode].block_num;
	box_num = pvs.wd[mode].box_num;

	int all_obj = rob_num + blo_num + box_num + 1;

	cg = new CheckboxGroup();

	p1.setLayout(new GridLayout(all_obj, 2, 20, 0));

	p1.add(new Checkbox("Clear",cg,true));
	p1.add(new Label(""));
	for(int i = 1; i <= rob_num; i++) {
	    p1.add(new Checkbox("Robot No."+i, cg, false));
	    p1.add(new Label("( " + -Math.rint(pvs.LR[mode][i][0])+" , " +
			     Math.rint(pvs.LR[mode][i][1])+" , " +
			     Math.rint(pvs.LR[mode][i][2])+" )",Label.LEFT));
	}
	for(int i = 0; i < blo_num; i++) {
	    int num = i+1;
	    p1.add(new Button("Block No."+num));
	    p1.add(new Label("( " + -Math.rint(pvs.wd[mode].block_data[i][1])
			     +" , " +Math.rint(pvs.wd[mode].block_data[i][2])
			     +" , " +Math.rint(pvs.wd[mode].block_data[i][4])
			     +" )",Label.LEFT));
	}
	for(int i = 0; i < box_num; i++) {
	    int num = i+1;
	    p1.add(new Button("Box No."+num));
	    p1.add(new Label("( " + -Math.rint(pvs.wd[mode].box_data[i][1])
			     +" , " +Math.rint(pvs.wd[mode].box_data[i][2])
			     +" , " +Math.rint(pvs.wd[mode].box_data[i][4])
			     +" )",Label.LEFT));
	}
	
	add("Center",p1);

        Panel south = new Panel();
        south.add(new Button("Quit"));
        add("South",south);

        setSize(300, 140+all_obj*25);
    }

    public void clear_color(boolean all) {
	for(int i = 1; i <= rob_num; i++) 
	  pvs.n[mode][i].push_rec = 0;
	if(all)
	  pvs.wd[mode].pushObj(0);
    }

    public boolean action(Event e, Object arg) {
	/* Robot$B%J%s%P!<$r%/%j%C%/$9$k$H3($N?'$,JQ$o$k(B */
	if(e.target instanceof Checkbox) {
	    Checkbox c = (Checkbox)(e.target);
	    if(((Boolean)arg).booleanValue()) {
		for(int i = 1; i <= rob_num; i++) {
		    if(c.getLabel().equals("Robot No."+i)) {
			clear_color(false);
			pvs.n[mode][i].push_rec = 1;
			//System.out.println("Push Key : "+i);
			return true;
		    }
		}
		if(c.getLabel().equals("Clear")) {
		    clear_color(true);
		    //System.out.println("Clear");
		}
	    }
	    return true;
	}
	else {
	    String label = (String)arg;
	    for(int i=0; i < blo_num; i++){
		int num = i+1;
		if(label.equals("Block No."+num)){
		    pvs.wd[mode].pushObj(num);
		    return true;
		}
	    }
	    for(int i=0; i < box_num; i++){
		int num = i+1;
		if(label.equals("Box No."+num)){
		    pvs.wd[mode].pushObj(num+blo_num);
		    return true;
		}
	    }
	    if(label.equals("Quit")){
		clear_color(true);
		rs.locate_open = false;
		setVisible(false);
		dispose();
		return true;
	    }
	}

	return false;
    }
    
    public void ender() {
	clear_color(true);
	dispose();
	setVisible(false);
    }

}

