/* 
 *  $B#3#D2hA|IA2h%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

/* A set of classes to parse, represent and display 3D wireframe models
   represented in Wavefront .obj format. */

import java.applet.Applet;
import java.net.URL;
import java.io.*;
import java.net.*;
import java.awt.*;

class FileFormatException extends Exception {
    public FileFormatException(String s) {
	super(s);
    }
}

/** The representation of a 3D model */
class Model3D {
    float vert[];
    int tvert[];
    int nvert, maxvert;
    int con[];
    int ncon, maxcon;
    boolean transformed, robot;
    Matrix3D mat;

    float xmin, xmax, ymin, ymax, zmin, zmax;

    Model3D () {
	mat = new Matrix3D ();
	mat.xrot(20);
	mat.yrot(30);
    }
    /** Create a 3D model by parsing an input stream */
    Model3D (VERT vert, boolean robot) {
	this();
	int m,k=0;
	this.robot = robot;
	if(robot == true) m = 8;
	else m = 0;
	for(int i=0;i<m;i++){
	    for(int j=0;j<8;j++){
		addVert((float) vert.x[i][j], 
			(float) vert.z[i][j], 
			(float) vert.y[i][j]);

		//System.out.println("B"+vert.x[i][j]+
				     //","+vert.y[i][j]+","+vert.z[i][j]);
	  }
	    for(int l=0;l<4;l++){
		if(l==3){
		    add(k+l, k);
		    add(k+l+4, k+4);
		}else {
		    add(k+l, k+l+1);
		    add(k+l+4, k+l+5);
		}
		add(k+l, k+l+4);
	    }
	    k += 8;
	}

	for(int i=0;i<vert.block_num;i++){
	    for(int j=0;j<8;j++){
		addVert((float) vert.block_x[i][j], 
			(float) vert.block_z[i][j], 
			(float) vert.block_y[i][j]);

		//System.out.println("A"+vert.block_x[i][j]+","
				     //+vert.block_y[i][j]+","
				     //+vert.block_z[i][j]);
	    }
	    for(int l=0;l<4;l++){
		if(l==3){
		    add(k+l, k);
		    add(k+l+4, k+4);
		}else {
		    add(k+l, k+l+1);
		    add(k+l+4, k+l+5);
		}
		add(k+l, k+l+4);
	    }
	    k += 8;
	}

	for(int i=0;i<vert.box_num;i++){
	    for(int j=0;j<8;j++){
		addVert((float) vert.box_x[i][j], 
			(float) vert.box_z[i][j], 
			(float) vert.box_y[i][j]);

		//System.out.println("A"+vert.box_x[i][j]+","
				     //+vert.box_y[i][j]+","
				     //+vert.box_z[i][j]);
	    }
	    for(int l=0;l<4;l++){
		if(l==3){
		    add(k+l, k);
		    add(k+l+4, k+4);
		}else {
		    add(k+l, k+l+1);
		    add(k+l+4, k+l+5);
		}
		add(k+l, k+l+4);
	    }
	    k += 8;
	}

//	for(int i=0;i<9;i++)
//	  for(int j=0;j<8;j++)
//	    System.out.println(""+vert.x[i][j]+","+vert.y[i][j]+","+vert.z[i][j]);
//	for(int i=block_num;i<vert.block_num;i++)
//	  for(int j=0;j<8;j++)
//	    System.out.println(""+vert.block_x[i][j]+","+vert.block_y[i][j]+","+vert.block_z[i][j]);
    }

    /** Add a vertex to this model */
    int addVert(float x, float y, float z) {
	int i = nvert;
	if (i >= maxvert)
	    if (vert == null) {
		maxvert = 100;
		vert = new float[maxvert * 3];
	    } else {
		maxvert *= 2;
		float nv[] = new float[maxvert * 3];
		System.arraycopy(vert, 0, nv, 0, vert.length);
		vert = nv;
	    }
	i *= 3;
	vert[i] = x;
	vert[i + 1] = y;
	vert[i + 2] = z;
	return nvert++;
    }
    /** Add a line from vertex p1 to vertex p2 */
    void add(int p1, int p2) {
	int i = ncon;
	if (p1 >= nvert || p2 >= nvert)
	    return;
	if (i >= maxcon)
	    if (con == null) {
		maxcon = 100;
		con = new int[maxcon];
	    } else {
		maxcon *= 2;
		int nv[] = new int[maxcon];
		System.arraycopy(con, 0, nv, 0, con.length);
		con = nv;
	    }
	if (p1 > p2) {
	    int t = p1;
	    p1 = p2;
	    p2 = t;
	}
	con[i] = (p1 << 16) | p2;
	ncon = i + 1;
    }
    /** Transform all the points in this model */
    void transform() {
	if (transformed || nvert <= 0)
	    return;
	if (tvert == null || tvert.length < nvert * 3){
	    tvert = new int[nvert*3];
	}
	mat.transform(vert, tvert, nvert);
	
//	System.out.println("nvert = "+nvert);

/*	for(int zz=0; zz < vert.length; zz=zz+3){
	    System.out.println("vert = "+vert[zz]+","+vert[zz+1]+","+vert[zz+2]);
	}

	for(int zz=0; zz < tvert.length; zz=zz+3){
	    System.out.println("tvert = "+tvert[zz]+","+tvert[zz+1]+","+tvert[zz+2]);
	} */


	transformed = true;
    }

    private void sort(int lo0, int hi0) {
	int a[] = con;
	int lo = lo0;
	int hi = hi0;
	if (lo >= hi)
	    return;
	int mid = a[(lo + hi) / 2];
	while (lo < hi) {
	    while (lo < hi && a[lo] < mid) {
		lo++;
	    }
	    while (lo < hi && a[hi] >= mid) {
		hi--;
	    }
	    if (lo < hi) {
		int T = a[lo];
		a[lo] = a[hi];
		a[hi] = T;
	    }
	}
	if (hi < lo) {
	    int T = hi;
	    hi = lo;
	    lo = T;
	}
	sort(lo0, lo);
	sort(lo == lo0 ? lo + 1 : lo, hi0);
    }

    /** eliminate duplicate lines */
    void compress() {
	int limit = ncon;
	int c[] = con;
	sort(0, ncon - 1);
	int d = 0;
	int pp1 = -1;
	for (int i = 0; i < limit; i++) {
	    int p1 = c[i];
	    if (pp1 != p1) {
		c[d] = p1;
		d++;
	    }
	    pp1 = p1;
	}
	ncon = d;
    }

    static Color gr[];

    /** Paint this model to a graphics context.  It uses the matrix associated
	with this model to map from model space to screen space.
	The next version of the browser should have double buffering,
	which will make this *much* nicer */
    boolean paint(Graphics g , int push_num) {

	if (vert == null || nvert <= 0){
	    System.out.println("paintreturn !!  "+ nvert);
	    return false;
	}
	transform();
	if (gr == null) {
	    gr = new Color[16];
	    for (int i = 0; i < 16; i++) {
		int grey = (int) (170*(1-Math.pow(i/15.0, 2.3)));
		gr[i] = new Color(grey, grey, grey);
	    }
	}

	int lim = ncon;
	int c[] = con;
	int v[] = tvert;
	if (lim <= 0 || nvert <= 0)
	    return false;

	for (int i = 0; i < lim; i++) {
	    int T = c[i];

	    int p1 = ((T >> 16) & 0xFFFF) * 3;
	    int p2 = (T & 0xFFFF) * 3;
	    
	    int grey = v[p1 + 2] + v[p2 + 2];
	    if (grey < 0)
	      grey = 0;
	    if (grey > 15)
	      grey = 15;
	    if(robot == false) {
		//System.out.println("Lim = "+lim);
		g.setColor(Color.red);
		if(push_num > 0){
		    if( (push_num-1) * 12 <= i && i < push_num * 12) {
			g.setColor(Color.yellow);     
		    }
		}
	    }
	    else {
		if(push_num > 0) g.setColor(Color.blue);
		else g.setColor(gr[grey]);
	    }

	    g.drawLine(v[p1], v[p1 + 1],
			   v[p2], v[p2 + 1]);
	}
	return true;
    }

    /** Find the bounding box of this model */
    void findBB() {
	if (nvert <= 0)
	    return;
	float v[] = vert;
	float xmin = v[0], xmax = xmin;
	float ymin = v[1], ymax = ymin;
	float zmin = v[2], zmax = zmin;
	for (int i = nvert * 3; (i -= 3) > 0;) {
	    float x = v[i];
	    if (x < xmin)
		xmin = x;
	    if (x > xmax)
		xmax = x;
	    float y = v[i + 1];
	    if (y < ymin)
		ymin = y;
	    if (y > ymax)
		ymax = y;
	    float z = v[i + 2];
	    if (z < zmin)
		zmin = z;
	    if (z > zmax)
		zmax = z;
	}
	this.xmax = xmax;
	this.xmin = xmin;
	this.ymax = ymax;
	this.ymin = ymin;
	this.zmax = zmax;
	this.zmin = zmin;
    }
}
