/* 
 *  $B%m%\%C%H@)8f%7%9%F%`!u(BKLIC$B%7%9%F%`@\B3%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.net.URL;
import java.util.*;
import java.awt.*;
import java.io.*;

/* $B<B%m%\%C%H@\B3%&%$%s%I%&(B */
public class KL1Robot extends Dialog {
    PVS1 pvs;
    MessageDialog message;
    int kl1Port[][], robotPort[];
    String robotMashine[];
    TextField command[] = new TextField[10];
    TextField target[] = new TextField[10];
    String robotChart[] = {"","","","","","","","","",""};
    String blockChart = "";
    int robotTarget[] = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};
    Choice rnum;
    boolean real;
    KL1Chart kl1Chart;
    int robotNumber;
    double startTime = -1;
    int mode;

    KL1Chat kl1chat[] = new KL1Chat[10];
    double rData[][];
    
    public KL1Robot(PVS1 pvs, MessageDialog message,
		    ConnectKL1 connect, Frame parent) {
	
	super(parent, "KL1Robot", false);
        setLayout(new BorderLayout());

        parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        parent.setLayout(new BorderLayout());
        parent.setResizable(false);
        parent.pack();

        this.pvs = pvs;
        this.message = message;
	mode = pvs.mode;
	kl1Port = connect.rre;
	robotPort = connect.rP;
	robotMashine = connect.rM;
	rData = connect.rData;
	robotNumber = connect.Num;
	kl1Chart = new KL1Chart(robotNumber, this, parent);
	
	Panel p0 = new Panel();
        Panel p1 = new Panel();
	Panel p2 = new Panel();

        p0.setFont(new Font("TimesRoman", Font.PLAIN, 22));

	rnum = new Choice();
        rnum.addItem("Virtual");
        rnum.addItem("Real");
        rnum.addItem("Calib");
	real = false;
	p0.add(rnum);
        p0.add(new Label("  Monitor Robot Moving"));
        add("North",p0);

        p1.setLayout(new GridLayout(robotNumber,2,5,3));
	p2.setLayout(new GridLayout(robotNumber,1,5,3));
        for(int i = 1; i <= robotNumber; i++) {
            p1.add(new Label("Robot"+i+" Command : ",Label.RIGHT));
            command[i] = new TextField("No Connect");
            target[i] = new TextField("No Target");
            p1.add(command[i]);
            p2.add(target[i]);
            kl1chat[i] = new KL1Chat(i, this);
        }
        add("Center",p1);
	add("East",p2);
        Panel south = new Panel();
        south.add(new Button("Chart"));
        south.add(new Button("Save"));
        south.add(new Button("Quit"));
        add("South",south);

        setSize(550,130+robotNumber*35);
	setVisible(true);
    }

    public double[] getPoint(String s){
        int ov = 3;
        String ds, str = "";
        double data[] = new double[3];
        int num = 0;
        for(int i=ov; i < s.length(); i++){
            ds = s.substring(i, i+1);
            if(",".equals(ds)) {
                data[num] = Double.valueOf(str).doubleValue();
                str = "";
                num ++;
		if(num == 3) i = s.length();
            }
            else str = str + ds;
        }
        if(num != 3) System.out.println("Data 0 Error!!!");
        return data;
    }

    /* $B%m%\%C%H:BI8$+$i%o!<%k%I:BI8$X(B */
    public double[] getWorldPoint(double r[], double p[]) {
        double w_p[] = new double[2];
        double w;
	p[0] = p[0] / r[3];
	p[1] = p[1] / r[3];
        if(p[0] < 0) {
            w = (Math.asin(p[1]/Math.sqrt(p[0]*p[0]+p[1]*p[1]))
		 -1.57)*57.29577951;
        }
        else {
            w = (1.57 - Math.asin(p[1]/Math.sqrt(p[0]*p[0]+p[1]*p[1]))
		 )*57.29577951;
        }
        double Rr = (r[2]+90-w)*0.017453292;
        w_p[0] = (Math.cos(Rr)*Math.sqrt(p[0]*p[0]+p[1]*p[1])+r[0]);
        w_p[1] = (Math.sin(Rr)*Math.sqrt(p[0]*p[0]+p[1]*p[1])+r[1]);
	//System.out.println("robot Gosa = "+r[3]);
        return w_p;
    }

    public double[][] getDeliverPoint(int n, double r[][]){
	double deliverPoint[][] = new double[5][2];
	for(int i=1; i<=robotNumber; i++){
	    // System.out.println("i = "+i+",n = "+n+", robot = "+robotNumber);
	    deliverPoint[i] = getCenterPoint(r[n], r[i]);
	    
	}
	return deliverPoint;
    }
    public double[] getCenterPoint(double r1[], double r2[]){
	double point[] = new double[2];
	for(int i=0; i<2; i++)
	  point[i] = (r1[i]+r2[i]) / 2;
	return point;
    }
    
    public int getPartnerRobot(double wp[], double dp[][]){
	int partner = -1;
	double min = 99999999;
	for(int i=1; i<=robotNumber; i++){
	    double gosa = getGosa(wp, dp[i]);
	    if(gosa < min) {
		min = gosa;
		partner = i;
	    }
	}
	return partner;
    }

    public double getGosa(double p1[], double p2[]){
	double dx = p1[0] - p2[0];
	double dy = p1[1] - p2[1];
	double gosa = Math.sqrt(dx*dx + dy*dy);
	return gosa;
    }

    public int getPickUpTarget(int num, double point[]){
	double robot[] = pvs.getRobotData(mode, num);

	double worldPoint[] = getWorldPoint(robot, point);
	//System.out.println("BlockData = "+worldPoint[0]+","+worldPoint[1]);
	int target = pvs.wd[mode].getBlockNumber(worldPoint);
	//System.out.println("Target = "+target);
	return target;
    }

    public int getReceiveTarget(int num, double point[]){
	double robot[][] = pvs.getRobotData(mode);
	double worldPoint[] = getWorldPoint(robot[num], point);
	double deliverPoint[][] = getDeliverPoint(num, robot);
	int partnerRobot = getPartnerRobot(worldPoint, deliverPoint);
	int target = robotTarget[partnerRobot];
	return target;
    }

    public void addBlock(int num, int owner, double kind){
	double nowTime;
	Date d = new Date();
	if(startTime < 0) {
	    startTime = d.getTime();
	}
	nowTime = d.getTime() - startTime;
	String kindBlock;
	if(kind == 1) kindBlock = "IN";
	else kindBlock = "in";
	blockChart += kindBlock+","+num+","+owner+","+nowTime+"\n";
	kl1Chart.ChartBlockChange(blockChart);
    }
    
    public void CommandRead(int num, String S){
	double nowTime;
	int nowTarget;
	double armData[] = new double[3];

	command[num].setText(S);
	Date d = new Date();
	if(startTime < 0) {
	    startTime = d.getTime();
	    pvs.wd[mode].changeStartTime(this);
	}
	nowTime = d.getTime() - startTime;
	//System.out.println("Robot"+num+" : "+S+" , "+nowTime);

	String Act = S.substring(0,2);
	if(robotTarget[num] < 0 && "mp".equals(Act)){
	    armData = getPoint(S);
	    int realNum = kl1chat[num].realRobotName();
	    if(armData[2] >= 400){
		robotTarget[num] = getReceiveTarget(realNum, armData);
	    }
	    else if(armData[2] <= 120){
		robotTarget[num] = getPickUpTarget(realNum, armData);
	    }
	    else if(armData[2] != 371){
		System.out.println("No Target Moving !!!  "  + num+":"+S);
	    }
	    if(robotTarget[num] != -1)
	      target[num].setText("Block"+robotTarget[num]);
	}
	else {
	    if(robotTarget[num] < 0){
		System.out.println("No Target !!!"+ num+":"+S);
	    }
	}
	robotChart[num] += Act + "," + robotTarget[num] + "," +nowTime + ",";
	    if("go".equals(Act) && robotTarget[num] > 0){
	    robotTarget[num] = -1;
	    target[num].setText("No Target");
	}
	kl1Chart.ChartChange(robotChart);
    }

    public void CommandEnd(int num) {
	double nowTime;
	Date d = new Date();
	nowTime = d.getTime() - startTime;
	//System.out.println("Robot"+num+" End : "+nowTime);

	if("".equals(robotChart[num]) == false){
	    robotChart[num] = robotChart[num] + nowTime + "\n";
	    kl1Chart.ChartChange(robotChart);
	}
	command[num].setText("Command Wait");
    }

    public String[] clearChart(){
	String robotChart[] = {"","","","","","","","","",""};
	String blockChart = "";
	this.robotChart = robotChart;
	this.blockChart = blockChart;
	startTime = -1;
	return robotChart;
    }

    public void saveData(){
	String fileRobot[] = {"robotChart1","robotChart2",
				"robotChart3","robotChart4"};
	String fileBlock = "blockChart";
	for(int i=0; i<4; i++){
	    saveData(fileRobot[i], robotChart[i+1]);
	}
	saveData(fileBlock, blockChart);
    }
    
    public void saveData(String file, String data){
	// System.out.println("Check1");
	try {
	    // System.out.println("Check2");
	    FileOutputStream fout;
	    fout = new FileOutputStream(file);

	    PrintStream pout;
	    pout = new PrintStream(fout,true);

	    pout.print(data);
	    pout.close();
	} catch (IOException e) {
	    System.out.println("Cannot access file.");
	}
    }
	
    public void kl1RobotEnd(){
	for(int i=1; i <= robotNumber; i++){
	    kl1chat[i].closeSystem();
	}
	pvs.deleteRobot(mode);
    }

    public boolean action(Event e, Object arg) {
        String label = (String)arg;
        if(label.equals("Quit")){
	    kl1RobotEnd();
            setVisible(false);
            return true;
        }
        if(label.equals("Chart") && kl1Chart.open == false){
	    kl1Chart.showOpen(robotChart);
	    kl1Chart.start();
            return true;
        }
        if(label.equals("Save") && kl1Chart.open == false){
	    // System.out.println("Save Start");
	    saveData();
            return true;
        }
	else if(e.target instanceof Choice) {
	    String choice = (String)e.arg;
	    if(choice.equals("Real")) {
		real = true;
		return true;
	    }
	    else if(choice.equals("Virtual")) {
		real = false;
		return true;
	    }
	    else if(choice.equals("Calib")) {
		real = true;
		pvs.wd[mode].calibStart();
		return true;
	    }
	    return false;
	}
        else return false;
    }
}
