/* 
 *  $B%=%1%C%H@\B3MQ(BChat$B%7%9%F%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.net.URL;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.lang.*;

public class KL1Chat implements Runnable{
    Thread thread = null;
    PVS1 pvs;
    KL1Robot kl1Robot;
    int me;
    int kl1Port[][], robotPort[];
    String robotMashine[];
    boolean real;
    SocketConnect klic1, klic2, robot;
    MessageDialog message;
    int robNum = 0;
    KL1Monitor kl1Monitor = null;
    double rData[];

    KL1Chat(int me, KL1Robot kl1Robot) {
	this.me = me;
	this.kl1Robot = kl1Robot;
	message = kl1Robot.message;
	pvs = kl1Robot.pvs;
	kl1Port = kl1Robot.kl1Port;
	robotPort = kl1Robot.robotPort;
	robotMashine = kl1Robot.robotMashine;
	rData = kl1Robot.rData[me];
	thread_start();
    }

    public void thread_start() {
	if(thread == null) {
	    thread = new Thread(this);
	    thread.start();
	}
    }

    public void thread_stop() {
	if(thread != null) {
	    thread.stop();
	    thread = null;
	    System.out.println("KL1Monitor Thread Stop");
	}
    }

    public void closeSystem(){
	thread_stop();
	klic1.serverClose();
	klic2.serverClose();
    }

    public synchronized void run(){
	klic1 = new SocketConnect();
	klic2 = new SocketConnect();
	System.out.println("Connect Wait :"+me);

	while(thread != null){
	    boolean a1 = klic1.ServerConnect(kl1Port[me-1][0]);
	    if(a1 == false) {
		String m = "R"+me+": can't open socket "+ kl1Port[me-1][0];
		message.message(m);
		thread_stop();
	    }

	    boolean a2 = klic2.ServerConnect(kl1Port[me-1][1]);
	    if(a2 == false) {
		String m = "R"+me+": can't open socket "+ kl1Port[me-1][1];
		message.message(m);
		thread_stop();
	    }
	    if(robNum == 0){
		robNum = 
		  pvs.AddRobot(0, robotMashine[me-1], robotPort[me-1], rData);
		if(robNum == 0) {
		    String m = "R"+me+": can't open for Robot "
		      + robotPort[me-1];
		    // message.message(m);
		    // thread_stop();
		}
		System.out.println("Connect OK :"+me);
	    }
	    else {
		kl1Monitor.thread_stop();
		kl1Monitor = null;
		pvs.AddRobot(robNum, robotMashine[me-1], robotPort[me-1]);
		System.out.println("Reconnect OK :"+me);
	    }
	    System.out.println("KL1Chat OK" + robNum);
	    kl1Monitor = new KL1Monitor(this);
	}
    }

    public int realRobotName(){
	return robNum;
    }
}


