/* 
 *  $B%m%\%C%HF0:n%A%c!<%HI=:n@.%W%m%0%i%`(B
 *  Copyright (c) 1997  Fumio Mizoguchi
 */

import java.applet.Applet;
import java.awt.*;
import java.io.*;

public class KL1Chart extends Dialog implements Runnable {

    Thread thread = null;
    KL1Canvas kc;
    boolean open = false;
    KL1Robot kr;
    String robotChart[];
    String blockChart = "";

    int robNum;
    int width = 550;
    int height = 450;
    Label para[];
    int llel[];
    int allPara;
    TextField BlockNum;
    TextField Kijun;
    Label AllPara, ActTime;

    KL1Chart(int robNum, KL1Robot kr, Frame parent){
	super(parent, "KL1Chart", false);
        setLayout(new BorderLayout());

        parent.setResizable(false);
        parent.setBackground(Color.lightGray);
        parent.setFont(new Font("TimesRoman", Font.PLAIN, 18));
        parent.setLayout(new BorderLayout());
        parent.setResizable(false);
        parent.pack();

	this.robNum = robNum;
	if(kr != null)
	  this.kr = kr;
	para = new Label[robNum+1];
	llel = new int[robNum+1];
	kc  = new KL1Canvas(robNum);
	Panel p0 = new Panel();
        p0.setFont(new Font("TimesRoman", Font.PLAIN, 22));
        p0.add(new Label("Robot Moving Chart"));

	Panel p1 = new Panel();
        p1.setFont(new Font("TimesRoman", Font.PLAIN, 20));
	p1.setLayout(new GridLayout(robNum*2+2, 1));
	
	p1.add(new Label("TIME"));
	p1.add(new Label(""));
	for(int i=1; i<=robNum; i++){
	    p1.add(new Label("Robot"+i));
	    p1.add(new Label(""));
	}

	Panel p2 = new Panel();
        p2.setFont(new Font("TimesRoman", Font.PLAIN, 18));
	p2.setLayout(new GridLayout(robNum*2+2, 1));
	p2.add(new Label("Parallel"));
	p2.add(new Label(""));
	for(int i=1; i<=robNum; i++){
	    p2.add(para[i] = new Label("0",Label.CENTER));
	    p2.add(new Label(""));
	}

	Panel south = new Panel();
	south.setLayout(new BorderLayout());
	Panel south1 = new Panel();
	south1.setLayout(new BorderLayout());
	Panel south2 = new Panel();
	south2.setFont(new Font("TimesRoman", Font.PLAIN, 18));
	south2.setLayout(new GridLayout(2,4,10,5));
	south2.add(new Label("Block Num = "));
        south2.add(BlockNum = new TextField("1",3));
	south2.add(new Label("Best Time = "));
        south2.add(Kijun = new TextField("30",4));
	south2.add(new Label("ACT Time = "));
        south2.add(ActTime = new Label("     " ));
	south2.add(new Label("Parallel = "));
        south2.add(AllPara = new Label("     "));
	Panel south3 = new Panel();
        south3.add(new Button("Repaint"));
        south3.add(new Button("Clear"));
        south3.add(new Button("Quit"));
	south1.add("Center",south2);
	south1.add("North",new Label("     "));
	south1.add("East",new Label("     "));
	south1.add("West",new Label("     "));
	south.add("South",new Label("     "));
	south.add("Center",south1);
	south.add("South",south3);
	south.add("East",new Label("     "));
	south.add("West",new Label("     "));
	

        add("North",p0);
        add("West",p1);
        add("East",p2);
	add("Center", kc);
        add("South",south);

	setSize(width, height);
    }
    public void showOpen(String rc[]){
	open = true;
	kc.openWin();
	robotChart = rc;
	this.setVisible(true);
    }
    
    public void Paint(){
	int num = 0;
	int all = 0;
	if(kc.open)
	  llel = kc.Paint(robotChart, blockChart);
	for(int i=1; i<=robNum; i++){
	    para[i].setText(""+llel[i]);
	    if(llel[i] != 0){
		all += llel[i];
		num ++;
	    }
	}
	if(num == 0) allPara = 0;
	else allPara = all/num;
	//System.out.println("Parallel = "+allPara +",  "+all+",  "+num);
    }

    public void ChartChange(String rc[]){
	robotChart = rc;
	Paint();
    }

    public void ChartBlockChange(String bc){
	blockChart = bc;
	Paint();
    }

    public double getParallel(int num, int best){
	double para;
	kc.ChangeChart();
	double robmove[] = kc.getRobotMove(num);
	double Ttime[] = kc.getTimeBlock(num);
	double time = Ttime[1] - Ttime[0];
	double M = 0.9;
	double numnum[] = new double[4];
	int numR = 0;

	for(int i=1; i<= 4; i++){
	    this.para[i].setText(""+Math.rint(robmove[i]*100/time));
	    System.out.println("R"+i+" = "+robmove[i]);
	    if(robmove[i] > 0){
		numnum[numR] = robmove[i]/time;
		numR ++;
	    }
	}
	System.out.println("Time = "+time);
	ActTime.setText(""+time/1000);

	

	double D = time/(double)((double)best * 1000);
	System.out.println("D = "+D);
	/*para = ((1-robmove[1]/time)+(1-robmove[2]/time)+
		(1-robmove[3]/time)+(1-robmove[4]/time))/(4*Math.pow(2,D*M) );
		*/
	double Ai = 1;

	for(int i=0; i<numR; i++){
	    Ai = Ai * numnum[i];
	}
	System.out.println("Ai = "+Ai);
	System.out.println("Time "+(M*best*1000)/time);
	para = (M*best*1000)/time + (1-M)*(1-Ai);
	return para;
    }

    public void start(){
	if(thread == null){
            thread = new Thread(this);
            thread.start();
        }
        else System.out.println("This Thread is moving !!");
    }

    public void stop() {
        if(thread != null){
            System.out.println("Thread_Stop!!!!");
            thread.stop();
            thread = null;
        }
    }

    public void stopfromThread() {
        if(thread != null){
            thread = null;
        }
    }

    public void run(){
	while(thread != null){
	    try{Thread.sleep(200);}
                catch(InterruptedException e){} 
	    Paint();
	    stopfromThread();
	}
    }

    public boolean action(Event e, Object arg) {
        String label = (String)arg;
        if(label.equals("Quit")){
	    open = false;
	    kc.closeWin();
            setVisible(false);
            return true;
        }
        if(label.equals("Repaint")){
	    Paint();
            return true;
        }
        else if(label.equals("Clear")){
	    if(kr != null)
	      robotChart = kr.clearChart();
	    blockChart = "";
	    kc.openWin();
	    Paint();
	    return true;
	}
	else if(e.target instanceof TextField){
	    int blnum= Integer.valueOf(BlockNum.getText()).intValue();
	    int ki = Integer.valueOf(Kijun.getText()).intValue();
	    double para = getParallel(blnum, ki);
	    AllPara.setText(""+para);
	    return true;
	}
        else return false;
    }
}



class KL1Canvas extends Panel {
    Canvas canvas;
    Scrollbar hbar, vbar;
    int robNum;
    int rim;
    String robotChart[] = {"","","","","","","","","",""};
    String blockChart = "";
    int ox, oy;
    int canvas_width, canvas_height;
    boolean open = false;
    boolean reshapePaint = true;
    int comNum[], blockNum;
    int gD[][][], bD[][];
    String Com[][];
    String Block[];

    int fi = 50;

    int reX, reY, reW, reH;

    KL1Canvas(int robNum){
	this.robNum = robNum;
	canvas = new Canvas();
	hbar = new Scrollbar(Scrollbar.HORIZONTAL);
	vbar = new Scrollbar(Scrollbar.VERTICAL);
	this.setLayout(new BorderLayout(0,0));
	this.add("Center",canvas);
	this.add("South",hbar);
	comNum = new int[robNum+1];
	gD = new int[robNum+1][5000][3];
	Com = new String[robNum+1][5000];
	bD = new int[5000][3];
	Block = new String[5000];
    }

    public void Paint(){
	if(open){
	    this.update(canvas.getGraphics());
	}
    }
    public int[] Paint(String rc[], String bc){
	int llel[] = new int[robNum+1];
	robotChart = rc;
	blockChart = bc;
	int sum[] = ChangeChart();
	int heikin = 0;
	ChangeBlockChart();
	Paint();
	double time[] = getTimeBlock(-1);
	for(int i=1; i<=robNum; i++){
	    if(comNum[i] == 0 || gD[i][comNum[i]-1][2] - gD[i][0][1] == 0)
	      llel[i] = 0;
	    else{
		llel[i] = (int)((sum[i]*100)/(time[1]-time[0]));
		heikin += llel[i];
	    }
	}
	heikin = heikin/4;
	System.out.println("Heikin = "+heikin);
	return llel;
    }

    public void openWin(){
	open = true;
	rim = getSize().width;
	reShape();
	ox = hbar.getMaximum();
	reShape();
    }
    public void closeWin(){
	open = false;
    }


    public double[] getTimeBlock(int num){
	double startTime = 999999999, endTime = 0;
	double time[] = new double[2];
	for(int i=1; i <= robNum; i++){
	    for(int j=0; j < comNum[i]; j++){
		if(gD[i][j][0] == num || num < 0){
		    if(gD[i][j][1] < startTime) startTime = gD[i][j][1];
		    if(gD[i][j][2] > endTime )  endTime = gD[i][j][2];
		}
	    }
	}
	time[0] = startTime;
	time[1] = endTime;
	return time;
    }

    public double[] getRobotMove(int num){
	double time[] = getTimeBlock(num);
	double sum[] = new double[robNum+1];
	System.out.println(time[0]+" , "+time[1]);
	for(int i=1; i <= robNum; i++){
	    sum[i] = 0;
	    for(int j=0; j < comNum[i]; j++){
		if(time[0] <= gD[i][j][1] && gD[i][j][2] <= time[1]){
		    sum[i] += gD[i][j][2] - gD[i][j][1];
		}
		else if(gD[i][j][1] < time[0] && time[0] <= gD[i][j][2] &&
			gD[i][j][2] <= time[1]){
		    sum[i] += gD[i][j][2] - time[0];
		}
		else if(time[0] <= gD[i][j][1] && gD[i][j][1] <= time[1] &&
			time[1] < gD[i][j][2] ){
		    sum[i] += time[1] - gD[i][j][1];
		}
	    }
	}
	return sum;
    }

    public int[] ChangeChart(){
	String line = null;
	int w = getSize().width;
	int sum[] = new int[robNum+1];
	for(int i=1; i <= robNum; i++){
	    sum[i] = 0;
	    comNum[i] = 0;
	    StringBufferInputStream str = 
              new StringBufferInputStream(robotChart[i]);
            DataInputStream inp = new DataInputStream(str);
	    try{
		while((line = inp.readLine()) != null){
		    if("".equals(line) || line.length() < 2){}
		    else {
			Com[i][comNum[i]] = line.substring(0,2);
			gD[i][comNum[i]] = ChangeData(line);
			sum[i] += gD[i][comNum[i]][2] - gD[i][comNum[i]][1];
			comNum[i] ++;
		    }
		}
	    }
	    catch(IOException abc){  } catch(Exception e) {}
	    if(comNum[i] > 0 && gD[i][comNum[i]-1][2]/fi > rim){
		rim = gD[i][comNum[i]-1][2]/fi + w/10;
		reShape();
		ox = hbar.getMaximum();
		reShape();
		//System.out.println("Change ox = "+ox);
	    }
	}
	return sum;
    }

    public boolean ChangeBlockChart(){
	String line = null;
        int w = getSize().width;
	blockNum = 0;
	StringBufferInputStream str = 
	  new StringBufferInputStream(blockChart);
	DataInputStream inp = new DataInputStream(str);
	try{
	    while((line = inp.readLine()) != null){
		if("".equals(line) || line.length() < 2){}
		else {
		    Block[blockNum] = line.substring(0,2);
		    bD[blockNum] = ChangeData(line);
		    blockNum ++;
		}
	    }
	}
	catch(IOException abc){  
	    System.out.println("IOException abc");
	} catch(Exception e) {
	    System.out.println("Exception e");
	}
	if(blockNum > 0 && bD[blockNum-1][2]/fi > rim){
	    rim = bD[blockNum-1][2]/fi + w/10;
	    reShape();
	    ox = hbar.getMaximum();
	    reShape();
	}
	return true;
    }

    public void paint(Graphics g){
	int font = 14;
	int timerCount = 10;
	int w = getSize().width;
	int h = getSize().height;
	int l;
	g.setFont(new Font("TimesRoman", Font.PLAIN, font));
	
	/* Timer */
	l = 0 * h/(robNum+1) + h/(robNum*5);
	g.drawLine(0,l, w,l);
	
	boolean okay = true;
	int timer = 0;
	while(okay){
	    
	    g.drawLine(timer-ox,l-5, timer-ox,l+5);
	    if(timer == 0)
	      g.drawString(""+(int)(timer*fi/(1000)), 
			   timer-ox,l+5+font);
	    else 
	      g.drawString(""+(int)(timer*fi/(1000)), 
			   timer-ox-font/2,l+5+font);
	    timer += 1000*timerCount/fi;
	    if(timer > rim) okay = false;
	}

	for(int k = 0; k< blockNum; k++) {
	    l = bD[k][1] * h/(robNum+1) + h/(robNum*5);
	    setBlockColor(g, bD[k][0]);
	    g.drawLine((int)(bD[k][2]/fi) - ox, l-3,
		       (int)(bD[k][2]/fi) - ox, l+3);
	    try {
		g.drawString(""+Block[k]+" "+bD[k][0], 
			     (int)(bD[k][2]/fi)+3 - ox, l-4);
	    }
	    catch(NullPointerException e){
		System.out.println("Null Except!");
		System.out.println("Block[k] = "+Block[k]+", "+k);
	    }
	}
	for(int i=1; i <= robNum; i++){
	    l = i * h/(robNum+1) + h/(robNum*5);
	    for(int k=0; k < comNum[i]; k++){
		boolean start = false;
		if(gD[i][k][0] < 0)
		  g.setColor(Color.black);
		else{
		    setBlockColor(g, gD[i][k][0]);
		}
		if(gD[i][k][1] == gD[i][k][2]) {
		    start = true;
		    gD[i][k][2] = gD[i][k][1] + 300;
		}
		g.drawLine((int)(gD[i][k][1]/fi) - ox, l, 
			   (int)(gD[i][k][2]/fi) - ox, l);
		g.drawLine((int)(gD[i][k][1]/fi) - ox, l-3, 
			   (int)(gD[i][k][1]/fi) - ox, l+3);
		if(start == false)
		  g.drawLine((int)(gD[i][k][2]/fi) - ox, l-3, 
			     (int)(gD[i][k][2]/fi) - ox, l+3);

		try {
		    g.drawString(""+Com[i][k], 
				 (int)(gD[i][k][1]/fi)+3 - ox, l+font);
		}
		catch(NullPointerException e){
		    System.out.println("Null Except!");
		    System.out.println("Com[i][k] = "+Com[i][k]+", "+i+", "+k);
		}
	    }
	}
    }

    public void setBlockColor(Graphics g, int n){
	int m = n%9;
	switch(m) {
	case 0:
	    g.setColor(Color.blue);
	    break;
	case 1:
	    g.setColor(Color.cyan);
	    break;
	case 2:
	    g.setColor(Color.green);
	    break;
	case 3:
	    g.setColor(Color.magenta);
	    break;
	case 4:
	    g.setColor(Color.orange);
	    break;
	case 5:
	    g.setColor(Color.pink);
	    break;
	case 6:
	    g.setColor(Color.red);
	    break;
	case 7:
	    g.setColor(Color.white);
	    break;
	case 8:
	    g.setColor(Color.yellow);
	    break;
	}
    }

    public int[] ChangeData(String s){
	int ov = 3;
	String ds, str = "";
	int data[] = new int[3];
	int num = 0;
	for(int i=ov; i < s.length(); i++){
	    ds = s.substring(i, i+1);
	    if(",".equals(ds)) {
		data[num] = Integer.valueOf(str).intValue();
		str = "";
		num ++;
	    }
	    else if("\n".equals(ds)) {
		data[num] = Integer.valueOf(str).intValue();
		if(num != 2){
		    System.out.println("Data Error!!!");
		}
		num ++;
		i = s.length();
	    }
	    else if(i == s.length()-1) {
		str = str + ds;
		data[num] = Integer.valueOf(str).intValue();
		if(num != 2){
		    System.out.println("Data Error!!!");
		}
		num ++;
		i = s.length();
	    }
	    else str = str + ds;
	}
	if(num == 0) System.out.println("Data 0 Error!!!");
	else if(num == 2) {
	    data[2] = data[1];
	}
	return data;
    }

    public boolean handleEvent(Event e) {
	if(e.target == hbar){
	    switch(e.id){
	    case Event.SCROLL_LINE_UP:
	    case Event.SCROLL_LINE_DOWN:
	    case Event.SCROLL_PAGE_UP:
	    case Event.SCROLL_PAGE_DOWN:
	    case Event.SCROLL_ABSOLUTE:
		ox = ((Integer)e.arg).intValue();
		Paint();
		break;
	    }
	    return true;
	}
	//return super.handleEvent(e);
	return false;
    }
    
    public synchronized void reshape(int x, int y, int width, int height){
	reX = x; reY = y; reW = width; reH = height;
	System.out.println("reshape :"+x+", "+y+", "+width+", "+height);
	super.reshape(x,y,width,height);

	Dimension hbar_size = hbar.getSize();
        Dimension vbar_size = vbar.getSize();
        canvas_width = width - vbar_size.width;
        canvas_height = height - hbar_size.height;
        hbar.setValues(ox, canvas_width, 0, rim-canvas_width);
        vbar.setValues(oy, canvas_height, 0, 1000-canvas_height);
        hbar.setPageIncrement(canvas_width/2);
        vbar.setPageIncrement(canvas_height/2);
	Paint();
    }

    public synchronized void reShape(){
	int x = reX, y = reY, width = reW, height = reH;
	super.reshape(x,y,width,height);

	Dimension hbar_size = hbar.getSize();
        Dimension vbar_size = vbar.getSize();
        canvas_width = width - vbar_size.width;
        canvas_height = height - hbar_size.height;
        hbar.setValues(ox, canvas_width, 0, rim-canvas_width);
        vbar.setValues(oy, canvas_height, 0, 1000-canvas_height);
        hbar.setPageIncrement(canvas_width/2);
        vbar.setPageIncrement(canvas_height/2);
    }
}
