/**********************************************************************/
/*                                                                    */
/*      program of Jclient.c                                          */
/*      Library for Java Simulator                                    */
/*                                                                    */
/*      Copyright (c) 1998  Fumio Mizoguchi                           */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include "Jclient.h"


/***** FUNCTION PROTOTYPE *****/
void connect_simulator(char *, int);
void connected_simulator(int);
void disconnect_simulator(void);
int  place_robot(int, int, int, int);
int  zr(void);
int  vm(int, int, int);
int  gs(void);
int  ac(unsigned int, unsigned int, unsigned int);
int  ct(void);
int  conf_sn(unsigned int, unsigned int * );


void send_data(char*);
void recieve_data(char*);
void recieve_nomad_state(void);
void recieve_sonar_data(void);


/***** EXTERNALDATA *****/
int fromlen;
int s, ns, port;
FILE *fp;


void connect_simulator(char *host, int port)
{
    struct sockaddr_in   sin;
    struct servent       *sp; 
    struct hostent      *hp;
    hp = gethostbyname(host);

    printf("host = %s, port = %d\n",host,port);

    if(hp == 0) {
        fprintf(stderr,"rwrite: unknown host\n");
        exit(1);
    }
    ns = socket(AF_INET , SOCK_STREAM , 0);
    if(ns < 0) {
        fprintf(stderr, "rwrite: socket\n");
        exit(1);
    }
    bzero((char *)&sin,sizeof(sin));
    bcopy(hp->h_addr_list[0],(char *)&sin.sin_addr,hp -> h_length);
    sin.sin_family = hp -> h_addrtype;
    sin.sin_port    =  port;
    if(connect(ns, (char *)&sin, sizeof(sin)) < 0){
        fprintf(stderr,"rwrite: connect\n");
        exit(1);
    }

    fp = fdopen(ns, "r");
}




/***** CONNECTED_SIMULATOR FUNCTION *************************************/
void connected_simulator(int port)
{
    /***** INTERNALDATA *****/
    char data[100];
    struct sockaddr_in sin, fsin;
    char machine[20];

    /***** PROCESS *****/
    if((s = socket(AF_INET,SOCK_STREAM,0))<0){
	perror("server: socket");
	exit(1);
    }
    sin.sin_family = AF_INET;
    sin.sin_port = htons(port);
    sin.sin_addr.s_addr = INADDR_ANY;  
    if(bind(s, &sin, sizeof(sin) ) < 0){
	perror("server: bind");
	exit(1);
    }
    if(listen(s,5)<0){
	perror("server: listen");
	exit(1);
    }
    
    gethostname(machine, sizeof(machine));
    printf("\nWaiting for Connection ... MACHINE --- %s\n", machine);
    printf("                           PORT ------ %d\n", port);
    
    if((ns=accept(s,&fsin,&fromlen))<0){
	perror("server :accept");
	exit(1);
    }
    
    fp = fdopen(ns, "r");

    send_data("Connect Program\n");
    recieve_data(data);
}
/***** END OF CONNECT_SIMULATOR FUNCTION ******************************/
    

/***** DISCONNECT_SIMULATOR FUNCTION **********************************/
void disconnect_simulator(void)
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    close(s);
}
/***** END OF DISCONNECT_SIMULATOR FUNCTION ***************************/


/***** PLACE_ROBOT FUNCTION *******************************************/
int place_robot(int x, int y, int s, int t)
{
    /***** INTERNALDATA *****/
    char data[100];
    char string[10];
    
    /***** PROCESS *****/
    strcpy(data, "place_robot(");
    itostr(string, x);
    strcat(data, string);
    strcat(data, ",");
    itostr(string, y);
    strcat(data, string);
    strcat(data, ",");
    itostr(string, s);
    strcat(data, string);
    strcat(data, ",");
    itostr(string, t);
    strcat(data, string);
    strcat(data, ")");
    strcat(data, "\n");

    send_data(data);
    while(1){
	recieve_data(data);
	if(!strcmp(data, "ok")){
	    break;
	}
    }
    recieve_nomad_state();
    recieve_sonar_data();

    return 1;
}
/***** END OF DISCONNECT_SIMULATOR FUNCTION ***************************/


/***** ZR FUNCTION ****************************************************/
int zr(void)
{
    /***** INTERNALDATA *****/
    char data[100];
    int i;
    
    /***** PROCESS *****/
    send_data("zr()\n");
    while(1){
	recieve_data(data);
	if(!strcmp("ok",data)){
	    break;
	}
    }
    return 1;
}
/***** END OF ZR FUNCTION *********************************************/


/***** VM FUNCTION ****************************************************/
int vm(int tv, int sv, int rv)
{
    /***** INTERNALDATA *****/
    char data[100];
    char string[10];
    
    /***** PROCESS *****/
    strcpy(data, "vm(");
    itostr(string, tv);
    strcat(data, string);
    strcat(data, ",");
    itostr(string, sv);
    strcat(data, string);
    strcat(data, ",");
    itostr(string, rv);
    strcat(data, string);
    strcat(data, ")");
    strcat(data, "\n");

    send_data(data);
    while(1){
	recieve_data(data);
	if(!strcmp(data, "ok")){
	    break;
	}
    }
    recieve_nomad_state();
    recieve_sonar_data();

    return 1;
}
/***** VM FUNCTION ****************************************************/


/***** GS FUNCTION ****************************************************/
int  gs(void)
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    
    return 1;
}
/***** END OF GS FUNCTION *********************************************/


/***** CT FUNCTION ****************************************************/
int ct(void)
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    
    return 1;
}
/***** END OF CT FUNCTION *********************************************/


/***** AC FUNCTION ****************************************************/
int ac(unsigned int tac, unsigned int sac, unsigned int rac)
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/

    return 1;
}
/***** END OF AC FUNCTION *********************************************/


/***** CONF_SN FUNCTION ***********************************************/
int conf_sn(unsigned int firerate, unsigned int order[16])
{
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    
    return 1;
}
/***** END OF AC FUNCTION *********************************************/

    
/***** SEND_DATA FUNCTION *********************************************/
void send_data(char *data)
{    
    /***** INTERNALDATA *****/

    /***** PROCESS *****/
    send(ns, data, strlen(data), 0);
}
/***** END OF SEND_DATA FUNCTION **************************************/
    

/***** RECIEVE_DATA FUNCTION ******************************************/
void recieve_data(char data[100])
{
    /***** INTERNALDATA *****/
    char c;
    int  i=0;
    
    /***** PROCESS *****/
    while((c = fgetc(fp)) != EOF){
	data[i] = c;
	i++;
	
	if(c == '\n'){
	    data[i-1] = (char)NULL;
	    break;
	}
    }
}
/***** END OF RECIEVE_DATA FUNCTON ************************************/


/***** RECIEVE_NOMAD_STATE FUNCTION ***********************************/
void recieve_nomad_state(void)
{
    /***** INTERNALDATA *****/
    char data[100];
    char state_data[10];
    int  i, j, k;

    /***** PROCESS *****/
    while(1){
	recieve_data(data);
	if(data[0] == 's' &&
	   data[1] == 't' &&
	   data[2] == 'a' &&
	   data[3] == 't' &&
	   data[4] == 'e'){
	    break;
	}
    }
    
    k = 6;
    for(i=0; i<4; i++){
	for(j=0; j<10 ; j++){
	    if(data[k] == ',' || data[k] == '\0'){
		state_data[j] = (char)NULL;
		State[34+i] = (long)atoi(state_data);
		k++;
		break;
	    }
	    state_data[j] = data[k];
	    k++;
	}
    }
}
/***** END OF RECIEVE_NOMAD_STATE FUNCTION ****************************/


/***** RECIEVE_SONAR_DATA FUNCTION ************************************/
void recieve_sonar_data(void)
{
    /***** INTERNALDATA *****/
    char data[100];
    char sonar_data[10];
    int  i, j, k;
    
    /***** PROCESS *****/
    while(1){
	recieve_data(data);
	if(data[0] == 's' &&
	   data[1] == 'o' &&
	   data[2] == 'n' &&
	   data[3] == 'a' &&
	   data[4] == 'r'){
	    break;
	}
    }
    
    k = 6;
    for(i=0; i<16; i++){
	for(j=0; j<10; j++){
	    if(data[k] == ',' || data[k] == '\0'){
		sonar_data[j] = (char)NULL;
		State[17+i] = (long)atoi(sonar_data);
		k++;
		break;
	    }
	    sonar_data[j] = data[k];
	    k++;
	}
    }

}
/***** END OF RECIEVE_SONAR_DATA FUNCTION *****************************/


/***** ITOSTR FUNCTION ************************************************/
int itostr(char *data, int num)
{
    /***** INTERNALDATA *****/
    int i,h1,h2,h3,h4,h5;
    
    /***** PROCESS *****/
    i = 0;
    if(num < 0){
        *(data+i) = '-';
        i++;
        num = -1*num;
    }
    
    h5 = num/10000;
    h4 = (num-10000*h5)/1000;
    h3 = (num-10000*h5-1000*h4)/100;
    h2 = (num-10000*h5-1000*h4-100*h3)/10;
    h1 = (num-10000*h5-1000*h4-100*h3-10*h2);

    if(h5 == 0){
        if(h4 == 0){
            if(h3 == 0){
                if(h2 == 0){
                    *(data+i) = (char)(h1+0x30);
                    i++;
                }else{
                    *(data+i) = (char)(h2+0x30);
                    i++;
                    *(data+i) = (char)(h1+0x30);
                    i++;
                }
            }
            else{
                *(data+i) = (char)(h3+0x30);
                i++;
                *(data+i) = (char)(h2+0x30);
                i++;
                *(data+i) = (char)(h1+0x30);
                i++;
            }
        }
        else{
            *(data+i) = (char)(h4+0x30);
            i++;
            *(data+i) = (char)(h3+0x30);
            i++;
            *(data+i) = (char)(h2+0x30);
            i++;
            *(data+i) = (char)(h1+0x30);
            i++;
        }
    }
    else{
        *(data+i) = (char)(h5+0x30);
        i++;
        *(data+i) = (char)(h4+0x30);
        i++;
        *(data+i) = (char)(h3+0x30);
        i++;
        *(data+i) = (char)(h2+0x30);
        i++;
        *(data+i) = (char)(h1+0x30);
        i++;
    }
    *(data+i) = (char)NULL;
    
    return i;
}
/***** END OF ITOSTR FUNCTION *****************************************/


