//
// Sample Program of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "HRSolver.h"
#include "HRParser.h"

void sampleWithParser()
{
	printf("sampleWithParser:\n");

	HRSolver solver;			// the HiRise constaint solver
	HRParser parser;			// parser for HiRise

	parser.createVar("x", 1);	// variable x with initial value 1
	parser.createVar("y");		// variable y
	parser.createVar("z");		// variable z

	HRCon* cstay = parser.createCon(0, "stay(x)"); // stay constraint on x 
												   // with strength 0  
	solver.add(cstay);			// add cstay

	HRCon* cedit = parser.createCon(1, "edit(y)"); // edit constraint on y
												   // with strength 1
	solver.add(cedit);			// add cedit

	HRCon* clinear =
		parser.createCon(2, "x + 2 * y - z = 3"); // linear constraint 
												  // with strength 2
	solver.add(clinear);		// add clinear

	solver.plan();				// plan

	cedit->set(2);				// let cedit assign 2 to y
	solver.execute();			// execute
	printf("x = %f, y = %f, z = %f\n",
		   parser.gv("x"), parser.gv("y"), parser.gv("z")); // print result

	cedit->set(3);				// let cedit assign 3 to y
	solver.execute();			// execute again
	printf("x = %f, y = %f, z = %f\n",
		   parser.gv("x"), parser.gv("y"), parser.gv("z")); // print result
	
	solver.remove(cstay);		// remove cstay
	solver.remove(cedit);		// remove cedit
	solver.remove(clinear);		// remove clinear
}

void sampleWithoutParser()
{
	printf("sampleWithoutParser:\n");

	HRSolver solver;			// the HiRise constaint solver

	HRVar x(1);					// variable x with initial value 1
	HRVar y;					// variable y
	HRVar z;					// variable z

	HRStay cstay(0, x);			// stay constraint on x with strength 0  
	solver.add(cstay);			// add cstay

	HREdit cedit(1, y);			// edit constraint on y with strength 1
	solver.add(cedit);			// add cedit

	HRLinear clinear(2);		// linear constraint with strength 2
	clinear.add(x, 1);
	clinear.add(y, 2);
	clinear.add(z, -1);
	clinear.setConst(3);
	solver.add(clinear);		// add clinear

	solver.plan();				// plan

	cedit.set(2);				// let cedit assign 2 to y
	solver.execute();			// execute
	printf("x = %f, y = %f, z = %f\n", *x, *y, *z); // print result

	cedit.set(3);				// let cedit assign 3 to y
	solver.execute();			// execute again
	printf("x = %f, y = %f, z = %f\n", *x, *y, *z); // print result
	
	solver.remove(cstay);		// remove cstay
	solver.remove(cedit);		// remove cedit
	solver.remove(clinear);		// remove clinear
}

int main(int argc, char* argv[])
{
	sampleWithParser();

	sampleWithoutParser();

	return 0;
}
