//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "stdafx.h"
#define _MYSTDIO_C
#include "mystdio.h"

#ifdef _DEBUG

static int _dprintf(const char *format, va_list args);

static int _dprintf(const char *format, va_list args)
{
	char buf[BUFSIZ];
	int ret;

	if ((ret = vsprintf(buf, format, args)) >= 0)
		OutputDebugString(buf);

	return ret;
}

int dprintf(const char *format, ...)
{
	va_list args;

	va_start(args, format);

	int ret = _dprintf(format, args);

	va_end(args);

	return ret;
}

int dfprintf(FILE *stream, const char *format, ...)
{
	va_list args;

	va_start(args, format);

	int ret;
	if (stream == stdout || stream == stderr)
		ret = _dprintf(format, args);
	else
		ret = vfprintf(stream, format, args);

	va_end(args);

	return ret;
}

#endif // _DEBUG
