//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// TreeView.h : CTreeView NX̐錾уC^[tFCX̒`܂B
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TREEVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
#define AFX_TREEVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "HRSolver.h"

class TreeNode;

class CTreeView : public CView
{
protected: // VACY@\݂̂쐬܂B
	CTreeView();
	DECLARE_DYNCREATE(CTreeView)

// Agr[g
public:
	CTreeDoc* GetDocument();

// Iy[V
public:

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CTreeView)
	public:
	virtual void OnDraw(CDC* pDC);  // ̃r[`悷ۂɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Cve[V
public:
	typedef enum {
		IM_NORMAL,
		IM_DRAG_OBJECT,
		IM_SPECIFY_LINE
	} InputMode;

	InputMode m_inputMode;

	TreeNode* m_pDraggedTreeNode;
	HREdit m_editX;
	HREdit m_editY;

	CPoint m_popupPoint;
	TreeNode* m_pSelectedNode;

	struct StayTreeData {
		TreeNode* m_pNode;
		HRStay m_stayX;
		HRStay m_stayY;
		
#ifdef WEAKER
		StayTreeData() : m_stayX(2), m_stayY(2) { m_pNode = 0; }
#else // !WEAKER
		StayTreeData() : m_stayX(1), m_stayY(1) { m_pNode = 0; }
#endif // WEAKER
	};

	CPtrArray m_stayTreeData;

	TreeNode* m_pLinedTreeNode;
	CPoint m_lineEnd0;
	CPoint m_lineEnd1;

	struct LineTreeData {
		TreeNode* m_pNode;
		CPoint m_lineEnd0;
		CPoint m_lineEnd1;
		HRLinear m_line;
		
#ifdef WEAKER
		LineTreeData() : m_line(2) { m_pNode = 0; }
#else // !WEAKER
		LineTreeData() : m_line(1) { m_pNode = 0; }
#endif // WEAKER
	};

	CPtrArray m_lineTreeData;

	BOOL m_firstDraw;

	virtual ~CTreeView();

	void planAndExec();

	void CalcEndPoints(CRect rect, CPoint point0, CPoint point1, 
					   CPoint& end0, CPoint& end1);
	TreeNode* PickTreeNode(TreeNode* pTree, int nodeSize, CPoint point);
	void DrawTree(TreeNode* pTree, int nodeSize, CDC* pDC);
	void RemoveStaysAndLines(TreeNode* pNode);

	void error(char* fname, char* message = 0);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	//{{AFX_MSG(CTreeView)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnTreeAdd();
	afx_msg void OnTreeRemove();
	afx_msg void OnTreeStay();
	afx_msg void OnTreeLine();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // TreeView.cpp t@CfobO̎gp܂B
inline CTreeDoc* CTreeView::GetDocument()
   { return (CTreeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_TREEVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
