//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRSolver.h"

class TreeNode {
public:
	HRSolver* m_solver;

	TreeNode* m_parent;
	CPtrArray m_children;

	HRVar m_x;
	HRVar m_y;
	HRVar m_left;
	HRVar m_right;

	HRLinear m_midAlign;

	// for a leaf node
	HRLinear m_xInterval;

	// for an internal node
	HRLinear m_leftAlign;
	HRLinear m_rightAlign;
	CPtrArray m_childrenGlues;
	CPtrArray m_yIntervals;

	TreeNode(HRSolver* pSolver, HRVar& xUnit, HRVar& yUnit,
			 TreeNode* pParent, int height, int nChildren);
	~TreeNode();
};
