//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TreeNode.h"

TreeNode::TreeNode(HRSolver* solver, HRVar& xUnit, HRVar& yUnit,
				   TreeNode* parent, int height, int nChildren)
#ifdef WEAKER
: m_midAlign(0), m_xInterval(1), m_leftAlign(0), m_rightAlign(0)
#else // !WEAKER
: m_midAlign(0), m_xInterval(0), m_leftAlign(0), m_rightAlign(0)
#endif // WEAKER
{
	int i;

	m_solver = solver;

	m_parent = parent;

#ifdef CONST_CHILDREN
	int nChildren1 = nChildren;
#else // !CONST_CHILDREN
	int nChildren1 = (int) ((double) rand() * (nChildren + 1) / (RAND_MAX + 1)); 
#endif // CONST_CHILDREN

	if (nChildren1 == 0 || height == 1) { // leaf node
		m_midAlign.center(m_left, m_right, m_x);
		m_solver->add(m_midAlign);

		m_xInterval.sum(m_left, xUnit, m_right);
		m_solver->add(m_xInterval);
	}
	else { // internal node
		TreeNode* lastChild;
		for (i = 0; i < nChildren1; i++) {
			TreeNode* child = new TreeNode(m_solver, xUnit, yUnit,
										   this, height - 1, nChildren);
			m_children.Add(child);

			if (i > 0) {
				HRLinear* childrenGlue = new HRLinear(0);
				m_childrenGlues.Add(childrenGlue);
				
				childrenGlue->equal(lastChild->m_right, child->m_left);
				m_solver->add(*childrenGlue);
			}

#ifdef WEAKER
			HRLinear* yInterval = new HRLinear(1);
#else // !WEAKER
			HRLinear* yInterval = new HRLinear(0);
#endif // WEAKER
			m_yIntervals.Add(yInterval);

			yInterval->sum(m_y, yUnit, child->m_y);
			m_solver->add(*yInterval);

			lastChild = child;
		}

		TreeNode* firstChild = (TreeNode*) m_children.GetAt(0);
		m_leftAlign.equal(m_left, firstChild->m_left);
		m_solver->add(m_leftAlign);

#if 0
		if (firstChild == lastChild)
			m_midAlign.equal(lastChild->m_x, m_x);
		else
			m_midAlign.center(firstChild->m_x, lastChild->m_x, m_x);
		m_solver->add(m_midAlign);
#else
		m_midAlign.center(m_left, m_right, m_x);
		m_solver->add(m_midAlign);
#endif

		m_rightAlign.equal(m_right, lastChild->m_right);
		m_solver->add(m_rightAlign);
	}
}

TreeNode::~TreeNode()
{
	int nChildren = m_children.GetSize();
	int i;
	
	for (i = 0; i < nChildren; i++) {
		if (i > 0) {
			HRLinear* childrenGlue = (HRLinear*) m_childrenGlues.GetAt(i - 1);
			if (childrenGlue != 0)
				delete childrenGlue;
		}

		HRLinear* yInterval = (HRLinear*) m_yIntervals.GetAt(i);
		if (yInterval != 0)
			delete yInterval;
	}

	for (i = 0; i < nChildren; i++) {
		TreeNode* child = (TreeNode*) m_children.GetAt(i);
		if (child != 0)
			delete child;
	}
}
