//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// TreeDoc.cpp : CTreeDoc NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include "HiRiseDemo.h"

#include "TreeDoc.h"

#include "TreeNode.h"
#include "TreeDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTreeDoc

IMPLEMENT_DYNCREATE(CTreeDoc, CDocument)

BEGIN_MESSAGE_MAP(CTreeDoc, CDocument)
	//{{AFX_MSG_MAP(CTreeDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTreeDoc NX̍\z/

CTreeDoc::CTreeDoc()
#ifdef WEAKER
: m_stayXUnit(4), m_stayYUnit(4), m_stayTopX(5), m_stayTopY(5)
#else // !WEAKER
: m_stayXUnit(3), m_stayYUnit(3), m_stayTopX(4), m_stayTopY(4)
#endif // WEAKER
{
	// TODO: ̈ʒuɂPxĂ΂\zp̃R[hǉĂB

	CTreeDialog dialog;
	dialog.DoModal();

	m_stayXUnit.add(m_xUnit);
	m_solver.add(m_stayXUnit);

	m_stayYUnit.add(m_yUnit);
	m_solver.add(m_stayYUnit);

	srand(dialog.m_seed);
	m_pTree = new TreeNode(&m_solver, m_xUnit, m_yUnit,
						   0, dialog.m_height, dialog.m_nChildren);

	m_stayTopX.add(m_pTree->m_x);
	m_solver.add(m_stayTopX);
	m_stayTopY.add(m_pTree->m_y);
	m_solver.add(m_stayTopY);

#ifdef WEAKER
	HREdit editXUnit(2);
#else // !WEAKER
	HREdit editXUnit(1);
#endif // WEAKER
	editXUnit.add(m_xUnit, 30);
	m_solver.add(editXUnit);

#ifdef WEAKER
	HREdit editYUnit(2);
#else // !WEAKER
	HREdit editYUnit(1);
#endif // WEAKER
	editYUnit.add(m_yUnit, 60);
	m_solver.add(editYUnit);

#ifdef WEAKER
	HREdit editTopX(2);
#else // !WEAKER
	HREdit editTopX(1);
#endif // WEAKER
	editTopX.add(m_pTree->m_x, 250);
	m_solver.add(editTopX);

#ifdef WEAKER
	HREdit editTopY(2);
#else // !WEAKER
	HREdit editTopY(1);
#endif // WEAKER
	editTopY.add(m_pTree->m_y, 20);
	m_solver.add(editTopY);

	clock_t t0 = clock();
	m_solver.plan();
	clock_t t1 = clock();
	m_solver.execute();
	clock_t t2 = clock();

	planTimeForConstruction = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	execTimeForConstruction = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	m_nodeSize = dialog.m_nodeSize;
	m_lineWidth = dialog.m_lineWidth;
}

CTreeDoc::~CTreeDoc()
{
	delete m_pTree;
}

BOOL CTreeDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CTreeDoc VAC[[V

void CTreeDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTreeDoc NX̐ff

#ifdef _DEBUG
void CTreeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTreeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTreeDoc R}h
