//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// KochView.h : CKochView NX̐錾уC^[tFCX̒`܂B
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_KOCHVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
#define AFX_KOCHVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "HRSolver.h"

class GraphNode;
class GraphEdge;

class CKochView : public CView
{
protected: // VACY@\݂̂쐬܂B
	CKochView();
	DECLARE_DYNCREATE(CKochView)

// Agr[g
public:
	CKochDoc* GetDocument();

// Iy[V
public:

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CKochView)
	public:
	virtual void OnDraw(CDC* pDC);  // ̃r[`悷ۂɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Cve[V
public:
	typedef enum {
		IM_NORMAL,
		IM_DRAG_OBJECT,
		IM_SPECIFY_EDGE
	} InputMode;

	InputMode m_inputMode;

	CPoint m_popupPoint;

	HREdit m_editX;
	HREdit m_editY;

	HRVar* m_draggedVertexX;
	HRVar* m_draggedVertexY;

#if 0
	GraphNode* m_pGraphNodeToAddEdge;
	CPoint m_edgeEnd0;
	CPoint m_edgeEnd1;
#endif

	BOOL m_firstDraw;

	virtual ~CKochView();

	void planAndExec();

	void DrawKoch(HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y,
				  KochElem* kochElem, CDC* pDC);

	BOOL PickVertexRec(CPoint point, KochElem* kochElem,
					   HRVar*& vx, HRVar*& vy);
	BOOL PickVertex(CPoint point, HRVar*& vx, HRVar*& vy);

	BOOL CheckIfPointIsOnLine(double px, double py,
							  double qx, double qy, double ax, double ay);
	KochElem* PickSegmentRec(CPoint point,
							 HRVar& end0x, HRVar& end0y,
							 HRVar& end1x, HRVar& end1y,
							 KochElem* kochElem, int& part);
	KochElem* PickSegment(CPoint point, int& part);
	
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	//{{AFX_MSG(CKochView)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // KochView.cpp t@CfobO̎gp܂B
inline CKochDoc* CKochView::GetDocument()
   { return (CKochDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_KOCHVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
