//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// KochView.cpp : CKochView NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include "HiRiseDemo.h"

#include "MainFrm.h"
#include "KochDoc.h"
#include "KochView.h"

#include "KochElem.h"

#ifndef M_PI
#define	M_PI 3.14159265358979323846
#endif // !M_PI

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CKochView

IMPLEMENT_DYNCREATE(CKochView, CView)

BEGIN_MESSAGE_MAP(CKochView, CView)
	//{{AFX_MSG_MAP(CKochView)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	//}}AFX_MSG_MAP
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKochView NX̍\z/

CKochView::CKochView()
#ifdef WEAKER
: m_editX(2), m_editY(2)
#else // !WEAKER
: m_editX(1), m_editY(1)
#endif // WEAKER
{
	// TODO: ̏ꏊɍ\zp̃R[hǉĂB

	m_firstDraw = TRUE;
	m_inputMode = IM_NORMAL;
}

CKochView::~CKochView()
{
}

BOOL CKochView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CKochView NX̕`

void CKochView::
DrawKoch(HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y,
		 KochElem* kochElem, CDC* pDC)
{
	CKochDoc* pDoc = GetDocument();

	if (kochElem->m_side0)
		DrawKoch(end0x, end0y, kochElem->m_bot0x, kochElem->m_bot0y,
				 kochElem->m_side0, pDC);
	else {
		pDC->MoveTo((LONG) *end0x, (LONG) *end0y);
		pDC->LineTo((LONG) *kochElem->m_bot0x, (LONG) *kochElem->m_bot0y);
	}

	if (kochElem->m_side1)
		DrawKoch(kochElem->m_bot0x, kochElem->m_bot0y,
				 kochElem->m_topX, kochElem->m_topY,
				 kochElem->m_side1, pDC);
	else
		pDC->MoveTo((LONG) *kochElem->m_bot0x, (LONG) *kochElem->m_bot0y);
		pDC->LineTo((LONG) *kochElem->m_topX, (LONG) *kochElem->m_topY);

	if (kochElem->m_side2)
		DrawKoch(kochElem->m_topX, kochElem->m_topY,
				 kochElem->m_bot1x, kochElem->m_bot1y,
				 kochElem->m_side2, pDC);
	else
		pDC->MoveTo((LONG) *kochElem->m_topX, (LONG) *kochElem->m_topY);
		pDC->LineTo((LONG) *kochElem->m_bot1x, (LONG) *kochElem->m_bot1y);

	if (kochElem->m_side3)
		DrawKoch(kochElem->m_bot1x, kochElem->m_bot1y, end1x, end1y,
				 kochElem->m_side3, pDC);
	else
		pDC->MoveTo((LONG) *kochElem->m_bot1x, (LONG) *kochElem->m_bot1y);
		pDC->LineTo((LONG) *end1x, (LONG) *end1y);
}

void CKochView::OnDraw(CDC* pDC)
{
	CKochDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B

	if (m_firstDraw) {
		char buf[BUFSIZ];
		sprintf(buf, "plan: %f ms, exec: %f ms (#vars: %d, #cons: %d)",
			    pDoc->planTimeForConstruction, pDoc->execTimeForConstruction,
				pDoc->m_solver.countVars(), pDoc->m_solver.countCons());
		extern CHiRiseDemoApp theApp;
		((CMainFrame*) theApp.m_pMainWnd)->SetStatusBar(buf);
		m_firstDraw = FALSE;
	}

	CPen *pOldPen = pDC->GetCurrentPen();
	CBrush* oldBrush = pDC->GetCurrentBrush();

	CPen pen1;
	pen1.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0, 0, 0));
	pDC->SelectObject(&pen1);
	
	DrawKoch(pDoc->m_end0x, pDoc->m_end0y, pDoc->m_end1x, pDoc->m_end1y,
			 pDoc->m_koch, pDC);

	pDC->SelectObject(pOldPen);
	pDC->SelectObject(oldBrush);
}

void CKochView::planAndExec()
{
	CKochDoc* pDoc = GetDocument();

	CWaitCursor wc;

	clock_t t0 = clock();
	pDoc->m_solver.plan();
	clock_t t1 = clock();
	pDoc->m_solver.execute();
	clock_t t2 = clock();

	double planTime = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	double execTime = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	char buf[BUFSIZ];
	sprintf(buf, "plan: %f ms, exec: %f ms (#vars: %d, #cons: %d)",
			planTime, execTime,
			pDoc->m_solver.countVars(), pDoc->m_solver.countCons());

	extern CHiRiseDemoApp theApp;
	((CMainFrame*) theApp.m_pMainWnd)->SetStatusBar(buf);
}

/////////////////////////////////////////////////////////////////////////////
// CKochView NẌ

BOOL CKochView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	return DoPreparePrinting(pInfo);
}

void CKochView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CKochView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}

/////////////////////////////////////////////////////////////////////////////
// CKochView NX̐ff

#ifdef _DEBUG
void CKochView::AssertValid() const
{
	CView::AssertValid();
}

void CKochView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CKochDoc* CKochView::GetDocument() // fobO o[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CKochDoc)));
	return (CKochDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CKochView NX̃bZ[W nh

BOOL CKochView::PickVertexRec(CPoint point, KochElem* kochElem,
									HRVar*& vx, HRVar*& vy)
{
	const int eps = 2;
	
	if (fabs(*kochElem->m_bot0x - point.x) < 2 &&
		fabs(*kochElem->m_bot0y - point.y) < 2) {
		vx = &kochElem->m_bot0x;
		vy = &kochElem->m_bot0y;
		return TRUE;
	}

	if (fabs(*kochElem->m_topX - point.x) < 2 &&
		fabs(*kochElem->m_topY - point.y) < 2) {
		vx = &kochElem->m_topX;
		vy = &kochElem->m_topY;
		return TRUE;
	}

	if (fabs(*kochElem->m_bot1x - point.x) < 2 &&
		fabs(*kochElem->m_bot1y - point.y) < 2) {
		vx = &kochElem->m_bot1x;
		vy = &kochElem->m_bot1y;
		return TRUE;
	}

	if (kochElem->m_side0 != 0) {
		if (PickVertexRec(point, kochElem->m_side0, vx, vy))
			return TRUE;
	}

	if (kochElem->m_side1 != 0) {
		if (PickVertexRec(point, kochElem->m_side1, vx, vy))
			return TRUE;
	}

	if (kochElem->m_side2 != 0) {
		if (PickVertexRec(point, kochElem->m_side2, vx, vy))
			return TRUE;
	}

	if (kochElem->m_side3 != 0) {
		if (PickVertexRec(point, kochElem->m_side3, vx, vy))
			return TRUE;
	}

	return FALSE;
}

BOOL CKochView::PickVertex(CPoint point, HRVar*& vx, HRVar*& vy)
{
	const int eps = 2;
	CKochDoc* pDoc = GetDocument();

	vx = 0;
	vy = 0;

	if (fabs(*pDoc->m_end0x - point.x) < 2 &&
		fabs(*pDoc->m_end0y - point.y) < 2) {
		vx = &pDoc->m_end0x;
		vy = &pDoc->m_end0y;
		return TRUE;
	}

	if (fabs(*pDoc->m_end1x - point.x) < 2 &&
		fabs(*pDoc->m_end1y - point.y) < 2) {
		vx = &pDoc->m_end1x;
		vy = &pDoc->m_end1y;
		return TRUE;
	}

	return PickVertexRec(point, pDoc->m_koch, vx, vy);
}

BOOL CKochView::
CheckIfPointIsOnLine(double px, double py,
					 double qx, double qy, double ax, double ay)
{
	CKochDoc* pDoc = GetDocument();
	int tolerance = 2 * pDoc->m_lineWidth;

	if (fabs(ax) >= fabs(ay)) {
		if (fabs(ax) < 0.1)
			return FALSE;
			
		double t = (px - qx) / ax;
		if (t < 0 || t > 1)
			return FALSE;

		double y = qy + t * ay;
		if (py > y - tolerance && py < y + tolerance)
			return TRUE;
	}
	else {
		if (fabs(ay) < 0.1)
			return FALSE;

		double t = (py - qy) / ay;
		if (t < 0 || t > 1)
			return FALSE;

		double x = qx + t * ax;
		if (px > x - tolerance && px < x + tolerance)
			return TRUE;
	}

	return FALSE;
}

KochElem* CKochView::
PickSegmentRec(CPoint point,
			   HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y,
			   KochElem* kochElem, int& part)
{
	if (kochElem->m_side0) {
		KochElem* picked
			= PickSegmentRec(point,
							 end0x, end0y,
							 kochElem->m_bot0x, kochElem->m_bot0y,
							 kochElem->m_side0, part);
		if (picked)
			return picked;
	}	
	else {
		double px = (double) point.x;
		double py = (double) point.y;
		double qx = (double) *end0x;
		double qy = (double) *end0y;
		double ax = (double) *kochElem->m_bot0x - qx;
		double ay = (double) *kochElem->m_bot0y - qy;

		if (CheckIfPointIsOnLine(px, py, qx, qy, ax, ay)) {
			part = 0;
			return kochElem;
		}
	}

	if (kochElem->m_side1) {
		KochElem* picked
			= PickSegmentRec(point,
							 kochElem->m_bot0x, kochElem->m_bot0y,
							 kochElem->m_topX, kochElem->m_topY,
							 kochElem->m_side1, part);
		if (picked)
			return picked;
	}
	else {
		double px = (double) point.x;
		double py = (double) point.y;
		double qx = (double) *kochElem->m_bot0x;
		double qy = (double) *kochElem->m_bot0y;
		double ax = (double) *kochElem->m_topX - qx;
		double ay = (double) *kochElem->m_topY - qy;

		if (CheckIfPointIsOnLine(px, py, qx, qy, ax, ay)) {
			part = 1;
			return kochElem;
		}
	}

	if (kochElem->m_side2) {
		KochElem* picked
			= PickSegmentRec(point,
							 kochElem->m_topX, kochElem->m_topY,
							 kochElem->m_bot1x, kochElem->m_bot1y,
							 kochElem->m_side2, part);
		if (picked)
			return picked;
	}
	else {
		double px = (double) point.x;
		double py = (double) point.y;
		double qx = (double) *kochElem->m_topX;
		double qy = (double) *kochElem->m_topY;
		double ax = (double) *kochElem->m_bot1x - qx;
		double ay = (double) *kochElem->m_bot1y - qy;

		if (CheckIfPointIsOnLine(px, py, qx, qy, ax, ay)) {
			part = 2;
			return kochElem;
		}
	}

	if (kochElem->m_side3) {
		KochElem* picked
			= PickSegmentRec(point,
							 kochElem->m_bot1x, kochElem->m_bot1y,
							 end1x, end1y,
							 kochElem->m_side3, part);
		if (picked)
			return picked;
	}
	else {
		double px = (double) point.x;
		double py = (double) point.y;
		double qx = (double) *kochElem->m_bot1x;
		double qy = (double) *kochElem->m_bot1y;
		double ax = (double) *end1x - qx;
		double ay = (double) *end1y - qy;

		if (CheckIfPointIsOnLine(px, py, qx, qy, ax, ay)) {
			part = 3;
			return kochElem;
		}
	}

	return 0;
}

KochElem* CKochView::PickSegment(CPoint point, int& part)
{
	CKochDoc* pDoc = GetDocument();

	return PickSegmentRec(point,
						  pDoc->m_end0x, pDoc->m_end0y,
						  pDoc->m_end1x, pDoc->m_end1y,
						  pDoc->m_koch, part);
}

void CKochView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CKochDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		break;
	case IM_DRAG_OBJECT:
		m_editX.set((HRValue) point.x);
		m_editY.set((HRValue) point.y);
		pDoc->m_solver.execute();

		RedrawWindow();
		break;
	case IM_SPECIFY_EDGE:
		break;
	}

	CView::OnMouseMove(nFlags, point);
}

void CKochView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CKochDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		if (PickVertex(point, m_draggedVertexX, m_draggedVertexY)) {
			m_inputMode = IM_DRAG_OBJECT;

			m_editX.clear();
			m_editX.add(*m_draggedVertexX, (HRValue) point.x);
			pDoc->m_solver.add(m_editX);
		
			m_editY.clear();
			m_editY.add(*m_draggedVertexY, (HRValue) point.y);
			pDoc->m_solver.add(m_editY);

			planAndExec();

			RedrawWindow();
		}
		break;
	case IM_DRAG_OBJECT:
		m_inputMode = IM_NORMAL;
		break;
	case IM_SPECIFY_EDGE:
		break;
	}

	CView::OnLButtonDown(nFlags, point);
}

void CKochView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CKochDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		break;
	case IM_DRAG_OBJECT:
		m_inputMode = IM_NORMAL;

		pDoc->m_solver.remove(m_editX);		
		pDoc->m_solver.remove(m_editY);		

		m_draggedVertexX = 0;
		m_draggedVertexY = 0;

		planAndExec();

		RedrawWindow();
		break;
	case IM_SPECIFY_EDGE:
		break;
	}

	CView::OnLButtonUp(nFlags, point);
}

void CKochView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	m_popupPoint = point;

	CView::OnRButtonDown(nFlags, point);
}


void CKochView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CKochDoc* pDoc = GetDocument();

	int part;
	KochElem* elem = PickSegment(point, part);
	if (elem) {
#ifdef DEBUG
		char buf[BUFSIZ];
		sprintf(buf, "segment: %x, %d\n", elem, part);
		OutputDebugString(buf);
#endif // DEBUG

		switch (part) {
		case 0:
			elem->m_side0 = new KochElem(&pDoc->m_solver,
										 elem->m_angle, 1, elem,
										 *elem->m_end0x, *elem->m_end0y,
										 elem->m_bot0x, elem->m_bot0y);
			break;
		case 1:
#ifdef OLD_ANGLE
			elem->m_side1 = new KochElem(&pDoc->m_solver,
										 elem->m_angle - M_PI / 3,
										 1, elem,
										 elem->m_bot0x, elem->m_bot0y,
										 elem->m_topX, elem->m_topY);
#else // !OLD_ANGLE
			elem->m_side1 = new KochElem(&pDoc->m_solver,
										 elem->m_angle - 1,
										 1, elem,
										 elem->m_bot0x, elem->m_bot0y,
										 elem->m_topX, elem->m_topY);
#endif // OLD_ANGLE
			break;
		case 2:
#ifdef OLD_ANGLE
			elem->m_side2 = new KochElem(&pDoc->m_solver,
										 elem->m_angle + M_PI / 3,
										 1, elem,
										 elem->m_topX, elem->m_topY,
										 elem->m_bot1x, elem->m_bot1y);
#else // !OLD_ANGLE
			elem->m_side2 = new KochElem(&pDoc->m_solver,
										 elem->m_angle + 1,
										 1, elem,
										 elem->m_topX, elem->m_topY,
										 elem->m_bot1x, elem->m_bot1y);
#endif // OLD_ANGLE
			break;
		case 3:
			elem->m_side3 = new KochElem(&pDoc->m_solver,
										 elem->m_angle,
										 1, elem,
										 elem->m_bot1x, elem->m_bot1y,
										 *elem->m_end1x, *elem->m_end1y);
			break;
		}

		planAndExec();

		RedrawWindow();
	}

	CView::OnRButtonUp(nFlags, point);
}
