//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRSolver.h"

class KochElem {
public:
	HRSolver* m_solver;

#ifdef OLD_ANGLE
	double m_angle;
#else // !OLD_ANGLE
	int m_angle;
#endif // OLD_ANGLE

	KochElem* m_parent;

	HRVar* m_end0x;
	HRVar* m_end0y;
	HRVar* m_end1x;
	HRVar* m_end1y;

	HRVar m_bot0x;
	HRVar m_bot0y;

	HRLinear m_locBot0x;
	HRLinear m_locBot0y;

	HRVar m_topX;
	HRVar m_topY;

	HRLinear m_locTop0;
	HRLinear m_locTop1;

	HRVar m_bot1x;
	HRVar m_bot1y;

	HRLinear m_locBot1x;
	HRLinear m_locBot1y;

	KochElem* m_side0;
	KochElem* m_side1;
	KochElem* m_side2;
	KochElem* m_side3;

#ifdef OLD_ANGLE
	KochElem(HRSolver* solver, double angle, int count, KochElem* parent,
			 HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y);
#else // !OLD_ANGLE
	KochElem(HRSolver* solver, int angle, int count, KochElem* parent,
			 HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y);
#endif // OLD_ANGLE
};
