//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "KochElem.h"

#ifndef M_PI
#define	M_PI 3.14159265358979323846
#endif // !M_PI

#ifdef OLD_ANGLE
KochElem::KochElem(HRSolver* solver, double angle, int count, KochElem* parent,
				   HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y)
#else // !OLD_ANGLE
KochElem::KochElem(HRSolver* solver, int angle, int count, KochElem* parent,
				   HRVar& end0x, HRVar& end0y, HRVar& end1x, HRVar& end1y)
#endif // OLD_ANGLE
#ifdef WEAKER
: m_locBot0x(0), m_locBot0y(0), m_locTop0(1), m_locTop1(1),
  m_locBot1x(0), m_locBot1y(0)
#else // !WEAKER
: m_locBot0x(0), m_locBot0y(0), m_locTop0(0), m_locTop1(0),
  m_locBot1x(0), m_locBot1y(0)
#endif // WEAKER
{
	m_solver = solver;

	m_angle = angle;

	m_parent = parent;

	m_end0x = &end0x;
	m_end0y = &end0y;
	m_end1x = &end1x;
	m_end1y = &end1y;

	m_locBot0x.add(m_bot0x, 1);
	m_locBot0x.add(end0x, (HRValue) -2 / 3);
	m_locBot0x.add(end1x, (HRValue) -1 / 3);
	solver->add(m_locBot0x);

	m_locBot0y.add(m_bot0y, 1);
	m_locBot0y.add(end0y, (HRValue) -2 / 3);
	m_locBot0y.add(end1y, (HRValue) -1 / 3);
	solver->add(m_locBot0y);

	m_locBot1x.add(m_bot1x, 1);
	m_locBot1x.add(end0x, (HRValue) -1 / 3);
	m_locBot1x.add(end1x, (HRValue) -2 / 3);
	solver->add(m_locBot1x);

	m_locBot1y.add(m_bot1y, 1);
	m_locBot1y.add(end0y, (HRValue) -1 / 3);
	m_locBot1y.add(end1y, (HRValue) -2 / 3);
	solver->add(m_locBot1y);

#ifdef OLD_ANGLE
	double ax = cos(angle - M_PI / 3);
	double ay = sin(angle - M_PI / 3);
#else // !OLD_ANGLE
	double ax = cos((angle - 1) * M_PI / 3);
	double ay = sin((angle - 1) * M_PI / 3);
#endif // OLD_ANGLE
	m_locTop0.add(m_topX, (HRValue) ay);
	m_locTop0.add(m_bot0x, (HRValue) -ay);
	m_locTop0.add(m_topY, (HRValue) -ax);
	m_locTop0.add(m_bot0y, (HRValue) ax);
	solver->add(m_locTop0);
	
#ifdef OLD_ANGLE
	double bx = cos(angle + M_PI / 3);
	double by = sin(angle + M_PI / 3);
#else // !OLD_ANGLE
	double bx = cos((angle + 1) * M_PI / 3);
	double by = sin((angle + 1) * M_PI / 3);
#endif // OLD_ANGLE
	m_locTop1.add(m_bot1x, (HRValue) by);
	m_locTop1.add(m_topX, (HRValue) -by);
	m_locTop1.add(m_bot1y, (HRValue) -bx);
	m_locTop1.add(m_topY, (HRValue) bx);
	solver->add(m_locTop1);

	if (count == 1) {
		m_side0 = 0;
		m_side1 = 0;
		m_side2 = 0;
		m_side3 = 0;
		
		return;
	}

	m_side0 = new KochElem(solver, angle, count - 1,
						   this, end0x, end0y, m_bot0x, m_bot0y);

#ifdef OLD_ANGLE
	m_side1 = new KochElem(solver, angle - M_PI / 3, count - 1,
						   this, m_bot0x, m_bot0y, m_topX, m_topY);
#else // !OLD_ANGLE
	m_side1 = new KochElem(solver, angle - 1, count - 1,
						   this, m_bot0x, m_bot0y, m_topX, m_topY);
#endif // OLD_ANGLE

#ifdef OLD_ANGLE
	m_side2 = new KochElem(solver, angle + M_PI / 3, count - 1,
						   this, m_topX, m_topY, m_bot1x, m_bot1y);
#else // !OLD_ANGLE
	m_side2 = new KochElem(solver, angle + 1, count - 1,
						   this, m_topX, m_topY, m_bot1x, m_bot1y);
#endif // OLD_ANGLE

	m_side3 = new KochElem(solver, angle, count - 1,
						   this, m_bot1x, m_bot1y, end1x, end1y);
}
