//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// KochDoc.cpp : CKochDoc NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include <math.h>
#include "HiRiseDemo.h"

#include "KochDoc.h"

#include "KochDialog.h"
#include "KochElem.h"

#ifndef M_PI
#define	M_PI 3.14159265358979323846
#endif // !M_PI

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CKochDoc

IMPLEMENT_DYNCREATE(CKochDoc, CDocument)

BEGIN_MESSAGE_MAP(CKochDoc, CDocument)
	//{{AFX_MSG_MAP(CKochDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKochDoc NX̍\z/

CKochDoc::CKochDoc()
#ifdef WEAKER
: m_horizontal(1), m_stayTopX(3), m_stayTopY(3), m_calcWidth(0), m_stayWidth(4)
#else // !WEAKER
: m_horizontal(0), m_stayTopX(2), m_stayTopY(2), m_calcWidth(0), m_stayWidth(3)
#endif // WEAKER
{
	// TODO: ̈ʒuɂPxĂ΂\zp̃R[hǉĂB

	CKochDialog dialog;
	dialog.DoModal();

	m_horizontal.add(m_end0y, 1);
	m_horizontal.add(m_end1y, -1);
	m_solver.add(m_horizontal);

	m_calcWidth.sum(m_end0x, m_width, m_end1x);
	m_solver.add(m_calcWidth);

	m_stayWidth.add(m_width);
	m_solver.add(m_stayWidth);

	m_koch = new KochElem(&m_solver, 0, dialog.m_level,
						  0, m_end0x, m_end0y, m_end1x, m_end1y);

	m_stayTopX.add(m_koch->m_topX);
	m_solver.add(m_stayTopX);

	m_stayTopY.add(m_koch->m_topY);
	m_solver.add(m_stayTopY);

#ifdef WEAKER
	HREdit editEnd0x(1);
#else // !WEAKER
	HREdit editEnd0x(0);
#endif // WEAKER
	editEnd0x.add(m_end0x, 50);
	m_solver.add(editEnd0x);

#ifdef WEAKER
	HREdit editTopX(1);
#else // !WEAKER
	HREdit editTopX(0);
#endif // WEAKER
	editTopX.add(m_koch->m_topX, 250);
	m_solver.add(editTopX);

#ifdef WEAKER
	HREdit editTopY(1);
#else // !WEAKER
	HREdit editTopY(0);
#endif // WEAKER
	editTopY.add(m_koch->m_topY, 50);
	m_solver.add(editTopY);

	clock_t t0 = clock();
	m_solver.plan();
	clock_t t1 = clock();
	m_solver.execute();
	clock_t t2 = clock();

	planTimeForConstruction = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	execTimeForConstruction = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	m_nodeSize = 20;
	m_lineWidth = 2;
}

CKochDoc::~CKochDoc()
{
	delete m_koch;
}

BOOL CKochDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CKochDoc VAC[[V

void CKochDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
	}
}

/////////////////////////////////////////////////////////////////////////////
// CKochDoc NX̐ff

#ifdef _DEBUG
void CKochDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CKochDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CKochDoc R}h
